/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class SelfResolvingDependencyConfigurationResolver
implements ConfigurationResolver {
    private final ConfigurationResolver delegate;

    public SelfResolvingDependencyConfigurationResolver(ConfigurationResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public void resolve(ConfigurationInternal configuration, ResolverResults results) throws ResolveException {
        this.delegate.resolve(configuration, results);
    }

    @Override
    public void resolveArtifacts(ConfigurationInternal configuration, ResolverResults results) throws ResolveException {
        this.delegate.resolveArtifacts(configuration, results);
        ResolvedConfiguration resolvedConfiguration = results.getResolvedConfiguration();
        DependencySet dependencies = configuration.getAllDependencies();
        CachingDependencyResolveContext resolveContext = new CachingDependencyResolveContext(configuration.isTransitive());
        SelfResolvingFilesProvider provider = new SelfResolvingFilesProvider(resolveContext, (Set<Dependency>)dependencies);
        results.withResolvedConfiguration(new FilesAggregatingResolvedConfiguration(resolvedConfiguration, provider));
    }

    protected static class FilesAggregatingResolvedConfiguration
    implements ResolvedConfiguration {
        final ResolvedConfiguration resolvedConfiguration;
        final SelfResolvingFilesProvider selfResolvingFilesProvider;

        FilesAggregatingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, SelfResolvingFilesProvider selfResolvingFilesProvider) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.selfResolvingFilesProvider = selfResolvingFilesProvider;
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            files.addAll(this.selfResolvingFilesProvider.getFiles(dependencySpec));
            files.addAll(this.resolvedConfiguration.getFiles(dependencySpec));
            return files;
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() {
            return this.resolvedConfiguration.getResolvedArtifacts();
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            return this.resolvedConfiguration.getFirstLevelModuleDependencies();
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
        }

        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        public LenientConfiguration getLenientConfiguration() {
            return this.resolvedConfiguration.getLenientConfiguration();
        }

        public void rethrowFailure() throws GradleException {
            this.resolvedConfiguration.rethrowFailure();
        }
    }

    protected static class SelfResolvingFilesProvider {
        final CachingDependencyResolveContext resolveContext;
        final Set<Dependency> dependencies;

        public SelfResolvingFilesProvider(CachingDependencyResolveContext resolveContext, Set<Dependency> dependencies) {
            this.resolveContext = resolveContext;
            this.dependencies = dependencies;
        }

        Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            Set selectedDependencies = CollectionUtils.filter(this.dependencies, dependencySpec);
            for (Dependency dependency : selectedDependencies) {
                this.resolveContext.add((Object)dependency);
            }
            return this.resolveContext.resolve().getFiles();
        }
    }
}

