/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentSelectionReasonSerializer
implements Serializer<ComponentSelectionReason> {
    private static final BiMap<Byte, ComponentSelectionReason> REASONS = HashBiMap.create((int)6);

    public ComponentSelectionReason read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        ComponentSelectionReason out = (ComponentSelectionReason)REASONS.get((Object)id);
        if (out == null) {
            throw new IllegalArgumentException("Unable to find selection reason with id: " + id);
        }
        return out;
    }

    public void write(Encoder encoder, ComponentSelectionReason value) throws IOException {
        Byte id = (Byte)REASONS.inverse().get((Object)value);
        if (id == null) {
            throw new IllegalArgumentException("Unknown selection reason: " + value);
        }
        encoder.writeByte(id.byteValue());
    }

    static {
        REASONS.put((Object)1, (Object)VersionSelectionReasons.REQUESTED);
        REASONS.put((Object)2, (Object)VersionSelectionReasons.ROOT);
        REASONS.put((Object)3, (Object)VersionSelectionReasons.FORCED);
        REASONS.put((Object)4, (Object)VersionSelectionReasons.CONFLICT_RESOLUTION);
        REASONS.put((Object)5, (Object)VersionSelectionReasons.SELECTED_BY_RULE);
        REASONS.put((Object)6, (Object)VersionSelectionReasons.CONFLICT_RESOLUTION_BY_RULE);
        REASONS.put((Object)7, (Object)VersionSelectionReasons.COMPOSITE_BUILD);
    }
}

