/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.util.Geodesic;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    protected P3 tempQ1 = new P3();
    protected P3 tempQ2 = new P3();
    protected P3 tempQ3 = new P3();
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    private int[][] oneFace;
    private P3[] threeVertices;
    protected float fontSize;
    protected String fontFace;
    protected String fontStyle;
    protected String fontChild;

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
    }

    @Override
    protected void output(T3 pt) {
        this.output(_VrmlExporter.round(pt));
    }

    @Override
    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + PT.esc(this.vwr.ms.modelSetName) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + this.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix) + "] } \n");
        float angle = this.getViewpoint();
        this.output("Viewpoint{fieldOfView " + angle);
        this.output(" position ");
        this.output(this.cameraPosition);
        this.output(" orientation ");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.outputInitialTransform();
    }

    protected void outputInitialTransform() {
        if (this.exportScale != 1.0f) {
            this.pushMatrix();
            this.outputScale(this.exportScale, this.exportScale, this.exportScale);
            this.output("\nchildren [\n");
        }
        this.pushMatrix();
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.outputTranslation(this.tempP1);
        this.output("\nchildren [\n");
    }

    protected float getViewpoint() {
        this.viewpoint.setM(this.vwr.tm.matrixRotate);
        this.tempP1.set(this.viewpoint.x, this.viewpoint.y, this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z);
        return (float)((double)this.aperatureAngle * Math.PI / 180.0);
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]}\n");
        if (this.exportScale != 1.0f) {
            this.output("]}");
        }
    }

    protected void outputAppearance(short colix, boolean isText) {
        String def = this.getDef((isText ? "T" : "") + colix);
        this.output("appearance ");
        if (def.charAt(0) == '_') {
            String color = this.rgbFractionalFromColix(colix);
            this.output(" DEF " + def + " Appearance{material Material{diffuseColor ");
            if (isText) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + color + " }}");
            } else {
                this.output(color + " transparency " + _VrmlExporter.translucencyFractionalFromColix(colix) + "}}");
            }
            return;
        }
        this.output(def);
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        if (doFill) {
            this.output("Transform{translation ");
            this.tempV1.ave(pt1, pt2);
            this.outputTranslation(this.tempV1);
            this.output(" children [ Billboard{axisOfRotation 0 0 0 children [ Transform{rotation 1 0 0 1.5708");
            float height = pt1.distance(pt2);
            this.outputScale(radius, height, radius);
            this.outputCylinderChildScaled(colix, (byte)2);
            this.output("}] }]\n");
            this.output("}\n");
            return;
        }
        String child = this.getDef("C" + colix + "_" + radius);
        this.output("Transform{");
        this.outputTransRot(pt1, pt2, 0, 0, 1, " ", "");
        this.outputScale(radius, radius, radius);
        this.output(" children [");
        if (child.charAt(0) == '_') {
            int i;
            this.output("DEF " + child);
            this.output(" Billboard{axisOfRotation 0 0 0 children [ Transform{children[");
            this.output(" Shape{");
            this.output("geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            float rpd = (float)Math.PI / 180;
            float scale = 0.02f / radius;
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)i * rpd) * (double)scale) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)i * rpd) * (double)scale) + " ");
            }
            this.output("] spine [");
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)i * rpd)) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)i * rpd)) + " 0 ");
            }
            this.output("]");
            this.output("}");
            this.outputAppearance(colix, false);
            this.output("}");
            this.output("]} ]}");
        } else {
            this.output(child);
        }
        this.output("]}\n");
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        float height = ptBase.distance(ptTip);
        this.pushMatrix();
        this.outputTransRot(ptBase, ptTip, 0, 1, 0, " ", "");
        this.outputScale(radius, height, radius);
        this.output(" children[Shape{geometry ");
        String child = this.getDef("c");
        if (child.charAt(0) == '_') {
            this.output("DEF " + child + " IndexedFaceSet {");
            this.outputConeGeometry(true);
            this.output(" }\n");
        } else {
            this.output(child);
        }
        this.outputAppearance(colix, false);
        this.output("}]");
        this.popMatrix();
    }

    protected void outputConeGeometry(boolean addBase) {
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n + (addBase ? 2 : 1);
        int[][] faces = AU.newInt2(n * (addBase ? 2 : 1));
        int fpt = 0;
        for (int i = 0; i < n; ++i) {
            faces[fpt++] = new int[]{i, (i + n - 1) % n, n};
            if (!addBase) continue;
            faces[fpt++] = new int[]{i, (i + 1) % n, n + 1};
        }
        T3[] vertexes = new P3[vertexCount];
        for (int i = 0; i < n; ++i) {
            float x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            float y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, -0.5f, y);
        }
        vertexes[n++] = P3.new3(0.0f, 0.5f, 0.0f);
        if (addBase) {
            vertexes[n++] = P3.new3(0.0f, -0.5f, 0.0f);
        }
        this.outputGeometry(vertexes, null, null, faces, null, vertexCount, faces.length, null, 3, null, null, null);
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        float height = pt1.distance(pt2);
        this.pushMatrix();
        if (ptX == null) {
            this.outputTransRot(pt1, pt2, 0, 1, 0, " ", "");
            this.outputScale(radius, height, radius);
        } else {
            this.outputTranslation(ptCenter);
            this.outputQuaternionFrame(ptCenter, ptY, pt1, ptX, 2.0f, 2.0f, 2.0f, " ", "");
            pt1.set(0.0f, 0.0f, -0.5f);
            pt2.set(0.0f, 0.0f, 0.5f);
        }
        this.outputCylinderChildScaled(colix, endcaps);
        this.popMatrix();
        if (endcaps == 3) {
            this.outputSphere(pt1, radius * 1.01f, colix, checkRadius);
            this.outputSphere(pt2, radius * 1.01f, colix, checkRadius);
        }
        return true;
    }

    protected void pushMatrix() {
        this.output("Transform{");
    }

    protected void popMatrix() {
        this.output("}\n");
    }

    protected void outputQuaternionFrame(P3 ptCenter, P3 ptX, P3 ptY, P3 ptZ, float xScale, float yScale, float zScale, String pre, String post) {
        this.tempQ1.setT(ptX);
        this.tempQ2.setT(ptY);
        A4 a = Quat.getQuaternionFrame(ptCenter, this.tempQ1, this.tempQ2).toAxisAngle4f();
        if (!Float.isNaN(a.x)) {
            if (this.isBinary) {
                this.tempQ1.set(a.x, a.y, a.z);
                this.outputRotation(a);
            } else {
                this.output(" rotation");
                this.output(pre);
                this.output(a.x + " " + a.y + " " + a.z + " " + a.angle);
                this.output(post);
            }
        }
        float sx = ptX.distance(ptCenter) * xScale;
        float sy = ptY.distance(ptCenter) * yScale;
        float sz = ptZ.distance(ptCenter) * zScale;
        if (this.isBinary) {
            this.outputScale(sx, sy, sz);
        } else {
            this.output(" scale");
            this.output(pre);
            this.output(_VrmlExporter.round(sx) + " " + _VrmlExporter.round(sy) + " " + _VrmlExporter.round(sz));
            this.output(post);
        }
    }

    protected void outputCylinderChildScaled(short colix, byte endcaps) {
        this.output(" children[Shape{geometry ");
        String child = this.getDef("C_" + endcaps);
        if (child.charAt(0) == '_') {
            this.output("DEF " + child + " IndexedFaceSet {");
            this.outputCylinderGeometry(endcaps == 2);
            this.output("}\n");
        } else {
            this.output(child);
        }
        this.outputAppearance(colix, false);
        this.output("}]");
    }

    protected void outputCylinderGeometry(boolean addEndCaps) {
        float y;
        float x;
        int i;
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n * 2 + (addEndCaps ? 2 : 0);
        int[][] faces = AU.newInt2(n * (addEndCaps ? 4 : 2));
        int fpt = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            faces[fpt++] = new int[]{i2, (i2 + 1) % n, i2 + n};
            faces[fpt++] = new int[]{(i2 + 1) % n, (i2 + 1) % n + n, i2 + n};
            if (!addEndCaps) continue;
            faces[fpt++] = new int[]{i2, (i2 + n - 1) % n, vertexCount - 2};
            faces[fpt++] = new int[]{i2 + n, (i2 + n + 1) % n + n, vertexCount - 1};
        }
        T3[] vertexes = new P3[vertexCount];
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, 0.5f, y);
        }
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            y = (float)Math.sin(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            vertexes[i + n] = P3.new3(x, -0.5f, y);
        }
        if (addEndCaps) {
            vertexes[vertexCount - 2] = P3.new3(0.0f, 0.5f, 0.0f);
            vertexes[vertexCount - 1] = P3.new3(0.0f, -0.5f, 0.0f);
        }
        this.outputGeometry(vertexes, null, null, faces, null, vertexCount, faces.length, null, 3, null, null, null);
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.output("Shape {geometry IndexedFaceSet {");
        this.outputGeometry(vertices, normals, colixes, indices, polygonColixes, nVertices, nPolygons, bsPolygons, faceVertexMax, colorList, htColixes, offset);
        this.output("}\n");
        this.outputAppearance(colix, false);
        this.output("}\n");
    }

    protected void outputGeometry(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, BS bsPolygons, int faceVertexMax, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.output("  creaseAngle 0.5  \n");
        if (polygonColixes != null) {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\npoint [\n");
        this.outputVertices(vertices, nVertices, offset);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] map = new int[nVertices];
        this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        this.output("  ]\n");
        if (normals != null) {
            Lst<String> vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(vNormals);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
            this.output("  ]\n");
        }
        map = null;
        if (colorList != null) {
            this.output("  color Color { color [\n");
            this.outputColors(colorList);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(indices, nPolygons, bsPolygons, faceVertexMax, htColixes, colixes, polygonColixes);
            this.output("  ]\n");
        }
    }

    @Override
    protected void outputFace(int[] face, int[] map, int faceVertexMax) {
        this.output(map[face[0]] + " " + map[face[1]] + " " + map[face[2]] + " -1\n");
        if (faceVertexMax == 4 && face.length == 4) {
            this.output(map[face[0]] + " " + map[face[2]] + " " + map[face[3]] + " -1\n");
        }
    }

    protected void outputNormals(Lst<String> vNormals) {
        int n = vNormals.size();
        for (int i = 0; i < n; ++i) {
            this.output((String)vNormals.get(i));
        }
    }

    protected void outputColors(Lst<Short> colorList) {
        int nColors = colorList.size();
        for (int i = 0; i < nColors; ++i) {
            String color = this.rgbFractionalFromColix((Short)colorList.get(i));
            this.output(" ");
            this.output(color);
            this.output("\n");
        }
    }

    protected void outputColorIndices(int[][] indices, int nPolygons, BS bsPolygons, int faceVertexMax, Map<Short, Integer> htColixes, short[] colixes, short[] polygonColixes) {
        int i0;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            if (polygonColixes == null) {
                this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][1]]) + " " + htColixes.get(colixes[indices[i][2]]) + " -1\n");
                if (faceVertexMax == 4 && indices[i].length == 4) {
                    this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][2]]) + " " + htColixes.get(colixes[indices[i][3]]) + " -1\n");
                }
            } else {
                this.output(htColixes.get(polygonColixes[i]) + "\n");
            }
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
    }

    @Override
    protected void outputSphere(P3 ptCenter, float radius, short colix, boolean checkRadius) {
        String check = _VrmlExporter.round(ptCenter) + (checkRadius ? " " + (int)(radius * 100.0f) : "");
        if (this.htSpheresRendered.get(check) != null) {
            return;
        }
        this.htSpheresRendered.put(check, Boolean.TRUE);
        this.outputSphereChildScaled(ptCenter, radius, null, colix);
    }

    @Override
    protected void outputEllipsoid(P3 ptCenter, P3[] points, short colix) {
        this.outputSphereChildScaled(ptCenter, 1.0f, points, colix);
    }

    protected void outputSphereChildScaled(P3 ptCenter, float radius, P3[] points, short colix) {
        String child = this.getDef("S");
        this.pushMatrix();
        this.outputTranslation(ptCenter);
        if (points == null) {
            this.outputScale(radius, radius, radius);
        } else {
            this.outputQuaternionFrame(ptCenter, points[1], points[3], points[5], 1.0f, 1.0f, 1.0f, " ", "");
        }
        this.output(" children[Shape{geometry ");
        if (child.charAt(0) == '_') {
            this.output("DEF " + child + " IndexedFaceSet {");
            this.outputSphereGeometry();
            this.output("}\n");
        } else {
            this.output(child);
        }
        this.outputAppearance(colix, false);
        this.output("}]");
        this.popMatrix();
    }

    protected void outputSphereGeometry() {
        T3[] vertices = Geodesic.getVertexVectors();
        int nVertices = 162;
        short[] faceList = Geodesic.getFaceVertexes(2);
        int nFaces = faceList.length / 3;
        int[][] indices = new int[nFaces][3];
        int p = 0;
        for (int i = 0; i < nFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                indices[i][j] = faceList[p++];
            }
        }
        this.outputGeometry(vertices, null, null, indices, null, nVertices, nFaces, null, 3, null, null, null);
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.output("Shape{geometry IndexedFaceSet{solid FALSE ");
        this.outputTriangleGeometry(pt1, pt2, pt3, colix);
        this.output("}\n");
        this.outputAppearance(colix, false);
        this.output("}\n");
    }

    private void outputTriangleGeometry(T3 pt1, T3 pt2, T3 pt3, short colix) {
        if (this.oneFace == null) {
            this.oneFace = new int[][]{{0, 1, 2}};
            this.threeVertices = new P3[]{this.tempP1, this.tempP2, this.tempP3};
        }
        this.threeVertices[0].setT(pt1);
        this.threeVertices[1].setT(pt2);
        this.threeVertices[2].setT(pt3);
        this.outputGeometry(this.threeVertices, null, null, this.oneFace, null, 3, 1, null, 3, null, null, null);
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    protected void outputTransRot(P3 pt1, P3 pt2, int x, int y, int z, String pre, String post) {
        this.tempV1.ave(pt2, pt1);
        if (this.isBinary) {
            this.outputTranslation(this.tempV1);
        } else {
            this.output("translation");
            this.output(pre);
            this.output(this.tempV1);
            this.output(post);
        }
        this.tempV1.sub(pt1);
        this.tempV1.normalize();
        this.tempV2.set(x, y, z);
        this.tempV2.add(this.tempV1);
        if (this.isBinary) {
            this.outputRotation(A4.newVA(this.tempV2, (float)Math.PI));
        } else {
            this.output(" rotation");
            this.output(pre);
            this.output(this.tempV2);
            this.output(" ");
            this.output(_VrmlExporter.round(3.1415927410125732));
            this.output(post);
        }
    }

    protected void outputScale(float x, float y, float z) {
        this.output(" scale " + _VrmlExporter.round(x) + " " + _VrmlExporter.round(y) + " " + _VrmlExporter.round(z));
    }

    protected void outputTranslation(T3 pt) {
        this.output("translation " + pt.x + " " + pt.y + " " + pt.z);
    }

    protected void outputRotation(A4 a) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.output("Transform{translation ");
        this.output(this.setFont(x, y, z, colix, text, font3d));
        this.output(" children [ ");
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF " + this.fontChild + " Billboard{axisOfRotation 0 0 0 children Transform{children Shape{");
            this.outputAppearance(colix, true);
            this.output(" geometry Text{fontStyle ");
            String fontstyle = this.getDef("F" + this.fontFace + this.fontStyle);
            if (fontstyle.charAt(0) == '_') {
                this.output("DEF " + fontstyle + " FontStyle{size " + this.fontSize + " family \"" + this.fontFace + "\" style \"" + this.fontStyle + "\"}");
            } else {
                this.output(fontstyle);
            }
            this.output(" string " + PT.esc(text) + "}}}}");
        } else {
            this.output(this.fontChild);
        }
        this.output("]}\n");
    }

    protected T3 setFont(int x, int y, int z, short colix, String text, Font font3d) {
        this.tempP3.set(x, y, this.fixScreenZ(z));
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.fontStyle = font3d.fontStyle.toUpperCase();
        this.fontFace = font3d.fontFace.toUpperCase();
        this.fontFace = this.fontFace.equals("MONOSPACED") ? "TYPEWRITER" : (this.fontFace.equals("SERIF") ? "SERIF" : "Arial");
        this.fontSize = font3d.fontSize * 0.015f;
        this.fontChild = this.getDef("T" + colix + this.fontFace + this.fontStyle + this.fontSize + "_" + text);
        return this.tempP1;
    }

    protected String getDef(String key) {
        return this.useTable == null ? "_" : this.useTable.getDef(key);
    }
}

