/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.util.Objects;
import oauth.signpost.OAuthConsumer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthToken {
    private final String key;
    private final String secret;

    public static OAuthToken createToken(OAuthConsumer oAuthConsumer) {
        return new OAuthToken(oAuthConsumer.getToken(), oAuthConsumer.getTokenSecret());
    }

    public OAuthToken(String string, String string2) {
        this.key = string;
        this.secret = string2;
    }

    public OAuthToken(OAuthToken oAuthToken) {
        CheckParameterUtil.ensureParameterNotNull(oAuthToken, "other");
        this.key = oAuthToken.key;
        this.secret = oAuthToken.secret;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.secret);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OAuthToken oAuthToken = (OAuthToken)object;
        return Objects.equals(this.key, oAuthToken.key) && Objects.equals(this.secret, oAuthToken.secret);
    }
}

