/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.LassoModeAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.ShowThumbnailAction;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class GeoImageLayer
extends AbstractModifiableLayer
implements PropertyChangeListener,
JumpToMarkerActions.JumpToMarkerLayer {
    private static List<Action> menuAdditions = new LinkedList<Action>();
    private static volatile List<MapMode> supportedMapModes;
    List<ImageEntry> data;
    GpxLayer gpxLayer;
    private final Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private final Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private int currentPhoto = -1;
    boolean useThumbs;
    private final ExecutorService thumbsLoaderExecutor = Executors.newSingleThreadExecutor(Utils.newThreadFactory("thumbnail-loader-%d", 1));
    private ThumbsLoader thumbsloader;
    private boolean thumbsLoaderRunning;
    volatile boolean thumbsLoaded;
    private BufferedImage offscreenBuffer;
    boolean updateOffscreenBuffer = true;
    private MouseAdapter mouseAdapter;
    private MapFrame.MapModeChangeListener mapModeListener;

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer) {
        this(list, gpxLayer, null, false);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, String string) {
        this(list, gpxLayer, string, false);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, boolean bl) {
        this(list, gpxLayer, null, bl);
    }

    public GeoImageLayer(List<ImageEntry> list, GpxLayer gpxLayer, String string, boolean bl) {
        super(string != null ? string : I18n.tr("Geotagged Images", new Object[0]));
        if (list != null) {
            Collections.sort(list);
        }
        this.data = list;
        this.gpxLayer = gpxLayer;
        this.useThumbs = bl;
    }

    public static void create(Collection<File> collection, GpxLayer gpxLayer) {
        Main.worker.execute(new Loader(collection, gpxLayer));
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage");
    }

    public static void registerMenuAddition(Action action) {
        menuAdditions.add(action);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(LayerListDialog.getInstance().createShowHideLayerAction());
        arrayList.add(LayerListDialog.getInstance().createDeleteLayerAction());
        arrayList.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        arrayList.add(new RenameLayerAction(null, this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new CorrelateGpxWithImages(this));
        arrayList.add(new ShowThumbnailAction(this));
        if (!menuAdditions.isEmpty()) {
            arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
            arrayList.addAll(menuAdditions);
        }
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new JumpToMarkerActions.JumpToNextMarker(this));
        arrayList.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private String infoText() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.data != null) {
            n3 = this.data.size();
            for (ImageEntry imageEntry : this.data) {
                if (imageEntry.getPos() != null) {
                    ++n;
                }
                if (!imageEntry.hasNewGpsData()) continue;
                ++n2;
            }
        }
        return "<html>" + I18n.trn("{0} image loaded.", "{0} images loaded.", n3, n3) + ' ' + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", n, n) + (n2 > 0 ? "<br>" + I18n.trn("{0} has updated GPS data.", "{0} have updated GPS data.", n2, n2) : "") + "</html>";
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isModified() {
        if (this.data != null) {
            for (ImageEntry imageEntry : this.data) {
                if (!imageEntry.hasNewGpsData()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        ImageEntry imageEntry;
        GeoImageLayer geoImageLayer = (GeoImageLayer)layer;
        this.stopLoadThumbs();
        geoImageLayer.stopLoadThumbs();
        ImageEntry imageEntry2 = imageEntry = geoImageLayer.data != null && geoImageLayer.currentPhoto >= 0 ? geoImageLayer.data.get(geoImageLayer.currentPhoto) : null;
        if (geoImageLayer.data != null) {
            this.data.addAll(geoImageLayer.data);
        }
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry imageEntry3 = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry imageEntry4 = this.data.get(i);
                if (imageEntry4.getFile().equals(imageEntry3.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                imageEntry3 = imageEntry4;
            }
        }
        if (imageEntry != null && !this.data.isEmpty()) {
            GuiHelper.runInEDTAndWait(() -> {
                for (int i = 0; i < this.data.size(); ++i) {
                    if (!imageEntry.equals(this.data.get(i))) continue;
                    this.currentPhoto = i;
                    ImageViewerDialog.showImage(this, this.data.get(i));
                    break;
                }
            });
        }
        this.setName(geoImageLayer.getName());
        this.thumbsLoaded &= geoImageLayer.thumbsLoaded;
    }

    private static Dimension scaledDimension(Image image) {
        double d = Main.map.mapView.getDist100Pixel();
        double d2 = 1000.0 / d;
        if (d2 < 22.0) {
            d2 = 22.0;
        }
        if (d2 > 120.0) {
            d2 = 120.0;
        }
        double d3 = d2 / 120.0;
        if (image == null) {
            return null;
        }
        return new Dimension((int)Math.round(d3 * (double)image.getWidth(null)), (int)Math.round(d3 * (double)image.getHeight(null)));
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Cloneable cloneable;
        Object object;
        Object object2;
        int n = mapView.getWidth();
        int n2 = mapView.getHeight();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.useThumbs) {
            if (!this.thumbsLoaded) {
                this.startLoadThumbs();
            }
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != n || this.offscreenBuffer.getHeight() != n2) {
                this.offscreenBuffer = new BufferedImage(n, n2, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                object2 = this.offscreenBuffer.createGraphics();
                ((Graphics)object2).setColor(new Color(0, 0, 0, 0));
                object = ((Graphics2D)object2).getComposite();
                ((Graphics2D)object2).setComposite(AlphaComposite.Clear);
                ((Graphics)object2).fillRect(0, 0, n, n2);
                ((Graphics2D)object2).setComposite((Composite)object);
                if (this.data != null) {
                    for (ImageEntry imageEntry : this.data) {
                        if (imageEntry.getPos() == null) continue;
                        cloneable = mapView.getPoint(imageEntry.getPos());
                        if (imageEntry.hasThumbnail()) {
                            Dimension dimension = GeoImageLayer.scaledDimension(imageEntry.getThumbnail());
                            Rectangle rectangle2 = new Rectangle(((Point)cloneable).x - dimension.width / 2, ((Point)cloneable).y - dimension.height / 2, dimension.width, dimension.height);
                            if (!rectangle.intersects(rectangle2)) continue;
                            ((Graphics)object2).drawImage(imageEntry.getThumbnail(), rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                            continue;
                        }
                        this.icon.paintIcon(mapView, (Graphics)object2, ((Point)cloneable).x - this.icon.getIconWidth() / 2, ((Point)cloneable).y - this.icon.getIconHeight() / 2);
                    }
                }
                this.updateOffscreenBuffer = false;
            }
            graphics2D.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else if (this.data != null) {
            object2 = this.data.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (((ImageEntry)object).getPos() == null) continue;
                Point point = mapView.getPoint(((ImageEntry)object).getPos());
                this.icon.paintIcon(mapView, graphics2D, point.x - this.icon.getIconWidth() / 2, point.y - this.icon.getIconHeight() / 2);
            }
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size() && ((ImageEntry)(object2 = this.data.get(this.currentPhoto))).getPos() != null) {
            int n3;
            int n4;
            object = mapView.getPoint(((ImageEntry)object2).getPos());
            if (this.useThumbs && ((ImageEntry)object2).hasThumbnail()) {
                cloneable = GeoImageLayer.scaledDimension(((ImageEntry)object2).getThumbnail());
                n4 = cloneable.width;
                n3 = cloneable.height;
            } else {
                n4 = this.selectedIcon.getIconWidth();
                n3 = this.selectedIcon.getIconHeight();
            }
            if (((ImageEntry)object2).getExifImgDir() != null) {
                double d = Math.max(25.0, (double)Math.max(n4, n3) * 0.85);
                double d2 = d / 1.4;
                double d3 = ((ImageEntry)object2).getExifImgDir();
                double d4 = d3 < 90.0 ? d3 + 270.0 : d3 - 90.0;
                double d5 = d4 < 90.0 ? d4 + 270.0 : d4 - 90.0;
                double d6 = d4 > 270.0 ? d4 - 270.0 : d4 + 90.0;
                double d7 = (double)((Point)object).x + Math.cos(Math.toRadians(d4)) * d;
                double d8 = (double)((Point)object).y + Math.sin(Math.toRadians(d4)) * d;
                double d9 = (double)((Point)object).x + Math.cos(Math.toRadians(d5)) * d2 / 2.0;
                double d10 = (double)((Point)object).y + Math.sin(Math.toRadians(d5)) * d2 / 2.0;
                double d11 = (double)((Point)object).x + Math.cos(Math.toRadians(d6)) * d2 / 2.0;
                double d12 = (double)((Point)object).y + Math.sin(Math.toRadians(d6)) * d2 / 2.0;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(new Color(255, 255, 255, 192));
                int[] nArray = new int[]{(int)d9, (int)d7, (int)d11, (int)d9};
                int[] nArray2 = new int[]{(int)d10, (int)d8, (int)d12, (int)d10};
                graphics2D.fillPolygon(nArray, nArray2, 4);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(1.2f));
                graphics2D.drawPolyline(nArray, nArray2, 3);
            }
            if (this.useThumbs && ((ImageEntry)object2).hasThumbnail()) {
                graphics2D.setColor(new Color(128, 0, 0, 122));
                graphics2D.fillRect(((Point)object).x - n4 / 2, ((Point)object).y - n3 / 2, n4, n3);
            } else {
                this.selectedIcon.paintIcon(mapView, graphics2D, ((Point)object).x - n4 / 2, ((Point)object).y - n3 / 2);
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.getPos());
        }
    }

    public void showNextPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showFirstPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            this.currentPhoto = 0;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showLastPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            this.currentPhoto = this.data.size() - 1;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void checkPreviousNextButtons() {
        ImageViewerDialog.setNextEnabled(this.data != null && this.currentPhoto < this.data.size() - 1);
        ImageViewerDialog.setPreviousEnabled(this.currentPhoto > 0);
    }

    public void removeCurrentPhoto() {
        if (this.data != null && !this.data.isEmpty() && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                ImageViewerDialog.showImage(this, null);
            }
            this.updateOffscreenBuffer = true;
            Main.map.repaint();
        }
    }

    public void removeCurrentPhotoFromDisk() {
        if (this.data != null && !this.data.isEmpty() && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            ImageEntry imageEntry = this.data.get(this.currentPhoto);
            int n = new ExtendedDialog(Main.parent, I18n.tr("Delete image file from disk", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Delete", new Object[0])).setButtonIcons("cancel", "dialogs/delete").setContent(new JLabel(I18n.tr("<html><h3>Delete the file {0} from disk?<p>The image file will be permanently lost!</h3></html>", imageEntry.getFile().getName()), ImageProvider.get("dialogs/geoimage/deletefromdisk"), 2)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
            if (n == 2) {
                this.data.remove(this.currentPhoto);
                if (this.currentPhoto >= this.data.size()) {
                    this.currentPhoto = this.data.size() - 1;
                }
                if (this.currentPhoto >= 0) {
                    ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
                } else {
                    ImageViewerDialog.showImage(this, null);
                }
                if (Utils.deleteFile(imageEntry.getFile())) {
                    Main.info("File " + imageEntry.getFile() + " deleted. ");
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image file could not be deleted.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                }
                this.updateOffscreenBuffer = true;
                Main.map.repaint();
            }
        }
    }

    public void copyCurrentPhotoPath() {
        if (this.data != null && !this.data.isEmpty() && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            ClipboardUtils.copyString(this.data.get(this.currentPhoto).getFile().toString());
        }
    }

    public void removePhotoByIdx(int n) {
        if (n >= 0 && this.data != null && n < this.data.size()) {
            this.data.remove(n);
        }
    }

    public ImageEntry getPhotoUnderMouse(MouseEvent mouseEvent) {
        if (this.data != null) {
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Rectangle rectangle;
                ImageEntry imageEntry = this.data.get(i);
                if (imageEntry.getPos() == null) continue;
                Point point = Main.map.mapView.getPoint(imageEntry.getPos());
                if (this.useThumbs && imageEntry.hasThumbnail()) {
                    Dimension dimension = GeoImageLayer.scaledDimension(imageEntry.getThumbnail());
                    rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                } else {
                    rectangle = new Rectangle(point.x - this.icon.getIconWidth() / 2, point.y - this.icon.getIconHeight() / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
                }
                if (!rectangle.contains(mouseEvent.getPoint())) continue;
                return imageEntry;
            }
        }
        return null;
    }

    public void clearCurrentPhoto(boolean bl) {
        this.currentPhoto = -1;
        if (bl) {
            this.updateBufferAndRepaint();
        }
    }

    private void clearOtherCurrentPhotos() {
        for (GeoImageLayer geoImageLayer : Main.getLayerManager().getLayersOfType(GeoImageLayer.class)) {
            if (geoImageLayer == this) continue;
            geoImageLayer.clearCurrentPhoto(false);
        }
    }

    public static void registerSupportedMapMode(MapMode mapMode) {
        if (supportedMapModes == null) {
            supportedMapModes = new ArrayList<MapMode>();
        }
        supportedMapModes.add(mapMode);
    }

    private static boolean isSupportedMapMode(MapMode mapMode) {
        if (mapMode instanceof SelectAction || mapMode instanceof LassoModeAction) {
            return true;
        }
        if (supportedMapModes != null) {
            for (MapMode mapMode2 : supportedMapModes) {
                if (mapMode != mapMode2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void hookUpMapView() {
        this.mouseAdapter = new MouseAdapter(){

            private boolean isMapModeOk() {
                return Main.map.mapMode == null || GeoImageLayer.isSupportedMapMode(Main.map.mapMode);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.isVisible() && this.isMapModeOk()) {
                    Main.map.mapView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.data == null || !GeoImageLayer.this.isVisible() || !this.isMapModeOk()) {
                    return;
                }
                for (int i = GeoImageLayer.this.data.size() - 1; i >= 0; --i) {
                    Rectangle rectangle;
                    ImageEntry imageEntry = GeoImageLayer.this.data.get(i);
                    if (imageEntry.getPos() == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.getPos());
                    if (GeoImageLayer.this.useThumbs && imageEntry.hasThumbnail()) {
                        Dimension dimension = GeoImageLayer.scaledDimension(imageEntry.getThumbnail());
                        rectangle = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
                    } else {
                        rectangle = new Rectangle(point.x - GeoImageLayer.this.icon.getIconWidth() / 2, point.y - GeoImageLayer.this.icon.getIconHeight() / 2, GeoImageLayer.this.icon.getIconWidth(), GeoImageLayer.this.icon.getIconHeight());
                    }
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    GeoImageLayer.this.clearOtherCurrentPhotos();
                    GeoImageLayer.this.currentPhoto = i;
                    ImageViewerDialog.showImage(GeoImageLayer.this, imageEntry);
                    Main.map.repaint();
                    break;
                }
            }
        };
        this.mapModeListener = (mapMode, mapMode2) -> {
            if (mapMode2 == null || GeoImageLayer.isSupportedMapMode(mapMode2)) {
                Main.map.mapView.addMouseListener(this.mouseAdapter);
            } else {
                Main.map.mapView.removeMouseListener(this.mouseAdapter);
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, Main.map.mapMode);
        Main.getLayerManager().addActiveLayerChangeListener(activeLayerChangeEvent -> {
            if (Main.getLayerManager().getActiveLayer() == this) {
                Main.map.selectSelectTool(false);
            }
        });
        Main.getLayerManager().addLayerChangeListener(new LayerManager.LayerChangeListener(){

            @Override
            public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
            }

            @Override
            public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
                if (layerRemoveEvent.getRemovedLayer() == GeoImageLayer.this) {
                    GeoImageLayer.this.stopLoadThumbs();
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                    MapFrame.removeMapModeChangeListener(GeoImageLayer.this.mapModeListener);
                    GeoImageLayer.this.currentPhoto = -1;
                    if (GeoImageLayer.this.data != null) {
                        GeoImageLayer.this.data.clear();
                    }
                    GeoImageLayer.this.data = null;
                    Main.getLayerManager().removeLayerChangeListener(this);
                }
            }

            @Override
            public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
            }
        });
        Main.map.mapView.addPropertyChangeListener(this);
        if (Main.map.getToggleDialog(ImageViewerDialog.class) == null) {
            ImageViewerDialog.newInstance();
            Main.map.addToggleDialog(ImageViewerDialog.getInstance());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("center".equals(propertyChangeEvent.getPropertyName()) || "scale".equals(propertyChangeEvent.getPropertyName())) {
            this.updateOffscreenBuffer = true;
        }
    }

    public synchronized void startLoadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded && !this.thumbsLoaderRunning) {
            this.stopLoadThumbs();
            this.thumbsloader = new ThumbsLoader(this);
            this.thumbsLoaderExecutor.submit(this.thumbsloader);
            this.thumbsLoaderRunning = true;
        }
    }

    public synchronized void stopLoadThumbs() {
        if (this.thumbsloader != null) {
            this.thumbsloader.stop = true;
        }
        this.thumbsLoaderRunning = false;
    }

    public void thumbsLoaded() {
        this.thumbsLoaded = true;
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        this.invalidate();
    }

    public List<ImageEntry> getImages() {
        return this.data == null ? Collections.emptyList() : new ArrayList<ImageEntry>(this.data);
    }

    public GpxLayer getGpxLayer() {
        return this.gpxLayer;
    }

    @Override
    public void jumpToNextMarker() {
        this.showNextPhoto();
    }

    @Override
    public void jumpToPreviousMarker() {
        this.showPreviousPhoto();
    }

    public boolean isUseThumbs() {
        return this.useThumbs;
    }

    public void setUseThumbs(boolean bl) {
        this.useThumbs = bl;
        if (bl && !this.thumbsLoaded) {
            this.startLoadThumbs();
        } else if (!bl) {
            this.stopLoadThumbs();
        }
    }

    static final class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private GeoImageLayer layer;
        private final Collection<File> selection;
        private final Set<String> loadedDirectories = new HashSet<String>();
        private final Set<String> errorMessages;
        private final GpxLayer gpxLayer;

        Loader(Collection<File> collection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF", new Object[0]));
            this.selection = collection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet<String>();
        }

        private void rememberError(String string) {
            this.errorMessages.add(string);
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan", new Object[0]));
            ArrayList<File> arrayList = new ArrayList<File>();
            try {
                this.addRecursiveFiles(arrayList, this.selection);
            }
            catch (IllegalStateException illegalStateException) {
                Main.debug(illegalStateException);
                this.rememberError(illegalStateException.getMessage());
            }
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(arrayList.size());
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(arrayList.size());
            ArrayList<ImageEntry> arrayList2 = new ArrayList<ImageEntry>(arrayList.size());
            for (File file : arrayList) {
                if (this.canceled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", file.getName()));
                this.progressMonitor.worked(1);
                ImageEntry imageEntry = new ImageEntry(file);
                imageEntry.extractExif();
                arrayList2.add(imageEntry);
            }
            this.layer = new GeoImageLayer(arrayList2, this.gpxLayer);
            arrayList.clear();
        }

        private void addRecursiveFiles(Collection<File> collection, Collection<File> collection2) {
            boolean bl = false;
            for (File file : collection2) {
                if (this.canceled) break;
                if (file == null) {
                    bl = true;
                    continue;
                }
                if (file.isDirectory()) {
                    String string = null;
                    try {
                        string = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        Main.error(iOException);
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", file.getAbsolutePath()));
                    }
                    if (string == null || this.loadedDirectories.contains(string)) continue;
                    this.loadedDirectories.add(string);
                    File[] fileArray = file.listFiles(JpgImporter.FILE_FILTER_WITH_FOLDERS);
                    if (fileArray != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", file.getPath()));
                        this.addRecursiveFiles(collection, Arrays.asList(fileArray));
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", file.getPath()));
                    continue;
                }
                collection.add(file);
            }
            if (bl) {
                throw new IllegalStateException(I18n.tr("One of the selected files was null", new Object[0]));
            }
        }

        private String formatErrorMessages() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (this.errorMessages.size() == 1) {
                stringBuilder.append(this.errorMessages.iterator().next());
            } else {
                stringBuilder.append(Utils.joinAsHtmlUnorderedList(this.errorMessages));
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, this.formatErrorMessages(), I18n.tr("Error", new Object[0]), 0);
            }
            if (this.layer != null) {
                Main.getLayerManager().addLayer(this.layer);
                if (!this.canceled && this.layer.data != null && !this.layer.data.isEmpty()) {
                    boolean bl = true;
                    for (ImageEntry imageEntry : this.layer.data) {
                        if (imageEntry.getPos() == null) continue;
                        bl = false;
                    }
                    if (bl) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }
    }
}

