/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringSupport;

public abstract class Instr {
    public static final Operand[] EMPTY_OPERANDS = new Operand[0];
    private final transient Operation operation;
    private boolean isDead;
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final ClassValue<Field[]> dumpableFields = new ClassValue<Field[]>(){

        @Override
        protected Field[] computeValue(Class type2) {
            try {
                ArrayList<Field> list2 = new ArrayList<Field>();
                for (Class cls = type2; cls != Instr.class; cls = cls.getSuperclass()) {
                    for (Field f : cls.getDeclaredFields()) {
                        if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.getName().startsWith("$")) continue;
                        try {
                            f.setAccessible(true);
                        }
                        catch (SecurityException se) {
                            continue;
                        }
                        list2.add(f);
                    }
                }
                return list2.toArray(new Field[list2.size()]);
            }
            catch (Exception e) {
                return EMPTY_FIELD_ARRAY;
            }
        }
    };

    public Instr(Operation operation) {
        this.operation = operation;
    }

    public String[] toStringNonOperandArgs() {
        return StringSupport.EMPTY_STRING_ARRAY;
    }

    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.isDead() ? "[DEAD]" : "");
        if (this instanceof ResultInstr) {
            buf.append(((ResultInstr)((Object)this)).getResult()).append(" = ");
        }
        Object[] operands = this.getOperands();
        buf.append((Object)this.operation).append('(');
        this.toArgList(buf, operands);
        Object[] extraArgs = this.toStringNonOperandArgs();
        if (extraArgs.length >= 1) {
            if (operands.length > 0) {
                buf.append(' ');
            }
            buf.append(';');
            this.toArgList(buf, extraArgs);
        }
        buf.append(')');
        return buf.toString();
    }

    public Field[] dumpableFields() {
        return dumpableFields.get(this.getClass());
    }

    private StringBuilder toArgList(StringBuilder buf, Object[] args2) {
        if (args2.length <= 0) {
            return buf;
        }
        for (int i2 = 0; i2 < args2.length - 1; ++i2) {
            buf.append(args2[i2]).append(", ");
        }
        buf.append(args2[args2.length - 1]);
        return buf;
    }

    @Interp
    public Operation getOperation() {
        return this.operation;
    }

    public boolean hasSideEffects() {
        return this.operation.hasSideEffects();
    }

    public boolean canRaiseException() {
        return this.operation.canRaiseException();
    }

    public boolean transfersControl() {
        return this.operation.transfersControl();
    }

    public boolean computeScopeFlags(IRScope scope) {
        return false;
    }

    public boolean isDeletable() {
        return !this.hasSideEffects() && !this.operation.isDebugOp() && !this.canRaiseException() && !this.transfersControl();
    }

    public boolean canBeDeletedFromScope(IRScope s2) {
        if (!this.isDeletable()) {
            return false;
        }
        if (this instanceof ResultInstr) {
            Variable r = ((ResultInstr)((Object)this)).getResult();
            if (s2.bindingHasEscaped()) {
                return !(r instanceof LocalVariable);
            }
        }
        return true;
    }

    public void markDead() {
        this.isDead = true;
    }

    @Interp
    public boolean isDead() {
        return this.isDead;
    }

    public abstract Operand[] getOperands();

    public abstract void setOperand(int var1, Operand var2);

    public List<Variable> getUsedVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Operand operand : this.getOperands()) {
            operand.addUsedVariables(vars);
        }
        return vars;
    }

    public void renameVars(Map<Operand, Operand> renameMap) {
        ResultInstr ri;
        Variable oldVar;
        Variable newVar;
        this.simplifyOperands(renameMap, true);
        if (this instanceof ResultInstr && (newVar = (Variable)renameMap.get(oldVar = (ri = (ResultInstr)((Object)this)).getResult())) != null) {
            ri.updateResult(newVar);
        }
    }

    public abstract Instr clone(CloneInfo var1);

    public Operand[] cloneOperands(CloneInfo info) {
        Operand[] operands = this.getOperands();
        Operand[] newOperands = new Operand[operands.length];
        for (int i2 = 0; i2 < operands.length; ++i2) {
            newOperands[i2] = operands[i2].cloneForInlining(info);
        }
        return newOperands;
    }

    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        Operand[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            this.setOperand(i2, operands[i2].getSimplifiedOperand(valueMap, force));
        }
    }

    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return null;
    }

    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    @Interp
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public void visit(IRVisitor visitor) {
        throw new RuntimeException(this.getClass().getSimpleName() + " has no compile logic");
    }
}

