/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager progressManager = ProgressManagerHolder.ourInstance;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    public abstract void runProcess(@NotNull Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract void run(@NotNull Task var1);

    public <T, E extends Exception> T run(@NotNull Task.WithResult<T, E> task) throws E {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/ProgressManager", "run"));
        }
        this.run((Task)task);
        return task.getResult();
    }

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/ProgressManager", "indicatorCanceled"));
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/ProgressManager", "canceled"));
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.getInstance().doCheckCanceled();
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    private static class ProgressManagerHolder {
        private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    }
}

