/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        Disposable disposable = Disposer.newDisposable(null);
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "newDisposable"));
        }
        return disposable;
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "newDisposable"));
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent2, @NotNull Disposable child) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/Disposer", "register"));
        }
        Disposer.register(parent2, child, null);
    }

    public static void register(@NotNull Disposable parent2, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/Disposer", "register"));
        }
        assert (parent2 != child) : " Cannot register to itself";
        ourTree.register(parent2, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/Disposer", "get"));
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(@NotNull Disposable each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/util/Disposer$1", "execute"));
                }
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(@NotNull Disposable parent2) {
                if (parent2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer$1", "beforeTreeExecution"));
                }
                if (parent2 instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent2).beforeTreeDispose();
                }
            }
        };
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }
}

