/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodSuperSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.MethodSuperSearcher");

    @Override
    public boolean execute(final @NotNull SuperMethodsSearch.SearchParameters queryParameters, final @NotNull Processor<MethodSignatureBackedByPsiMethod> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/MethodSuperSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/MethodSuperSearcher", "execute"));
        }
        final PsiClass parentClass = queryParameters.getPsiClass();
        final PsiMethod method = queryParameters.getMethod();
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
                boolean checkBases = queryParameters.isCheckBases();
                boolean allowStaticMethod = queryParameters.isAllowStaticMethod();
                List<HierarchicalMethodSignature> supers = signature.getSuperSignatures();
                for (HierarchicalMethodSignature superSignature : supers) {
                    if (!MethodSignatureUtil.isSubsignature(superSignature, signature) || MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature, PsiMethod method, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<MethodSignatureBackedByPsiMethod> consumer) {
        PsiMethod signatureMethod = signature.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf(parentClass, hisClass, true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method, method);
            return consumer.process(signature);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance(method.getProject()).getResolveHelper().isAccessible(superMethod, method, null);
    }
}

