/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @Override
    public PsiElement getElement() {
        return this.myStatement;
    }

    @Override
    public TextRange getRangeInElement() {
        int parent2 = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(parent2, this.myIdentifier.getTextLength() + parent2);
    }

    @Override
    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        if (label == null) {
            return null;
        }
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            PsiLabeledStatement statement;
            if (!(context instanceof PsiLabeledStatement) || !label.equals((statement = (PsiLabeledStatement)context).getName())) continue;
            return statement;
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getElement().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiLabelReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiLabelReference", "bindToElement"));
        }
        if (element instanceof PsiLabeledStatement) {
            this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, ((PsiLabeledStatement)element).getName());
            return this.myIdentifier;
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public String[] getVariants() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement)) continue;
            result2.add(((PsiLabeledStatement)context).getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiLabelReference", "getVariants"));
        }
        return stringArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }
}

