/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl");
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = ContainerUtil.newTroveMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = ContainerUtil.newTroveMap();
    private final ConcurrentFactoryMap<Class, ProviderBinding[]> myBindingCache;
    private boolean myInitialized;

    public PsiReferenceRegistrarImpl(final Language language) {
        this.myBindingCache = new ConcurrentFactoryMap<Class, ProviderBinding[]>(){

            @Override
            @Nullable
            protected ProviderBinding[] create(Class key) {
                List<ProviderBinding> result2 = ContainerUtil.newSmartList();
                for (Class bindingClass : PsiReferenceRegistrarImpl.this.myBindingsMap.keySet()) {
                    if (!bindingClass.isAssignableFrom(key)) continue;
                    result2.add((ProviderBinding)PsiReferenceRegistrarImpl.this.myBindingsMap.get(bindingClass));
                }
                for (Class bindingClass : PsiReferenceRegistrarImpl.this.myNamedBindingsMap.keySet()) {
                    if (!bindingClass.isAssignableFrom(key)) continue;
                    result2.add((ProviderBinding)PsiReferenceRegistrarImpl.this.myNamedBindingsMap.get(bindingClass));
                }
                if (language != Language.ANY) {
                    PsiReferenceRegistrar anyRegistrar = ReferenceProvidersRegistry.getInstance().getRegistrar(Language.ANY);
                    Collections.addAll(result2, (Object[])((PsiReferenceRegistrarImpl)anyRegistrar).myBindingCache.get(key));
                }
                return result2.toArray(new ProviderBinding[result2.size()]);
            }
        };
    }

    public void markInitialized() {
        this.myInitialized = true;
    }

    @Override
    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        SimpleProviderBinding providerBinding;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        Class<T> scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List<PatternCondition<T>> conditions = pattern.getCondition().getConditions();
        for (PatternCondition<T> _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List<PatternCondition<String>> conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition<String> condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection<String> strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtil.toStringArray(strings), nameCondition, scope, true, provider, priority, pattern);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "unregisterReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "unregisterReferenceProvider"));
        }
        this.myBindingsMap.get(scope).unregisterProvider(provider);
    }

    /*
     * WARNING - void declaration
     */
    private void registerNamedReferenceProvider(@NotNull String[] names2, final PsiNamePatternCondition<?> nameCondition, @NotNull Class scopeClass, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern elementPattern) {
        void pattern;
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (scopeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeClass", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        if (elementPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerNamedReferenceProvider"));
        }
        NamedObjectProviderBinding providerBinding = this.myNamedBindingsMap.get(scopeClass);
        if (providerBinding == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    if (position == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl$2", "getName"));
                    }
                    return nameCondition.getPropertyValue(position);
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names2, (ElementPattern)pattern, caseSensitive, provider, priority);
    }

    public void registerReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "registerReferenceProvider"));
        }
        this.registerReferenceProvider(PlatformPatterns.psiElement(scope), provider, 0.0);
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        ProviderBinding[] bindings = (ProviderBinding[])this.myBindingCache.get(element.getClass());
        if (bindings.length == 0) {
            List<ProviderBinding.ProviderInfo<ProcessingContext>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
            }
            return list2;
        }
        List<ProviderBinding.ProviderInfo<ProcessingContext>> ret = ContainerUtil.newSmartList();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element, ret, hints);
        }
        List<ProviderBinding.ProviderInfo<ProcessingContext>> list3 = ret;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl", "getPairsByElement"));
        }
        return list3;
    }
}

