/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.PersistentHashMapValueStorage;

public class CumulativeStubVersion {
    private static final int VERSION = 30 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);

    public static int getCumulativeVersion() {
        int version = VERSION;
        for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            BinaryFileStubBuilder builder;
            IFileElementType type2;
            Language l;
            ParserDefinition parserDefinition;
            if (fileType instanceof LanguageFileType && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l = ((LanguageFileType)fileType).getLanguage())) != null && (type2 = parserDefinition.getFileNodeType()) instanceof IStubFileElementType) {
                version += ((IStubFileElementType)type2).getStubVersion();
            }
            if ((builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) == null) continue;
            version += builder.getStubVersion();
        }
        return version;
    }
}

