/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LockFreeCopyOnWriteArrayList<E>
implements ConcurrentList<E>,
List<E>,
RandomAccess {
    @NotNull
    private volatile Object[] array = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private static final AtomicFieldUpdater<LockFreeCopyOnWriteArrayList, Object[]> ARRAY_UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCopyOnWriteArrayList.class, Object[].class);

    LockFreeCopyOnWriteArrayList() {
    }

    private boolean replaceArray(@NotNull Object[] oldArray, @NotNull Object[] newArray) {
        if (oldArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldArray", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "replaceArray"));
        }
        if (newArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newArray", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "replaceArray"));
        }
        return ARRAY_UPDATER.compareAndSet(this, oldArray, newArray);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int indexOf(Object o, @NotNull Object[] elements, int index2, int fence) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "indexOf"));
        }
        if (o == null) {
            for (int i = index2; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index2; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, @NotNull Object[] elements, int index2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "lastIndexOf"));
        }
        if (o == null) {
            for (int i = index2; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index2; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] elements = this.array;
        if (elements.length == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toArray"));
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = Arrays.copyOf(elements, elements.length, Object[].class);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toArray"));
        }
        Object[] elements = this.array;
        int len = elements.length;
        if (a.length < len) {
            T[] TArray = Arrays.copyOf(elements, len, a.getClass());
            if (TArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toArray"));
            }
            return TArray;
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toArray"));
        }
        return a;
    }

    private E get(@NotNull Object[] a, int index2) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "get"));
        }
        return (E)a[index2];
    }

    @Override
    public E get(int index2) {
        return this.get(this.array, index2);
    }

    @Override
    public E set(int index2, E element) {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = this.array, index2)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index2, element))) {
        }
        return oldValue;
    }

    @NotNull
    private static Object[] createArraySet(@NotNull Object[] elements, int index2, Object element) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArraySet"));
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index2] = element;
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArraySet"));
        }
        return newElements;
    }

    @Override
    public boolean add(E e) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, e))) {
        }
        return true;
    }

    @NotNull
    private Object[] createArrayAdd(@NotNull Object[] elements, E e) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAdd"));
        }
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        if (len != 0) {
            System.arraycopy(elements, 0, newElements, 0, len);
        }
        newElements[len] = e;
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAdd"));
        }
        return newElements;
    }

    @Override
    public void add(int index2, E element) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, index2, element))) {
        }
    }

    @NotNull
    private Object[] createArrayAdd(@NotNull Object[] elements, int index2, E element) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAdd"));
        }
        int len = elements.length;
        if (index2 > len || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        int numMoved = len - index2;
        Object[] newElements = new Object[len + 1];
        if (index2 != 0) {
            System.arraycopy(elements, 0, newElements, 0, index2);
        }
        if (numMoved != 0) {
            System.arraycopy(elements, index2, newElements, index2 + 1, numMoved);
        }
        newElements[index2] = element;
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAdd"));
        }
        return newElements;
    }

    @Override
    public E remove(int index2) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index2))) {
        }
        E oldValue = this.get(elements, index2);
        return oldValue;
    }

    @NotNull
    private static Object[] createArrayRemove(@NotNull Object[] elements, int index2) {
        Object[] newElements;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRemove"));
        }
        int len = elements.length;
        int numMoved = len - index2 - 1;
        Object[] objectArray = newElements = len == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index2 != 0) {
            System.arraycopy(elements, 0, newElements, 0, index2);
        }
        if (numMoved != 0) {
            System.arraycopy(elements, index2 + 1, newElements, index2, numMoved);
        }
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRemove"));
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements = this.array, o)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRemove(@NotNull Object[] elements, Object o) {
        int i;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRemove"));
        }
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i = newLen; i != 0; --i) {
            Object element = elements[i];
            if (LockFreeCopyOnWriteArrayList.eq(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i);
                break;
            }
            newElements[i - 1] = element;
        }
        if (i == 0 && !LockFreeCopyOnWriteArrayList.eq(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean addIfAbsent(E e) {
        Object[] newElements;
        Object[] elements;
        do {
            elements = this.array;
            int len = elements.length;
            newElements = new Object[len + 1];
            for (int i = 0; i < len; ++i) {
                if (LockFreeCopyOnWriteArrayList.eq(e, elements[i])) {
                    return false;
                }
                newElements[i] = elements[i];
            }
            newElements[len] = e;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "containsAll"));
        }
        Object[] elements = this.array;
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "removeAll"));
        }
        if (c.isEmpty()) {
            return false;
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRemoveAll(@NotNull Object[] elements, @NotNull Collection<?> c) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRemoveAll"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRemoveAll"));
        }
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "retainAll"));
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRetainAll(@NotNull Object[] elements, @NotNull Collection<?> c) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRetainAll"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayRetainAll"));
        }
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newlen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newlen, Object[].class);
    }

    @Override
    public void clear() {
        this.array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "addAll"));
        }
        if (c.isEmpty()) {
            return false;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, cs))) {
        }
        return true;
    }

    @NotNull
    private static Object[] createArrayAddAll(@NotNull Object[] elements, @NotNull Object[] cs) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        return newElements;
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "addAll"));
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index2, cs))) {
        }
        return true;
    }

    @NotNull
    private static Object[] createArrayAddAll(@NotNull Object[] elements, int index2, @NotNull Object[] cs) {
        Object[] newElements;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        int len = elements.length;
        if (index2 > len || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        int numMoved = len - index2;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index2);
            System.arraycopy(elements, index2, newElements, index2 + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index2, cs.length);
        if (newElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "createArrayAddAll"));
        }
        return newElements;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.array);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "toString"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list2 = (List)o;
        Iterator it = list2.iterator();
        for (Object element : this.array) {
            if (it.hasNext() && LockFreeCopyOnWriteArrayList.eq(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.array) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object[] elements = this.array;
        if (elements.length == 0) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "iterator"));
            }
            return emptyIterator;
        }
        COWIterator cOWIterator = new COWIterator(elements, 0);
        if (cOWIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "iterator"));
        }
        return cOWIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.listIterator(0);
        if (listIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "listIterator"));
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        Object[] elements = this.array;
        int len = elements.length;
        if (index2 < 0 || index2 > len) {
            throw new IndexOutOfBoundsException("Index: " + index2);
        }
        ListIterator listIterator = elements.length == 0 ? EmptyListIterator.getInstance() : new COWIterator(elements, index2);
        if (listIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList", "listIterator"));
        }
        return listIterator;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class COWIterator
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        private int lastRet;

        private COWIterator(@NotNull Object[] elements, int initialCursor) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/LockFreeCopyOnWriteArrayList$COWIterator", "<init>"));
            }
            this.lastRet = -1;
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastRet = --this.cursor;
            return this.snapshot[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new NoSuchElementException();
            }
            Object e = this.snapshot[this.lastRet];
            this.lastRet = -1;
            LockFreeCopyOnWriteArrayList.this.remove(e);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

