/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtVisitor;

public abstract class TranslatorVisitor<T>
extends KtVisitor<T, TranslationContext> {
    protected abstract T emptyResult(@NotNull TranslationContext var1);

    @Override
    public T visitKtElement(@NotNull KtElement expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/general/TranslatorVisitor", "visitKtElement"));
        }
        context.bindingTrace().report(ErrorsJs.NOT_SUPPORTED.on(expression, expression));
        return this.emptyResult(context);
    }

    public final void traverseContainer(@NotNull KtDeclarationContainer jetClass, @NotNull TranslationContext context) {
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/js/translate/general/TranslatorVisitor", "traverseContainer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/general/TranslatorVisitor", "traverseContainer"));
        }
        for (KtDeclaration declaration : jetClass.getDeclarations()) {
            declaration.accept(this, context);
        }
    }
}

