/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ResolutionCandidate<D extends CallableDescriptor> {
    private final Call call;
    private final D candidateDescriptor;
    private final TypeSubstitutor knownTypeParametersResultingSubstitutor;
    private ReceiverValue dispatchReceiver;
    private ExplicitReceiverKind explicitReceiverKind;

    private ResolutionCandidate(@NotNull Call call, @NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "<init>"));
        }
        this.call = call;
        this.candidateDescriptor = descriptor2;
        this.dispatchReceiver = dispatchReceiver;
        this.explicitReceiverKind = explicitReceiverKind;
        this.knownTypeParametersResultingSubstitutor = knownTypeParametersResultingSubstitutor;
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor2, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, knownTypeParametersResultingSubstitutor);
    }

    public static <D extends CallableDescriptor> ResolutionCandidate<D> create(@NotNull Call call, @NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable TypeSubstitutor knownTypeParametersResultingSubstitutor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "create"));
        }
        return new ResolutionCandidate<D>(call, descriptor2, dispatchReceiver, explicitReceiverKind, knownTypeParametersResultingSubstitutor);
    }

    public void setDispatchReceiver(@Nullable ReceiverValue dispatchReceiver) {
        this.dispatchReceiver = dispatchReceiver;
    }

    public void setExplicitReceiverKind(@NotNull ExplicitReceiverKind explicitReceiverKind) {
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "setExplicitReceiverKind"));
        }
        this.explicitReceiverKind = explicitReceiverKind;
    }

    @NotNull
    public Call getCall() {
        Call call = this.call;
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "getCall"));
        }
        return call;
    }

    @NotNull
    public D getDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "getDescriptor"));
        }
        return d;
    }

    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.dispatchReceiver;
    }

    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Nullable
    public TypeSubstitutor getKnownTypeParametersResultingSubstitutor() {
        return this.knownTypeParametersResultingSubstitutor;
    }

    public String toString() {
        return this.candidateDescriptor.toString();
    }
}

