/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FolderPicker;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;

public final class BibliographyDialog
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler {
    public static final String REGISTRY_PATH = "/org.openoffice.da.Writer4LaTeX.Options/BibliographyOptions";
    private XComponentContext xContext;
    private FolderPicker folderPicker;
    public static String __serviceName = "org.openoffice.da.writer4latex.BibliographyDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer4latex.BibliographyDialog";

    public BibliographyDialog(XComponentContext xContext) {
        this.xContext = xContext;
        this.folderPicker = new FolderPicker(xContext);
    }

    public boolean callHandlerMethod(XWindow xWindow, Object event, String sMethod) throws WrappedTargetException {
        XDialog xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
        DialogAccess dlg = new DialogAccess(xDialog);
        try {
            if (sMethod.equals("external_event")) {
                return this.handleExternalEvent(dlg, event);
            }
            if (sMethod.equals("ConvertZoteroCitationsChange")) {
                return this.convertZoteroCitationsChange(dlg);
            }
            if (sMethod.equals("ConvertJabRefCitationsChange")) {
                return this.convertJabRefCitationsChange(dlg);
            }
            if (sMethod.equals("UseExternalBibTeXFilesChange")) {
                return this.useExternalBibTeXFilesChange(dlg);
            }
            if (sMethod.equals("UseNatbibChange")) {
                return this.useNatbibChange(dlg);
            }
            if (sMethod.equals("BibTeXLocationChange")) {
                return this.bibTeXLocationChange(dlg);
            }
            if (sMethod.equals("BibTeXDirClick")) {
                return this.bibTeXDirClick(dlg);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedTargetException(sMethod, (Object)this, (Object)e);
        }
        return false;
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"external_event", "UseExternalBibTeXFilesChange", "ConvertZoteroCitationsChange", "ConvertJabRefCitationsChange", "UseNatbibChange", "BibTeXLocationChange", "ExternalBibTeXDirClick"};
        return sNames;
    }

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    private boolean handleExternalEvent(DialogAccess dlg, Object aEventObject) throws Exception {
        try {
            String sMethod = AnyConverter.toString((Object)aEventObject);
            if (sMethod.equals("ok")) {
                this.saveConfiguration(dlg);
                return true;
            }
            if (sMethod.equals("back") || sMethod.equals("initialize")) {
                this.loadConfiguration(dlg);
                this.enableBibTeXSettings(dlg);
                this.useNatbibChange(dlg);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method external_event requires a string in the event object argument.", (Object)this, -1);
        }
        return false;
    }

    private void loadConfiguration(DialogAccess dlg) {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            Object view = registry.getRegistryView(REGISTRY_PATH, false);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            dlg.setCheckBoxStateAsBoolean("UseExternalBibTeXFiles", XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseExternalBibTeXFiles"));
            dlg.setCheckBoxStateAsBoolean("ConvertZoteroCitations", XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertZoteroCitations"));
            dlg.setCheckBoxStateAsBoolean("ConvertJabRefCitations", XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertJabRefCitations"));
            dlg.setCheckBoxStateAsBoolean("IncludeOriginalCitations", XPropertySetHelper.getPropertyValueAsBoolean(xProps, "IncludeOriginalCitations"));
            dlg.setListBoxSelectedItem("BibTeXLocation", XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXLocation"));
            dlg.setTextFieldText("BibTeXDir", XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir"));
            dlg.setCheckBoxStateAsBoolean("UseNatbib", XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseNatbib"));
            dlg.setTextFieldText("NatbibOptions", XPropertySetHelper.getPropertyValueAsString(xProps, "NatbibOptions"));
            registry.disposeRegistryView(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.convertZoteroCitationsChange(dlg);
        this.useExternalBibTeXFilesChange(dlg);
    }

    private void saveConfiguration(DialogAccess dlg) {
        RegistryHelper registry = new RegistryHelper(this.xContext);
        try {
            Object view = registry.getRegistryView(REGISTRY_PATH, true);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            XPropertySetHelper.setPropertyValue(xProps, "UseExternalBibTeXFiles", dlg.getCheckBoxStateAsBoolean("UseExternalBibTeXFiles"));
            XPropertySetHelper.setPropertyValue(xProps, "ConvertZoteroCitations", dlg.getCheckBoxStateAsBoolean("ConvertZoteroCitations"));
            XPropertySetHelper.setPropertyValue(xProps, "ConvertJabRefCitations", dlg.getCheckBoxStateAsBoolean("ConvertJabRefCitations"));
            XPropertySetHelper.setPropertyValue(xProps, "IncludeOriginalCitations", dlg.getCheckBoxStateAsBoolean("IncludeOriginalCitations"));
            XPropertySetHelper.setPropertyValue(xProps, "BibTeXLocation", dlg.getListBoxSelectedItem("BibTeXLocation"));
            XPropertySetHelper.setPropertyValue(xProps, "BibTeXDir", dlg.getTextFieldText("BibTeXDir"));
            XPropertySetHelper.setPropertyValue(xProps, "UseNatbib", dlg.getCheckBoxStateAsBoolean("UseNatbib"));
            XPropertySetHelper.setPropertyValue(xProps, "NatbibOptions", dlg.getTextFieldText("NatbibOptions"));
            XChangesBatch xUpdateContext = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)view);
            try {
                xUpdateContext.commitChanges();
            }
            catch (Exception e) {
                // empty catch block
            }
            registry.disposeRegistryView(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean useExternalBibTeXFilesChange(DialogAccess dlg) {
        this.enableBibTeXSettings(dlg);
        return true;
    }

    private boolean convertZoteroCitationsChange(DialogAccess dlg) {
        this.enableBibTeXSettings(dlg);
        return true;
    }

    private boolean convertJabRefCitationsChange(DialogAccess dlg) {
        this.enableBibTeXSettings(dlg);
        return true;
    }

    private boolean useNatbibChange(DialogAccess dlg) {
        boolean bUseNatbib = dlg.getCheckBoxStateAsBoolean("UseNatbib");
        dlg.setControlEnabled("NatbibOptionsLabel", bUseNatbib);
        dlg.setControlEnabled("NatbibOptions", bUseNatbib);
        return true;
    }

    private boolean bibTeXLocationChange(DialogAccess dlg) {
        this.enableBibTeXSettings(dlg);
        return true;
    }

    private void enableBibTeXSettings(DialogAccess dlg) {
        boolean bConvertZoteroJabRef = dlg.getCheckBoxStateAsBoolean("ConvertZoteroCitations") || dlg.getCheckBoxStateAsBoolean("ConvertJabRefCitations");
        boolean bEnableLocation = dlg.getCheckBoxStateAsBoolean("UseExternalBibTeXFiles") || bConvertZoteroJabRef;
        boolean bEnableDir = dlg.getListBoxSelectedItem("BibTeXLocation") < 2;
        dlg.setControlEnabled("IncludeOriginalCitations", bConvertZoteroJabRef);
        dlg.setControlEnabled("BibTeXLocationLabel", bEnableLocation);
        dlg.setControlEnabled("BibTeXLocation", bEnableLocation);
        dlg.setControlEnabled("BibTeXDirLabel", bEnableLocation && bEnableDir);
        dlg.setControlEnabled("BibTeXDir", bEnableLocation && bEnableDir);
        dlg.setControlEnabled("BibTeXDirButton", bEnableLocation && bEnableDir);
    }

    private String getDocumentDirURL() {
        XModel xModel;
        XComponent xComponent;
        XServiceInfo xInfo;
        Object desktop = null;
        try {
            desktop = this.xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", this.xContext);
        }
        catch (Exception e) {
            return "";
        }
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        if (xDesktop != null && (xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)(xComponent = xDesktop.getCurrentComponent()))) != null && xInfo.supportsService("com.sun.star.text.TextDocument") && (xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent)) != null) {
            String sURL = xModel.getURL();
            int nSlash = sURL.lastIndexOf(47);
            return nSlash > -1 ? sURL.substring(0, nSlash) : "";
        }
        return "";
    }

    private boolean hasBibTeXFiles(File dir) {
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".bib")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean bibTeXDirClick(DialogAccess dlg) {
        String sPath = this.folderPicker.getPath();
        if (sPath != null) {
            try {
                String sDocumentDirURL;
                File bibDir = new File(new URI(sPath));
                String sBibPath = bibDir.getCanonicalPath();
                if (dlg.getListBoxSelectedItem("BibTeXLocation") == 1 && (sDocumentDirURL = this.getDocumentDirURL()).length() > 0) {
                    String sDocumentDirPath = new File(new URI(sDocumentDirURL)).getCanonicalPath();
                    sBibPath = sBibPath.startsWith(sDocumentDirPath) ? (sBibPath.length() > sDocumentDirPath.length() ? sBibPath.substring(sDocumentDirPath.length() + 1) : "") : "";
                }
                dlg.setTextFieldText("BibTeXDir", sBibPath);
                if (!this.hasBibTeXFiles(bibDir)) {
                    MessageBox msgBox = new MessageBox(this.xContext);
                    msgBox.showMessage("Writer4LaTeX warning", "The selected directory does not contain any BibTeX files");
                }
            }
            catch (IOException e) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }
}

