# -*- coding:binary -*-
require 'spec_helper'

require 'msf/core'
require 'msf/core/exploit/smb/server/share'
require 'rex/proto/smb/constants'

RSpec.describe Msf::Exploit::Remote::SMB::Server::Share do

  include_context "Msf::StringIO"

  subject(:mod) do
    mod = Msf::Exploit.new
    mod.extend described_class
    mod.send(:initialize)

    mod
  end

  let(:valid_find_file_both_directory_info_params) do
    "\x16\x00\x56\x05\x07\x00\x04\x01\x00\x00\x00\x00\x5c\x00\x74\x00" +
    "\x65\x00\x73\x00\x74\x00\x2e\x00\x65\x00\x78\x00\x65\x00\x00\x00"
  end
  let(:find_file_both_directory_info_res_length) { 179 }

  before(:example) do
    msf_io.string = ''
    mod.instance_variable_set('@state', {
      msf_io => {
        :multiplex_id => 0x41424344,
        :process_id   => 0x45464748,
        :file_id      => 0xdead,
        :dir_id       => 0xbeef
      }
    })
    mod.lo = 0
    mod.hi = 0
    mod.share = 'test'
    mod.file_name = 'test.exe'
    mod.file_contents = 'metasploit'
  end

  describe "#smb_cmd_trans2_find_first2" do

    context "when valid SMB_FIND_FILE_BOTH_DIRECTORY_INFO parameters" do
      it "returns the number of bytes answered" do
        expect(mod.smb_cmd_trans2_find_first2(msf_io, valid_find_file_both_directory_info_params)).to eq(find_file_both_directory_info_res_length)
      end

      it "send TRANSACTIONS2 response with the file name found in the SMB_Data" do
        mod.smb_cmd_trans2_find_first2(msf_io, valid_find_file_both_directory_info_params)
        res = msf_io.read

        trans2_res = Rex::Proto::SMB::Constants::SMB_TRANS_RES_PKT.make_struct
        trans2_res.from_s(res)
        param_count = trans2_res['Payload'].v['ParamCount']
        data_count = trans2_res['Payload'].v['DataCount']

        data  = trans2_res['Payload'].v['SetupData'][2 + param_count, data_count]
        smb_data = Rex::Proto::SMB::Constants::SMB_FIND_FILE_BOTH_DIRECTORY_INFO_HDR.make_struct
        smb_data.from_s(data)

        expect(smb_data.v['FileName']).to eq(Rex::Text.to_unicode(mod.file_name))
      end
    end
  end

end


