# ends-with [![NPM version](https://badge.fury.io/js/ends-with.svg)](http://badge.fury.io/js/ends-with)


> Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for comparisons.

## Install
#### Install with [npm](npmjs.org):

```bash
npm i ends-with --save-dev
```

## Run benchmarks

This uses the fasted version of 9 different [implementations](benchmark/implementations) that were benchmarked.

```bash
node benchmark
```

## Run tests

```bash
npm test
```

## Usage

```js
var endsWith = require('ends-with');

endsWith('abc', 'c');
//=> true

endsWith(['a', 'b', 'c'], 'c');
//=> true

endsWith(['abc', 'abc', 'abc'], 'c');
//=> false

endsWith(['abc', 'abc', 'abc'], 'c');
//=> false

endsWith(['a', 'b', 42], 42)
//=> true

endsWith(['a', 'b', 42], '42')
//=> false
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014 Jon Schlinkert, contributors.  
Released under the MIT license

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on October 06, 2014._