/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.parser;

import antlr.ANTLRError;
import antlr.ANTLRException;
import antlr.CommonHiddenStreamToken;
import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.NoViableAltForCharException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamRecognitionException;
import antlr.collections.impl.BitSet;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.metamodel.AbstractAttributeRef;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AggregationRef;
import ch.interlis.ili2c.metamodel.AggregationView;
import ch.interlis.ili2c.metamodel.AnyOIDType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AssociationPath;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.AxisAttributeRef;
import ch.interlis.ili2c.metamodel.BaseUnit;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.ConditionalExpression;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.CoordTypeAny;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.DecompositionView;
import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumValType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ErrorMessages;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.ExtendedView;
import ch.interlis.ili2c.metamodel.FormalArgument;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.FunctionallyDerivedUnit;
import ch.interlis.ili2c.metamodel.Graphic;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.InspectionFactor;
import ch.interlis.ili2c.metamodel.JoinView;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.NumericOIDType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Objects;
import ch.interlis.ili2c.metamodel.Parameter;
import ch.interlis.ili2c.metamodel.ParameterAssignment;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PathElBase;
import ch.interlis.ili2c.metamodel.PathElParent;
import ch.interlis.ili2c.metamodel.PathElRefAttr;
import ch.interlis.ili2c.metamodel.PathElThis;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RefSystemModel;
import ch.interlis.ili2c.metamodel.RefSystemRef;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Selection;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.SignInstruction;
import ch.interlis.ili2c.metamodel.StructAttributeRef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.SymbologyModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.ThisArea;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.UnionView;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import ch.interlis.ili2c.parser.Ili24Lexer;
import ch.interlis.ili2c.parser.Ili24ParserTokenTypes;
import ch.interlis.ili2c.parser.MetaValue;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ili24Parser
extends LLkParser
implements Ili24ParserTokenTypes {
    protected PredefinedModel modelInterlis;
    protected Type predefinedBooleanType;
    protected Table predefinedScalSystemClass;
    protected Table predefinedCoordSystemClass;
    protected TransferDescription td;
    private Ili24Lexer lexer;
    private TokenStreamHiddenTokenFilter filter;
    private boolean checkMetaObjs;
    ResourceBundle rsrc = ResourceBundle.getBundle(ErrorMessages.class.getName(), Locale.getDefault());
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"INTERLIS\"", "';'", "\"CONTRACTED\"", "\"REFSYSTEM\"", "\"MODEL\"", "\"SYMBOLOGY\"", "\"TYPE\"", "NAME", "'('", "')'", "\"NOINCREMENTALTRANSFER\"", "\"AT\"", "STRING", "\"VERSION\"", "EXPLANATION", "\"TRANSLATION\"", "\"OF\"", "'['", "']'", "'='", "\"CHARSET\"", "\"XMLNS\"", "\"IMPORTS\"", "\"UNQUALIFIED\"", "','", "'.'", "\"VIEW\"", "\"TOPIC\"", "\"EXTENDS\"", "\"BASKET\"", "\"OID\"", "\"AS\"", "\"DEPENDS\"", "\"ON\"", "\"DEFFERED\"", "\"GENERICS\"", "\"CLASS\"", "\"STRUCTURE\"", "\"NO\"", "\"ATTRIBUTE\"", "\"PARAMETER\"", "\"CONTINUOUS\"", "\"SUBDIVISION\"", "':'", "':='", "\"MANDATORY\"", "\"BAG\"", "\"LIST\"", "\"ANYSTRUCTURE\"", "\"RESTRICTION\"", "\"REFERENCE\"", "\"TO\"", "\"ANYCLASS\"", "\"ASSOCIATION\"", "\"DERIVED\"", "\"FROM\"", "\"CARDINALITY\"", "\"END\"", "'--'", "'-<>'", "'-<#>'", "\"OR\"", "'{'", "'*'", "'..'", "'}'", "\"CONSTRAINTS\"", "\"DOMAIN\"", "\"UNDEFINED\"", "\"URI\"", "\"NAME\"", "\"MTEXT\"", "\"TEXT\"", "\"ORDERED\"", "\"CIRCULAR\"", "\"ALL\"", "\"FINAL\"", "'#'", "\"OTHERS\"", "\"HALIGNMENT\"", "\"VALIGNMENT\"", "\"BOOLEAN\"", "\"NUMERIC\"", "\"CLOCKWISE\"", "\"COUNTERCLOCKWISE\"", "'<'", "'>'", "\"PI\"", "\"LNBASE\"", "\"FORMAT\"", "\"BASED\"", "\"INHERITANCE\"", "'/'", "\"DATE\"", "\"TIMEOFDAY\"", "\"DATETIME\"", "\"COORD\"", "\"MULTICOORD\"", "\"REFSYS\"", "\"ROTATION\"", "'->'", "\"CONTEXT\"", "\"ANY\"", "\"BLACKBOX\"", "\"XML\"", "\"BINARY\"", "'@'", "'>>'", "\"DIRECTED\"", "\"POLYLINE\"", "\"MULTIPOLYLINE\"", "\"SURFACE\"", "\"MULTISURFACE\"", "\"AREA\"", "\"MULTIAREA\"", "\"VERTEX\"", "\"WITHOUT\"", "\"OVERLAPS\"", "\"LINE\"", "\"ATTRIBUTES\"", "\"WITH\"", "\"ARCS\"", "\"STRAIGHTS\"", "\"FORM\"", "\"UNIT\"", "\"ABSTRACT\"", "\"FUNCTION\"", "\"SIGN\"", "'~'", "\"OBJECTS\"", "\"METAOBJECT\"", "\"CONSTRAINT\"", "'<='", "'>='", "'%'", "\"EXISTENCE\"", "\"REQUIRED\"", "\"IN\"", "\"UNIQUE\"", "\"WHERE\"", "\"LOCAL\"", "\"SET\"", "'=>'", "\"AND\"", "\"NOT\"", "\"DEFINED\"", "'=='", "'!='", "'<>'", "\"INSPECTION\"", "\"THIS\"", "\"THISAREA\"", "\"THATAREA\"", "\"PARENT\"", "'\\\\'", "\"AGGREGATES\"", "\"FIRST\"", "\"LAST\"", "\"OBJECT\"", "\"ENUMVAL\"", "\"ENUMTREEVAL\"", "\"PROJECTION\"", "\"JOIN\"", "\"NULL\"", "\"UNION\"", "\"AGGREGATION\"", "\"EQUAL\"", "\"BASE\"", "\"EXTENDED\"", "\"BY\"", "\"GRAPHIC\"", "\"ACCORDING\"", "\"WHEN\"", "\"DATA\"", "\"EXTERNAL\"", "\"TRANSIENT\"", "\"HIDING\"", "\"GENERIC\"", "DEC", "POSINT", "NUMBER", "PLUS", "MINUS", "WS", "ILI_METAVALUE", "SL_COMMENT", "ILI_DOC", "ML_COMMENT", "'<-'", "ESC", "DIGIT", "LETTER", "ILI1_SCALING", "SCALING", "ILI1_DEC", "HEXDIGIT", "HEXNUMBER", "NUMERICSTUFF"};
    public static final BitSet _tokenSet_0 = new BitSet(Ili24Parser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(Ili24Parser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(Ili24Parser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(Ili24Parser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(Ili24Parser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(Ili24Parser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(Ili24Parser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(Ili24Parser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(Ili24Parser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(Ili24Parser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(Ili24Parser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(Ili24Parser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(Ili24Parser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(Ili24Parser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(Ili24Parser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(Ili24Parser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(Ili24Parser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(Ili24Parser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(Ili24Parser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(Ili24Parser.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(Ili24Parser.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(Ili24Parser.mk_tokenSet_21());
    public static final BitSet _tokenSet_22 = new BitSet(Ili24Parser.mk_tokenSet_22());
    public static final BitSet _tokenSet_23 = new BitSet(Ili24Parser.mk_tokenSet_23());
    public static final BitSet _tokenSet_24 = new BitSet(Ili24Parser.mk_tokenSet_24());
    public static final BitSet _tokenSet_25 = new BitSet(Ili24Parser.mk_tokenSet_25());
    public static final BitSet _tokenSet_26 = new BitSet(Ili24Parser.mk_tokenSet_26());
    public static final BitSet _tokenSet_27 = new BitSet(Ili24Parser.mk_tokenSet_27());
    public static final BitSet _tokenSet_28 = new BitSet(Ili24Parser.mk_tokenSet_28());
    public static final BitSet _tokenSet_29 = new BitSet(Ili24Parser.mk_tokenSet_29());
    public static final BitSet _tokenSet_30 = new BitSet(Ili24Parser.mk_tokenSet_30());
    public static final BitSet _tokenSet_31 = new BitSet(Ili24Parser.mk_tokenSet_31());
    public static final BitSet _tokenSet_32 = new BitSet(Ili24Parser.mk_tokenSet_32());
    public static final BitSet _tokenSet_33 = new BitSet(Ili24Parser.mk_tokenSet_33());
    public static final BitSet _tokenSet_34 = new BitSet(Ili24Parser.mk_tokenSet_34());
    public static final BitSet _tokenSet_35 = new BitSet(Ili24Parser.mk_tokenSet_35());
    public static final BitSet _tokenSet_36 = new BitSet(Ili24Parser.mk_tokenSet_36());
    public static final BitSet _tokenSet_37 = new BitSet(Ili24Parser.mk_tokenSet_37());
    public static final BitSet _tokenSet_38 = new BitSet(Ili24Parser.mk_tokenSet_38());
    public static final BitSet _tokenSet_39 = new BitSet(Ili24Parser.mk_tokenSet_39());
    public static final BitSet _tokenSet_40 = new BitSet(Ili24Parser.mk_tokenSet_40());
    public static final BitSet _tokenSet_41 = new BitSet(Ili24Parser.mk_tokenSet_41());
    public static final BitSet _tokenSet_42 = new BitSet(Ili24Parser.mk_tokenSet_42());
    public static final BitSet _tokenSet_43 = new BitSet(Ili24Parser.mk_tokenSet_43());
    public static final BitSet _tokenSet_44 = new BitSet(Ili24Parser.mk_tokenSet_44());
    public static final BitSet _tokenSet_45 = new BitSet(Ili24Parser.mk_tokenSet_45());
    public static final BitSet _tokenSet_46 = new BitSet(Ili24Parser.mk_tokenSet_46());
    public static final BitSet _tokenSet_47 = new BitSet(Ili24Parser.mk_tokenSet_47());
    public static final BitSet _tokenSet_48 = new BitSet(Ili24Parser.mk_tokenSet_48());
    public static final BitSet _tokenSet_49 = new BitSet(Ili24Parser.mk_tokenSet_49());
    public static final BitSet _tokenSet_50 = new BitSet(Ili24Parser.mk_tokenSet_50());
    public static final BitSet _tokenSet_51 = new BitSet(Ili24Parser.mk_tokenSet_51());
    public static final BitSet _tokenSet_52 = new BitSet(Ili24Parser.mk_tokenSet_52());
    public static final BitSet _tokenSet_53 = new BitSet(Ili24Parser.mk_tokenSet_53());
    public static final BitSet _tokenSet_54 = new BitSet(Ili24Parser.mk_tokenSet_54());
    public static final BitSet _tokenSet_55 = new BitSet(Ili24Parser.mk_tokenSet_55());
    public static final BitSet _tokenSet_56 = new BitSet(Ili24Parser.mk_tokenSet_56());
    public static final BitSet _tokenSet_57 = new BitSet(Ili24Parser.mk_tokenSet_57());
    public static final BitSet _tokenSet_58 = new BitSet(Ili24Parser.mk_tokenSet_58());
    public static final BitSet _tokenSet_59 = new BitSet(Ili24Parser.mk_tokenSet_59());
    public static final BitSet _tokenSet_60 = new BitSet(Ili24Parser.mk_tokenSet_60());
    public static final BitSet _tokenSet_61 = new BitSet(Ili24Parser.mk_tokenSet_61());
    public static final BitSet _tokenSet_62 = new BitSet(Ili24Parser.mk_tokenSet_62());
    public static final BitSet _tokenSet_63 = new BitSet(Ili24Parser.mk_tokenSet_63());
    public static final BitSet _tokenSet_64 = new BitSet(Ili24Parser.mk_tokenSet_64());
    public static final BitSet _tokenSet_65 = new BitSet(Ili24Parser.mk_tokenSet_65());
    public static final BitSet _tokenSet_66 = new BitSet(Ili24Parser.mk_tokenSet_66());
    public static final BitSet _tokenSet_67 = new BitSet(Ili24Parser.mk_tokenSet_67());
    public static final BitSet _tokenSet_68 = new BitSet(Ili24Parser.mk_tokenSet_68());
    public static final BitSet _tokenSet_69 = new BitSet(Ili24Parser.mk_tokenSet_69());
    public static final BitSet _tokenSet_70 = new BitSet(Ili24Parser.mk_tokenSet_70());
    public static final BitSet _tokenSet_71 = new BitSet(Ili24Parser.mk_tokenSet_71());
    public static final BitSet _tokenSet_72 = new BitSet(Ili24Parser.mk_tokenSet_72());
    public static final BitSet _tokenSet_73 = new BitSet(Ili24Parser.mk_tokenSet_73());
    public static final BitSet _tokenSet_74 = new BitSet(Ili24Parser.mk_tokenSet_74());
    public static final BitSet _tokenSet_75 = new BitSet(Ili24Parser.mk_tokenSet_75());
    public static final BitSet _tokenSet_76 = new BitSet(Ili24Parser.mk_tokenSet_76());
    public static final BitSet _tokenSet_77 = new BitSet(Ili24Parser.mk_tokenSet_77());
    public static final BitSet _tokenSet_78 = new BitSet(Ili24Parser.mk_tokenSet_78());
    public static final BitSet _tokenSet_79 = new BitSet(Ili24Parser.mk_tokenSet_79());
    public static final BitSet _tokenSet_80 = new BitSet(Ili24Parser.mk_tokenSet_80());
    public static final BitSet _tokenSet_81 = new BitSet(Ili24Parser.mk_tokenSet_81());
    public static final BitSet _tokenSet_82 = new BitSet(Ili24Parser.mk_tokenSet_82());
    public static final BitSet _tokenSet_83 = new BitSet(Ili24Parser.mk_tokenSet_83());
    public static final BitSet _tokenSet_84 = new BitSet(Ili24Parser.mk_tokenSet_84());
    public static final BitSet _tokenSet_85 = new BitSet(Ili24Parser.mk_tokenSet_85());
    public static final BitSet _tokenSet_86 = new BitSet(Ili24Parser.mk_tokenSet_86());
    public static final BitSet _tokenSet_87 = new BitSet(Ili24Parser.mk_tokenSet_87());
    public static final BitSet _tokenSet_88 = new BitSet(Ili24Parser.mk_tokenSet_88());
    public static final BitSet _tokenSet_89 = new BitSet(Ili24Parser.mk_tokenSet_89());
    public static final BitSet _tokenSet_90 = new BitSet(Ili24Parser.mk_tokenSet_90());
    public static final BitSet _tokenSet_91 = new BitSet(Ili24Parser.mk_tokenSet_91());
    public static final BitSet _tokenSet_92 = new BitSet(Ili24Parser.mk_tokenSet_92());
    public static final BitSet _tokenSet_93 = new BitSet(Ili24Parser.mk_tokenSet_93());
    public static final BitSet _tokenSet_94 = new BitSet(Ili24Parser.mk_tokenSet_94());

    public static boolean parseIliFile(TransferDescription td, String filename, Reader stream, boolean checkMetaObjects, int line0Offest) {
        return Ili24Parser.parseIliFile(td, filename, new Ili24Lexer(stream), checkMetaObjects, line0Offest);
    }

    public static boolean parseIliFile(TransferDescription td, String filename, InputStream stream, boolean checkMetaObjects, int line0Offest) {
        return Ili24Parser.parseIliFile(td, filename, new Ili24Lexer(stream), checkMetaObjects, line0Offest);
    }

    public static boolean parseIliFile(TransferDescription td, String filename, Ili24Lexer lexer, boolean checkMetaObjects, int line0Offest) {
        try {
            if (filename != null && "".equals(td.getName())) {
                td.setName(filename);
            }
            lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter(lexer);
            filter.hide(190);
            filter.hide(188);
            Ili24Parser parser = new Ili24Parser(filter);
            parser.checkMetaObjs = true;
            parser.lexer = lexer;
            parser.filter = filter;
            parser.setFilename(filename);
            return parser.interlisDescription(td);
        }
        catch (RecognitionException ex) {
            int line = ex.getLine();
            CompilerLogEvent.logError(filename, line, ex.getLocalizedMessage());
            return false;
        }
        catch (Ili2cSemanticException ex) {
            int line = ex.getSourceLine();
            CompilerLogEvent.logError(filename, line, ex.getLocalizedMessage());
            return false;
        }
        catch (TokenStreamRecognitionException ex) {
            if (ex.recog instanceof NoViableAltForCharException) {
                NoViableAltForCharException ex2 = (NoViableAltForCharException)ex.recog;
                String msg = "unexpected char: " + ex2.foundChar + " (0x" + Integer.toHexString(ex2.foundChar).toUpperCase() + ")";
                CompilerLogEvent.logError(filename, ex2.getLine(), msg);
            } else {
                CompilerLogEvent.logError(filename, ex.recog.getLine(), ex.getLocalizedMessage());
            }
            return false;
        }
        catch (ANTLRError ex) {
            EhiLogger.traceState(filename + ": " + ex);
            return false;
        }
        catch (Exception ex) {
            CompilerLogEvent.logError(filename, 0, ex);
            return false;
        }
    }

    protected AttributeDef findAttribute(Container scope, String name) {
        if (!(scope instanceof Viewable)) {
            return null;
        }
        Viewable currentViewable = (Viewable)scope;
        AttributeDef attrdef = null;
        Iterator<Extendable> it = currentViewable.getAttributes();
        while (it.hasNext()) {
            AttributeDef ele = (AttributeDef)it.next();
            if (!ele.getName().equals(name)) continue;
            attrdef = ele;
            break;
        }
        return attrdef;
    }

    protected boolean isAttributeRef(Viewable v, String name) {
        AttributeDef attr = this.findAttribute(v, name);
        if (attr == null) {
            return false;
        }
        Type type = attr.getDomainResolvingAliases();
        if (type instanceof ReferenceType) {
            return false;
        }
        return !(type instanceof ObjectType);
    }

    protected Domain resolveDomainRef(Container scope, String[] nams, int lin) {
        AbstractPatternDef topic;
        Model model;
        String domainName = null;
        Domain d = null;
        switch (nams.length) {
            case 1: {
                model = (Model)scope.getContainerOrSame(Model.class);
                topic = (AbstractPatternDef)scope.getContainerOrSame(AbstractPatternDef.class);
                domainName = nams[0];
                break;
            }
            case 2: {
                model = this.resolveOrFixModelName(scope, nams[0], lin);
                topic = null;
                domainName = nams[1];
                break;
            }
            case 3: {
                model = this.resolveOrFixModelName(scope, nams[0], lin);
                topic = this.resolveOrFixTopicName(model, nams[1], lin);
                domainName = nams[2];
                break;
            }
            default: {
                this.reportError(this.rsrc.getString("err_domainRef_weird"), lin);
                model = this.resolveModelName(scope, nams[0]);
                topic = null;
                if (model == null) {
                    model = (Model)scope.getContainerOrSame(Model.class);
                }
                domainName = nams[nams.length - 1];
            }
        }
        d = null;
        if (topic != null) {
            d = (Domain)topic.getRealElement(Domain.class, domainName);
        }
        if (d == null && topic == null | nams.length == 1) {
            d = (Domain)model.getRealElement(Domain.class, domainName);
        }
        if (d == null && nams.length == 1) {
            d = (Domain)model.getImportedElement(Domain.class, domainName);
        }
        if (d == null) {
            if (topic == null) {
                this.reportError(this.formatMessage("err_domainRef_notInModel", domainName, model.toString()), lin);
            } else {
                this.reportError(this.formatMessage("err_domainRef_notInModelOrTopic", domainName, topic.toString(), model.toString()), lin);
            }
            try {
                d = new Domain();
                d.setName(domainName);
                if (topic == null) {
                    model.add(d);
                } else {
                    topic.add(d);
                }
            }
            catch (Exception ex) {
                Ili24Parser.panic();
            }
        }
        return d;
    }

    protected Element resolveStructureOrDomainRef(Container scope, String[] nams, int lin) {
        String tableName;
        AbstractPatternDef topic;
        Model model;
        switch (nams.length) {
            case 1: {
                model = (Model)scope.getContainerOrSame(Model.class);
                topic = (AbstractPatternDef)scope.getContainerOrSame(AbstractPatternDef.class);
                tableName = nams[0];
                break;
            }
            case 2: {
                String modelName = nams[0];
                model = this.resolveOrFixModelName(scope, modelName, lin);
                tableName = nams[1];
                topic = null;
                break;
            }
            case 3: {
                String modelName = nams[0];
                String topicName = nams[1];
                model = this.resolveOrFixModelName(scope, modelName, lin);
                topic = this.resolveOrFixTopicName(model, topicName, lin);
                tableName = nams[2];
                break;
            }
            default: {
                this.reportError(this.rsrc.getString("err_weirdTableRef"), lin);
                model = this.resolveModelName(scope, nams[0]);
                if (model == null) {
                    model = (Model)scope.getContainerOrSame(Model.class);
                }
                topic = null;
                tableName = nams[nams.length - 1];
            }
        }
        Table t = null;
        if (topic != null) {
            t = (Table)topic.getElement(Table.class, tableName);
        }
        if (t == null && model != null) {
            t = (Table)model.getElement(Table.class, tableName);
        }
        if (t == null && nams.length == 1) {
            t = (Table)model.getImportedElement(Table.class, tableName);
        }
        if (t != null) {
            if (t.isIdentifiable()) {
                this.reportError(this.formatMessage("err_structRef_StructRequired", t.getScopedName((Container)null)), lin);
            }
            return t;
        }
        return this.resolveDomainRef(scope, nams, lin);
    }

    protected GraphicParameterDef resolveRuntimeParameterRef(Container scope, String[] nams, int lin) {
        Model model;
        String domainName = null;
        GraphicParameterDef d = null;
        switch (nams.length) {
            case 1: {
                model = (Model)scope.getContainerOrSame(Model.class);
                domainName = nams[0];
                break;
            }
            case 2: {
                model = this.resolveOrFixModelName(scope, nams[0], lin);
                domainName = nams[1];
                break;
            }
            default: {
                this.reportError(this.rsrc.getString("err_runtimeParamRef_weird"), lin);
                model = this.resolveModelName(scope, nams[0]);
                if (model == null) {
                    model = (Model)scope.getContainerOrSame(Model.class);
                }
                domainName = nams[nams.length - 1];
            }
        }
        d = null;
        d = (GraphicParameterDef)model.getRealElement(GraphicParameterDef.class, domainName);
        if (d == null && nams.length == 1) {
            d = (GraphicParameterDef)model.getImportedElement(GraphicParameterDef.class, domainName);
        }
        if (d == null) {
            this.reportError(this.formatMessage("err_runtimeParamRef_notInModel", domainName, model.toString()), lin);
        }
        return d;
    }

    @Override
    public void reportError(String message) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, 0, message);
    }

    @Override
    public void reportWarning(String message) {
        String filename = this.getFilename();
        CompilerLogEvent.logWarning(filename, 0, message);
    }

    protected void reportError(String message, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, message);
    }

    protected void reportWarning(String message, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logWarning(filename, lineNumber, message);
    }

    protected void reportError(Throwable ex, int lineNumber) {
        String filename = this.getFilename();
        if (ex instanceof RecognitionException) {
            CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
        } else if (ex instanceof Ili2cSemanticException) {
            CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
        } else {
            CompilerLogEvent.logError(filename, lineNumber, ex);
        }
    }

    protected void reportError(Ili2cSemanticException ex) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, ex.getSourceLine(), ex.getLocalizedMessage());
    }

    @Override
    public void reportError(RecognitionException ex) {
        String filename = this.getFilename();
        int lineNumber = ex.getLine();
        CompilerLogEvent.logError(filename, lineNumber, ex.getLocalizedMessage());
    }

    protected void reportInternalError(int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, this.formatMessage("err_internalCompilerError", ""));
    }

    protected void reportInternalError(Throwable ex, int lineNumber) {
        String filename = this.getFilename();
        CompilerLogEvent.logError(filename, lineNumber, this.formatMessage("err_internalCompilerError", ""), ex);
    }

    protected String formatMessage(String msg, Object[] args) {
        try {
            MessageFormat mess = new MessageFormat(this.rsrc.getString(msg));
            return mess.format(args);
        }
        catch (Exception ex) {
            EhiLogger.logError("Internal compiler error", ex);
            return "Internal compiler error [" + ex.getLocalizedMessage() + "]";
        }
    }

    protected String formatMessage(String msg, String arg) {
        return this.formatMessage(msg, new Object[]{arg});
    }

    protected String formatMessage(String msg, String arg1, String arg2) {
        return this.formatMessage(msg, new Object[]{arg1, arg2});
    }

    protected String formatMessage(String msg, String arg1, String arg2, String arg3) {
        return this.formatMessage(msg, new Object[]{arg1, arg2, arg3});
    }

    public static void panic() {
        throw new ANTLRError();
    }

    protected Model resolveModelName(Container scope, String modelName) {
        Model scopeModel = scope instanceof TransferDescription ? null : (Model)scope.getContainerOrSame(Model.class);
        if (scopeModel != null && modelName.equals(scopeModel.getName())) {
            return scopeModel;
        }
        return (Model)this.td.getRealElement(Model.class, modelName);
    }

    protected Model resolveOrFixModelName(Container scope, String modelName, int line) {
        Topic referredTopic;
        Model scopeModel = (Model)scope.getContainerOrSame(Model.class);
        Model m = this.resolveModelName(scope, modelName);
        if (m != null) {
            if (scopeModel != null && scopeModel != m && !scopeModel.isImporting(m) && m != this.modelInterlis) {
                this.reportError(this.formatMessage("err_model_notImported", scopeModel.toString(), m.toString()), line);
                try {
                    scopeModel.addImport(m, false);
                }
                catch (Exception ex) {
                    Ili24Parser.panic();
                }
            }
            return m;
        }
        if (scopeModel != null && (referredTopic = (Topic)scopeModel.getRealElement(Topic.class, modelName)) != null) {
            this.reportError(this.formatMessage("err_topicRef_withoutModelScope", referredTopic.toString()), line);
            Ili24Parser.panic();
        }
        try {
            this.reportError(this.formatMessage("err_noSuchModel", modelName), line);
            DataModel artificialModel = new DataModel();
            artificialModel.setName(modelName);
            this.td.add(artificialModel);
        }
        catch (Exception ex) {
            Ili24Parser.panic();
        }
        m = this.resolveModelName(scope, modelName);
        if (m == null) {
            Ili24Parser.panic();
        }
        return m;
    }

    protected Topic resolveOrFixTopicName(Model model, String topicName, int line) {
        Topic topic = (Topic)model.getRealElement(Topic.class, topicName);
        if (topic == null) {
            this.reportError(this.formatMessage("err_noSuchTopic", topicName, model.toString()), line);
            try {
                topic = new Topic();
                topic.setName(topicName);
                model.add(topic);
            }
            catch (Exception ex) {
                Ili24Parser.panic();
            }
        }
        return topic;
    }

    protected MetaObject resolveMetaObject(MetaDataUseDef basket, Table polymorphicTo, String name, int line) {
        List<MetaObject> matching = basket.findMatchingMetaObjects(polymorphicTo, name);
        if (matching.size() >= 2) {
            this.reportError(this.formatMessage("err_metaObject_refAmbiguous", name, matching.get(0).getScopedName((Container)null), matching.get(1).getScopedName((Container)null)), line);
            return matching.get(0);
        }
        if (matching.size() == 1) {
            return matching.get(0);
        }
        this.reportError(this.formatMessage("err_metaObject_unknownName", name, basket.getScopedName((Container)null), polymorphicTo.getScopedName((Container)null)), line);
        return null;
    }

    protected MetaDataUseDef resolveOrFixBasketName(Container container, String basketName, int line) {
        Model model = (Model)container.getContainerOrSame(Model.class);
        AbstractPatternDef topic = (AbstractPatternDef)container.getContainerOrSame(AbstractPatternDef.class);
        MetaDataUseDef basket = null;
        if (topic != null) {
            basket = (MetaDataUseDef)topic.getRealElement(MetaDataUseDef.class, basketName);
        }
        if (basket == null) {
            basket = (MetaDataUseDef)model.getRealElement(MetaDataUseDef.class, basketName);
        }
        if (basket != null) {
            return basket;
        }
        this.reportError(this.formatMessage("err_noSuchMetaDataUseDef", basketName, container.toString()), line);
        try {
            MetaDataUseDef ref = new MetaDataUseDef();
            ref.setName(basketName);
            if (topic != null) {
                topic.add(ref);
            } else {
                model.add(ref);
            }
            return ref;
        }
        catch (Exception ex) {
            Ili24Parser.panic();
            return null;
        }
    }

    protected AttributeDef findOverridingAttribute(Viewable container, int mods, String name, int line) {
        boolean declaredExtended = (mods & 4) != 0;
        AttributeDef overriding = (AttributeDef)container.getRealElement(AttributeDef.class, name);
        if (overriding == null && declaredExtended) {
            this.reportError(this.formatMessage("err_noAttrToExtend", name, container.toString()), line);
        }
        if (overriding != null && overriding.getContainer(Viewable.class) == container) {
            this.reportError(this.formatMessage("err_attrNameInSameViewable", container.toString(), name), line);
        } else if (overriding != null && !declaredExtended) {
            this.reportError(this.formatMessage("err_attrExtendedWithoutDecl", name, container.toString(), overriding.toString()), line);
        }
        return overriding;
    }

    private Table buildDecomposedStruct(AttributeDef attrdef, boolean areaDecomp) throws PropertyVetoException {
        Type type = attrdef.getDomainResolvingAliases();
        if (type instanceof CompositionType) {
            return ((CompositionType)type).getComponentType();
        }
        if (type instanceof PolylineType) {
            return ((PolylineType)type).getImplicitLineGeometryStructure();
        }
        if (type instanceof SurfaceType) {
            return ((SurfaceType)type).getImplicitSurfaceBoundaryStructure();
        }
        if (type instanceof AreaType) {
            if (areaDecomp) {
                return ((AreaType)type).getImplicitSurfaceEdgeStructure();
            }
            return ((AreaType)type).getImplicitSurfaceBoundaryStructure();
        }
        throw new IllegalArgumentException(this.formatMessage("err_decompositionView_notDecomposable", attrdef.getName()));
    }

    private AttributeDef getBaseViewableProxyAttr(Viewable start1, String base, int line) {
        AttributeDef baseProxy = (AttributeDef)start1.getRealElement(AttributeDef.class, base);
        if (baseProxy == null) {
            return null;
        }
        Type proxyType = baseProxy.getDomain();
        if (!(proxyType instanceof ObjectType)) {
            return null;
        }
        return baseProxy;
    }

    private Viewable getBaseViewable(AttributeDef baseProxy) {
        if (baseProxy == null) {
            return null;
        }
        Type proxyType = baseProxy.getDomain();
        if (!(proxyType instanceof ObjectType)) {
            return null;
        }
        return ((ObjectType)proxyType).getRef();
    }

    private String getIliDoc() throws TokenStreamException {
        CommonHiddenStreamToken cmtToken;
        String ilidoc = null;
        ArrayList<CommonHiddenStreamToken> docs = new ArrayList<CommonHiddenStreamToken>();
        for (cmtToken = ((CommonHiddenStreamToken)this.LT(1)).getHiddenBefore(); cmtToken != null; cmtToken = cmtToken.getHiddenBefore()) {
            if (cmtToken.getType() != 190) continue;
            docs.add(0, cmtToken);
        }
        Iterator doci = docs.iterator();
        StringBuilder buf = new StringBuilder();
        String sep = "";
        while (doci.hasNext()) {
            cmtToken = (CommonHiddenStreamToken)doci.next();
            ilidoc = cmtToken.getText().trim();
            if (ilidoc.startsWith("/**")) {
                ilidoc = ilidoc.substring(3);
            }
            if (ilidoc.endsWith("*/")) {
                ilidoc = ilidoc.substring(0, ilidoc.length() - 2);
            }
            LineNumberReader lines = new LineNumberReader(new StringReader(ilidoc.trim()));
            try {
                String line;
                while ((line = lines.readLine()) != null) {
                    if ((line = line.trim()).startsWith("*")) {
                        line = line.substring(1).trim();
                    }
                    buf.append(sep);
                    buf.append(line);
                    sep = "\n";
                }
            }
            catch (IOException ex) {
                EhiLogger.logError(ex);
            }
        }
        ilidoc = buf.toString();
        if (ilidoc.length() == 0) {
            ilidoc = null;
        }
        return ilidoc;
    }

    private Settings getMetaValues() throws TokenStreamException {
        CommonHiddenStreamToken cmtToken;
        ArrayList<CommonHiddenStreamToken> docs = new ArrayList<CommonHiddenStreamToken>();
        for (cmtToken = ((CommonHiddenStreamToken)this.LT(1)).getHiddenBefore(); cmtToken != null; cmtToken = cmtToken.getHiddenBefore()) {
            if (cmtToken.getType() != 188) continue;
            docs.add(0, cmtToken);
        }
        Iterator doci = docs.iterator();
        StringBuilder metaValuesText = new StringBuilder();
        String sep = "";
        while (doci.hasNext()) {
            cmtToken = (CommonHiddenStreamToken)doci.next();
            String valueText = cmtToken.getText().trim();
            metaValuesText.append(sep + valueText);
            sep = ";";
        }
        Settings metaValues = null;
        try {
            metaValues = MetaValue.parseMetaValues(metaValuesText.toString());
        }
        catch (ANTLRException ex) {
            this.reportError("failed to parse Metavalue <" + metaValuesText.toString() + ">", this.LT(1).getLine());
        }
        return metaValues;
    }

    protected Ili24Parser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public Ili24Parser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected Ili24Parser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public Ili24Parser(TokenStream lexer) {
        this(lexer, 1);
    }

    public Ili24Parser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final boolean interlisDescription(TransferDescription td1) throws RecognitionException, TokenStreamException {
        boolean canProceed = true;
        this.td = td1;
        this.modelInterlis = this.td.INTERLIS;
        this.predefinedBooleanType = Type.findReal(this.td.INTERLIS.BOOLEAN.getType());
        this.predefinedScalSystemClass = this.td.INTERLIS.SCALSYSTEM;
        this.predefinedCoordSystemClass = this.td.INTERLIS.COORDSYSTEM;
        try {
            this.interlis2Def();
        }
        catch (NoViableAltException nvae) {
            if (this.inputState.guessing == 0) {
                this.reportError(this.rsrc.getString("err_notIliDescription"));
                canProceed = false;
            }
            throw nvae;
        }
        return canProceed;
    }

    protected final void interlis2Def() throws RecognitionException, TokenStreamException {
        Token ili = null;
        try {
            ili = this.LT(1);
            this.match(4);
            PrecisionDecimal version = this.decimal();
            if (this.inputState.guessing == 0) {
                if (version.doubleValue() != 2.4) {
                    this.reportError(this.rsrc.getString("err_wrongInterlisVersion"), ili.getLine());
                    Ili24Parser.panic();
                }
                this.lexer.isIli1 = false;
            }
            this.match(5);
            while (this.LA(1) >= 6 && this.LA(1) <= 10) {
                this.modelDef();
            }
            this.match(1);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
    }

    protected final PrecisionDecimal decimal() throws RecognitionException, TokenStreamException {
        Token d = null;
        Token p = null;
        Token n = null;
        PrecisionDecimal dec = null;
        try {
            switch (this.LA(1)) {
                case 182: {
                    d = this.LT(1);
                    this.match(182);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(d.getText());
                    }
                    break;
                }
                case 183: {
                    p = this.LT(1);
                    this.match(183);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(p.getText());
                    }
                    break;
                }
                case 184: {
                    n = this.LT(1);
                    this.match(184);
                    if (this.inputState.guessing == 0) {
                        dec = new PrecisionDecimal(n.getText());
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_1);
            }
            throw ex;
        }
        return dec;
    }

    protected final void modelDef() throws RecognitionException, TokenStreamException {
        Token n1 = null;
        Token n = null;
        Token issuerToken = null;
        Token ver = null;
        Token verexpl = null;
        Token ianaNameToken = null;
        Token xmlnsToken = null;
        Token imp1 = null;
        Token imp2 = null;
        Token endDot = null;
        Model md = null;
        Object importedNames = null;
        boolean mods = false;
        boolean unqualified = false;
        boolean contracted = false;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 6) {
                this.match(6);
                if (this.inputState.guessing == 0) {
                    contracted = true;
                }
            } else if (this.LA(1) < 7 || this.LA(1) > 10) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            switch (this.LA(1)) {
                case 7: {
                    this.match(7);
                    this.match(8);
                    if (this.inputState.guessing != 0) break;
                    md = new RefSystemModel();
                    break;
                }
                case 9: {
                    this.match(9);
                    this.match(8);
                    if (this.inputState.guessing != 0) break;
                    md = new SymbologyModel();
                    break;
                }
                case 10: {
                    this.match(10);
                    this.match(8);
                    if (this.inputState.guessing != 0) break;
                    md = new TypeModel();
                    break;
                }
                case 8: {
                    this.match(8);
                    if (this.inputState.guessing != 0) break;
                    md = new DataModel();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            n1 = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                try {
                    md.setContracted(contracted);
                    md.setName(n1.getText());
                    md.setFileName(this.getFilename());
                    md.setDocumentation(ilidoc);
                    md.setMetaValues(metaValues);
                    md.setIliVersion("2.4");
                    this.td.add(md);
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                    Ili24Parser.panic();
                }
            }
            if (this.LA(1) == 12) {
                this.match(12);
                n = this.LT(1);
                this.match(11);
                this.match(13);
                if (this.inputState.guessing == 0) {
                    try {
                        md.setLanguage(n.getText());
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                }
            } else if (this.LA(1) != 14 && this.LA(1) != 15) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 14) {
                this.match(14);
            } else if (this.LA(1) != 15) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(15);
            issuerToken = this.LT(1);
            this.match(16);
            if (this.inputState.guessing == 0) {
                String issuer = issuerToken.getText();
                md.setIssuer(issuer);
                Pattern pattern = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
                Matcher matcher = pattern.matcher(issuer);
                if (matcher.matches()) {
                    String scheme = matcher.group(1);
                    if (scheme == null) {
                        this.reportError("issuer doesn't match URI syntax <" + issuer + ">", issuerToken.getLine());
                    }
                } else {
                    this.reportError("issuer doesn't match URI syntax <" + issuer + ">", issuerToken.getLine());
                }
            }
            this.match(17);
            ver = this.LT(1);
            this.match(16);
            if (this.LA(1) == 18) {
                verexpl = this.LT(1);
                this.match(18);
            } else if (this.LA(1) != 19 && this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                md.setModelVersion(ver.getText());
                if (verexpl != null) {
                    md.setModelVersionExpl(verexpl.getText());
                }
            }
            if (this.LA(1) == 19) {
                this.match(19);
                this.match(20);
                this.match(11);
                this.match(21);
                this.match(16);
                this.match(22);
                if (this.inputState.guessing == 0) {
                    // empty if block
                }
            } else if (this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(23);
            if (this.LA(1) == 24) {
                this.match(24);
                ianaNameToken = this.LT(1);
                this.match(16);
                this.match(5);
            } else if (!_tokenSet_2.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 25) {
                this.match(25);
                xmlnsToken = this.LT(1);
                this.match(16);
                this.match(5);
            } else if (!_tokenSet_3.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 26) {
                Model imported;
                this.match(26);
                if (this.LA(1) == 27) {
                    this.match(27);
                    if (this.inputState.guessing == 0) {
                        unqualified = true;
                    }
                } else if (this.LA(1) == 4 || this.LA(1) == 11) {
                    if (this.inputState.guessing == 0) {
                        unqualified = false;
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 11) {
                    imp1 = this.LT(1);
                    this.match(11);
                    if (this.inputState.guessing == 0 && (imported = this.resolveOrFixModelName(this.td, imp1.getText(), imp1.getLine())) != null) {
                        md.addImport(imported, unqualified);
                    }
                } else if (this.LA(1) == 4) {
                    this.match(4);
                    if (this.inputState.guessing == 0) {
                        md.addImport(this.modelInterlis, unqualified);
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    if (this.LA(1) == 27) {
                        this.match(27);
                        if (this.inputState.guessing == 0) {
                            unqualified = true;
                        }
                    } else if (this.LA(1) == 4 || this.LA(1) == 11) {
                        if (this.inputState.guessing == 0) {
                            unqualified = false;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 11) {
                        imp2 = this.LT(1);
                        this.match(11);
                        if (this.inputState.guessing != 0 || (imported = this.resolveOrFixModelName(this.td, imp2.getText(), imp2.getLine())) == null) continue;
                        md.addImport(imported, unqualified);
                        continue;
                    }
                    if (this.LA(1) == 4) {
                        this.match(4);
                        if (this.inputState.guessing != 0) continue;
                        md.addImport(this.modelInterlis, unqualified);
                        continue;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(5);
            }
            block27: while (true) {
                switch (this.LA(1)) {
                    case 7: 
                    case 131: {
                        this.metaDataBasketDef(md);
                        continue block27;
                    }
                    case 128: {
                        this.unitDefs(md);
                        continue block27;
                    }
                    case 130: {
                        this.functionDef(md);
                        continue block27;
                    }
                    case 122: {
                        this.lineFormTypeDef(md);
                        continue block27;
                    }
                    case 71: {
                        this.domainDefs(md);
                        continue block27;
                    }
                    case 105: {
                        this.contextDefs(md);
                        continue block27;
                    }
                    case 44: {
                        this.runTimeParameterDef(md);
                        continue block27;
                    }
                    case 40: 
                    case 41: {
                        this.classDef(md);
                        continue block27;
                    }
                    case 30: 
                    case 31: {
                        this.topicDef(md);
                        continue block27;
                    }
                }
                break;
            }
            this.end(md);
            endDot = this.LT(1);
            this.match(29);
            if (this.inputState.guessing == 0) {
                try {
                    md.checkIntegrity();
                }
                catch (Exception ex) {
                    this.reportError(ex, endDot.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_4);
            }
            throw ex;
        }
    }

    protected final void metaDataBasketDef(Container scope) throws RecognitionException, TokenStreamException {
        Token n = null;
        Token ext = null;
        Token classNameTok = null;
        Token objNameTok1 = null;
        Token objNameTok2 = null;
        boolean sign = false;
        MetaDataUseDef def = null;
        MetaDataUseDef base = null;
        Topic topic = null;
        Table aclass = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 131) {
                this.match(131);
                if (this.inputState.guessing == 0) {
                    sign = true;
                }
            } else if (this.LA(1) == 7) {
                this.match(7);
                if (this.inputState.guessing == 0) {
                    sign = false;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(33);
            n = this.LT(1);
            this.match(11);
            int mods = this.properties(2);
            if (this.inputState.guessing == 0) {
                def = new MetaDataUseDef();
                def.setDocumentation(ilidoc);
                def.setMetaValues(metaValues);
                def.setSignData(sign);
                def.setName(n.getText());
                try {
                    def.setFinal((mods & 2) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            if (this.LA(1) == 32) {
                ext = this.LT(1);
                this.match(32);
                base = this.metaDataBasketRef(scope);
                if (this.inputState.guessing == 0) {
                    try {
                        def.setExtending(base);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, ext.getLine());
                    }
                }
            } else if (this.LA(1) != 132) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(132);
            topic = this.topicRef(scope);
            if (this.inputState.guessing == 0) {
                def.setTopic(topic);
                scope.add(def);
            }
            while (this.LA(1) == 133) {
                this.match(133);
                this.match(20);
                classNameTok = this.LT(1);
                this.match(11);
                this.match(47);
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                objNameTok1 = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    String className = classNameTok.getText();
                    aclass = (Table)topic.getRealElement(Table.class, className);
                    if (aclass == null) {
                        this.reportError(this.formatMessage("err_noSuchTable", className, topic.toString()), classNameTok.getLine());
                    } else if (!aclass.isExtending(this.td.INTERLIS.METAOBJECT)) {
                        this.reportError(this.formatMessage("err_class_superNonMetaObject", className), classNameTok.getLine());
                    }
                    if (aclass != null) {
                        String objName = objNameTok1.getText();
                        MetaObject mo = new MetaObject(objName, aclass);
                        mo.setDocumentation(ilidoc);
                        mo.setMetaValues(metaValues);
                        def.add(mo);
                    }
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    if (this.inputState.guessing == 0) {
                        ilidoc = this.getIliDoc();
                        metaValues = this.getMetaValues();
                    }
                    objNameTok2 = this.LT(1);
                    this.match(11);
                    if (this.inputState.guessing != 0 || aclass == null) continue;
                    String objName = objNameTok2.getText();
                    MetaObject mo = new MetaObject(objName, aclass);
                    mo.setDocumentation(ilidoc);
                    mo.setMetaValues(metaValues);
                    def.add(mo);
                }
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void unitDefs(Container scope) throws RecognitionException, TokenStreamException {
        try {
            this.match(128);
            while (this.LA(1) == 11) {
                this.unitDef(scope);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void functionDef(Container container) throws RecognitionException, TokenStreamException {
        block30: {
            Token fn = null;
            Token lpar = null;
            Token sem = null;
            Token col = null;
            Token explan = null;
            Type t = null;
            FormalArgument arg = null;
            Function f = null;
            ArrayList<FormalArgument> args = null;
            String ilidoc = null;
            Settings metaValues = null;
            try {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                this.match(130);
                fn = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    f = new Function();
                    args = new ArrayList<FormalArgument>();
                    try {
                        f.setName(fn.getText());
                        f.setDocumentation(ilidoc);
                        f.setMetaValues(metaValues);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, fn.getLine());
                        return;
                    }
                }
                lpar = this.LT(1);
                this.match(12);
                if (this.LA(1) == 11) {
                    arg = this.formalArgument(container, lpar.getLine(), args);
                    if (this.inputState.guessing == 0) {
                        try {
                            args.add(arg);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, lpar.getLine());
                            return;
                        }
                    }
                    while (this.LA(1) == 5) {
                        sem = this.LT(1);
                        this.match(5);
                        arg = this.formalArgument(container, sem.getLine(), args);
                        if (this.inputState.guessing != 0) continue;
                        try {
                            args.add(arg);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, sem.getLine());
                            return;
                        }
                    }
                } else if (this.LA(1) != 13) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(13);
                col = this.LT(1);
                this.match(47);
                t = this.argumentType(container, col.getLine(), null);
                if (this.inputState.guessing == 0) {
                    try {
                        f.setArguments(args.toArray(new FormalArgument[args.size()]));
                    }
                    catch (Exception ex) {
                        this.reportError(ex, col.getLine());
                        return;
                    }
                    try {
                        if (t != null) {
                            f.setDomain(t);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, col.getLine());
                        return;
                    }
                }
                if (this.LA(1) == 18) {
                    explan = this.LT(1);
                    this.match(18);
                    if (this.inputState.guessing == 0) {
                        try {
                            f.setExplanation(explan.getText());
                        }
                        catch (Exception ex) {
                            this.reportError(ex, explan.getLine());
                            return;
                        }
                    }
                } else if (this.LA(1) != 5) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(5);
                if (this.inputState.guessing != 0) break block30;
                try {
                    container.add(f);
                }
                catch (Exception ex) {
                    this.reportError(ex, fn.getLine());
                    return;
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_5);
                }
                throw ex;
            }
        }
    }

    protected final void lineFormTypeDef(Model model) throws RecognitionException, TokenStreamException {
        Token linform = null;
        Token nam = null;
        Token lineStructure = null;
        Object explString = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            linform = this.LT(1);
            this.match(122);
            this.match(127);
            while (this.LA(1) == 11) {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                nam = this.LT(1);
                this.match(11);
                this.match(47);
                lineStructure = this.LT(1);
                this.match(11);
                this.match(5);
                if (this.inputState.guessing != 0) continue;
                LineForm lf = new LineForm();
                try {
                    lf.setName(nam.getText());
                    lf.setDocumentation(ilidoc);
                    lf.setMetaValues(metaValues);
                    Table seg = (Table)model.getImportedElement(Table.class, lineStructure.getText());
                    if (seg == null) {
                        this.reportError(this.formatMessage("err_noSuchTable", lineStructure.getText(), model.toString()), lineStructure.getLine());
                    }
                    lf.setSegmentStructure(seg);
                    model.add(lf);
                }
                catch (Exception ex) {
                    this.reportError(ex, nam.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_6);
            }
            throw ex;
        }
    }

    protected final void domainDefs(Container container) throws RecognitionException, TokenStreamException {
        try {
            this.match(71);
            while (this.LA(1) == 11) {
                this.domainDef(container);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void contextDefs(Container container) throws RecognitionException, TokenStreamException {
        try {
            this.match(105);
            this.match(11);
            this.match(23);
            while (_tokenSet_7.member(this.LA(1))) {
                this.contextDef(container);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void runTimeParameterDef(Container scope) throws RecognitionException, TokenStreamException {
        Token n = null;
        GraphicParameterDef def = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            this.match(44);
            while (this.LA(1) == 11) {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                n = this.LT(1);
                this.match(11);
                this.match(47);
                if (this.inputState.guessing == 0) {
                    def = new GraphicParameterDef();
                    def.setSourceLine(n.getLine());
                    def.setName(n.getText());
                    def.setDocumentation(ilidoc);
                    def.setMetaValues(metaValues);
                }
                Type domain = this.attrTypeDef(scope, true, null, n.getLine(), null);
                if (this.inputState.guessing == 0) {
                    def.setDomain(domain);
                    scope.add(def);
                }
                this.match(5);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_6);
            }
            throw ex;
        }
    }

    protected final void classDef(Container container) throws RecognitionException, TokenStreamException {
        Token n1 = null;
        Token extToken = null;
        Token oid = null;
        Table table = null;
        Table extending = null;
        Table overwriting = null;
        boolean identifiable = true;
        Constraint constr = null;
        Domain classOid = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 40) {
                this.match(40);
            } else if (this.LA(1) == 41) {
                this.match(41);
                if (this.inputState.guessing == 0) {
                    identifiable = false;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            n1 = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                try {
                    table = new Table();
                    table.setName(n1.getText());
                    table.setDocumentation(ilidoc);
                    table.setMetaValues(metaValues);
                    table.setIdentifiable(identifiable);
                    table.setAbstract(true);
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                }
                overwriting = (Table)container.getElement(Table.class, n1.getText());
            }
            int mods = this.properties(7);
            if (this.inputState.guessing == 0) {
                try {
                    table.setAbstract((mods & 1) != 0);
                    table.setFinal((mods & 2) != 0);
                    if ((mods & 4) != 0) {
                        if (overwriting == null) {
                            this.reportError(this.formatMessage("err_noTableOrStructureToExtend", n1.getText(), container.toString()), n1.getLine());
                        } else {
                            table.setExtending(overwriting);
                            table.setExtended(true);
                        }
                    }
                    if (container instanceof Model && !table.isAbstract() && table.isIdentifiable()) {
                        this.reportError(this.formatMessage("err_table_concreteOutsideTopic", table.toString()), n1.getLine());
                        table.setFinal(false);
                        table.setAbstract(true);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                }
            }
            if (this.LA(1) == 32) {
                extToken = this.LT(1);
                this.match(32);
                extending = this.classRef(container);
                if (this.inputState.guessing == 0) {
                    if ((mods & 4) != 0) {
                        this.reportError(this.rsrc.getString("err_extendedWithExtends"), extToken.getLine());
                    } else {
                        try {
                            table.setExtending(extending);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, extToken.getLine());
                        }
                    }
                }
            } else if (this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(23);
            if (this.inputState.guessing == 0) {
                try {
                    container.add(table);
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                    Ili24Parser.panic();
                }
            }
            if (this.LA(1) == 34 || this.LA(1) == 42) {
                if (this.LA(1) == 34) {
                    oid = this.LT(1);
                    this.match(34);
                    this.match(35);
                    classOid = this.domainRef(container);
                } else if (this.LA(1) == 42) {
                    this.match(42);
                    this.match(34);
                    if (this.inputState.guessing == 0) {
                        classOid = new NoOid();
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing == 0) {
                    table.setOid(classOid);
                }
                this.match(5);
            } else if (!_tokenSet_8.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 43) {
                this.match(43);
            } else if (!_tokenSet_9.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 11 || this.LA(1) == 45 || this.LA(1) == 46) {
                this.attributeDef(table);
            }
            while (_tokenSet_10.member(this.LA(1))) {
                constr = this.constraintDef(table);
                if (this.inputState.guessing != 0 || constr == null) continue;
                table.add(constr);
            }
            if (this.LA(1) == 44) {
                this.match(44);
                while (this.LA(1) == 11) {
                    this.parameterDef(table);
                }
            } else if (this.LA(1) != 61) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.end(table);
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_5);
            }
            throw ex;
        }
    }

    protected final void topicDef(Container container) throws RecognitionException, TokenStreamException {
        Token n1 = null;
        Token extToken = null;
        Token oid2 = null;
        Token oid = null;
        Token on = null;
        Token com = null;
        Topic topic = null;
        Topic extending = null;
        Topic depTopic = null;
        boolean viewTopic = false;
        Domain topicOid = null;
        Domain topicOid2 = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 30) {
                this.match(30);
                if (this.inputState.guessing == 0) {
                    viewTopic = true;
                }
            } else if (this.LA(1) != 31) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(31);
            n1 = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                try {
                    topic = new Topic();
                    topic.setViewTopic(viewTopic);
                    topic.setName(n1.getText());
                    topic.setDocumentation(ilidoc);
                    topic.setMetaValues(metaValues);
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                }
            }
            int mods = this.properties(3);
            if (this.inputState.guessing == 0) {
                try {
                    container.add(topic);
                    topic.setAbstract((mods & 1) != 0);
                    topic.setFinal((mods & 2) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n1.getLine());
                }
            }
            if (this.LA(1) == 32) {
                extToken = this.LT(1);
                this.match(32);
                extending = this.topicRef(container);
                if (this.inputState.guessing == 0) {
                    try {
                        topic.setExtending(extending);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, extToken.getLine());
                    }
                }
            } else if (this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(23);
            if (this.LA(1) == 33) {
                this.match(33);
                oid2 = this.LT(1);
                this.match(34);
                this.match(35);
                topicOid2 = this.domainRef(container);
                this.match(5);
                if (this.inputState.guessing == 0) {
                    if (!(topicOid2.getType() instanceof OIDType)) {
                        this.reportError(this.formatMessage("err_topic_domainnotanoid", topicOid2.toString()), oid2.getLine());
                    }
                    topic.setBasketOid(topicOid2);
                }
            } else if (!_tokenSet_11.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 34) {
                oid = this.LT(1);
                this.match(34);
                this.match(35);
                topicOid = this.domainRef(container);
                this.match(5);
                if (this.inputState.guessing == 0) {
                    if (!(topicOid.getType() instanceof OIDType)) {
                        this.reportError(this.formatMessage("err_topic_domainnotanoid", topicOid.toString()), oid.getLine());
                    }
                    topic.setOid(topicOid);
                }
            } else if (!_tokenSet_12.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 36) {
                this.match(36);
                on = this.LT(1);
                this.match(37);
                depTopic = this.topicRef(topic);
                if (this.inputState.guessing == 0) {
                    try {
                        topic.makeDependentOn(depTopic);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, on.getLine());
                    }
                }
                while (this.LA(1) == 28) {
                    com = this.LT(1);
                    this.match(28);
                    depTopic = this.topicRef(topic);
                    if (this.inputState.guessing != 0) continue;
                    try {
                        topic.makeDependentOn(depTopic);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, com.getLine());
                    }
                }
                this.match(5);
            }
            if (this.LA(1) == 38) {
                this.match(38);
                this.match(39);
                this.domainRef(container);
                while (this.LA(1) == 28) {
                    this.match(28);
                    this.domainRef(container);
                }
                this.match(5);
            } else if (!_tokenSet_13.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.definitions(topic);
            this.end(topic);
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_6);
            }
            throw ex;
        }
    }

    protected final void end(Element elt) throws RecognitionException, TokenStreamException {
        Token nam = null;
        try {
            this.match(61);
            nam = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0 && elt != null && !nam.getText().equals(elt.getName())) {
                this.reportError(this.formatMessage("err_end_mismatch", elt.toString(), elt.getName(), nam.getText()), nam.getLine());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_14);
            }
            throw ex;
        }
    }

    protected final int properties(int acceptable) throws RecognitionException, TokenStreamException {
        int mods = 0;
        try {
            if (this.LA(1) == 12) {
                this.match(12);
                int mod = this.property(acceptable, mods);
                if (this.inputState.guessing == 0) {
                    mods = mod;
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    mod = this.property(acceptable, mods);
                    if (this.inputState.guessing != 0) continue;
                    mods |= mod;
                }
                this.match(13);
            } else if (!_tokenSet_15.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_15);
            }
            throw ex;
        }
        return mods;
    }

    protected final Topic topicRef(Container scope) throws RecognitionException, TokenStreamException {
        LinkedList nams = new LinkedList();
        Topic topic = null;
        int lin = 0;
        try {
            lin = this.names2(nams);
            if (this.inputState.guessing == 0) {
                String topicName;
                Model model;
                switch (nams.size()) {
                    case 1: {
                        model = (Model)scope.getContainerOrSame(Model.class);
                        topicName = (String)nams.get(0);
                        break;
                    }
                    case 2: {
                        String modelName = (String)nams.get(0);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topicName = (String)nams.get(1);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdTopicRef"), lin);
                        model = this.resolveModelName(scope, (String)nams.get(0));
                        if (model == null) {
                            model = (Model)scope.getContainerOrSame(Model.class);
                        }
                        topicName = (String)nams.get(nams.size() - 1);
                    }
                }
                topic = (Topic)model.getRealElement(Topic.class, topicName);
                if (topic == null && nams.size() == 1) {
                    topic = (Topic)model.getImportedElement(Topic.class, topicName);
                }
                if (topic == null) {
                    this.reportError(this.formatMessage("err_noSuchTopic", topicName, model.toString()), lin);
                    try {
                        topic = new Topic();
                        topic.setName(topicName);
                        model.add(topic);
                    }
                    catch (Exception ex) {
                        Ili24Parser.panic();
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_16);
            }
            throw ex;
        }
        return topic;
    }

    protected final Domain domainRef(Container scope) throws RecognitionException, TokenStreamException {
        LinkedList nams = new LinkedList();
        Domain d = null;
        int lin = 0;
        try {
            lin = this.names2(nams);
            if (this.inputState.guessing == 0) {
                d = this.resolveDomainRef(scope, nams.toArray(new String[nams.size()]), lin);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_17);
            }
            throw ex;
        }
        return d;
    }

    protected final void definitions(Container scope) throws RecognitionException, TokenStreamException {
        try {
            block14: while (true) {
                switch (this.LA(1)) {
                    case 7: 
                    case 131: {
                        this.metaDataBasketDef(scope);
                        continue block14;
                    }
                    case 128: {
                        this.unitDefs(scope);
                        continue block14;
                    }
                    case 130: {
                        this.functionDef(scope);
                        continue block14;
                    }
                    case 71: {
                        this.domainDefs(scope);
                        continue block14;
                    }
                    case 105: {
                        this.contextDefs(scope);
                        continue block14;
                    }
                    case 40: 
                    case 41: {
                        this.classDef(scope);
                        continue block14;
                    }
                    case 57: {
                        this.associationDef(scope);
                        continue block14;
                    }
                    case 70: {
                        this.constraintsDef(scope);
                        continue block14;
                    }
                    case 30: {
                        this.viewDef(scope);
                        continue block14;
                    }
                    case 174: {
                        this.graphicDef(scope);
                        continue block14;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_18);
            }
            throw ex;
        }
    }

    protected final void associationDef(Container scope) throws RecognitionException, TokenStreamException {
        Token a = null;
        Token n = null;
        Token extToken = null;
        Token derivedToken = null;
        Token oid = null;
        Token nam = null;
        AssociationDef def = new AssociationDef();
        AssociationDef extending = null;
        Cardinality card = null;
        String ilidoc = null;
        Settings metaValues = null;
        Domain assocOid = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            a = this.LT(1);
            this.match(57);
            if (this.LA(1) == 11) {
                n = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    try {
                        def.setName(n.getText());
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                }
            } else if (!_tokenSet_19.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            int mods = this.properties(1031);
            if (this.inputState.guessing == 0) {
                try {
                    def.setSourceLine(a.getLine());
                    def.setDocumentation(ilidoc);
                    def.setMetaValues(metaValues);
                    def.setAbstract((mods & 1) != 0);
                    def.setFinal((mods & 2) != 0);
                    def.setExtended((mods & 4) != 0);
                    def.setIdentifiable((mods & 0x400) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, a.getLine());
                }
            }
            if (this.LA(1) == 32) {
                extToken = this.LT(1);
                this.match(32);
                extending = this.associationRef(scope);
                if (this.inputState.guessing == 0) {
                    if ((mods & 4) != 0) {
                        this.reportError(this.rsrc.getString("err_extendedWithExtends"), extToken.getLine());
                    } else {
                        try {
                            def.setExtending(extending);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, extToken.getLine());
                        }
                    }
                }
            } else if (this.LA(1) != 23 && this.LA(1) != 58) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 58) {
                derivedToken = this.LT(1);
                this.match(58);
                this.match(59);
                ViewableAlias derivedFrom = this.renamedViewableRef(scope);
                if (this.inputState.guessing == 0) {
                    try {
                        def.setDerivedFrom(derivedFrom.getAliasing());
                        LocalAttribute attrib = new LocalAttribute();
                        attrib.setName(derivedFrom.getName());
                        attrib.setDomain(new ObjectType(derivedFrom.getAliasing()));
                        def.add(attrib);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, derivedToken.getLine());
                    }
                }
            } else if (this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(23);
            if (this.LA(1) == 34 || this.LA(1) == 42) {
                if (this.LA(1) == 34) {
                    oid = this.LT(1);
                    this.match(34);
                    this.match(35);
                    assocOid = this.domainRef(scope);
                } else if (this.LA(1) == 42) {
                    this.match(42);
                    this.match(34);
                    if (this.inputState.guessing == 0) {
                        assocOid = new NoOid();
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(5);
                if (this.inputState.guessing == 0) {
                    def.setOid(assocOid);
                }
            } else if (!_tokenSet_20.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                scope.add(def);
            }
            this.roleDefs(def);
            if (this.inputState.guessing == 0) {
                if ((mods & 4) != 0) {
                    AssociationDef overwriting = null;
                    AbstractPatternDef baseTopic = (AbstractPatternDef)((AbstractPatternDef)scope).getExtending();
                    if (baseTopic != null) {
                        overwriting = (AssociationDef)baseTopic.getRealElement(AssociationDef.class, def.getName());
                    }
                    if (overwriting == null) {
                        this.reportError(this.formatMessage("err_noAssociationToExtend", def.getName(), scope.toString()), a.getLine());
                    } else {
                        try {
                            def.setExtending(overwriting);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, a.getLine());
                        }
                    }
                }
                try {
                    def.fixupRoles();
                }
                catch (Ili2cSemanticException ex) {
                    this.reportError(ex);
                }
                catch (Exception ex) {
                    this.reportError(ex, a.getLine());
                }
            }
            if (this.LA(1) == 43) {
                this.match(43);
            } else if (!_tokenSet_21.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 11 || this.LA(1) == 45 || this.LA(1) == 46) {
                this.attributeDef(def);
            }
            if (this.LA(1) == 60) {
                this.match(60);
                this.match(23);
                card = this.cardinality();
                this.match(5);
                if (this.inputState.guessing == 0) {
                    def.setCardinality(card);
                }
            } else if (!_tokenSet_22.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (_tokenSet_10.member(this.LA(1))) {
                Constraint constr = this.constraintDef(def);
                if (this.inputState.guessing != 0 || constr == null) continue;
                def.add(constr);
            }
            this.match(61);
            if (this.LA(1) == 11) {
                nam = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0 && !nam.getText().equals(def.getName())) {
                    this.reportError(this.formatMessage("err_end_mismatch", def.toString(), def.getName(), nam.getText()), nam.getLine());
                }
            } else if (this.LA(1) != 5) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_13);
            }
            throw ex;
        }
    }

    protected final void constraintsDef(Container scope) throws RecognitionException, TokenStreamException {
        try {
            this.match(70);
            this.match(20);
            Viewable def = this.viewableRef(scope);
            this.match(23);
            while (_tokenSet_10.member(this.LA(1))) {
                Constraint constr = this.constraintDef(def);
                if (this.inputState.guessing != 0 || constr == null) continue;
                def.add(constr);
            }
            this.match(61);
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_13);
            }
            throw ex;
        }
    }

    protected final void viewDef(Container container) throws RecognitionException, TokenStreamException {
        Token viewToken = null;
        Token n = null;
        Token extToken = null;
        View view = null;
        View base = null;
        LinkedList aliases = new LinkedList();
        Object decomposedViewable = null;
        boolean areaDecomp = false;
        int selLine = 0;
        Object cols = null;
        int props = 0;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            viewToken = this.LT(1);
            this.match(30);
            n = this.LT(1);
            this.match(11);
            props = this.properties(519);
            switch (this.LA(1)) {
                case 117: 
                case 153: 
                case 165: 
                case 166: 
                case 168: 
                case 169: {
                    view = this.formationDef(container);
                    if (this.inputState.guessing != 0 || (props & 4) == 0) break;
                    this.reportError(this.formatMessage("err_view_formationdef", n.getText()), n.getLine());
                    break;
                }
                case 32: {
                    extToken = this.LT(1);
                    this.match(32);
                    base = this.viewRef(container);
                    if (this.inputState.guessing != 0) break;
                    if ((props & 4) != 0) {
                        this.reportError(this.rsrc.getString("err_extendedWithExtends"), extToken.getLine());
                        view = new Projection();
                        break;
                    }
                    try {
                        view = new ExtendedView(base);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, extToken.getLine());
                    }
                    ((ExtendedView)view).setExtended(false);
                    break;
                }
                case 23: 
                case 143: 
                case 171: {
                    if (this.inputState.guessing != 0) break;
                    if ((props & 4) == 0) {
                        this.reportError(this.formatMessage("err_view_missingFormationdef", n.getText()), n.getLine());
                        view = new Projection();
                        break;
                    }
                    base = null;
                    AbstractPatternDef baseTopic = (AbstractPatternDef)((AbstractPatternDef)container).getExtending();
                    if (baseTopic != null) {
                        base = (View)baseTopic.getRealElement(View.class, n.getText());
                    }
                    if (base == null) {
                        this.reportError(this.formatMessage("err_view_nothingToExtend", n.getText(), container.toString()), viewToken.getLine());
                        break;
                    }
                    try {
                        view = new ExtendedView(base);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                    ((ExtendedView)view).setExtended(true);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing == 0) {
                try {
                    view.setSourceLine(n.getLine());
                    view.setName(n.getText());
                    view.setAbstract((props & 1) != 0);
                    view.setFinal((props & 2) != 0);
                    view.setTransient((props & 0x200) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                container.add(view);
            }
            while (this.LA(1) == 171) {
                this.baseExtensionDef(view);
            }
            while (this.LA(1) == 143) {
                if (this.inputState.guessing == 0) {
                    selLine = this.LT(1).getLine();
                }
                Selection select = this.selection(view, view);
                if (this.inputState.guessing != 0) continue;
                try {
                    if (select == null) continue;
                    view.add(select);
                }
                catch (Exception ex) {
                    this.reportError(ex, selLine);
                }
            }
            this.match(23);
            if (this.inputState.guessing == 0) {
                view.setDocumentation(ilidoc);
                view.setMetaValues(metaValues);
            }
            this.viewAttributes(view);
            while (_tokenSet_10.member(this.LA(1))) {
                Constraint constr = this.constraintDef(view);
                if (this.inputState.guessing != 0 || constr == null) continue;
                view.add(constr);
            }
            this.end(view);
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_13);
            }
            throw ex;
        }
    }

    protected final void graphicDef(Container cont) throws RecognitionException, TokenStreamException {
        Token n = null;
        Viewable basedOn = null;
        int mods = 0;
        Graphic graph = null;
        Graphic extending = null;
        Selection sel = null;
        int selLine = 0;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            this.match(174);
            n = this.LT(1);
            this.match(11);
            mods = this.properties(3);
            if (this.LA(1) == 32) {
                this.match(32);
                extending = this.graphicRef(cont);
            } else if (this.LA(1) != 23 && this.LA(1) != 94) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 94) {
                this.match(94);
                this.match(37);
                basedOn = this.viewableRefDepReq(cont);
            } else if (this.LA(1) != 23) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(23);
            if (this.inputState.guessing == 0) {
                graph = new Graphic();
                try {
                    graph.setName(n.getText());
                    graph.setDocumentation(ilidoc);
                    graph.setMetaValues(metaValues);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                try {
                    graph.setAbstract((mods & 1) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                try {
                    graph.setFinal((mods & 2) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                try {
                    graph.setExtending(extending);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                try {
                    if (basedOn == null) {
                        if (extending == null) {
                            this.reportError(this.formatMessage("err_graphic_basedOnOmitted", graph.toString()), n.getLine());
                            Ili24Parser.panic();
                        }
                        basedOn = extending.getBasedOn();
                    }
                    graph.setBasedOn(basedOn);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
                try {
                    cont.add(graph);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            while (this.LA(1) == 143) {
                if (this.inputState.guessing == 0) {
                    selLine = this.LT(1).getLine();
                }
                sel = this.selection(basedOn, graph);
                if (this.inputState.guessing != 0 || sel == null) continue;
                try {
                    graph.add(sel);
                }
                catch (Exception ex) {
                    this.reportError(ex, selLine);
                }
            }
            while (this.LA(1) == 11) {
                this.drawingRule(graph);
            }
            this.end(graph);
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_13);
            }
            throw ex;
        }
    }

    protected final int names2(List names) throws RecognitionException, TokenStreamException {
        int lineNumber;
        block38: {
            Token ili = null;
            Token iName = null;
            Token i2Name = null;
            Token isg = null;
            Token irf = null;
            Token imo = null;
            Token iur = null;
            Token inm = null;
            Token ibo = null;
            Token iha = null;
            Token iva = null;
            Token sg = null;
            Token rf = null;
            Token mo = null;
            Token firstName = null;
            Token nextName = null;
            lineNumber = 0;
            try {
                block1 : switch (this.LA(1)) {
                    case 4: {
                        ili = this.LT(1);
                        this.match(4);
                        this.match(29);
                        if (this.inputState.guessing == 0) {
                            lineNumber = ili.getLine();
                        }
                        switch (this.LA(1)) {
                            case 11: {
                                iName = this.LT(1);
                                this.match(11);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(iName.getText());
                                }
                                if (this.LA(1) == 29) {
                                    this.match(29);
                                    i2Name = this.LT(1);
                                    this.match(11);
                                    if (this.inputState.guessing == 0) {
                                        names.add(i2Name.getText());
                                        break block1;
                                    }
                                    break block38;
                                }
                                if (_tokenSet_23.member(this.LA(1))) break block1;
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            case 131: {
                                isg = this.LT(1);
                                this.match(131);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(isg.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 7: {
                                irf = this.LT(1);
                                this.match(7);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(irf.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 134: {
                                imo = this.LT(1);
                                this.match(134);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(imo.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 73: {
                                iur = this.LT(1);
                                this.match(73);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(iur.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 74: {
                                inm = this.LT(1);
                                this.match(74);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(inm.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 85: {
                                ibo = this.LT(1);
                                this.match(85);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(ibo.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 83: {
                                iha = this.LT(1);
                                this.match(83);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(iha.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            case 84: {
                                iva = this.LT(1);
                                this.match(84);
                                if (this.inputState.guessing == 0) {
                                    names.add(ili.getText());
                                    names.add(iva.getText());
                                    break block1;
                                }
                                break block38;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                    }
                    case 131: {
                        sg = this.LT(1);
                        this.match(131);
                        if (this.inputState.guessing == 0) {
                            lineNumber = sg.getLine();
                            names.add(sg.getText());
                        }
                        break;
                    }
                    case 7: {
                        rf = this.LT(1);
                        this.match(7);
                        if (this.inputState.guessing == 0) {
                            lineNumber = rf.getLine();
                            names.add(rf.getText());
                        }
                        break;
                    }
                    case 134: {
                        mo = this.LT(1);
                        this.match(134);
                        if (this.inputState.guessing == 0) {
                            lineNumber = mo.getLine();
                            names.add(mo.getText());
                        }
                        break;
                    }
                    case 11: {
                        firstName = this.LT(1);
                        this.match(11);
                        if (this.inputState.guessing == 0) {
                            lineNumber = firstName.getLine();
                            names.add(firstName.getText());
                        }
                        while (this.LA(1) == 29) {
                            this.match(29);
                            nextName = this.LT(1);
                            this.match(11);
                            if (this.inputState.guessing != 0) continue;
                            names.add(nextName.getText());
                        }
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_23);
                }
                throw ex;
            }
        }
        return lineNumber;
    }

    protected final Table classRef(Container scope) throws RecognitionException, TokenStreamException {
        Table t;
        block17: {
            LinkedList nams = new LinkedList();
            t = null;
            int lin = 0;
            String tableName = null;
            try {
                AbstractPatternDef topic;
                Model model;
                lin = this.names2(nams);
                if (this.inputState.guessing != 0) break block17;
                switch (nams.size()) {
                    case 1: {
                        model = (Model)scope.getContainerOrSame(Model.class);
                        topic = (AbstractPatternDef)scope.getContainerOrSame(AbstractPatternDef.class);
                        tableName = (String)nams.get(0);
                        break;
                    }
                    case 2: {
                        String modelName = (String)nams.get(0);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        tableName = (String)nams.get(1);
                        topic = null;
                        break;
                    }
                    case 3: {
                        String modelName = (String)nams.get(0);
                        String topicName = (String)nams.get(1);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topic = this.resolveOrFixTopicName(model, topicName, lin);
                        tableName = (String)nams.get(2);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdTableRef"), lin);
                        model = this.resolveModelName(scope, (String)nams.get(0));
                        if (model == null) {
                            model = (Model)scope.getContainerOrSame(Model.class);
                        }
                        topic = null;
                        tableName = (String)nams.get(nams.size() - 1);
                    }
                }
                t = null;
                if (topic != null) {
                    t = (Table)topic.getElement(Table.class, tableName);
                }
                if (t == null && model != null) {
                    t = (Table)model.getElement(Table.class, tableName);
                }
                if (t == null && nams.size() == 1) {
                    t = (Table)model.getImportedElement(Table.class, tableName);
                }
                if (t != null) break block17;
                if (topic == null) {
                    this.reportError(this.formatMessage("err_noSuchTable", tableName, model.toString()), lin);
                } else {
                    this.reportError(this.formatMessage("err_noSuchTable", tableName, topic.toString()), lin);
                }
                if (model == this.modelInterlis) break block17;
                try {
                    t = new Table();
                    t.setName(tableName);
                    if (topic == null) {
                        t.setAbstract(true);
                        model.add(t);
                        break block17;
                    }
                    topic.add(t);
                }
                catch (Exception ex) {
                    Ili24Parser.panic();
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_24);
                }
                throw ex;
            }
        }
        return t;
    }

    protected final void attributeDef(Viewable container) throws RecognitionException, TokenStreamException {
        Token n = null;
        int mods = 0;
        LocalAttribute attrib = null;
        AttributeDef overriding = null;
        Type overridingDomain = null;
        Cardinality overridingCardinality = new Cardinality(0L, Long.MAX_VALUE);
        Type type = null;
        boolean mandatory = false;
        boolean isContinuous = false;
        boolean isSubdivision = false;
        String ilidoc = null;
        Settings metaValues = null;
        Evaluable f = null;
        ArrayList<Evaluable> fv = new ArrayList<Evaluable>();
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            if (this.LA(1) == 45 || this.LA(1) == 46) {
                if (this.LA(1) == 45) {
                    this.match(45);
                    if (this.inputState.guessing == 0) {
                        isContinuous = true;
                    }
                } else if (this.LA(1) != 46) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(46);
                if (this.inputState.guessing == 0) {
                    isSubdivision = true;
                }
            } else if (this.LA(1) != 11) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            n = this.LT(1);
            this.match(11);
            mods = this.properties(519);
            this.match(47);
            if (this.inputState.guessing == 0) {
                overriding = this.findOverridingAttribute(container, mods, n.getText(), n.getLine());
                if (overriding != null) {
                    overridingDomain = overriding.getDomainResolvingAliases();
                }
                attrib = new LocalAttribute();
                try {
                    attrib.setName(n.getText());
                    attrib.setDocumentation(ilidoc);
                    attrib.setMetaValues(metaValues);
                    attrib.setAbstract((mods & 1) != 0);
                    attrib.setFinal((mods & 2) != 0);
                    attrib.setSubdivision(isSubdivision);
                    attrib.setContinuous(isContinuous);
                    attrib.setTransient((mods & 0x200) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            type = this.attrTypeDef(container, true, overridingDomain, n.getLine(), null);
            if (this.inputState.guessing == 0 && type != null) {
                if (type instanceof ReferenceType) {
                    ReferenceType rt;
                    if (!(container instanceof Table) || ((Table)container).isIdentifiable()) {
                        this.reportError(this.formatMessage("err_attributeDef_refattrInClass", n.getText()), n.getLine());
                    }
                    if (!((Table)(rt = (ReferenceType)type).getReferred()).isIdentifiable()) {
                        this.reportError(this.formatMessage("err_attributeDef_refattrToStruct", n.getText()), n.getLine());
                    }
                }
                try {
                    attrib.setDomain(type);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            if (this.LA(1) == 48) {
                this.match(48);
                f = this.factor(container, container);
                if (this.inputState.guessing == 0) {
                    fv.add(f);
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    f = this.factor(container, container);
                    if (this.inputState.guessing != 0) continue;
                    fv.add(f);
                }
                if (this.inputState.guessing == 0) {
                    attrib.setBasePaths(fv.toArray(new Evaluable[fv.size()]));
                }
            } else if (this.LA(1) != 5) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                if (attrib.isTransient() && f == null && !attrib.isAbstract()) {
                    this.reportError(this.formatMessage("err_attributeDef_transientWoFactor", n.getText()), n.getLine());
                }
                if (overriding != null && overriding.isTransient() != attrib.isTransient()) {
                    this.reportError(this.formatMessage("err_attributeDef_transientModeChange", n.getText()), n.getLine());
                }
            }
            this.match(5);
            if (this.inputState.guessing == 0) {
                try {
                    container.add(attrib);
                    attrib.setExtending(overriding);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_25);
            }
            throw ex;
        }
    }

    protected final Constraint constraintDef(Viewable constrained) throws RecognitionException, TokenStreamException {
        Constraint constr = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            switch (this.LA(1)) {
                case 49: {
                    constr = this.mandatoryConstraint(constrained);
                    break;
                }
                case 135: {
                    constr = this.plausibilityConstraint(constrained);
                    break;
                }
                case 139: {
                    constr = this.existenceConstraint(constrained);
                    break;
                }
                case 142: {
                    constr = this.uniquenessConstraint(constrained);
                    break;
                }
                case 145: {
                    constr = this.setConstraint(constrained);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing == 0) {
                constr.setDocumentation(ilidoc);
                constr.setMetaValues(metaValues);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final void parameterDef(Table container) throws RecognitionException, TokenStreamException {
        Token n = null;
        Token pt = null;
        int mods = 0;
        Type type = null;
        boolean mandatory = false;
        boolean declaredExtended = false;
        Parameter overriding = null;
        Type overridingDomain = null;
        Table referred = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            n = this.LT(1);
            this.match(11);
            mods = this.properties(7);
            this.match(47);
            if (this.inputState.guessing == 0) {
                declaredExtended = (mods & 4) != 0;
                overriding = (Parameter)container.getRealElement(Parameter.class, n.getText());
                if (overriding != null) {
                    overridingDomain = overriding.getType();
                }
                if (overriding == null && declaredExtended) {
                    this.reportError(this.formatMessage("err_parameter_nothingToExtend", n.getText(), container.toString()), n.getLine());
                }
                if (overriding != null && container == overriding.getContainer(Viewable.class)) {
                    this.reportError(this.formatMessage("err_parameter_nameInSameContainer", container.toString(), n.getText()), n.getLine());
                } else if (overriding != null && !declaredExtended) {
                    this.reportError(this.formatMessage("err_parameter_extendedWithoutDecl", n.getText(), container.toString(), overriding.toString()), n.getLine());
                }
            }
            boolean synPredMatched267 = false;
            if (this.LA(1) == 134) {
                int _m267 = this.mark();
                synPredMatched267 = true;
                ++this.inputState.guessing;
                try {
                    this.match(134);
                }
                catch (RecognitionException pe) {
                    synPredMatched267 = false;
                }
                this.rewind(_m267);
                --this.inputState.guessing;
            }
            if (synPredMatched267) {
                pt = this.LT(1);
                this.match(134);
                if (this.LA(1) == 20) {
                    this.match(20);
                    referred = this.classRef(container);
                } else if (this.LA(1) == 5) {
                    if (this.inputState.guessing == 0) {
                        referred = container;
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing == 0) {
                    MetaobjectType reference = new MetaobjectType();
                    try {
                        reference.setReferred(referred);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, pt.getLine());
                    }
                    type = reference;
                }
            } else if (_tokenSet_27.member(this.LA(1))) {
                type = this.attrTypeDef(container, true, overridingDomain, n.getLine(), null);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                Parameter p = new Parameter();
                try {
                    p.setName(n.getText());
                    p.setDocumentation(ilidoc);
                    p.setMetaValues(metaValues);
                    container.add(p);
                    p.setType(type);
                    p.setExtending(overriding);
                    p.setAbstract((mods & 1) != 0);
                    p.setFinal((mods & 2) != 0);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_28);
            }
            throw ex;
        }
    }

    protected final Table structureRef(Container scope) throws RecognitionException, TokenStreamException {
        Table t = null;
        int refto = 0;
        try {
            if (this.inputState.guessing == 0) {
                refto = this.LT(1).getLine();
            }
            t = this.classRef(scope);
            if (this.inputState.guessing == 0 && t.isIdentifiable()) {
                this.reportError(this.formatMessage("err_structRef_StructRequired", t.getScopedName((Container)null)), refto);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_29);
            }
            throw ex;
        }
        return t;
    }

    protected final Type attrTypeDef(Container scope, boolean allowAliases, Type extending, int line, ArrayList formalArgs) throws RecognitionException, TokenStreamException {
        Type typ = null;
        Cardinality card = null;
        CompositionType ct = null;
        boolean ordered = false;
        try {
            switch (this.LA(1)) {
                case 49: {
                    this.match(49);
                    if (_tokenSet_30.member(this.LA(1))) {
                        typ = this.attrType(scope, allowAliases, extending, line, formalArgs);
                    } else if (_tokenSet_31.member(this.LA(1))) {
                        if (this.inputState.guessing == 0) {
                            if (extending != null) {
                                try {
                                    typ = extending.clone();
                                }
                                catch (Exception ex) {
                                    this.reportError(ex, line);
                                    typ = null;
                                }
                            } else {
                                this.reportError(this.rsrc.getString("err_type_mandatoryLonely"), line);
                                typ = null;
                            }
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.inputState.guessing != 0) break;
                    try {
                        if (typ != null) {
                            typ.setMandatory(true);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    break;
                }
                case 4: 
                case 7: 
                case 11: 
                case 12: 
                case 16: 
                case 34: 
                case 40: 
                case 41: 
                case 43: 
                case 52: 
                case 54: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 79: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 131: 
                case 134: 
                case 182: 
                case 183: 
                case 184: {
                    typ = this.attrType(scope, allowAliases, extending, line, formalArgs);
                    break;
                }
                case 50: 
                case 51: {
                    if (this.LA(1) == 50) {
                        this.match(50);
                        if (this.inputState.guessing == 0) {
                            ordered = false;
                        }
                    } else if (this.LA(1) == 51) {
                        this.match(51);
                        if (this.inputState.guessing == 0) {
                            ordered = true;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 66) {
                        card = this.cardinality();
                    } else if (this.LA(1) != 20) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(20);
                    typ = this.attrType(scope, allowAliases, extending, line, formalArgs);
                    if (this.inputState.guessing != 0) break;
                    try {
                        if (typ instanceof CompositionType) {
                            ct = (CompositionType)typ;
                            if (card != null) {
                                ct.setCardinality(card);
                            } else {
                                ct.setCardinality(new Cardinality(0L, Long.MAX_VALUE));
                            }
                            ct.setOrdered(ordered);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_31);
            }
            throw ex;
        }
        return typ;
    }

    protected final Evaluable factor(Container ns, Container functionNs) throws RecognitionException, TokenStreamException {
        Evaluable ev = null;
        GraphicParameterDef param = null;
        LinkedList nams = new LinkedList();
        int lin = 0;
        InspectionFactor inspFactor = null;
        ObjectPath inspRestriction = null;
        try {
            switch (this.LA(1)) {
                case 44: {
                    this.match(44);
                    lin = this.names2(nams);
                    if (this.inputState.guessing == 0) {
                        param = this.resolveRuntimeParameterRef(ns, nams.toArray(new String[nams.size()]), lin);
                        ev = new ParameterValue(param);
                    }
                    break;
                }
                case 117: 
                case 153: {
                    boolean synPredMatched340 = false;
                    if (this.LA(1) == 117 || this.LA(1) == 153) {
                        int _m340 = this.mark();
                        synPredMatched340 = true;
                        ++this.inputState.guessing;
                        try {
                            if (this.LA(1) == 117) {
                                this.match(117);
                            } else if (this.LA(1) != 153) {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            this.match(153);
                            this.match(20);
                        }
                        catch (RecognitionException pe) {
                            synPredMatched340 = false;
                        }
                        this.rewind(_m340);
                        --this.inputState.guessing;
                    }
                    if (synPredMatched340) {
                        View dummy = this.inspection(ns);
                        if (this.inputState.guessing == 0) {
                            DecompositionView insp = (DecompositionView)dummy;
                            inspFactor = new InspectionFactor();
                            ev = inspFactor;
                            inspFactor.setRenamedViewable(insp.getRenamedViewable());
                            inspFactor.setDecomposedAttribute(insp.getDecomposedAttribute());
                            inspFactor.setAreaInspection(insp.isAreaDecomposition());
                        }
                    } else if (this.LA(1) == 153) {
                        this.match(153);
                        Viewable dummy = this.viewableRef(ns);
                        if (this.inputState.guessing == 0) {
                            inspFactor = new InspectionFactor();
                            ev = inspFactor;
                            inspFactor.setInspectionViewable((DecompositionView)dummy);
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 20) {
                        this.match(20);
                        inspRestriction = this.objectOrAttributePath((Viewable)ns);
                        if (this.inputState.guessing == 0) {
                            inspFactor.setRestriction(inspRestriction);
                        }
                        break;
                    }
                    if (_tokenSet_32.member(this.LA(1))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 16: 
                case 72: 
                case 81: 
                case 90: 
                case 91: 
                case 92: 
                case 111: 
                case 182: 
                case 183: 
                case 184: {
                    ev = this.constant(ns);
                    break;
                }
                default: {
                    boolean synPredMatched334 = false;
                    if (_tokenSet_7.member(this.LA(1))) {
                        int _m334 = this.mark();
                        synPredMatched334 = true;
                        ++this.inputState.guessing;
                        try {
                            this.xyRef();
                            this.match(12);
                        }
                        catch (RecognitionException pe) {
                            synPredMatched334 = false;
                        }
                        this.rewind(_m334);
                        --this.inputState.guessing;
                    }
                    if (synPredMatched334) {
                        ev = this.functionCall(ns, functionNs);
                        break;
                    }
                    if (_tokenSet_33.member(this.LA(1))) {
                        if (this.inputState.guessing == 0 && !(ns instanceof Viewable)) {
                            this.reportError(this.formatMessage("err_Container_currentIsNotViewable", ns.toString()), this.LT(1).getLine());
                        }
                        ev = this.objectOrAttributePath((Viewable)ns);
                        break;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_32);
            }
            throw ex;
        }
        return ev;
    }

    protected final Type attrType(Container scope, boolean allowAliases, Type extending, int line, ArrayList formalArgs) throws RecognitionException, TokenStreamException {
        Token as = null;
        LinkedList nams = new LinkedList();
        Type typ = null;
        Table restrictedTo = null;
        int lin = 0;
        CompositionType ct = null;
        try {
            switch (this.LA(1)) {
                case 12: 
                case 16: 
                case 34: 
                case 40: 
                case 41: 
                case 43: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 79: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 182: 
                case 183: 
                case 184: {
                    typ = this.type(scope, extending, formalArgs, false);
                    break;
                }
                case 4: 
                case 7: 
                case 11: 
                case 52: 
                case 131: 
                case 134: {
                    if (_tokenSet_7.member(this.LA(1))) {
                        lin = this.names2(nams);
                        if (this.inputState.guessing == 0) {
                            Element e = this.resolveStructureOrDomainRef(scope, nams.toArray(new String[nams.size()]), lin);
                            if (e instanceof Table) {
                                Table s = (Table)e;
                                ct = new CompositionType();
                                try {
                                    ct.setSourceLine(lin);
                                    ct.setCardinality(new Cardinality(0L, 1L));
                                    ct.setComponentType(s);
                                }
                                catch (Exception ex) {
                                    this.reportError(ex, line);
                                }
                                typ = ct;
                            } else {
                                Domain aliased = (Domain)e;
                                if (!(allowAliases || aliased != null && aliased.getContainer(Model.class) == this.td.INTERLIS)) {
                                    this.reportError(this.rsrc.getString("err_aliasAtWrongPlace"), line);
                                } else {
                                    typ = new TypeAlias();
                                    try {
                                        ((TypeAlias)typ).setAliasing(aliased);
                                    }
                                    catch (Exception ex) {
                                        this.reportError(ex, line);
                                    }
                                }
                                ct = null;
                            }
                        }
                    } else if (this.LA(1) == 52) {
                        as = this.LT(1);
                        this.match(52);
                        if (this.inputState.guessing == 0) {
                            ct = new CompositionType();
                            try {
                                ct.setSourceLine(as.getLine());
                                ct.setCardinality(new Cardinality(0L, 1L));
                                ct.setComponentType(this.modelInterlis.ANYSTRUCTURE);
                            }
                            catch (Exception ex) {
                                this.reportError(ex, as.getLine());
                            }
                            typ = ct;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 53 && ct != null) {
                        this.match(53);
                        this.match(12);
                        restrictedTo = this.structureRef(scope);
                        if (this.inputState.guessing == 0) {
                            ct.addRestrictedTo(restrictedTo);
                        }
                        while (this.LA(1) == 5) {
                            this.match(5);
                            restrictedTo = this.structureRef(scope);
                            if (this.inputState.guessing != 0) continue;
                            ct.addRestrictedTo(restrictedTo);
                        }
                        this.match(13);
                        break;
                    }
                    if (_tokenSet_31.member(this.LA(1))) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 54: {
                    typ = this.referenceAttr(scope);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_31);
            }
            throw ex;
        }
        return typ;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Cardinality cardinality() throws RecognitionException, TokenStreamException {
        Token lcurl = null;
        long min = 0L;
        long max = Long.MAX_VALUE;
        Cardinality card = null;
        try {
            lcurl = this.LT(1);
            this.match(66);
            if (this.LA(1) == 67) {
                this.match(67);
            } else {
                if (this.LA(1) != 183) throw new NoViableAltException(this.LT(1), this.getFilename());
                min = this.posInteger();
                if (this.LA(1) == 68) {
                    this.match(68);
                    if (this.LA(1) == 183) {
                        max = this.posInteger();
                    } else {
                        if (this.LA(1) != 67) throw new NoViableAltException(this.LT(1), this.getFilename());
                        this.match(67);
                    }
                } else {
                    if (this.LA(1) != 69) throw new NoViableAltException(this.LT(1), this.getFilename());
                    if (this.inputState.guessing == 0) {
                        max = min;
                    }
                }
            }
            this.match(69);
            if (this.inputState.guessing != 0) return card;
            try {
                return new Cardinality(min, max);
            }
            catch (Exception ex) {
                this.reportError(ex, lcurl.getLine());
            }
            return card;
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing != 0) throw ex;
            this.reportError(ex);
            this.recover(ex, _tokenSet_34);
            return card;
        }
    }

    protected final Type type(Container scope, Type extending, ArrayList formalArgs, boolean isGeneric) throws RecognitionException, TokenStreamException {
        Type typ;
        block5: {
            typ = null;
            try {
                if (_tokenSet_35.member(this.LA(1))) {
                    typ = this.baseType(scope, extending, formalArgs, isGeneric);
                    break block5;
                }
                if (this.LA(1) >= 112 && this.LA(1) <= 118) {
                    typ = this.lineType(scope, extending);
                    break block5;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return typ;
    }

    protected final ReferenceType referenceAttr(Container scope) throws RecognitionException, TokenStreamException {
        Token refkw = null;
        ReferenceType rt = null;
        int mods = 0;
        try {
            refkw = this.LT(1);
            this.match(54);
            this.match(55);
            mods = this.properties(256);
            rt = this.restrictedClassOrAssRef(scope);
            if (this.inputState.guessing == 0) {
                boolean external = (mods & 0x100) != 0;
                Topic targetTopic = (Topic)rt.getReferred().getContainerOrSame(Topic.class);
                Topic thisTopic = (Topic)scope.getContainerOrSame(Topic.class);
                if (targetTopic != null && thisTopic != null && !thisTopic.isExtending(targetTopic)) {
                    if (!external) {
                        this.reportError(this.formatMessage("err_refattr_externalreq", ""), refkw.getLine());
                    } else if (targetTopic != thisTopic && !thisTopic.isDependentOn(targetTopic)) {
                        this.reportError(this.formatMessage("err_viewableref_topicdepreq", thisTopic.getName(), targetTopic.getName()), refkw.getLine());
                    }
                }
                rt.setExternal(external);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_31);
            }
            throw ex;
        }
        return rt;
    }

    protected final ReferenceType restrictedClassOrAssRef(Container scope) throws RecognitionException, TokenStreamException {
        ReferenceType rt = new ReferenceType();
        int refto = 0;
        boolean mods = false;
        try {
            if (this.inputState.guessing == 0) {
                refto = this.LT(1).getLine();
            }
            if (this.LA(1) == 56) {
                this.match(56);
                if (this.inputState.guessing == 0) {
                    try {
                        rt.setReferred(this.modelInterlis.ANYCLASS);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, refto);
                    }
                }
            } else if (_tokenSet_7.member(this.LA(1))) {
                AbstractClassDef ref = this.classOrAssociationRef(scope);
                if (this.inputState.guessing == 0) {
                    try {
                        rt.setReferred(ref);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, refto);
                    }
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 53) {
                this.match(53);
                this.match(12);
                AbstractClassDef restrictedTo = this.classOrAssociationRef(scope);
                if (this.inputState.guessing == 0) {
                    rt.addRestrictedTo(restrictedTo);
                }
                while (this.LA(1) == 5) {
                    this.match(5);
                    restrictedTo = this.classOrAssociationRef(scope);
                    if (this.inputState.guessing != 0) continue;
                    rt.addRestrictedTo(restrictedTo);
                }
                this.match(13);
            } else if (!_tokenSet_37.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_37);
            }
            throw ex;
        }
        return rt;
    }

    protected final AbstractClassDef classOrAssociationRef(Container scope) throws RecognitionException, TokenStreamException {
        AbstractClassDef def = null;
        int line = 0;
        try {
            if (this.inputState.guessing == 0) {
                line = this.LT(1).getLine();
            }
            Viewable ref = this.viewableRef(scope);
            if (this.inputState.guessing == 0) {
                if (ref instanceof AbstractClassDef) {
                    def = (AbstractClassDef)ref;
                } else {
                    this.reportError(this.formatMessage("err_classOrAssociationRef", ref.getScopedName((Container)null)), line);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_38);
            }
            throw ex;
        }
        return def;
    }

    protected final Viewable viewableRef(Container scope) throws RecognitionException, TokenStreamException {
        LinkedList nams = new LinkedList();
        int lin = 0;
        Viewable found = null;
        String elementName = null;
        try {
            lin = this.names2(nams);
            if (this.inputState.guessing == 0) {
                Viewable elt;
                Container container = null;
                switch (nams.size()) {
                    case 1: {
                        elementName = (String)nams.get(0);
                        container = scope.getContainerOrSame(AbstractPatternDef.class);
                        if (container != null) break;
                        container = scope.getContainerOrSame(Model.class);
                        break;
                    }
                    case 2: {
                        container = this.resolveOrFixModelName(scope, (String)nams.get(0), lin);
                        elementName = (String)nams.get(1);
                        break;
                    }
                    case 3: {
                        container = this.resolveOrFixTopicName(this.resolveOrFixModelName(scope, (String)nams.get(0), lin), (String)nams.get(1), lin);
                        elementName = (String)nams.get(2);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdViewOrTableRef"), lin);
                        Ili24Parser.panic();
                    }
                }
                if ((elt = (Viewable)container.getRealElement(Viewable.class, elementName)) == null && nams.size() == 1) {
                    Model model = (Model)scope.getContainerOrSame(Model.class);
                    elt = (Viewable)model.getImportedElement(Viewable.class, elementName);
                }
                if (elt == null) {
                    this.reportError(this.formatMessage("err_noSuchViewOrTable", elementName, container.toString()), lin);
                    Ili24Parser.panic();
                }
                found = elt;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_39);
            }
            throw ex;
        }
        return found;
    }

    protected final CompositionType restrictedStructureRef(Container scope) throws RecognitionException, TokenStreamException {
        Table ref = null;
        CompositionType ct = null;
        int line = 0;
        try {
            if (this.inputState.guessing == 0) {
                line = this.LT(1).getLine();
            }
            if (this.LA(1) == 52) {
                this.match(52);
                if (this.inputState.guessing == 0) {
                    ref = this.modelInterlis.ANYSTRUCTURE;
                }
            } else if (_tokenSet_7.member(this.LA(1))) {
                ref = this.structureRef(scope);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                ct = new CompositionType();
                try {
                    ct.setSourceLine(line);
                    ct.setComponentType(ref);
                }
                catch (Exception ex) {
                    this.reportError(ex, line);
                }
            }
            if (this.LA(1) == 53) {
                this.match(53);
                this.match(12);
                Table restrictedTo = this.structureRef(scope);
                if (this.inputState.guessing == 0) {
                    ct.addRestrictedTo(restrictedTo);
                }
                while (this.LA(1) == 5) {
                    this.match(5);
                    restrictedTo = this.structureRef(scope);
                    if (this.inputState.guessing != 0) continue;
                    ct.addRestrictedTo(restrictedTo);
                }
                this.match(13);
            } else if (this.LA(1) != 1) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
        return ct;
    }

    protected final AssociationDef associationRef(Container scope) throws RecognitionException, TokenStreamException {
        AssociationDef ref = null;
        int refline = 0;
        try {
            if (this.inputState.guessing == 0) {
                refline = this.LT(1).getLine();
            }
            Viewable t = this.viewableRef(scope);
            if (this.inputState.guessing == 0) {
                if (t instanceof AssociationDef) {
                    ref = (AssociationDef)t;
                } else {
                    this.reportError(this.formatMessage("err_assocref_notAnAssoc", t.getScopedName((Container)null)), refline);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_40);
            }
            throw ex;
        }
        return ref;
    }

    protected final ViewableAlias renamedViewableRef(Container scope) throws RecognitionException, TokenStreamException {
        Token n = null;
        String aliasName = null;
        Viewable aliasFor = null;
        ViewableAlias found = null;
        try {
            boolean synPredMatched406 = false;
            if (this.LA(1) == 11) {
                int _m406 = this.mark();
                synPredMatched406 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(132);
                }
                catch (RecognitionException pe) {
                    synPredMatched406 = false;
                }
                this.rewind(_m406);
                --this.inputState.guessing;
            }
            if (synPredMatched406) {
                n = this.LT(1);
                this.match(11);
                this.match(132);
                if (this.inputState.guessing == 0) {
                    aliasName = n.getText();
                }
            } else if (!_tokenSet_7.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            aliasFor = this.viewableRefDepReq(scope);
            if (this.inputState.guessing == 0) {
                found = new ViewableAlias(aliasName, aliasFor);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_41);
            }
            throw ex;
        }
        return found;
    }

    protected final void roleDefs(AssociationDef container) throws RecognitionException, TokenStreamException {
        try {
            boolean synPredMatched100 = false;
            if (this.LA(1) == 11) {
                int _m100 = this.mark();
                synPredMatched100 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.properties(2319);
                    switch (this.LA(1)) {
                        case 62: {
                            this.match(62);
                            break;
                        }
                        case 63: {
                            this.match(63);
                            break;
                        }
                        case 64: {
                            this.match(64);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                }
                catch (RecognitionException pe) {
                    synPredMatched100 = false;
                }
                this.rewind(_m100);
                --this.inputState.guessing;
            }
            if (synPredMatched100) {
                this.roleDef(container);
                this.roleDefs(container);
            } else if (!_tokenSet_20.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_20);
            }
            throw ex;
        }
    }

    protected final void roleDef(AssociationDef container) throws RecognitionException, TokenStreamException {
        Token n = null;
        Token col = null;
        Cardinality card = null;
        ReferenceType ref = null;
        Evaluable obj = null;
        RoleDef def = new RoleDef(true);
        int kind = 0;
        boolean external = false;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            Topic thisTopic;
            Topic targetTopic;
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            n = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                def.setSourceLine(n.getLine());
            }
            int mods = this.properties(2319);
            switch (this.LA(1)) {
                case 62: {
                    this.match(62);
                    if (this.inputState.guessing != 0) break;
                    kind = 1;
                    break;
                }
                case 63: {
                    this.match(63);
                    if (this.inputState.guessing != 0) break;
                    kind = 2;
                    break;
                }
                case 64: {
                    this.match(64);
                    if (this.inputState.guessing != 0) break;
                    kind = 3;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.LA(1) == 66) {
                card = this.cardinality();
            } else if (!_tokenSet_42.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ref = this.restrictedClassOrAssRef(container);
            if (this.inputState.guessing == 0) {
                try {
                    external = (mods & 0x100) != 0;
                    targetTopic = (Topic)ref.getReferred().getContainerOrSame(Topic.class);
                    thisTopic = (Topic)container.getContainerOrSame(Topic.class);
                    if (targetTopic != null && thisTopic != null && !thisTopic.isExtending(targetTopic)) {
                        if (!external) {
                            this.reportError(this.formatMessage("err_role_externalreq", ""), n.getLine());
                        } else if (targetTopic != thisTopic && !thisTopic.isDependentOn(targetTopic)) {
                            this.reportError(this.formatMessage("err_viewableref_topicdepreq", thisTopic.getName(), targetTopic.getName()), n.getLine());
                        }
                    }
                    ref.setExternal(external);
                    def.setName(n.getText());
                    def.setDocumentation(ilidoc);
                    def.setMetaValues(metaValues);
                    def.setExtended((mods & 4) != 0);
                    def.setAbstract((mods & 1) != 0);
                    def.setFinal((mods & 2) != 0);
                    def.setHiding((mods & 0x800) != 0);
                    def.setOrdered((mods & 8) != 0);
                    def.setKind(kind);
                    if (card != null) {
                        if (kind == 3 && card.getMaximum() > 1L) {
                            this.reportError(this.formatMessage("err_role_maxcard1", n.getText()), n.getLine());
                        }
                        def.setCardinality(card);
                    }
                    if (ref.getReferred() instanceof Table && !((Table)ref.getReferred()).isIdentifiable()) {
                        this.reportError(this.formatMessage("err_role_toStruct", n.getText()), n.getLine());
                    }
                    def.addReference(ref);
                    container.add(def);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            while (this.LA(1) == 65) {
                this.match(65);
                ref = this.restrictedClassOrAssRef(container);
                if (this.inputState.guessing != 0) continue;
                targetTopic = (Topic)ref.getReferred().getContainerOrSame(Topic.class);
                thisTopic = (Topic)container.getContainerOrSame(Topic.class);
                if (targetTopic != null && thisTopic != null && !thisTopic.isExtending(targetTopic)) {
                    if (!external) {
                        this.reportError(this.formatMessage("err_role_externalreq", ""), n.getLine());
                    } else if (targetTopic != thisTopic && !thisTopic.isDependentOn(targetTopic)) {
                        this.reportError(this.formatMessage("err_viewableref_topicdepreq", thisTopic.getName(), targetTopic.getName()), n.getLine());
                    }
                }
                ref.setExternal(external);
                if (ref.getReferred() instanceof Table && !((Table)ref.getReferred()).isIdentifiable()) {
                    this.reportError(this.formatMessage("err_role_toStruct", n.getText()), n.getLine());
                }
                def.addReference(ref);
            }
            if (this.LA(1) == 48) {
                col = this.LT(1);
                this.match(48);
                obj = this.factor(container, container);
                if (this.inputState.guessing == 0) {
                    if (!(obj instanceof ObjectPath)) {
                        this.reportError(this.formatMessage("err_role_factorNotAnObjectPath", ""), col.getLine());
                    }
                    def.setDerivedFrom((ObjectPath)obj);
                }
            } else if (this.LA(1) != 5) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_20);
            }
            throw ex;
        }
    }

    protected final int posInteger() throws RecognitionException, TokenStreamException {
        Token p = null;
        int i = 0;
        try {
            p = this.LT(1);
            this.match(183);
            if (this.inputState.guessing == 0) {
                try {
                    i = Integer.parseInt(p.getText());
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, p.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_43);
            }
            throw ex;
        }
        return i;
    }

    protected final void domainDef(Container container) throws RecognitionException, TokenStreamException {
        block33: {
            Token n = null;
            Token eq = null;
            Domain extending = null;
            Type extendingType = null;
            Type declared = null;
            int mods = 0;
            String ilidoc = null;
            Settings metaValues = null;
            try {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                n = this.LT(1);
                this.match(11);
                mods = this.properties(4099);
                if (this.LA(1) == 32) {
                    this.match(32);
                    extending = this.domainRef(container);
                    if (this.inputState.guessing == 0 && extending != null) {
                        extendingType = extending.getType();
                    }
                } else if (this.LA(1) != 23) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                eq = this.LT(1);
                this.match(23);
                if (this.LA(1) == 49) {
                    this.match(49);
                    if (_tokenSet_44.member(this.LA(1))) {
                        declared = this.type(container, extendingType, null, (mods & 0x1000) != 0);
                    } else if (this.LA(1) != 5 && this.LA(1) != 70) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                } else if (_tokenSet_44.member(this.LA(1))) {
                    declared = this.type(container, extendingType, null, (mods & 0x1000) != 0);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 70) {
                    this.match(70);
                    this.match(11);
                    this.match(47);
                    this.expression(container, this.predefinedBooleanType, container);
                    while (this.LA(1) == 28) {
                        this.match(28);
                        this.match(11);
                        this.match(47);
                        this.expression(container, this.predefinedBooleanType, container);
                    }
                } else if (this.LA(1) != 5) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(5);
                if (this.inputState.guessing != 0) break block33;
                Domain dd = new Domain();
                try {
                    dd.setName(n.getText());
                    dd.setDocumentation(ilidoc);
                    dd.setMetaValues(metaValues);
                    try {
                        if ((mods & 1) != 0) {
                            dd.setAbstract(true);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                    try {
                        if ((mods & 2) != 0) {
                            dd.setFinal(true);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                    try {
                        if (declared != null) {
                            dd.setType(declared);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                    try {
                        if (declared != null && !declared.isMandatory() && extendingType != null && extendingType.isMandatory()) {
                            this.reportError(this.formatMessage("err_extendingMandatoryDomain", dd.toString(), extending.toString()), eq.getLine());
                            declared.setMandatory(true);
                        }
                        dd.setExtending(extending);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, n.getLine());
                    }
                    container.add(dd);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_45);
                }
                throw ex;
            }
        }
    }

    protected final Evaluable expression(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Evaluable expr = null;
        try {
            expr = this.term(ns, expectedType, functionNs);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_46);
            }
            throw ex;
        }
        return expr;
    }

    protected final Type baseType(Container scope, Type extending, ArrayList formalArgs, boolean isGeneric) throws RecognitionException, TokenStreamException {
        Type bt = null;
        try {
            switch (this.LA(1)) {
                case 73: 
                case 74: 
                case 75: 
                case 76: {
                    bt = this.textType(extending);
                    break;
                }
                case 12: {
                    bt = this.enumerationType(extending);
                    break;
                }
                case 79: {
                    bt = this.enumTreeValueType(scope, extending);
                    break;
                }
                case 83: 
                case 84: {
                    bt = this.alignmentType();
                    break;
                }
                case 85: {
                    bt = this.booleanType();
                    break;
                }
                case 86: 
                case 182: 
                case 183: 
                case 184: {
                    bt = this.numericType(scope, extending, false);
                    break;
                }
                case 16: 
                case 93: {
                    bt = this.formattedType(scope, extending);
                    break;
                }
                case 97: 
                case 98: 
                case 99: {
                    bt = this.dateTimeType(scope, extending);
                    break;
                }
                case 100: 
                case 101: {
                    bt = this.coordinateType(scope, extending, isGeneric);
                    break;
                }
                case 34: {
                    bt = this.oIDType(scope, extending);
                    break;
                }
                case 107: {
                    bt = this.blackboxType(scope, extending);
                    break;
                }
                case 40: 
                case 41: {
                    bt = this.classType(scope, extending);
                    break;
                }
                case 43: {
                    bt = this.attributePathType(scope, extending, formalArgs);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return bt;
    }

    protected final LineType lineType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        LineType lt;
        block47: {
            Token pl = null;
            Token mpl = null;
            Token surf = null;
            Token msurf = null;
            Token area = null;
            Token marea = null;
            Token att = null;
            boolean directed = false;
            boolean withStraights = false;
            boolean withArcs = false;
            LineForm[] theLineForms = null;
            PrecisionDecimal theMaxOverlap = null;
            Domain controlPointDomain = null;
            Table lineAttrStructure = null;
            int line = 0;
            lt = null;
            try {
                switch (this.LA(1)) {
                    case 112: 
                    case 113: 
                    case 114: {
                        if (this.LA(1) == 112) {
                            this.match(112);
                            if (this.inputState.guessing == 0) {
                                directed = true;
                            }
                        } else if (this.LA(1) != 113 && this.LA(1) != 114) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.LA(1) == 113) {
                            pl = this.LT(1);
                            this.match(113);
                            if (this.inputState.guessing == 0) {
                                line = pl.getLine();
                            }
                        } else if (this.LA(1) == 114) {
                            mpl = this.LT(1);
                            this.match(114);
                            if (this.inputState.guessing == 0) {
                                line = mpl.getLine();
                            }
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing != 0) break;
                        lt = new PolylineType();
                        try {
                            ((PolylineType)lt).setDirected(directed);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, line);
                        }
                        break;
                    }
                    case 115: {
                        surf = this.LT(1);
                        this.match(115);
                        if (this.inputState.guessing != 0) break;
                        line = surf.getLine();
                        lt = new SurfaceType();
                        break;
                    }
                    case 116: {
                        msurf = this.LT(1);
                        this.match(116);
                        if (this.inputState.guessing != 0) break;
                        line = msurf.getLine();
                        lt = new SurfaceType();
                        break;
                    }
                    case 117: {
                        area = this.LT(1);
                        this.match(117);
                        if (this.inputState.guessing != 0) break;
                        line = area.getLine();
                        lt = new AreaType();
                        break;
                    }
                    case 118: {
                        marea = this.LT(1);
                        this.match(118);
                        if (this.inputState.guessing != 0) break;
                        line = marea.getLine();
                        lt = new AreaType();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (this.LA(1) == 124) {
                    theLineForms = this.lineForm(scope);
                } else if (!_tokenSet_47.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 119) {
                    this.match(119);
                    controlPointDomain = this.domainRef(scope);
                } else if (!_tokenSet_48.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 120) {
                    this.match(120);
                    this.match(121);
                    this.match(90);
                    theMaxOverlap = this.decimal();
                } else if (!_tokenSet_49.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing == 0) {
                    if (theLineForms == null && extending instanceof LineType) {
                        theLineForms = ((LineType)extending).getLineForms();
                    }
                    if (theMaxOverlap == null && extending instanceof LineType) {
                        theMaxOverlap = ((LineType)extending).getMaxOverlap();
                    }
                    if (controlPointDomain == null && extending instanceof LineType) {
                        controlPointDomain = ((LineType)extending).getControlPointDomain();
                    }
                    try {
                        if (theLineForms != null) {
                            lt.setLineForms(theLineForms);
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        lt.setControlPointDomain(controlPointDomain);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        lt.setMaxOverlap(theMaxOverlap);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                }
                if (this.LA(1) == 122) {
                    att = this.LT(1);
                    this.match(122);
                    this.match(123);
                    lineAttrStructure = this.structureRef(scope);
                    if (this.inputState.guessing != 0) break block47;
                    try {
                        if (lt instanceof SurfaceOrAreaType) {
                            ((SurfaceOrAreaType)lt).setLineAttributeStructure(lineAttrStructure);
                            break block47;
                        }
                        this.reportError(this.formatMessage("err_lineType_lineAttrForPolyline", ""), att.getLine());
                    }
                    catch (Exception ex) {
                        this.reportError(ex, att.getLine());
                    }
                    break block47;
                }
                if (!_tokenSet_36.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return lt;
    }

    protected final Type textType(Type extending) throws RecognitionException, TokenStreamException {
        Token ur = null;
        Token nm = null;
        Token star = null;
        Type tt = null;
        int i = -1;
        boolean normalizedText = false;
        try {
            switch (this.LA(1)) {
                case 73: {
                    ur = this.LT(1);
                    this.match(73);
                    if (this.inputState.guessing == 0) {
                        tt = new TypeAlias();
                        try {
                            tt.setAliasing(this.modelInterlis.URI);
                        }
                        catch (Exception ex) {
                            this.reportInternalError(ex, ur.getLine());
                        }
                    }
                    break;
                }
                case 74: {
                    nm = this.LT(1);
                    this.match(74);
                    if (this.inputState.guessing == 0) {
                        tt = new TypeAlias();
                        try {
                            tt.setAliasing(this.modelInterlis.NAME);
                        }
                        catch (Exception ex) {
                            this.reportInternalError(ex, nm.getLine());
                        }
                    }
                    break;
                }
                case 75: 
                case 76: {
                    if (this.LA(1) == 75) {
                        this.match(75);
                    } else if (this.LA(1) == 76) {
                        this.match(76);
                        if (this.inputState.guessing == 0) {
                            normalizedText = true;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 67) {
                        star = this.LT(1);
                        this.match(67);
                        i = this.posInteger();
                        if (this.inputState.guessing == 0) {
                            try {
                                tt = new TextType(i);
                                ((TextType)tt).setNormalized(normalizedText);
                            }
                            catch (Exception ex) {
                                this.reportError(ex, star.getLine());
                            }
                        }
                        break;
                    }
                    if (_tokenSet_36.member(this.LA(1))) {
                        if (this.inputState.guessing == 0) {
                            tt = new TextType();
                            ((TextType)tt).setNormalized(normalizedText);
                        }
                        break;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return tt;
    }

    protected final EnumerationType enumerationType(Type extending) throws RecognitionException, TokenStreamException {
        Token ord = null;
        Token circ = null;
        EnumerationType et = new EnumerationType();
        try {
            Enumeration enumer = this.enumeration(extending);
            if (this.inputState.guessing == 0) {
                try {
                    et.setEnumeration(enumer);
                }
                catch (Exception ex) {
                    this.reportError(ex, 0);
                }
            }
            switch (this.LA(1)) {
                case 77: {
                    ord = this.LT(1);
                    this.match(77);
                    if (this.inputState.guessing == 0) {
                        try {
                            et.setOrdered(true);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, ord.getLine());
                        }
                    }
                    break;
                }
                case 78: {
                    circ = this.LT(1);
                    this.match(78);
                    if (this.inputState.guessing == 0) {
                        try {
                            et.setCircular(true);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, circ.getLine());
                        }
                    }
                    break;
                }
                case 5: 
                case 13: 
                case 18: 
                case 48: 
                case 70: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return et;
    }

    protected final EnumTreeValueType enumTreeValueType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        Domain ref = null;
        EnumTreeValueType et = null;
        try {
            this.match(79);
            this.match(20);
            ref = this.domainRef(scope);
            if (this.inputState.guessing == 0) {
                et = new EnumTreeValueType();
                et.setEnumType(ref);
                return et;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return et;
    }

    protected final Type alignmentType() throws RecognitionException, TokenStreamException {
        TypeAlias tt;
        block11: {
            Token h = null;
            Token v = null;
            tt = null;
            try {
                if (this.LA(1) == 83) {
                    h = this.LT(1);
                    this.match(83);
                    if (this.inputState.guessing == 0) {
                        tt = new TypeAlias();
                        try {
                            tt.setAliasing(this.modelInterlis.HALIGNMENT);
                        }
                        catch (Exception ex) {
                            this.reportInternalError(ex, h.getLine());
                        }
                    }
                    break block11;
                }
                if (this.LA(1) == 84) {
                    v = this.LT(1);
                    this.match(84);
                    if (this.inputState.guessing == 0) {
                        tt = new TypeAlias();
                        try {
                            tt.setAliasing(this.modelInterlis.VALIGNMENT);
                        }
                        catch (Exception ex) {
                            this.reportInternalError(ex, v.getLine());
                        }
                    }
                    break block11;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return tt;
    }

    protected final Type booleanType() throws RecognitionException, TokenStreamException {
        Token b = null;
        TypeAlias tt = null;
        try {
            b = this.LT(1);
            this.match(85);
            if (this.inputState.guessing == 0) {
                tt = new TypeAlias();
                try {
                    tt.setAliasing(this.modelInterlis.BOOLEAN);
                }
                catch (Exception ex) {
                    this.reportInternalError(ex, b.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return tt;
    }

    protected final NumericType numericType(Container scope, Type extending, boolean isCoord) throws RecognitionException, TokenStreamException {
        NumericType ntyp;
        block35: {
            Token dots = null;
            Token numer = null;
            Token circ = null;
            Token lbrac = null;
            Token cw = null;
            Token ccw = null;
            PrecisionDecimal min = null;
            PrecisionDecimal max = null;
            int rotation = 0;
            int rotationLine = 0;
            ntyp = null;
            Unit u = null;
            RefSystemRef referenceSystem = null;
            int line = 0;
            try {
                if (this.LA(1) >= 182 && this.LA(1) <= 184) {
                    min = this.decimal();
                    dots = this.LT(1);
                    this.match(68);
                    max = this.decimal();
                    if (this.inputState.guessing == 0) {
                        line = rotationLine = dots.getLine();
                        try {
                            ntyp = new NumericType(min, max);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, dots.getLine());
                            ntyp = new NumericType();
                        }
                    }
                } else if (this.LA(1) == 86) {
                    numer = this.LT(1);
                    this.match(86);
                    if (this.inputState.guessing == 0) {
                        ntyp = new NumericType();
                        line = rotationLine = numer.getLine();
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 78) {
                    circ = this.LT(1);
                    this.match(78);
                    if (this.inputState.guessing == 0) {
                        try {
                            ntyp.setCircular(true);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, circ.getLine());
                        }
                    }
                } else if (!_tokenSet_50.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 21) {
                    lbrac = this.LT(1);
                    this.match(21);
                    u = this.unitRef(scope);
                    this.match(22);
                } else if (!_tokenSet_51.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                switch (this.LA(1)) {
                    case 87: {
                        cw = this.LT(1);
                        this.match(87);
                        if (this.inputState.guessing != 0) break;
                        rotation = 1;
                        rotationLine = cw.getLine();
                        break;
                    }
                    case 88: {
                        ccw = this.LT(1);
                        this.match(88);
                        if (this.inputState.guessing != 0) break;
                        rotation = 2;
                        rotationLine = ccw.getLine();
                        break;
                    }
                    case 66: 
                    case 89: {
                        referenceSystem = this.refSys(scope, isCoord);
                        break;
                    }
                    case 5: 
                    case 13: 
                    case 18: 
                    case 28: 
                    case 48: 
                    case 70: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (this.inputState.guessing != 0) break block35;
                try {
                    if (u == null && extending instanceof NumericType) {
                        u = ((NumericType)extending).getUnit();
                    }
                    ntyp.setUnit(u);
                }
                catch (Exception ex) {
                    this.reportError(ex, lbrac.getLine());
                }
                try {
                    if (ntyp != null) {
                        ntyp.setRotation(rotation);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, rotationLine);
                }
                try {
                    if (referenceSystem == null && extending instanceof NumericType) {
                        referenceSystem = ((NumericType)extending).getReferenceSystem();
                    }
                    ntyp.setReferenceSystem(referenceSystem);
                }
                catch (Exception ex) {
                    this.reportError(ex, line);
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_52);
                }
                throw ex;
            }
        }
        return ntyp;
    }

    protected final FormattedType formattedType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        FormattedType ft;
        block53: {
            Token format_kw = null;
            Token prefix = null;
            Token postfix = null;
            Token min = null;
            Token max = null;
            Token min2 = null;
            Token max2 = null;
            Token min3 = null;
            Token max3 = null;
            ft = new FormattedType();
            Domain domain = null;
            Table struct = null;
            FormattedTypeBaseAttrRef baseAttr = null;
            int line = 0;
            try {
                boolean synPredMatched163 = false;
                if (this.LA(1) == 93) {
                    int _m163 = this.mark();
                    synPredMatched163 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(93);
                        this.match(94);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched163 = false;
                    }
                    this.rewind(_m163);
                    --this.inputState.guessing;
                }
                if (synPredMatched163) {
                    format_kw = this.LT(1);
                    this.match(93);
                    this.match(94);
                    this.match(37);
                    struct = this.structureRef(scope);
                    if (this.inputState.guessing == 0) {
                        line = format_kw.getLine();
                        ft = new FormattedType();
                        if (extending != null) {
                            try {
                                ft.setExtending(extending);
                            }
                            catch (Exception ex) {
                                this.reportError(ex, line);
                            }
                        }
                        ft.setBaseStruct(struct);
                    }
                    this.match(12);
                    if (this.LA(1) == 95) {
                        this.match(95);
                    } else if (this.LA(1) != 11 && this.LA(1) != 13 && this.LA(1) != 16) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.LA(1) == 16) {
                        prefix = this.LT(1);
                        this.match(16);
                        if (this.inputState.guessing == 0 && prefix != null) {
                            ft.setPrefix(prefix.getText());
                        }
                    } else if (this.LA(1) != 11 && this.LA(1) != 13) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    while (this.LA(1) == 11) {
                        baseAttr = this.baseAttrRef(ft, struct);
                        if (this.inputState.guessing == 0) {
                            postfix = null;
                        }
                        if (this.LA(1) == 16) {
                            postfix = this.LT(1);
                            this.match(16);
                        } else if (this.LA(1) != 11 && this.LA(1) != 13) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing != 0) continue;
                        if (postfix != null) {
                            baseAttr.setPostfix(postfix.getText());
                        }
                        ft.addBaseAttrRef(baseAttr);
                    }
                    this.match(13);
                    if (this.LA(1) == 16) {
                        min = this.LT(1);
                        this.match(16);
                        this.match(68);
                        max = this.LT(1);
                        this.match(16);
                    } else if (!_tokenSet_36.member(this.LA(1))) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.inputState.guessing != 0 || min == null) break block53;
                    try {
                        if (!ft.isValueInRange(min.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", min.getText()), min.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", min.getText()), min.getLine());
                    }
                    try {
                        if (!ft.isValueInRange(max.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", max.getText()), max.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", max.getText()), max.getLine());
                    }
                    ft.setMinimum(min.getText());
                    ft.setMaximum(max.getText());
                    break block53;
                }
                if (this.LA(1) == 16) {
                    min2 = this.LT(1);
                    this.match(16);
                    this.match(68);
                    max2 = this.LT(1);
                    this.match(16);
                    if (this.inputState.guessing != 0) break block53;
                    line = min2.getLine();
                    ft = new FormattedType();
                    if (extending != null) {
                        try {
                            ft.setExtending(extending);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, line);
                        }
                    }
                    try {
                        if (!ft.isValueInRange(min2.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", min2.getText()), min2.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", min2.getText()), min2.getLine());
                    }
                    try {
                        if (!ft.isValueInRange(max2.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", max2.getText()), max2.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", max2.getText()), max2.getLine());
                    }
                    ft.setMinimum(min2.getText());
                    ft.setMaximum(max2.getText());
                    break block53;
                }
                if (this.LA(1) == 93) {
                    this.match(93);
                    domain = this.domainRef(scope);
                    min3 = this.LT(1);
                    this.match(16);
                    this.match(68);
                    max3 = this.LT(1);
                    this.match(16);
                    if (this.inputState.guessing != 0) break block53;
                    line = min3.getLine();
                    ft = new FormattedType();
                    if (extending != null) {
                        try {
                            ft.setExtending(extending);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, line);
                        }
                    }
                    ft.setBaseDomain(domain);
                    try {
                        if (!ft.isValueInRange(min3.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", min3.getText()), min3.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", min3.getText()), min3.getLine());
                    }
                    try {
                        if (!ft.isValueInRange(max3.getText())) {
                            this.reportError(this.formatMessage("err_formattedType_valueOutOfRange", max3.getText()), max3.getLine());
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.reportError(this.formatMessage("err_formattedType_illegalFormat", max3.getText()), max3.getLine());
                    }
                    ft.setMinimum(min3.getText());
                    ft.setMaximum(max3.getText());
                    break block53;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return ft;
    }

    protected final CoordType dateTimeType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        CoordType ct = null;
        try {
            switch (this.LA(1)) {
                case 97: {
                    this.match(97);
                    break;
                }
                case 98: {
                    this.match(98);
                    break;
                }
                case 99: {
                    this.match(99);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return ct;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final CoordType coordinateType(Container scope, Type extending, boolean isGeneric) throws RecognitionException, TokenStreamException {
        void var4_14;
        Token coord = null;
        NumericType nt1 = null;
        NumericType nt2 = null;
        NumericType nt3 = null;
        int[] rots = null;
        Object var4_9 = null;
        NumericalType ext_nt1 = null;
        NumericalType ext_nt2 = null;
        NumericalType ext_nt3 = null;
        if (extending instanceof CoordType) {
            NumericalType[] ext_dimensions = ((CoordType)extending).getDimensions();
            if (!(extending instanceof CoordTypeAny)) {
                if (ext_dimensions.length >= 1) {
                    ext_nt1 = ext_dimensions[0];
                }
                if (ext_dimensions.length >= 2) {
                    ext_nt2 = ext_dimensions[1];
                }
                if (ext_dimensions.length >= 3) {
                    ext_nt3 = ext_dimensions[2];
                }
            }
        }
        try {
            if (this.LA(1) == 100) {
                coord = this.LT(1);
                this.match(100);
            } else {
                if (this.LA(1) != 101) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(101);
            }
            nt1 = this.numericType(scope, ext_nt1, true);
            if (this.LA(1) == 28) {
                this.match(28);
                nt2 = this.numericType(scope, ext_nt2, true);
                if (this.LA(1) == 28) {
                    this.match(28);
                    if (this.LA(1) == 103) {
                        rots = this.rotationDef();
                    } else {
                        if (!_tokenSet_53.member(this.LA(1))) throw new NoViableAltException(this.LT(1), this.getFilename());
                        nt3 = this.numericType(scope, ext_nt3, true);
                        if (this.LA(1) == 28) {
                            this.match(28);
                            rots = this.rotationDef();
                        } else if (!_tokenSet_54.member(this.LA(1))) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                } else if (!_tokenSet_54.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 102) {
                    this.match(102);
                    this.match(16);
                } else if (!_tokenSet_36.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (!_tokenSet_36.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing != 0) return var4_14;
            NumericalType[] nts = nt3 != null ? new NumericalType[]{nt1, nt2, nt3} : (nt2 != null ? new NumericalType[]{nt1, nt2} : new NumericalType[]{nt1});
            try {
                if (isGeneric) {
                    CoordTypeAny coordTypeAny = new CoordTypeAny();
                    return var4_14;
                }
                if (rots == null) {
                    CoordType coordType = new CoordType(nts);
                    return var4_14;
                }
                CoordType coordType = new CoordType(nts, rots[0], rots[1]);
                return var4_14;
            }
            catch (Exception ex) {
                this.reportError(ex, coord.getLine());
            }
            return var4_14;
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing != 0) throw ex;
            this.reportError(ex);
            this.recover(ex, _tokenSet_36);
            return var4_14;
        }
    }

    protected final OIDType oIDType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        OIDType bt = null;
        Type extendingOidType = null;
        if (extending != null && extending instanceof OIDType) {
            extendingOidType = ((OIDType)extending).getOIDType();
        }
        try {
            this.match(34);
            switch (this.LA(1)) {
                case 106: {
                    this.match(106);
                    if (this.inputState.guessing == 0) {
                        bt = new AnyOIDType();
                    }
                    break;
                }
                case 73: 
                case 74: 
                case 75: 
                case 76: {
                    Type t = this.textType(extendingOidType);
                    if (this.inputState.guessing == 0) {
                        bt = new TextOIDType(t);
                    }
                    break;
                }
                case 86: 
                case 182: 
                case 183: 
                case 184: {
                    NumericType nt = this.numericType(scope, extendingOidType, false);
                    if (this.inputState.guessing == 0) {
                        bt = new NumericOIDType(nt);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return bt;
    }

    protected final BlackboxType blackboxType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        BlackboxType sutype;
        block7: {
            sutype = null;
            try {
                this.match(107);
                if (this.LA(1) == 108) {
                    this.match(108);
                    if (this.inputState.guessing == 0) {
                        sutype = new BlackboxType();
                        sutype.setKind(1);
                    }
                    break block7;
                }
                if (this.LA(1) == 109) {
                    this.match(109);
                    if (this.inputState.guessing == 0) {
                        sutype = new BlackboxType();
                        sutype.setKind(2);
                    }
                    break block7;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return sutype;
    }

    protected final ClassType classType(Container scope, Type extending) throws RecognitionException, TokenStreamException {
        ClassType bt;
        block16: {
            bt = new ClassType();
            try {
                if (this.LA(1) == 40) {
                    this.match(40);
                    if (this.LA(1) == 53) {
                        this.match(53);
                        this.match(12);
                        AbstractClassDef restrictedTo = this.classOrAssociationRef(scope);
                        if (this.inputState.guessing == 0) {
                            bt.addRestrictedTo(restrictedTo);
                        }
                        while (this.LA(1) == 5) {
                            this.match(5);
                            restrictedTo = this.classOrAssociationRef(scope);
                            if (this.inputState.guessing != 0) continue;
                            bt.addRestrictedTo(restrictedTo);
                        }
                        this.match(13);
                    } else if (!_tokenSet_36.member(this.LA(1))) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break block16;
                }
                if (this.LA(1) == 41) {
                    this.match(41);
                    if (this.inputState.guessing == 0) {
                        bt.setStructure(true);
                    }
                    if (this.LA(1) == 53) {
                        this.match(53);
                        this.match(12);
                        Table restrictedTo = this.structureRef(scope);
                        if (this.inputState.guessing == 0) {
                            bt.addRestrictedTo(restrictedTo);
                        }
                        while (this.LA(1) == 5) {
                            this.match(5);
                            restrictedTo = this.structureRef(scope);
                            if (this.inputState.guessing != 0) continue;
                            bt.addRestrictedTo(restrictedTo);
                        }
                        this.match(13);
                    } else if (!_tokenSet_36.member(this.LA(1))) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break block16;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_36);
                }
                throw ex;
            }
        }
        return bt;
    }

    protected final AttributePathType attributePathType(Container scope, Type extending, ArrayList formalArgs) throws RecognitionException, TokenStreamException {
        Token of = null;
        Token n = null;
        Token lp = null;
        Token semi = null;
        AttributePathType sutype = null;
        ObjectPath attrRestr = null;
        Type type = null;
        ArrayList<Type> typev = new ArrayList<Type>();
        FormalArgument argRestr = null;
        try {
            this.match(43);
            if (this.LA(1) == 20) {
                of = this.LT(1);
                this.match(20);
                if (_tokenSet_33.member(this.LA(1)) && scope instanceof Viewable) {
                    attrRestr = this.attributePath((Viewable)scope);
                    if (this.inputState.guessing == 0) {
                        Type attrType = null;
                        try {
                            attrType = attrRestr.getType();
                        }
                        catch (Exception ex) {
                            this.reportError(ex.getLocalizedMessage(), of.getLine());
                            attrRestr = null;
                        }
                        if (attrType != null && !(attrType instanceof ClassType)) {
                            this.reportError(this.formatMessage("err_objectPath_targetAttrNotClassType", attrRestr.toString()), of.getLine());
                            attrRestr = null;
                        }
                    }
                } else if (!_tokenSet_55.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 110 && formalArgs != null) {
                    this.match(110);
                    n = this.LT(1);
                    this.match(11);
                    if (this.inputState.guessing == 0) {
                        for (int argi = 0; argi < formalArgs.size(); ++argi) {
                            FormalArgument arg = (FormalArgument)formalArgs.get(argi);
                            if (!arg.getName().equals(n.getText())) continue;
                            argRestr = arg;
                            break;
                        }
                        if (argRestr == null) {
                            this.reportError(this.formatMessage("err_function_noSuchArgWoScope", n.getText()), n.getLine());
                        }
                    }
                } else if (!_tokenSet_56.member(this.LA(1))) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (!_tokenSet_56.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 53) {
                this.match(53);
                lp = this.LT(1);
                this.match(12);
                type = this.attrTypeDef(scope, true, null, lp.getLine(), null);
                if (this.inputState.guessing == 0) {
                    typev.add(type);
                }
                while (this.LA(1) == 5) {
                    semi = this.LT(1);
                    this.match(5);
                    type = this.attrTypeDef(scope, true, null, semi.getLine(), null);
                    if (this.inputState.guessing != 0) continue;
                    typev.add(type);
                }
                this.match(13);
            } else if (!_tokenSet_36.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                sutype = new AttributePathType();
                if (attrRestr != null) {
                    sutype.setAttrRestriction(attrRestr);
                } else if (argRestr != null) {
                    sutype.setArgRestriction(argRestr);
                }
                if (typev.size() > 0) {
                    sutype.setTypeRestriction(typev.toArray(new Type[typev.size()]));
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_36);
            }
            throw ex;
        }
        return sutype;
    }

    protected final Constant constant(Container scope) throws RecognitionException, TokenStreamException {
        Constant c = null;
        try {
            switch (this.LA(1)) {
                case 72: {
                    this.match(72);
                    if (this.inputState.guessing == 0) {
                        c = new Constant.Undefined();
                    }
                    break;
                }
                case 91: 
                case 92: 
                case 182: 
                case 183: 
                case 184: {
                    c = this.numericConst(scope);
                    break;
                }
                case 16: {
                    c = this.textConst();
                    break;
                }
                case 81: {
                    c = this.enumerationConst();
                    break;
                }
                case 90: {
                    c = this.classConst(scope);
                    break;
                }
                case 111: {
                    c = this.attributeConst(scope);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_57);
            }
            throw ex;
        }
        return c;
    }

    protected final Constant numericConst(Container scope) throws RecognitionException, TokenStreamException {
        Unit un = null;
        Constant.Numeric c = null;
        try {
            PrecisionDecimal val = this.decConst();
            if (this.LA(1) == 21) {
                this.match(21);
                un = this.unitRef(scope);
                this.match(22);
            } else if (!_tokenSet_57.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                c = un == null ? new Constant.Numeric(val) : new Constant.Numeric(val, un);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_57);
            }
            throw ex;
        }
        return c;
    }

    protected final Constant textConst() throws RecognitionException, TokenStreamException {
        Token s = null;
        Constant.Text c = null;
        try {
            s = this.LT(1);
            this.match(16);
            if (this.inputState.guessing == 0) {
                c = new Constant.Text(s.getText());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_58);
            }
            throw ex;
        }
        return c;
    }

    protected final Constant.Enumeration enumerationConst() throws RecognitionException, TokenStreamException {
        Constant.Enumeration c;
        block11: {
            ArrayList<String> mentionedNames = new ArrayList<String>();
            int lin = 0;
            c = null;
            try {
                this.match(81);
                if (this.LA(1) == 11) {
                    lin = this.enumNameList(mentionedNames);
                    if (this.LA(1) == 29) {
                        this.match(29);
                        this.match(82);
                        if (this.inputState.guessing == 0) {
                            mentionedNames.add(Constant.Enumeration.OTHERS);
                        }
                    } else if (!_tokenSet_59.member(this.LA(1))) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.inputState.guessing == 0) {
                        c = new Constant.Enumeration(mentionedNames);
                    }
                    break block11;
                }
                if (this.LA(1) == 82) {
                    this.match(82);
                    if (this.inputState.guessing == 0) {
                        mentionedNames.add(Constant.Enumeration.OTHERS);
                        c = new Constant.Enumeration(mentionedNames);
                    }
                    break block11;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_59);
                }
                throw ex;
            }
        }
        return c;
    }

    public final Constant classConst(Container scope) throws RecognitionException, TokenStreamException {
        Constant.Class c = null;
        Viewable ref = null;
        try {
            this.match(90);
            ref = this.viewableRef(scope);
            if (this.inputState.guessing == 0) {
                c = new Constant.Class(ref);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_57);
            }
            throw ex;
        }
        return c;
    }

    public final Constant attributeConst(Container scope) throws RecognitionException, TokenStreamException {
        Token n = null;
        Constant.AttributePath c = null;
        Viewable ref = null;
        AttributeDef attr = null;
        try {
            this.match(111);
            boolean synPredMatched222 = false;
            if (_tokenSet_7.member(this.LA(1))) {
                int _m222 = this.mark();
                synPredMatched222 = true;
                ++this.inputState.guessing;
                try {
                    this.xyRef();
                    this.match(104);
                }
                catch (RecognitionException pe) {
                    synPredMatched222 = false;
                }
                this.rewind(_m222);
                --this.inputState.guessing;
            }
            if (synPredMatched222) {
                ref = this.viewableRef(scope);
                this.match(104);
            } else if (this.LA(1) != 11) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            n = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                if (ref != null) {
                    scope = ref;
                }
                if ((attr = this.findAttribute(scope, n.getText())) == null) {
                    this.reportError(this.formatMessage("err_attributePathConst_unknownAttr", n.getText(), scope.toString()), n.getLine());
                }
                c = new Constant.AttributePath(attr);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_57);
            }
            throw ex;
        }
        return c;
    }

    protected final Enumeration enumeration(Type extending) throws RecognitionException, TokenStreamException {
        LinkedList<Enumeration.Element> elements = new LinkedList<Enumeration.Element>();
        boolean isFinal = false;
        Enumeration enumer = null;
        try {
            this.match(12);
            if (this.LA(1) == 11) {
                Enumeration.Element curElement = this.enumElement(extending);
                if (this.inputState.guessing == 0) {
                    elements.add(curElement);
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    curElement = this.enumElement(extending);
                    if (this.inputState.guessing != 0) continue;
                    for (Enumeration.Element ele : elements) {
                        if (!ele.getName().equals(curElement.getName())) continue;
                        this.reportError(this.formatMessage("err_enumerationType_DupEle", curElement.getName()), curElement.getSourceLine());
                        break;
                    }
                    elements.add(curElement);
                }
                if (this.LA(1) == 47) {
                    this.match(47);
                    this.match(80);
                    if (this.inputState.guessing == 0) {
                        isFinal = true;
                    }
                } else if (this.LA(1) != 13) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else if (this.LA(1) == 80) {
                this.match(80);
                if (this.inputState.guessing == 0) {
                    isFinal = true;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                enumer = new Enumeration(elements);
                enumer.setFinal(isFinal);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_60);
            }
            throw ex;
        }
        return enumer;
    }

    protected final Enumeration.Element enumElement(Type extending) throws RecognitionException, TokenStreamException {
        Enumeration subEnum = null;
        Object curEnum = null;
        Enumeration.Element ee = null;
        int lineNumber = 0;
        LinkedList elt = new LinkedList();
        int siz = 0;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            lineNumber = this.enumNameList(elt);
            if (this.LA(1) == 12) {
                subEnum = this.enumeration(extending);
            } else if (this.LA(1) != 13 && this.LA(1) != 28 && this.LA(1) != 47) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                siz = elt.size();
                for (int i = siz - 1; i >= 0; --i) {
                    if (i == siz - 1) {
                        if (subEnum == null) {
                            ee = new Enumeration.Element((String)elt.get(i));
                            ee.setDocumentation(ilidoc);
                            ee.setMetaValues(metaValues);
                            ee.setSourceLine(lineNumber);
                            continue;
                        }
                        ee = new Enumeration.Element((String)elt.get(i), subEnum);
                        ee.setDocumentation(ilidoc);
                        ee.setMetaValues(metaValues);
                        ee.setSourceLine(lineNumber);
                        continue;
                    }
                    ArrayList<Enumeration.Element> subEe = new ArrayList<Enumeration.Element>();
                    subEe.add(ee);
                    ee = new Enumeration.Element((String)elt.get(i), new Enumeration(subEe));
                    ee.setSourceLine(lineNumber);
                }
                if (subEnum == null && siz > 1) {
                    this.reportError(this.rsrc.getString("err_dottedEnum"), lineNumber);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_61);
            }
            throw ex;
        }
        return ee;
    }

    protected final int enumNameList(List namList) throws RecognitionException, TokenStreamException {
        Token firstName = null;
        int lin = 0;
        try {
            firstName = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                namList.add(firstName.getText());
                lin = firstName.getLine();
            }
            this.enumNameListHelper(namList);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_62);
            }
            throw ex;
        }
        return lin;
    }

    protected final Unit unitRef(Container scope) throws RecognitionException, TokenStreamException {
        Unit u;
        block19: {
            LinkedList nams = new LinkedList();
            u = null;
            int lin = 0;
            try {
                String unitName;
                Topic topic;
                Model model;
                lin = this.names2(nams);
                if (this.inputState.guessing != 0) break block19;
                switch (nams.size()) {
                    case 1: {
                        model = (Model)scope.getContainerOrSame(Model.class);
                        topic = (Topic)scope.getContainerOrSame(Topic.class);
                        unitName = (String)nams.get(0);
                        break;
                    }
                    case 2: {
                        String modelName = (String)nams.get(0);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topic = null;
                        unitName = (String)nams.get(1);
                        break;
                    }
                    case 3: {
                        String modelName = (String)nams.get(0);
                        String topicName = (String)nams.get(1);
                        unitName = (String)nams.get(2);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topic = this.resolveOrFixTopicName(model, topicName, lin);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdUnitRef"), lin);
                        model = this.resolveModelName(scope, (String)nams.get(0));
                        if (model == null) {
                            model = (Model)scope.getContainerOrSame(Model.class);
                        }
                        topic = null;
                        unitName = (String)nams.get(nams.size() - 1);
                    }
                }
                u = null;
                if (topic != null) {
                    u = (Unit)topic.getRealElement(Unit.class, unitName);
                }
                if (u == null) {
                    u = (Unit)model.getRealElement(Unit.class, unitName);
                }
                if (u == null && nams.size() == 1) {
                    u = (Unit)model.getImportedElement(Unit.class, unitName);
                }
                if (u == null) {
                    Iterator it = topic != null ? topic.iterator() : model.iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof Unit) || !unitName.equals(((Unit)o).getDocName())) continue;
                        u = (Unit)o;
                        this.reportError(this.formatMessage("err_unitRefByDocName", unitName, model.toString(), u.getScopedName(scope)), lin);
                        break;
                    }
                }
                if (u != null) break block19;
                if (topic != null) {
                    this.reportError(this.formatMessage("err_noSuchUnitInModelOrTopic", unitName, topic.toString(), model.toString()), lin);
                } else {
                    this.reportError(this.formatMessage("err_noSuchUnit", unitName, model.toString()), lin);
                }
                try {
                    u = new BaseUnit();
                    u.setName(unitName);
                    if (topic != null) {
                        topic.add(u);
                        break block19;
                    }
                    model.add(u);
                }
                catch (Exception ex) {
                    Ili24Parser.panic();
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_63);
                }
                throw ex;
            }
        }
        return u;
    }

    protected final RefSystemRef refSys(Container scope, boolean isCoord) throws RecognitionException, TokenStreamException {
        RefSystemRef rsr;
        block30: {
            Token lpar = null;
            Token slash1 = null;
            Token less = null;
            Token slash2 = null;
            rsr = null;
            MetaObject system = null;
            Domain domain = null;
            int axisNumber = 0;
            try {
                if (this.LA(1) == 66) {
                    lpar = this.LT(1);
                    this.match(66);
                    if (_tokenSet_7.member(this.LA(1)) && isCoord) {
                        system = this.metaObjectRef(scope, this.predefinedCoordSystemClass);
                        slash1 = this.LT(1);
                        this.match(21);
                        axisNumber = this.posInteger();
                        this.match(22);
                        if (this.inputState.guessing == 0) {
                            try {
                                if (system != null) {
                                    rsr = new RefSystemRef.CoordSystemAxis(system, axisNumber);
                                }
                            }
                            catch (Exception ex) {
                                this.reportError(ex, slash1.getLine());
                            }
                        }
                    } else if (_tokenSet_7.member(this.LA(1)) && !isCoord) {
                        system = this.metaObjectRef(scope, this.predefinedScalSystemClass);
                        if (this.inputState.guessing == 0) {
                            try {
                                if (system != null) {
                                    rsr = new RefSystemRef.CoordSystem(system);
                                }
                            }
                            catch (Exception ex) {
                                this.reportError(ex, lpar.getLine());
                            }
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(69);
                    break block30;
                }
                if (this.LA(1) == 89) {
                    less = this.LT(1);
                    this.match(89);
                    domain = this.domainRef(scope);
                    if (this.LA(1) == 21) {
                        slash2 = this.LT(1);
                        this.match(21);
                        axisNumber = this.posInteger();
                        this.match(22);
                        if (this.inputState.guessing == 0) {
                            try {
                                if (domain != null) {
                                    rsr = new RefSystemRef.CoordDomainAxis(domain, axisNumber);
                                }
                            }
                            catch (Exception ex) {
                                this.reportError(ex, slash2.getLine());
                            }
                        }
                    } else if (this.LA(1) == 90) {
                        if (this.inputState.guessing == 0) {
                            try {
                                if (domain != null) {
                                    rsr = new RefSystemRef.CoordDomain(domain);
                                }
                            }
                            catch (Exception ex) {
                                this.reportError(ex, less.getLine());
                            }
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(90);
                    break block30;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_52);
                }
                throw ex;
            }
        }
        return rsr;
    }

    protected final MetaObject metaObjectRef(Container scope, Table polymorphicTo) throws RecognitionException, TokenStreamException {
        MetaObject referred = null;
        int lin = 0;
        LinkedList nams = new LinkedList();
        try {
            lin = this.names2(nams);
            if (this.inputState.guessing == 0) {
                switch (nams.size()) {
                    case 1: {
                        MetaDataUseDef ref = null;
                        Model model = (Model)scope.getContainerOrSame(Model.class);
                        Topic topic = (Topic)scope.getContainerOrSame(Topic.class);
                        Object basket = null;
                        if (topic != null) {
                            for (Object ele : topic) {
                                if (!(ele instanceof MetaDataUseDef)) continue;
                                if (ref == null) {
                                    ref = (MetaDataUseDef)ele;
                                    continue;
                                }
                                this.reportError(this.rsrc.getString("err_metaObject_scopeRequired"), lin);
                            }
                        }
                        for (Object ele : model) {
                            if (!(ele instanceof MetaDataUseDef)) continue;
                            if (ref == null) {
                                ref = (MetaDataUseDef)ele;
                                continue;
                            }
                            this.reportError(this.rsrc.getString("err_metaObject_scopeRequired"), lin);
                        }
                        if (ref == null) {
                            this.reportError(this.rsrc.getString("err_noMetaDataUseDef"), lin);
                        }
                        String objectName = (String)nams.get(0);
                        referred = this.resolveMetaObject(ref, polymorphicTo, objectName, lin);
                        break;
                    }
                    case 2: {
                        String basketName = (String)nams.get(0);
                        MetaDataUseDef ref = this.resolveOrFixBasketName(scope, basketName, lin);
                        String objectName = (String)nams.get(1);
                        referred = this.resolveMetaObject(ref, polymorphicTo, objectName, lin);
                        break;
                    }
                    case 3: {
                        String modelName = (String)nams.get(0);
                        String basketName = (String)nams.get(1);
                        String objectName = (String)nams.get(2);
                        Model model = this.resolveOrFixModelName(scope, modelName, lin);
                        MetaDataUseDef ref = this.resolveOrFixBasketName(model, basketName, lin);
                        referred = this.resolveMetaObject(ref, polymorphicTo, objectName, lin);
                        break;
                    }
                    case 4: {
                        String modelName = (String)nams.get(0);
                        String topicName = (String)nams.get(1);
                        String basketName = (String)nams.get(2);
                        String objectName = (String)nams.get(3);
                        Model model = this.resolveOrFixModelName(scope, modelName, lin);
                        Topic topic = this.resolveOrFixTopicName(model, topicName, lin);
                        MetaDataUseDef ref = this.resolveOrFixBasketName(topic, basketName, lin);
                        referred = this.resolveMetaObject(ref, polymorphicTo, objectName, lin);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdMetaObjectRef"), lin);
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_64);
            }
            throw ex;
        }
        return referred;
    }

    protected final PrecisionDecimal decConst() throws RecognitionException, TokenStreamException {
        PrecisionDecimal dec = null;
        try {
            switch (this.LA(1)) {
                case 91: {
                    this.match(91);
                    if (this.inputState.guessing == 0) {
                        dec = PrecisionDecimal.PI;
                    }
                    break;
                }
                case 92: {
                    this.match(92);
                    if (this.inputState.guessing == 0) {
                        dec = PrecisionDecimal.LNBASE;
                    }
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    dec = this.decimal();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_65);
            }
            throw ex;
        }
        return dec;
    }

    protected final FormattedTypeBaseAttrRef baseAttrRef(FormattedType ft, Table scope) throws RecognitionException, TokenStreamException {
        FormattedTypeBaseAttrRef baseAttr;
        block18: {
            Token name = null;
            Token name2 = null;
            baseAttr = null;
            Domain domain = null;
            int intPos = 0;
            try {
                boolean synPredMatched175 = false;
                if (this.LA(1) == 11) {
                    int _m175 = this.mark();
                    synPredMatched175 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(11);
                        this.match(96);
                        this.match(11);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched175 = false;
                    }
                    this.rewind(_m175);
                    --this.inputState.guessing;
                }
                if (synPredMatched175) {
                    name = this.LT(1);
                    this.match(11);
                    this.match(96);
                    domain = this.domainRef(scope);
                    if (this.inputState.guessing == 0) {
                        Type type;
                        AttributeDef attrdef = this.findAttribute(scope, name.getText());
                        if (attrdef == null) {
                            this.reportError(this.formatMessage("err_formattedType_unknownAttr", name.getText(), scope.toString()), name.getLine());
                        }
                        if (!((type = attrdef.getDomain()) instanceof CompositionType)) {
                            this.reportError(this.formatMessage("err_formattedType_StructAttrRequired", name.getText(), scope.toString()), name.getLine());
                        }
                        if (((CompositionType)type).getCardinality().getMaximum() > 1L) {
                            this.reportError(this.formatMessage("err_formattedType_maxCard1", name.getText(), scope.toString()), name.getLine());
                        }
                        baseAttr = new FormattedTypeBaseAttrRef(ft, attrdef, domain);
                    }
                    break block18;
                }
                if (this.LA(1) == 11) {
                    name2 = this.LT(1);
                    this.match(11);
                    if (this.LA(1) == 96) {
                        this.match(96);
                        intPos = this.posInteger();
                    } else if (this.LA(1) != 11 && this.LA(1) != 13 && this.LA(1) != 16) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.inputState.guessing == 0) {
                        Type type;
                        AttributeDef attrdef = this.findAttribute(scope, name2.getText());
                        if (attrdef == null) {
                            this.reportError(this.formatMessage("err_formattedType_unknownAttr", name2.getText(), scope.toString()), name2.getLine());
                        }
                        if (!((type = attrdef.getDomainResolvingAliases()) instanceof NumericType)) {
                            this.reportError(this.formatMessage("err_formattedType_NumericAttrRequired", name2.getText(), scope.toString()), name2.getLine());
                        }
                        baseAttr = new FormattedTypeBaseAttrRef(ft, attrdef, intPos);
                    }
                    break block18;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_66);
                }
                throw ex;
            }
        }
        return baseAttr;
    }

    protected final Constant formattedConst() throws RecognitionException, TokenStreamException {
        Constant c = null;
        try {
            c = this.textConst();
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
        return c;
    }

    protected final int[] rotationDef() throws RecognitionException, TokenStreamException {
        Token rot = null;
        int[] rots = null;
        try {
            rot = this.LT(1);
            this.match(103);
            int nullAxis = this.posInteger();
            this.match(104);
            int piHalfAxis = this.posInteger();
            if (this.inputState.guessing == 0) {
                if (nullAxis == 0 || piHalfAxis == 0) {
                    this.reportError(this.rsrc.getString("err_axisNumber_zero"), rot.getLine());
                } else {
                    rots = new int[]{nullAxis, piHalfAxis};
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_54);
            }
            throw ex;
        }
        return rots;
    }

    protected final void contextDef(Container container) throws RecognitionException, TokenStreamException {
        Token eq = null;
        String ilidoc = null;
        Settings metaValues = null;
        try {
            if (this.inputState.guessing == 0) {
                ilidoc = this.getIliDoc();
                metaValues = this.getMetaValues();
            }
            this.domainRef(container);
            eq = this.LT(1);
            this.match(23);
            this.domainRef(container);
            while (this.LA(1) == 65) {
                this.match(65);
                this.domainRef(container);
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_67);
            }
            throw ex;
        }
    }

    protected final ObjectPath attributePath(Viewable ns) throws RecognitionException, TokenStreamException {
        ObjectPath object = null;
        try {
            object = this.objectOrAttributePath(ns);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_68);
            }
            throw ex;
        }
        return object;
    }

    protected final void xyRef() throws RecognitionException, TokenStreamException {
        try {
            if (this.LA(1) == 11) {
                this.match(11);
            } else if (this.LA(1) == 4) {
                this.match(4);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            while (this.LA(1) == 29) {
                this.match(29);
                this.match(11);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            throw ex;
        }
    }

    protected final LineForm[] lineForm(Container scope) throws RecognitionException, TokenStreamException {
        LinkedList<LineForm> ll = null;
        LineForm linForm = null;
        LineForm[] lf = new LineForm[]{};
        try {
            this.match(124);
            this.match(12);
            if (this.inputState.guessing == 0) {
                ll = new LinkedList<LineForm>();
            }
            linForm = this.lineFormType(scope);
            if (this.inputState.guessing == 0 && linForm != null) {
                ll.add(linForm);
            }
            while (this.LA(1) == 28) {
                this.match(28);
                linForm = this.lineFormType(scope);
                if (this.inputState.guessing != 0 || linForm == null) continue;
                ll.add(linForm);
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                lf = ll.toArray(lf);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_47);
            }
            throw ex;
        }
        return lf;
    }

    protected final LineForm lineFormType(Container scope) throws RecognitionException, TokenStreamException {
        Token nam = null;
        LineForm lf = null;
        try {
            switch (this.LA(1)) {
                case 125: {
                    this.match(125);
                    if (this.inputState.guessing == 0) {
                        lf = this.modelInterlis.ARCS;
                    }
                    break;
                }
                case 126: {
                    this.match(126);
                    if (this.inputState.guessing == 0) {
                        lf = this.modelInterlis.STRAIGHTS;
                    }
                    break;
                }
                case 11: {
                    nam = this.LT(1);
                    this.match(11);
                    if (this.inputState.guessing == 0) {
                        Model scopeModel = (Model)scope.getContainerOrSame(Model.class);
                        lf = (LineForm)scopeModel.getRealElement(LineForm.class, nam.getText());
                        if (lf == null) {
                            lf = (LineForm)this.modelInterlis.getRealElement(LineForm.class, nam.getText());
                        }
                        if (lf == null) {
                            this.reportError(this.formatMessage("err_lineForm_unknownName", nam.getText(), scopeModel.toString()), nam.getLine());
                        }
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_69);
            }
            throw ex;
        }
        return lf;
    }

    protected final void unitDef(Container scope) throws RecognitionException, TokenStreamException {
        block30: {
            Token n = null;
            Token idn = null;
            Token ext = null;
            boolean mods = false;
            Unit extending = null;
            Unit u = null;
            boolean _abstract = false;
            String docName = null;
            String idName = null;
            String ilidoc = null;
            Settings metaValues = null;
            try {
                if (this.inputState.guessing == 0) {
                    ilidoc = this.getIliDoc();
                    metaValues = this.getMetaValues();
                }
                n = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    docName = idName = n.getText();
                }
                switch (this.LA(1)) {
                    case 21: {
                        this.match(21);
                        idn = this.LT(1);
                        this.match(11);
                        this.match(22);
                        if (this.inputState.guessing != 0) break;
                        idName = idn.getText();
                        break;
                    }
                    case 12: {
                        this.match(12);
                        this.match(129);
                        this.match(13);
                        if (this.inputState.guessing != 0) break;
                        _abstract = true;
                        break;
                    }
                    case 5: 
                    case 23: 
                    case 32: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (this.LA(1) == 32) {
                    ext = this.LT(1);
                    this.match(32);
                    extending = this.unitRef(scope);
                } else if (this.LA(1) != 5 && this.LA(1) != 23) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 23) {
                    this.match(23);
                    if (_tokenSet_70.member(this.LA(1))) {
                        u = this.derivedUnit(scope, idName, docName, _abstract);
                        if (this.inputState.guessing == 0 && extending != null) {
                            this.reportError(this.rsrc.getString("err_derivedUnit_ext"), ext.getLine());
                        }
                    } else if (this.LA(1) == 12) {
                        u = this.composedUnit(scope, idName, docName, _abstract);
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(5);
                } else if (this.LA(1) == 5) {
                    this.match(5);
                    if (this.inputState.guessing == 0) {
                        u = new BaseUnit();
                        try {
                            u.setName(idName);
                            u.setDocName(docName);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, n.getLine());
                        }
                        try {
                            u.setAbstract(_abstract);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, n.getLine());
                        }
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing != 0) break block30;
                try {
                    u.setDocumentation(ilidoc);
                    u.setMetaValues(metaValues);
                    scope.add(u);
                    if (extending != null) {
                        u.setExtending(extending);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_45);
                }
                throw ex;
            }
        }
    }

    protected final Unit derivedUnit(Container scope, String idName, String docName, boolean _abstract) throws RecognitionException, TokenStreamException {
        Token f = null;
        Token exp = null;
        Token st = null;
        Token sl = null;
        DerivedUnit u = null;
        Unit baseUnit = null;
        LinkedList<NumericallyDerivedUnit.Factor> factors = null;
        int line = 0;
        char compOp = '*';
        PrecisionDecimal fac = new PrecisionDecimal("1");
        try {
            switch (this.LA(1)) {
                case 130: {
                    f = this.LT(1);
                    this.match(130);
                    exp = this.LT(1);
                    this.match(18);
                    this.match(21);
                    baseUnit = this.unitRef(scope);
                    this.match(22);
                    if (this.inputState.guessing != 0) break;
                    u = new FunctionallyDerivedUnit();
                    try {
                        u.setName(idName);
                        u.setDocName(docName);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, f.getLine());
                    }
                    try {
                        ((FunctionallyDerivedUnit)u).setExplanation(exp.getText());
                    }
                    catch (Exception ex) {
                        this.reportError(ex, exp.getLine());
                    }
                    try {
                        ((Unit)u).setAbstract(_abstract);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, f.getLine());
                    }
                    try {
                        ((FunctionallyDerivedUnit)u).setExtending(baseUnit);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, f.getLine());
                    }
                    break;
                }
                case 91: 
                case 92: 
                case 182: 
                case 183: 
                case 184: {
                    fac = this.decConst();
                    if (this.inputState.guessing == 0) {
                        u = new NumericallyDerivedUnit();
                        factors = new LinkedList<NumericallyDerivedUnit.Factor>();
                        try {
                            factors.add(new NumericallyDerivedUnit.Factor('*', fac));
                        }
                        catch (Exception ex) {
                            this.reportError(ex, line);
                        }
                    }
                    while (this.LA(1) == 67 || this.LA(1) == 96) {
                        if (this.LA(1) == 67) {
                            st = this.LT(1);
                            this.match(67);
                            if (this.inputState.guessing == 0) {
                                compOp = '*';
                                line = st.getLine();
                            }
                        } else if (this.LA(1) == 96) {
                            sl = this.LT(1);
                            this.match(96);
                            if (this.inputState.guessing == 0) {
                                compOp = '/';
                                line = sl.getLine();
                            }
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        fac = this.decConst();
                        if (this.inputState.guessing != 0) continue;
                        try {
                            factors.add(new NumericallyDerivedUnit.Factor(compOp, fac));
                        }
                        catch (Exception ex) {
                            this.reportError(ex, line);
                        }
                    }
                    this.match(21);
                    baseUnit = this.unitRef(scope);
                    this.match(22);
                    if (this.inputState.guessing != 0) break;
                    DerivedUnit ndu = u;
                    try {
                        u.setName(idName);
                        u.setDocName(docName);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ((Unit)u).setAbstract(_abstract);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ndu.setExtending(baseUnit);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ((NumericallyDerivedUnit)ndu).setConversionFactors(factors.toArray(new NumericallyDerivedUnit.Factor[factors.size()]));
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    break;
                }
                case 21: {
                    this.match(21);
                    baseUnit = this.unitRef(scope);
                    this.match(22);
                    if (this.inputState.guessing != 0) break;
                    u = new NumericallyDerivedUnit();
                    NumericallyDerivedUnit ndu = u;
                    try {
                        u.setName(idName);
                        u.setDocName(docName);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ((Unit)u).setAbstract(_abstract);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ndu.setExtending(baseUnit);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    try {
                        ndu.setConversionFactors(new NumericallyDerivedUnit.Factor[]{new NumericallyDerivedUnit.Factor('*', new PrecisionDecimal("1"))});
                    }
                    catch (Exception ex) {
                        this.reportError(ex, line);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_71);
            }
            throw ex;
        }
        return u;
    }

    protected final ComposedUnit composedUnit(Container scope, String idName, String docName, boolean _abstract) throws RecognitionException, TokenStreamException {
        Token lbrac = null;
        Token st = null;
        Token sl = null;
        ComposedUnit u = null;
        LinkedList<ComposedUnit.Composed> composed = null;
        int line = 0;
        char compOp = '*';
        Unit compUnit = null;
        try {
            lbrac = this.LT(1);
            this.match(12);
            compUnit = this.unitRef(scope);
            if (this.inputState.guessing == 0) {
                u = new ComposedUnit();
                composed = new LinkedList<ComposedUnit.Composed>();
                try {
                    composed.add(new ComposedUnit.Composed('*', compUnit));
                    u.setName(idName);
                    u.setDocName(docName);
                }
                catch (Exception ex) {
                    this.reportError(ex, lbrac.getLine());
                }
                try {
                    u.setAbstract(_abstract);
                }
                catch (Exception ex) {
                    this.reportError(ex, lbrac.getLine());
                }
            }
            while (this.LA(1) == 67 || this.LA(1) == 96) {
                if (this.LA(1) == 67) {
                    st = this.LT(1);
                    this.match(67);
                    if (this.inputState.guessing == 0) {
                        compOp = '*';
                        line = st.getLine();
                    }
                } else if (this.LA(1) == 96) {
                    sl = this.LT(1);
                    this.match(96);
                    if (this.inputState.guessing == 0) {
                        compOp = '/';
                        line = sl.getLine();
                    }
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                compUnit = this.unitRef(scope);
                if (this.inputState.guessing != 0) continue;
                try {
                    composed.add(new ComposedUnit.Composed(compOp, compUnit));
                }
                catch (Exception ex) {
                    this.reportError(ex, line);
                }
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                try {
                    u.setComposedUnits(composed.toArray(new ComposedUnit.Composed[composed.size()]));
                }
                catch (Exception ex) {
                    this.reportError(ex, lbrac.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_71);
            }
            throw ex;
        }
        return u;
    }

    protected final MetaDataUseDef metaDataBasketRef(Container scope) throws RecognitionException, TokenStreamException {
        MetaDataUseDef ref;
        block17: {
            ref = null;
            int lin = 0;
            LinkedList nams = new LinkedList();
            try {
                String basketName;
                Topic topic;
                Model model;
                lin = this.names2(nams);
                if (this.inputState.guessing != 0) break block17;
                switch (nams.size()) {
                    case 1: {
                        model = (Model)scope.getContainerOrSame(Model.class);
                        topic = (Topic)scope.getContainerOrSame(Topic.class);
                        basketName = (String)nams.get(0);
                        break;
                    }
                    case 2: {
                        String modelName = (String)nams.get(0);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topic = null;
                        basketName = (String)nams.get(1);
                        break;
                    }
                    case 3: {
                        String modelName = (String)nams.get(0);
                        String topicName = (String)nams.get(1);
                        basketName = (String)nams.get(2);
                        model = this.resolveOrFixModelName(scope, modelName, lin);
                        topic = this.resolveOrFixTopicName(model, topicName, lin);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdMetaDataUseRef"), lin);
                        model = this.resolveModelName(scope, (String)nams.get(0));
                        if (model == null) {
                            model = (Model)scope.getContainerOrSame(Model.class);
                        }
                        topic = null;
                        basketName = (String)nams.get(nams.size() - 1);
                    }
                }
                ref = null;
                if (topic != null) {
                    ref = (MetaDataUseDef)topic.getRealElement(MetaDataUseDef.class, basketName);
                }
                if (ref == null) {
                    ref = (MetaDataUseDef)model.getRealElement(MetaDataUseDef.class, basketName);
                }
                if (ref == null && nams.size() == 1) {
                    ref = (MetaDataUseDef)model.getImportedElement(MetaDataUseDef.class, basketName);
                }
                if (ref != null) break block17;
                if (topic != null) {
                    this.reportError(this.formatMessage("err_noSuchMetaDataUseDefInModelOrTopic", basketName, topic.toString(), model.toString()), lin);
                } else {
                    this.reportError(this.formatMessage("err_noSuchMetaDataUseDef", basketName, model.toString()), lin);
                }
                try {
                    ref = new MetaDataUseDef();
                    ref.setName(basketName);
                    if (topic != null) {
                        topic.add(ref);
                        break block17;
                    }
                    model.add(ref);
                }
                catch (Exception ex) {
                    Ili24Parser.panic();
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_72);
                }
                throw ex;
            }
        }
        return ref;
    }

    protected final MandatoryConstraint mandatoryConstraint(Viewable v) throws RecognitionException, TokenStreamException {
        Token mand = null;
        Evaluable condition = null;
        MandatoryConstraint constr = null;
        try {
            mand = this.LT(1);
            this.match(49);
            this.match(135);
            boolean synPredMatched277 = false;
            if (this.LA(1) == 11) {
                int _m277 = this.mark();
                synPredMatched277 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(47);
                }
                catch (RecognitionException pe) {
                    synPredMatched277 = false;
                }
                this.rewind(_m277);
                --this.inputState.guessing;
            }
            if (synPredMatched277) {
                this.match(11);
                this.match(47);
            } else if (!_tokenSet_73.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            condition = this.expression(v, this.predefinedBooleanType, v);
            this.match(5);
            if (this.inputState.guessing == 0) {
                try {
                    constr = new MandatoryConstraint();
                    constr.setCondition(condition);
                }
                catch (Exception ex) {
                    this.reportError(ex, mand.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final PlausibilityConstraint plausibilityConstraint(Viewable v) throws RecognitionException, TokenStreamException {
        Token tok = null;
        int direction = 0;
        Evaluable condition = null;
        PlausibilityConstraint constr = null;
        try {
            tok = this.LT(1);
            this.match(135);
            boolean synPredMatched281 = false;
            if (this.LA(1) == 11) {
                int _m281 = this.mark();
                synPredMatched281 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(47);
                }
                catch (RecognitionException pe) {
                    synPredMatched281 = false;
                }
                this.rewind(_m281);
                --this.inputState.guessing;
            }
            if (synPredMatched281) {
                this.match(11);
                this.match(47);
            } else if (this.LA(1) != 136 && this.LA(1) != 137) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 136) {
                this.match(136);
                if (this.inputState.guessing == 0) {
                    direction = 1;
                }
            } else if (this.LA(1) == 137) {
                this.match(137);
                if (this.inputState.guessing == 0) {
                    direction = 0;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            PrecisionDecimal percentage = this.decimal();
            this.match(138);
            condition = this.expression(v, this.predefinedBooleanType, v);
            this.match(5);
            if (this.inputState.guessing == 0) {
                try {
                    constr = new PlausibilityConstraint();
                    constr.setDirection(direction);
                    constr.setCondition(condition);
                    constr.setPercentage(percentage.doubleValue());
                }
                catch (Exception ex) {
                    this.reportError(ex, tok.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final ExistenceConstraint existenceConstraint(Viewable v) throws RecognitionException, TokenStreamException {
        ExistenceConstraint constr = new ExistenceConstraint();
        ObjectPath attrRef = null;
        try {
            this.match(139);
            this.match(135);
            boolean synPredMatched286 = false;
            if (this.LA(1) == 11) {
                int _m286 = this.mark();
                synPredMatched286 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(47);
                }
                catch (RecognitionException pe) {
                    synPredMatched286 = false;
                }
                this.rewind(_m286);
                --this.inputState.guessing;
            }
            if (synPredMatched286) {
                this.match(11);
                this.match(47);
            } else if (!_tokenSet_33.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ObjectPath attr = this.attributePath(v);
            if (this.inputState.guessing == 0) {
                constr.setRestrictedAttribute(attr);
            }
            this.match(140);
            this.match(141);
            Viewable ref = this.viewableRefDepReq(v);
            this.match(47);
            attrRef = this.attributePath(ref);
            if (this.inputState.guessing == 0) {
                constr.addRequiredIn(attrRef);
            }
            while (this.LA(1) == 65) {
                this.match(65);
                ref = this.viewableRefDepReq(v);
                this.match(47);
                attrRef = this.attributePath(ref);
                if (this.inputState.guessing != 0) continue;
                constr.addRequiredIn(attrRef);
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final UniquenessConstraint uniquenessConstraint(Viewable v) throws RecognitionException, TokenStreamException {
        Evaluable preCond = null;
        UniquenessConstraint constr = new UniquenessConstraint();
        try {
            this.match(142);
            boolean synPredMatched292 = false;
            if (this.LA(1) == 12) {
                int _m292 = this.mark();
                synPredMatched292 = true;
                ++this.inputState.guessing;
                try {
                    this.match(12);
                    this.match(33);
                }
                catch (RecognitionException pe) {
                    synPredMatched292 = false;
                }
                this.rewind(_m292);
                --this.inputState.guessing;
            }
            if (synPredMatched292) {
                this.match(12);
                this.match(33);
                this.match(13);
            } else if (!_tokenSet_74.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            boolean synPredMatched295 = false;
            if (this.LA(1) == 11) {
                int _m295 = this.mark();
                synPredMatched295 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(47);
                }
                catch (RecognitionException pe) {
                    synPredMatched295 = false;
                }
                this.rewind(_m295);
                --this.inputState.guessing;
            }
            if (synPredMatched295) {
                this.match(11);
                this.match(47);
            } else if (!_tokenSet_74.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 143) {
                this.match(143);
                preCond = this.expression(v, this.predefinedBooleanType, v);
                this.match(47);
                if (this.inputState.guessing == 0) {
                    constr.setPreCondition(preCond);
                }
            } else if (!_tokenSet_75.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (_tokenSet_33.member(this.LA(1))) {
                constr = this.globalUniqueness(v);
            } else if (this.LA(1) == 12) {
                constr = this.localUniqueness(v);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final SetConstraint setConstraint(Viewable v) throws RecognitionException, TokenStreamException {
        Token tok = null;
        Evaluable preCond = null;
        Evaluable condition = null;
        SetConstraint constr = new SetConstraint();
        try {
            tok = this.LT(1);
            this.match(145);
            this.match(135);
            boolean synPredMatched310 = false;
            if (this.LA(1) == 12) {
                int _m310 = this.mark();
                synPredMatched310 = true;
                ++this.inputState.guessing;
                try {
                    this.match(12);
                    this.match(33);
                }
                catch (RecognitionException pe) {
                    synPredMatched310 = false;
                }
                this.rewind(_m310);
                --this.inputState.guessing;
            }
            if (synPredMatched310) {
                this.match(12);
                this.match(33);
                this.match(13);
            } else if (!_tokenSet_76.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            boolean synPredMatched313 = false;
            if (this.LA(1) == 11) {
                int _m313 = this.mark();
                synPredMatched313 = true;
                ++this.inputState.guessing;
                try {
                    this.match(11);
                    this.match(47);
                }
                catch (RecognitionException pe) {
                    synPredMatched313 = false;
                }
                this.rewind(_m313);
                --this.inputState.guessing;
            }
            if (synPredMatched313) {
                this.match(11);
                this.match(47);
            } else if (!_tokenSet_76.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 143) {
                this.match(143);
                preCond = this.expression(v, this.predefinedBooleanType, v);
                this.match(47);
                if (this.inputState.guessing == 0) {
                    constr.setPreCondition(preCond);
                }
            } else if (!_tokenSet_73.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            condition = this.expression(v, this.predefinedBooleanType, v);
            this.match(5);
            if (this.inputState.guessing == 0) {
                try {
                    constr.setCondition(condition);
                }
                catch (Exception ex) {
                    this.reportError(ex, tok.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_26);
            }
            throw ex;
        }
        return constr;
    }

    protected final Viewable viewableRefDepReq(Container scope) throws RecognitionException, TokenStreamException {
        Viewable ref = null;
        int refLine = 0;
        try {
            if (this.inputState.guessing == 0) {
                refLine = this.LT(1).getLine();
            }
            ref = this.viewableRef(scope);
            if (this.inputState.guessing == 0 && ref != null) {
                AbstractPatternDef scopeTopic = (AbstractPatternDef)scope.getContainerOrSame(AbstractPatternDef.class);
                AbstractPatternDef refTopic = (AbstractPatternDef)ref.getContainer(AbstractPatternDef.class);
                if (refTopic != scopeTopic && !scopeTopic.isDependentOn(refTopic)) {
                    this.reportError(this.formatMessage("err_viewableref_topicdepreq", scopeTopic.getName(), refTopic.getName()), refLine);
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_77);
            }
            throw ex;
        }
        return ref;
    }

    protected final UniquenessConstraint globalUniqueness(Viewable scope) throws RecognitionException, TokenStreamException {
        UniquenessConstraint constr = new UniquenessConstraint();
        UniqueEl elements = null;
        try {
            elements = this.uniqueEl(scope);
            if (this.inputState.guessing == 0) {
                constr.setElements(elements);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_71);
            }
            throw ex;
        }
        return constr;
    }

    protected final UniquenessConstraint localUniqueness(Viewable start) throws RecognitionException, TokenStreamException {
        Token n = null;
        Token n2 = null;
        Token n3 = null;
        Token n4 = null;
        UniquenessConstraint constr = new UniquenessConstraint();
        constr.setLocal(true);
        UniqueEl elements = new UniqueEl();
        constr.setElements(elements);
        ObjectPath prefix = null;
        LinkedList<AttributeRef> path = new LinkedList<AttributeRef>();
        Viewable<?> next = null;
        Viewable<?> localViewable = null;
        try {
            PathEl[] attrRef;
            AttributeRef el;
            AttributeDef attrdef;
            this.match(12);
            this.match(144);
            this.match(13);
            n = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                next = start;
                attrdef = this.findAttribute(start, n.getText());
                if (attrdef == null) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownAttr", n.getText(), next.toString()), n.getLine());
                }
                if (!(attrdef.getDomainResolvingAliases() instanceof CompositionType)) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownStructAttr", n.getText(), next.toString()), n.getLine());
                }
                el = new AttributeRef(attrdef);
                path.add(el);
                next = ((PathEl)el).getViewable();
            }
            while (this.LA(1) == 104) {
                this.match(104);
                n2 = this.LT(1);
                this.match(11);
                if (this.inputState.guessing != 0) continue;
                attrdef = this.findAttribute(next, n2.getText());
                if (attrdef == null) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownAttr", n2.getText(), next.toString()), n2.getLine());
                }
                if (!(attrdef.getDomainResolvingAliases() instanceof CompositionType)) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownStructAttr", n2.getText(), next.toString()), n2.getLine());
                }
                el = new AttributeRef(attrdef);
                path.add(el);
                next = ((PathEl)el).getViewable();
            }
            if (this.inputState.guessing == 0) {
                prefix = new ObjectPath(start, path.toArray(new PathEl[path.size()]));
                constr.setPrefix(prefix);
            }
            this.match(47);
            n3 = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                localViewable = next;
                attrdef = this.findAttribute(localViewable, n3.getText());
                if (attrdef == null) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownAttr", n3.getText(), localViewable.toString()), n3.getLine());
                }
                attrRef = new AttributeRef[]{new AttributeRef(attrdef)};
                elements.addAttribute(new ObjectPath(localViewable, attrRef));
            }
            while (this.LA(1) == 28) {
                this.match(28);
                n4 = this.LT(1);
                this.match(11);
                if (this.inputState.guessing != 0) continue;
                attrdef = this.findAttribute(localViewable, n4.getText());
                if (attrdef == null) {
                    this.reportError(this.formatMessage("err_localUniqueness_unknownAttr", n4.getText(), localViewable.toString()), n4.getLine());
                }
                attrRef = new AttributeRef[]{new AttributeRef(attrdef)};
                elements.addAttribute(new ObjectPath(localViewable, attrRef));
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_71);
            }
            throw ex;
        }
        return constr;
    }

    protected final UniqueEl uniqueEl(Viewable scope) throws RecognitionException, TokenStreamException {
        UniqueEl ret = null;
        ObjectPath attr = null;
        try {
            attr = this.objectOrAttributePath(scope);
            if (this.inputState.guessing == 0) {
                ret = new UniqueEl();
                ret.addAttribute(attr);
            }
            while (this.LA(1) == 28) {
                this.match(28);
                attr = this.objectOrAttributePath(scope);
                if (this.inputState.guessing != 0) continue;
                ret.addAttribute(attr);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_78);
            }
            throw ex;
        }
        return ret;
    }

    protected final ObjectPath objectOrAttributePath(Viewable start) throws RecognitionException, TokenStreamException {
        Token p = null;
        ObjectPath object = null;
        LinkedList<PathEl> path = new LinkedList<PathEl>();
        Viewable<?> next = null;
        try {
            PathEl el = this.pathEl(start);
            if (this.inputState.guessing == 0) {
                path.add(el);
                next = start;
            }
            while (this.LA(1) == 104) {
                p = this.LT(1);
                this.match(104);
                if (this.inputState.guessing == 0) {
                    Viewable<?> prenext = next;
                    next = el.getViewable();
                }
                el = this.pathEl(next);
                if (this.inputState.guessing != 0) continue;
                path.add(el);
            }
            if (this.inputState.guessing == 0) {
                object = new ObjectPath(start, path.toArray(new PathEl[path.size()]));
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_79);
            }
            throw ex;
        }
        return object;
    }

    protected final Evaluable term(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Evaluable expr = null;
        boolean lineNumber = false;
        try {
            expr = this.term0(ns, expectedType, functionNs);
            if (this.LA(1) == 146) {
                this.match(146);
                expr = this.term0(ns, expectedType, functionNs);
            } else if (!_tokenSet_46.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_46);
            }
            throw ex;
        }
        return expr;
    }

    protected final Evaluable term0(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Token o = null;
        LinkedList<Evaluable> disjoined = null;
        Evaluable expr = null;
        int lineNumber = 0;
        try {
            expr = this.term1(ns, expectedType, functionNs);
            if (this.inputState.guessing == 0) {
                disjoined = new LinkedList<Evaluable>();
                disjoined.add(expr);
            }
            while (this.LA(1) == 65) {
                o = this.LT(1);
                this.match(65);
                expr = this.term1(ns, expectedType, functionNs);
                if (this.inputState.guessing != 0) continue;
                disjoined.add(expr);
                lineNumber = o.getLine();
            }
            if (this.inputState.guessing == 0) {
                if (disjoined.size() == 1) {
                    expr = (Evaluable)disjoined.get(0);
                } else {
                    try {
                        expr = new Expression.Disjunction(disjoined.toArray(new Evaluable[disjoined.size()]));
                    }
                    catch (Exception ex) {
                        this.reportError(ex, lineNumber);
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_80);
            }
            throw ex;
        }
        return expr;
    }

    protected final Evaluable term1(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Token an = null;
        LinkedList<Evaluable> conjoined = null;
        Evaluable expr = null;
        int lineNumber = 0;
        try {
            expr = this.term2(ns, expectedType, functionNs);
            if (this.inputState.guessing == 0) {
                conjoined = new LinkedList<Evaluable>();
                conjoined.add(expr);
            }
            while (this.LA(1) == 147) {
                an = this.LT(1);
                this.match(147);
                expr = this.term2(ns, expectedType, functionNs);
                if (this.inputState.guessing != 0) continue;
                conjoined.add(expr);
                lineNumber = an.getLine();
            }
            if (this.inputState.guessing == 0) {
                if (conjoined.size() == 1) {
                    expr = (Evaluable)conjoined.get(0);
                } else {
                    try {
                        expr = new Expression.Conjunction(conjoined.toArray(new Evaluable[conjoined.size()]));
                    }
                    catch (Exception ex) {
                        this.reportError(ex, lineNumber);
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_81);
            }
            throw ex;
        }
        return expr;
    }

    protected final Evaluable term2(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Evaluable expr = null;
        Evaluable comparedWith = null;
        int op = 61;
        int[] lineNumberPar = null;
        try {
            expr = this.predicate(ns, expectedType, functionNs);
            if (_tokenSet_82.member(this.LA(1))) {
                if (this.inputState.guessing == 0) {
                    lineNumberPar = new int[1];
                }
                op = this.relation(lineNumberPar);
                comparedWith = this.predicate(ns, expectedType, functionNs);
                if (this.inputState.guessing == 0) {
                    try {
                        switch (op) {
                            case 61: {
                                expr = new Expression.Equality(expr, comparedWith);
                                break;
                            }
                            case 33: {
                                expr = new Expression.Inequality(expr, comparedWith);
                                break;
                            }
                            case 108: {
                                expr = new Expression.LessThanOrEqual(expr, comparedWith);
                                break;
                            }
                            case 103: {
                                expr = new Expression.GreaterThanOrEqual(expr, comparedWith);
                                break;
                            }
                            case 60: {
                                expr = new Expression.LessThan(expr, comparedWith);
                                break;
                            }
                            case 62: {
                                expr = new Expression.GreaterThan(expr, comparedWith);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.reportError(ex, lineNumberPar[0]);
                    }
                }
            } else if (!_tokenSet_83.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_83);
            }
            throw ex;
        }
        return expr;
    }

    protected final Evaluable predicate(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Token nt = null;
        Token def = null;
        Evaluable expr = null;
        boolean negation = false;
        try {
            switch (this.LA(1)) {
                case 12: 
                case 148: {
                    if (this.LA(1) == 148) {
                        nt = this.LT(1);
                        this.match(148);
                        if (this.inputState.guessing == 0) {
                            negation = true;
                        }
                    } else if (this.LA(1) != 12) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(12);
                    expr = this.expression(ns, expectedType, functionNs);
                    this.match(13);
                    if (this.inputState.guessing == 0 && negation) {
                        try {
                            expr = new Expression.Negation(expr);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, nt.getLine());
                        }
                    }
                    break;
                }
                case 149: {
                    def = this.LT(1);
                    this.match(149);
                    this.match(12);
                    expr = this.factor(ns, ns);
                    this.match(13);
                    if (this.inputState.guessing == 0) {
                        try {
                            expr = new Expression.DefinedCheck(expr);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, def.getLine());
                        }
                    }
                    break;
                }
                case 4: 
                case 7: 
                case 11: 
                case 16: 
                case 44: 
                case 72: 
                case 81: 
                case 90: 
                case 91: 
                case 92: 
                case 111: 
                case 117: 
                case 131: 
                case 134: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 182: 
                case 183: 
                case 184: {
                    expr = this.factor(ns, ns);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_32);
            }
            throw ex;
        }
        return expr;
    }

    protected final char relation(int[] lineNumberPar) throws RecognitionException, TokenStreamException {
        Token eq = null;
        Token be = null;
        Token lg = null;
        Token le = null;
        Token ge = null;
        Token ls = null;
        Token gr = null;
        int code = 61;
        try {
            switch (this.LA(1)) {
                case 150: {
                    eq = this.LT(1);
                    this.match(150);
                    if (this.inputState.guessing == 0) {
                        code = 61;
                        lineNumberPar[0] = eq.getLine();
                    }
                    break;
                }
                case 151: {
                    be = this.LT(1);
                    this.match(151);
                    if (this.inputState.guessing == 0) {
                        code = 33;
                        lineNumberPar[0] = be.getLine();
                    }
                    break;
                }
                case 152: {
                    lg = this.LT(1);
                    this.match(152);
                    if (this.inputState.guessing == 0) {
                        code = 33;
                        lineNumberPar[0] = lg.getLine();
                    }
                    break;
                }
                case 136: {
                    le = this.LT(1);
                    this.match(136);
                    if (this.inputState.guessing == 0) {
                        code = 108;
                        lineNumberPar[0] = le.getLine();
                    }
                    break;
                }
                case 137: {
                    ge = this.LT(1);
                    this.match(137);
                    if (this.inputState.guessing == 0) {
                        code = 103;
                        lineNumberPar[0] = ge.getLine();
                    }
                    break;
                }
                case 89: {
                    ls = this.LT(1);
                    this.match(89);
                    if (this.inputState.guessing == 0) {
                        code = 60;
                        lineNumberPar[0] = ls.getLine();
                    }
                    break;
                }
                case 90: {
                    gr = this.LT(1);
                    this.match(90);
                    if (this.inputState.guessing == 0) {
                        code = 62;
                        lineNumberPar[0] = gr.getLine();
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_73);
            }
            throw ex;
        }
        return (char)code;
    }

    protected final FunctionCall functionCall(Container ns, Container functionNs) throws RecognitionException, TokenStreamException {
        Token lpar = null;
        FunctionCall call = null;
        Function called = null;
        Evaluable arg = null;
        LinkedList<Evaluable> args = null;
        FormalArgument[] formalArguments = null;
        Type expectedType = null;
        int curArgument = 0;
        LinkedList nams = new LinkedList();
        int lin = 0;
        try {
            lin = this.names2(nams);
            if (this.inputState.guessing == 0) {
                String elementName = null;
                Container container = null;
                switch (nams.size()) {
                    case 1: {
                        elementName = (String)nams.get(0);
                        container = functionNs.getContainerOrSame(AbstractPatternDef.class);
                        if (container != null) break;
                        container = functionNs.getContainerOrSame(Model.class);
                        break;
                    }
                    case 2: {
                        container = this.resolveOrFixModelName(functionNs, (String)nams.get(0), lin);
                        elementName = (String)nams.get(1);
                        break;
                    }
                    case 3: {
                        container = this.resolveOrFixTopicName(this.resolveOrFixModelName(functionNs, (String)nams.get(0), lin), (String)nams.get(1), lin);
                        elementName = (String)nams.get(2);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_weirdFunctionRef"), lin);
                        Ili24Parser.panic();
                    }
                }
                if ((called = (Function)container.getRealElement(Function.class, elementName)) == null && nams.size() == 1) {
                    Model model = (Model)functionNs.getContainerOrSame(Model.class);
                    called = (Function)model.getImportedElement(Function.class, elementName);
                }
                if (called == null) {
                    this.reportError(this.formatMessage("err_functionRef_weird", elementName, container.toString()), lin);
                    Ili24Parser.panic();
                }
            }
            lpar = this.LT(1);
            this.match(12);
            if (this.inputState.guessing == 0) {
                args = new LinkedList<Evaluable>();
                if (called != null) {
                    formalArguments = called.getArguments();
                }
            }
            if (this.inputState.guessing == 0) {
                ++curArgument;
                expectedType = formalArguments == null || curArgument > formalArguments.length ? null : formalArguments[curArgument - 1].getType();
            }
            if (_tokenSet_84.member(this.LA(1))) {
                arg = this.argument(ns, expectedType, functionNs);
                if (this.inputState.guessing == 0) {
                    args.add(arg);
                }
                while (this.LA(1) == 28) {
                    this.match(28);
                    if (this.inputState.guessing == 0) {
                        ++curArgument;
                        expectedType = formalArguments == null || curArgument > formalArguments.length ? null : formalArguments[curArgument - 1].getType();
                    }
                    arg = this.argument(ns, expectedType, functionNs);
                    if (this.inputState.guessing != 0) continue;
                    args.add(arg);
                }
            } else if (this.LA(1) != 13) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                try {
                    call = new FunctionCall(called, args.toArray(new Evaluable[args.size()]));
                }
                catch (Exception ex) {
                    this.reportError(ex, lpar.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_32);
            }
            throw ex;
        }
        return call;
    }

    protected final View inspection(Container container) throws RecognitionException, TokenStreamException {
        Token decomp = null;
        Token n1 = null;
        Token n2 = null;
        LinkedList<String> aliases = new LinkedList<String>();
        ViewableAlias decomposedViewable = null;
        boolean areaDecomp = false;
        DecompositionView view = null;
        try {
            if (this.LA(1) == 117) {
                this.match(117);
                if (this.inputState.guessing == 0) {
                    areaDecomp = true;
                }
            } else if (this.LA(1) != 153) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            decomp = this.LT(1);
            this.match(153);
            this.match(20);
            decomposedViewable = this.renamedViewableRef(container);
            this.match(104);
            n1 = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                aliases.add(n1.getText());
            }
            while (this.LA(1) == 104) {
                this.match(104);
                n2 = this.LT(1);
                this.match(11);
                if (this.inputState.guessing != 0) continue;
                aliases.add(n2.getText());
            }
            if (this.inputState.guessing == 0) {
                view = new DecompositionView();
                try {
                    String[] aliasv = aliases.toArray(new String[aliases.size()]);
                    PathEl[] attrRef = new AttributeRef[aliasv.length];
                    Viewable currentView = decomposedViewable.getAliasing();
                    AttributeDef attrdef = null;
                    for (int i = 0; i < aliasv.length; ++i) {
                        if (i > 0) {
                            if (!(attrRef[i - 1].getDomain() instanceof CompositionType)) {
                                this.reportError(this.formatMessage("err_inspection_noStructAttr", aliasv[i - 1]), n1.getLine());
                            }
                            currentView = ((AttributeRef)attrRef[i - 1]).getViewable();
                        }
                        if ((attrdef = this.findAttribute(currentView, aliasv[i])) == null) {
                            this.reportError(this.formatMessage("err_attributeRef_unknownAttr", aliasv[i], currentView.toString()), n1.getLine());
                        }
                        attrRef[i] = new AttributeRef(attrdef);
                    }
                    view.setDecomposedAttribute(new ObjectPath(decomposedViewable.getAliasing(), attrRef));
                    view.setAreaDecomposition(areaDecomp);
                    view.setRenamedViewable(decomposedViewable);
                    Table decomposedStruct = this.buildDecomposedStruct(attrdef, areaDecomp);
                    LocalAttribute attrib = new LocalAttribute();
                    attrib.setName(decomposedViewable.getName());
                    attrib.setDomain(new ObjectType(decomposedStruct));
                    view.add(attrib);
                }
                catch (Exception ex) {
                    this.reportError(ex, decomp.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_85);
            }
            throw ex;
        }
        return view;
    }

    protected final PathEl pathEl(Viewable currentViewable) throws RecognitionException, TokenStreamException {
        Token kwi = null;
        Token kwa = null;
        Token kwp = null;
        Token n = null;
        PathEl el = null;
        try {
            switch (this.LA(1)) {
                case 154: {
                    this.match(154);
                    if (this.inputState.guessing == 0) {
                        el = new PathElThis(currentViewable);
                    }
                    break;
                }
                case 155: {
                    kwi = this.LT(1);
                    this.match(155);
                    if (this.inputState.guessing == 0) {
                        if (!(currentViewable instanceof DecompositionView) || !((DecompositionView)currentViewable).isAreaDecomposition()) {
                            this.reportError(this.formatMessage("err_pathEl_thisareaOnNonAreaInspection", currentViewable.toString()), kwi.getLine());
                        }
                        el = new ThisArea((DecompositionView)currentViewable, false);
                    }
                    break;
                }
                case 156: {
                    kwa = this.LT(1);
                    this.match(156);
                    if (this.inputState.guessing == 0) {
                        if (!(currentViewable instanceof DecompositionView) || !((DecompositionView)currentViewable).isAreaDecomposition()) {
                            this.reportError(this.formatMessage("err_pathEl_thatareaOnNonAreaInspection", currentViewable.toString()), kwa.getLine());
                        }
                        el = new ThisArea((DecompositionView)currentViewable, true);
                    }
                    break;
                }
                case 157: {
                    kwp = this.LT(1);
                    this.match(157);
                    if (this.inputState.guessing == 0) {
                        if (!(currentViewable instanceof DecompositionView) || ((DecompositionView)currentViewable).isAreaDecomposition()) {
                            this.reportError(this.formatMessage("err_pathEl_parentOnNonInspection", currentViewable.toString()), kwp.getLine());
                        }
                        el = new PathElParent(currentViewable);
                    }
                    break;
                }
                case 158: {
                    el = this.associationPath(currentViewable);
                    if (this.inputState.guessing == 0) {
                    }
                    break;
                }
                default: {
                    if ((this.LA(1) == 11 || this.LA(1) == 159) && (this.isAttributeRef(currentViewable, this.LT(1).getText()) || this.LT(1).getText().equals("AGGREGATES"))) {
                        el = this.attributeRef(currentViewable);
                        break;
                    }
                    if (this.LA(1) == 11) {
                        n = this.LT(1);
                        this.match(11);
                        if (this.inputState.guessing == 0) {
                            AttributeDef refattr = null;
                            refattr = this.findAttribute(currentViewable, n.getText());
                            if (refattr != null && refattr.getDomainResolvingAliases() instanceof ReferenceType) {
                                el = new PathElRefAttr(refattr);
                                break;
                            }
                            if (refattr != null && refattr.getDomainResolvingAliases() instanceof ObjectType) {
                                ObjectType ref = (ObjectType)refattr.getDomainResolvingAliases();
                                el = new PathElBase(currentViewable, n.getText(), ref.getRef());
                                break;
                            }
                            if (currentViewable instanceof AssociationDef && currentViewable.getRealElement(RoleDef.class, n.getText()) != null) {
                                el = new PathElAssocRole((RoleDef)currentViewable.getRealElement(RoleDef.class, n.getText()));
                                break;
                            }
                            if (currentViewable instanceof AbstractClassDef && ((AbstractClassDef)currentViewable).findOpposideRole(n.getText()) != null) {
                                RoleDef oppend = ((AbstractClassDef)currentViewable).findOpposideRole(n.getText());
                                el = new PathElAbstractClassRole(oppend);
                                break;
                            }
                            this.reportError(this.formatMessage("err_pathEl_wrongName", n.getText(), currentViewable.toString()), n.getLine());
                        }
                        break;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_86);
            }
            throw ex;
        }
        return el;
    }

    protected final AssociationPath associationPath(Viewable currentViewable) throws RecognitionException, TokenStreamException {
        Token bs = null;
        Token roleName = null;
        AssociationPath el = null;
        try {
            bs = this.LT(1);
            this.match(158);
            roleName = this.LT(1);
            this.match(11);
            if (this.inputState.guessing == 0) {
                RoleDef targetRole;
                if (!(currentViewable instanceof Table) && !(currentViewable instanceof AssociationDef)) {
                    this.reportError(this.formatMessage("err_associationPath_currentIsNotClass", currentViewable.toString()), bs.getLine());
                }
                if ((targetRole = ((AbstractClassDef)currentViewable).findOpposideRole(roleName.getText())) == null) {
                    this.reportError(this.formatMessage("err_associationPath_noRole", roleName.getText(), currentViewable.toString()), roleName.getLine());
                }
                el = new AssociationPath(targetRole);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_86);
            }
            throw ex;
        }
        return el;
    }

    protected final AbstractAttributeRef attributeRef(Viewable currentViewable) throws RecognitionException, TokenStreamException {
        AbstractAttributeRef el;
        block18: {
            Token n = null;
            Token aggr = null;
            el = null;
            try {
                if (this.LA(1) == 11) {
                    n = this.LT(1);
                    this.match(11);
                    if (this.LA(1) == 21) {
                        this.match(21);
                        long idx = this.listIndex();
                        this.match(22);
                        if (this.inputState.guessing == 0) {
                            Type type;
                            AttributeDef attrdef = this.findAttribute(currentViewable, n.getText());
                            if (attrdef == null) {
                                this.reportError(this.formatMessage("err_attributeRef_unknownAttr", n.getText(), currentViewable.toString()), n.getLine());
                            }
                            if ((type = attrdef.getDomainResolvingAliases()) instanceof CoordType) {
                                if (idx <= 0L || idx >= (long)((CoordType)type).getDimensions().length) {
                                    this.reportError(this.formatMessage("err_attributeRef_axisOutOfBound", Integer.toString(((CoordType)type).getDimensions().length)), n.getLine());
                                }
                                AxisAttributeRef attrref = new AxisAttributeRef(attrdef, (int)idx);
                                el = attrref;
                            } else if (type instanceof CompositionType) {
                                StructAttributeRef attrref = new StructAttributeRef(attrdef, idx);
                                el = attrref;
                            } else {
                                this.reportError(this.formatMessage("err_attributeRef_unknownStructAttr", n.getText(), currentViewable.toString()), n.getLine());
                            }
                        }
                        break block18;
                    }
                    if (_tokenSet_86.member(this.LA(1))) {
                        if (this.inputState.guessing == 0) {
                            AttributeDef attrdef = this.findAttribute(currentViewable, n.getText());
                            if (attrdef == null) {
                                this.reportError(this.formatMessage("err_attributeRef_unknownAttr", n.getText(), currentViewable.toString()), n.getLine());
                            }
                            AttributeRef attrref = new AttributeRef(attrdef);
                            el = attrref;
                        }
                        break block18;
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.LA(1) == 159) {
                    aggr = this.LT(1);
                    this.match(159);
                    if (this.inputState.guessing == 0) {
                        if (!(currentViewable instanceof AggregationView)) {
                            this.reportError(this.formatMessage("err_attributeRef_noAggregates", currentViewable.toString()), aggr.getLine());
                        }
                        el = new AggregationRef((AggregationView)currentViewable);
                    }
                    break block18;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_86);
                }
                throw ex;
            }
        }
        return el;
    }

    protected final long listIndex() throws RecognitionException, TokenStreamException {
        long index = 0L;
        try {
            switch (this.LA(1)) {
                case 160: {
                    this.match(160);
                    if (this.inputState.guessing == 0) {
                        index = -1L;
                    }
                    break;
                }
                case 161: {
                    this.match(161);
                    if (this.inputState.guessing == 0) {
                        index = -2L;
                    }
                    break;
                }
                case 183: {
                    index = this.posInteger();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_87);
            }
            throw ex;
        }
        return index;
    }

    protected final Evaluable argument(Container ns, Type expectedType, Container functionNs) throws RecognitionException, TokenStreamException {
        Evaluable arg;
        block21: {
            Viewable ref = null;
            AbstractClassDef restrictedTo = null;
            boolean classRequired = expectedType instanceof ClassType;
            arg = null;
            Objects objs = null;
            try {
                if (_tokenSet_73.member(this.LA(1))) {
                    arg = this.expression(ns, expectedType, functionNs);
                    break block21;
                }
                if (this.LA(1) == 79) {
                    this.match(79);
                    if (this.inputState.guessing == 0) {
                        Viewable context = (Viewable)ns.getContainerOrSame(Viewable.class);
                        objs = new Objects(context);
                        arg = objs;
                    }
                    if (this.LA(1) == 12) {
                        this.match(12);
                        if (_tokenSet_7.member(this.LA(1))) {
                            ref = this.viewableRef(ns);
                        } else if (this.LA(1) == 56) {
                            this.match(56);
                            if (this.inputState.guessing == 0) {
                                ref = this.modelInterlis.ANYCLASS;
                            }
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing == 0) {
                            objs.setBase(ref);
                        }
                        if (!(ref instanceof AbstractClassDef)) {
                            throw new SemanticException("ref instanceof AbstractClassDef");
                        }
                        if (this.LA(1) == 53) {
                            this.match(53);
                            this.match(12);
                            restrictedTo = this.classOrAssociationRef(ns);
                            if (this.inputState.guessing == 0) {
                                objs.addRestrictedTo(restrictedTo);
                            }
                            while (this.LA(1) == 5) {
                                this.match(5);
                                restrictedTo = this.classOrAssociationRef(ns);
                                if (this.inputState.guessing != 0) continue;
                                objs.addRestrictedTo(restrictedTo);
                            }
                            this.match(13);
                        } else if (this.LA(1) != 13) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        this.match(13);
                    } else if (this.LA(1) != 13 && this.LA(1) != 28) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break block21;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_69);
                }
                throw ex;
            }
        }
        return arg;
    }

    protected final FormalArgument formalArgument(Container scope, int line, ArrayList formalArgs) throws RecognitionException, TokenStreamException {
        Token n = null;
        FormalArgument arg = null;
        Type domain = null;
        try {
            n = this.LT(1);
            this.match(11);
            this.match(47);
            domain = this.argumentType(scope, line, formalArgs);
            if (this.inputState.guessing == 0) {
                arg = new FormalArgument(n.getText(), domain);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_78);
            }
            throw ex;
        }
        return arg;
    }

    protected final Type argumentType(Container scope, int line, ArrayList formalArgs) throws RecognitionException, TokenStreamException {
        Viewable ref = null;
        Type domain = null;
        boolean objects = false;
        ObjectType ot = null;
        AbstractClassDef restrictedTo = null;
        try {
            switch (this.LA(1)) {
                case 4: 
                case 7: 
                case 11: 
                case 12: 
                case 16: 
                case 34: 
                case 40: 
                case 41: 
                case 43: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 54: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 79: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 131: 
                case 134: 
                case 182: 
                case 183: 
                case 184: {
                    domain = this.attrTypeDef(scope, true, null, line, formalArgs);
                    break;
                }
                case 133: 
                case 162: {
                    if (this.LA(1) == 162) {
                        this.match(162);
                        if (this.inputState.guessing == 0) {
                            objects = false;
                        }
                    } else if (this.LA(1) == 133) {
                        this.match(133);
                        if (this.inputState.guessing == 0) {
                            objects = true;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(20);
                    if (_tokenSet_7.member(this.LA(1))) {
                        ref = this.viewableRef(scope);
                    } else if (this.LA(1) == 56) {
                        this.match(56);
                        if (this.inputState.guessing == 0) {
                            ref = this.modelInterlis.ANYCLASS;
                        }
                    } else {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    if (this.inputState.guessing == 0) {
                        ot = new ObjectType(ref, objects);
                        domain = ot;
                    }
                    if (!(ref instanceof AbstractClassDef)) {
                        throw new SemanticException("ref instanceof AbstractClassDef");
                    }
                    if (this.LA(1) == 53) {
                        this.match(53);
                        this.match(12);
                        restrictedTo = this.classOrAssociationRef(scope);
                        if (this.inputState.guessing == 0) {
                            ot.addRestrictedTo(restrictedTo);
                        }
                        while (this.LA(1) == 5) {
                            this.match(5);
                            restrictedTo = this.classOrAssociationRef(scope);
                            if (this.inputState.guessing != 0) continue;
                            ot.addRestrictedTo(restrictedTo);
                        }
                        this.match(13);
                        break;
                    }
                    if (this.LA(1) != 5 && this.LA(1) != 13) {
                        if (this.LA(1) == 18) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                case 163: {
                    this.match(163);
                    if (this.inputState.guessing == 0) {
                        domain = new EnumValType(true);
                    }
                    break;
                }
                case 164: {
                    this.match(164);
                    if (this.inputState.guessing == 0) {
                        domain = new EnumValType(false);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_88);
            }
            throw ex;
        }
        return domain;
    }

    protected final View formationDef(Container container) throws RecognitionException, TokenStreamException {
        View view = null;
        try {
            switch (this.LA(1)) {
                case 165: {
                    view = this.projection(container);
                    break;
                }
                case 166: {
                    view = this.join(container);
                    break;
                }
                case 168: {
                    view = this.union(container);
                    break;
                }
                case 169: {
                    view = this.aggregation(container);
                    break;
                }
                case 117: 
                case 153: {
                    view = this.inspection(container);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_89);
            }
            throw ex;
        }
        return view;
    }

    protected final View viewRef(Container scope) throws RecognitionException, TokenStreamException {
        View view = null;
        try {
            Viewable viewable = this.viewableRef(scope);
            if (this.inputState.guessing == 0) {
                view = (View)viewable;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_89);
            }
            throw ex;
        }
        return view;
    }

    protected final void baseExtensionDef(Viewable scope) throws RecognitionException, TokenStreamException {
        Token baseName = null;
        Token by = null;
        Token cm = null;
        Viewable base = null;
        ViewableAlias ext1 = null;
        ViewableAlias ext2 = null;
        try {
            LocalAttribute attrib;
            AttributeDef exstAttr;
            this.match(171);
            baseName = this.LT(1);
            this.match(11);
            this.match(172);
            by = this.LT(1);
            this.match(173);
            ext1 = this.renamedViewableRef(scope);
            if (this.inputState.guessing == 0) {
                base = this.getBaseViewable(this.getBaseViewableProxyAttr(scope, baseName.getText(), baseName.getLine()));
                if (base == null) {
                    this.reportError(this.formatMessage("err_viewable_noSuchBase", baseName.getText(), scope.toString()), baseName.getLine());
                }
                if ((exstAttr = (AttributeDef)scope.getRealElement(AttributeDef.class, ext1.getName())) != null) {
                    this.reportError(this.formatMessage("err_attrNameInSameViewable", scope.toString(), ext1.getName()), by.getLine());
                }
                if (!ext1.getAliasing().isExtending(base)) {
                    this.reportError(this.formatMessage("err_viewext_notBase", ext1.getName(), baseName.getText()), by.getLine());
                }
                try {
                    attrib = new LocalAttribute();
                    attrib.setName(ext1.getName());
                    attrib.setDomain(new ObjectType(ext1.getAliasing()));
                    scope.add(attrib);
                }
                catch (Exception ex) {
                    this.reportError(ex, by.getLine());
                }
            }
            while (this.LA(1) == 28) {
                cm = this.LT(1);
                this.match(28);
                ext2 = this.renamedViewableRef(scope);
                if (this.inputState.guessing != 0) continue;
                exstAttr = (AttributeDef)scope.getRealElement(AttributeDef.class, ext2.getName());
                if (exstAttr != null) {
                    this.reportError(this.formatMessage("err_attrNameInSameViewable", scope.toString(), ext2.getName()), cm.getLine());
                }
                if (!ext2.getAliasing().isExtending(base)) {
                    this.reportError(this.formatMessage("err_viewext_notBase", ext2.getName(), baseName.getText()), cm.getLine());
                }
                try {
                    attrib = new LocalAttribute();
                    attrib.setName(ext2.getName());
                    attrib.setDomain(new ObjectType(ext2.getAliasing()));
                    scope.add(attrib);
                }
                catch (Exception ex) {
                    this.reportError(ex, cm.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_89);
            }
            throw ex;
        }
    }

    protected final Selection selection(Viewable view, Container functionNs) throws RecognitionException, TokenStreamException {
        ExpressionSelection sel = null;
        Evaluable logex = null;
        LinkedList base = new LinkedList();
        try {
            this.match(143);
            logex = this.expression(view, this.predefinedBooleanType, functionNs);
            if (this.inputState.guessing == 0) {
                sel = new ExpressionSelection(view, logex);
            }
            this.match(5);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_90);
            }
            throw ex;
        }
        return sel;
    }

    protected final void viewAttributes(Viewable view) throws RecognitionException, TokenStreamException {
        Token all = null;
        Token v = null;
        Token n = null;
        int mods = 0;
        Evaluable f = null;
        try {
            if (this.LA(1) == 43) {
                this.match(43);
            } else if (!_tokenSet_91.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            block10: while (true) {
                if (this.LA(1) == 79) {
                    all = this.LT(1);
                    this.match(79);
                    this.match(20);
                    v = this.LT(1);
                    this.match(11);
                    this.match(5);
                    if (this.inputState.guessing != 0) continue;
                    AttributeDef allOfAttr = null;
                    Viewable attrScope = (Viewable)view.getContainerOrSame(Viewable.class);
                    if (attrScope == null) {
                        this.reportInternalError(v.getLine());
                    } else {
                        if (attrScope instanceof UnionView) {
                            this.reportError(this.formatMessage("err_unionView_illegalallof", v.getText()), v.getLine());
                        }
                        if ((allOfAttr = this.getBaseViewableProxyAttr(attrScope, v.getText(), v.getLine())) == null) {
                            this.reportError(this.formatMessage("err_viewable_noSuchBase", v.getText(), attrScope.toString()), v.getLine());
                        }
                    }
                    if (allOfAttr == null) continue;
                    ObjectType proxyType = (ObjectType)allOfAttr.getDomain();
                    proxyType.setAllOf(true);
                    Viewable allOf = this.getBaseViewable(allOfAttr);
                    Iterator<Extendable> attrs = allOf.getAttributes();
                    while (true) {
                        if (!attrs.hasNext()) continue block10;
                        AttributeDef attr = (AttributeDef)attrs.next();
                        AttributeDef exstAttr = (AttributeDef)view.getRealElement(AttributeDef.class, attr.getName());
                        if (exstAttr != null) {
                            this.reportError(this.formatMessage("err_attrNameInSameViewable", view.toString(), attr.getName()), v.getLine());
                        }
                        if (attr.isAbstract() && !view.isAbstract()) {
                            this.reportError(this.formatMessage("err_view_abstractAttr", view.toString(), attr.getName()), v.getLine());
                        }
                        LocalAttribute pa = new LocalAttribute();
                        pa.setGeneratedByAllOf(true);
                        try {
                            PathEl[] pathItems = new AttributeRef[]{new AttributeRef(attr)};
                            ObjectPath path = new ObjectPath(allOf, pathItems);
                            pa.setName(attr.getName());
                            pa.setDomain(attr.getDomain());
                            pa.setBasePaths(new ObjectPath[]{path});
                            view.add(pa);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, all.getLine());
                        }
                    }
                }
                boolean synPredMatched417 = false;
                if (this.LA(1) == 11) {
                    int _m417 = this.mark();
                    synPredMatched417 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(11);
                        mods = this.properties(519);
                        this.match(48);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched417 = false;
                    }
                    this.rewind(_m417);
                    --this.inputState.guessing;
                }
                if (synPredMatched417) {
                    n = this.LT(1);
                    this.match(11);
                    mods = this.properties(519);
                    this.match(48);
                    f = this.factor(view, view);
                    if (this.inputState.guessing == 0) {
                        AttributeDef overriding = this.findOverridingAttribute(view, mods, n.getText(), n.getLine());
                        Type overridingDomain = null;
                        if (overriding != null) {
                            overridingDomain = overriding.getDomainResolvingAliases();
                        }
                        LocalAttribute attrib = new LocalAttribute();
                        try {
                            attrib.setName(n.getText());
                            attrib.setAbstract((mods & 1) != 0);
                            attrib.setTransient((mods & 0x200) != 0);
                            attrib.setBasePaths(new Evaluable[]{f});
                        }
                        catch (Exception ex) {
                            this.reportError(ex, n.getLine());
                        }
                        try {
                            view.add(attrib);
                            attrib.setExtending(overriding);
                        }
                        catch (Exception ex) {
                            this.reportError(ex, n.getLine());
                        }
                    }
                    this.match(5);
                    continue;
                }
                if (this.LA(1) == 11 || this.LA(1) == 45 || this.LA(1) == 46) {
                    this.attributeDef(view);
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_22);
            }
            throw ex;
        }
    }

    protected final Projection projection(Container container) throws RecognitionException, TokenStreamException {
        Token projToken = null;
        Projection view = null;
        ViewableAlias base = null;
        try {
            projToken = this.LT(1);
            this.match(165);
            this.match(20);
            base = this.renamedViewableRef(container);
            if (this.inputState.guessing == 0) {
                view = new Projection();
                try {
                    view.setSelected(base);
                    LocalAttribute attrib = new LocalAttribute();
                    attrib.setName(base.getName());
                    attrib.setDomain(new ObjectType(base.getAliasing()));
                    view.add(attrib);
                }
                catch (Exception ex) {
                    this.reportError(ex, projToken.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_71);
            }
            throw ex;
        }
        return view;
    }

    protected final View join(Container container) throws RecognitionException, TokenStreamException {
        JoinView view;
        block16: {
            Token join = null;
            ViewableAlias viewable = null;
            LinkedList<ViewableAlias> aliases = new LinkedList<ViewableAlias>();
            view = null;
            try {
                join = this.LT(1);
                this.match(166);
                this.match(20);
                viewable = this.renamedViewableRef(container);
                if (this.inputState.guessing == 0) {
                    aliases.add(viewable);
                }
                int _cnt393 = 0;
                while (true) {
                    if (this.LA(1) == 28) {
                        this.match(28);
                        viewable = this.renamedViewableRef(container);
                        if (this.LA(1) == 12) {
                            this.match(12);
                            this.match(65);
                            this.match(167);
                            this.match(13);
                            if (this.inputState.guessing == 0) {
                                viewable.setIncludeNull(true);
                            }
                        } else if (this.LA(1) != 5 && this.LA(1) != 28) {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing == 0) {
                            aliases.add(viewable);
                        }
                    } else {
                        if (_cnt393 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    ++_cnt393;
                }
                if (this.inputState.guessing != 0) break block16;
                view = new JoinView();
                try {
                    view.setJoining(aliases.toArray(new ViewableAlias[aliases.size()]));
                    for (int i = 0; i < aliases.size(); ++i) {
                        ViewableAlias base = (ViewableAlias)aliases.get(i);
                        AttributeDef exstAttr = (AttributeDef)view.getRealElement(AttributeDef.class, base.getName());
                        if (exstAttr != null) {
                            this.reportError(this.formatMessage("err_attrNameInSameViewable", view.toString(), base.getName()), join.getLine());
                        }
                        LocalAttribute attrib = new LocalAttribute();
                        attrib.setName(base.getName());
                        attrib.setDomain(new ObjectType(base.getAliasing()));
                        view.add(attrib);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, join.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_71);
                }
                throw ex;
            }
        }
        return view;
    }

    protected final View union(Container container) throws RecognitionException, TokenStreamException {
        UnionView view;
        block12: {
            Token union = null;
            ViewableAlias viewable = null;
            LinkedList<ViewableAlias> aliases = new LinkedList<ViewableAlias>();
            view = null;
            try {
                union = this.LT(1);
                this.match(168);
                this.match(20);
                viewable = this.renamedViewableRef(container);
                if (this.inputState.guessing == 0) {
                    aliases.add(viewable);
                }
                int _cnt396 = 0;
                while (true) {
                    if (this.LA(1) == 28) {
                        this.match(28);
                        viewable = this.renamedViewableRef(container);
                        if (this.inputState.guessing == 0) {
                            aliases.add(viewable);
                        }
                    } else {
                        if (_cnt396 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    ++_cnt396;
                }
                if (this.inputState.guessing != 0) break block12;
                view = new UnionView();
                try {
                    view.setUnited(aliases.toArray(new ViewableAlias[aliases.size()]));
                    for (int i = 0; i < aliases.size(); ++i) {
                        ViewableAlias base = (ViewableAlias)aliases.get(i);
                        AttributeDef exstAttr = (AttributeDef)view.getRealElement(AttributeDef.class, base.getName());
                        if (exstAttr != null) {
                            this.reportError(this.formatMessage("err_attrNameInSameViewable", view.toString(), base.getName()), union.getLine());
                        }
                        LocalAttribute attrib = new LocalAttribute();
                        attrib.setName(base.getName());
                        attrib.setDomain(new ObjectType(base.getAliasing()));
                        view.add(attrib);
                    }
                }
                catch (Exception ex) {
                    this.reportError(ex, union.getLine());
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_71);
                }
                throw ex;
            }
        }
        return view;
    }

    protected final AggregationView aggregation(Container container) throws RecognitionException, TokenStreamException {
        AggregationView view;
        block9: {
            Token agg = null;
            Token eq = null;
            ViewableAlias base = null;
            UniqueEl cols = null;
            view = null;
            try {
                agg = this.LT(1);
                this.match(169);
                this.match(20);
                base = this.renamedViewableRef(container);
                if (this.inputState.guessing == 0) {
                    view = new AggregationView(base);
                    try {
                        LocalAttribute attrib = new LocalAttribute();
                        attrib.setName(base.getName());
                        attrib.setDomain(new ObjectType(base.getAliasing()));
                        view.add(attrib);
                    }
                    catch (Exception ex) {
                        this.reportError(ex, agg.getLine());
                    }
                }
                if (this.LA(1) == 79) {
                    this.match(79);
                    break block9;
                }
                if (this.LA(1) == 170) {
                    eq = this.LT(1);
                    this.match(170);
                    this.match(12);
                    cols = this.uniqueEl(view);
                    this.match(13);
                    if (this.inputState.guessing == 0) {
                        view.setEqual(cols);
                    }
                    break block9;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_71);
                }
                throw ex;
            }
        }
        return view;
    }

    protected final Graphic graphicRef(Container scope) throws RecognitionException, TokenStreamException {
        Graphic graph;
        block17: {
            LinkedList nams = new LinkedList();
            graph = null;
            String graphicName = null;
            int lin = 0;
            try {
                Topic topic;
                Model model;
                lin = this.names2(nams);
                if (this.inputState.guessing != 0) break block17;
                switch (nams.size()) {
                    case 1: {
                        model = (Model)scope.getContainerOrSame(Model.class);
                        topic = (Topic)scope.getContainerOrSame(Topic.class);
                        graphicName = (String)nams.get(0);
                        break;
                    }
                    case 2: {
                        model = this.resolveOrFixModelName(scope, (String)nams.get(0), lin);
                        topic = null;
                        graphicName = (String)nams.get(1);
                        break;
                    }
                    case 3: {
                        model = this.resolveOrFixModelName(scope, (String)nams.get(0), lin);
                        topic = this.resolveOrFixTopicName(model, (String)nams.get(1), lin);
                        graphicName = (String)nams.get(2);
                        break;
                    }
                    default: {
                        this.reportError(this.rsrc.getString("err_graphicRef_weird"), lin);
                        model = this.resolveModelName(scope, (String)nams.get(0));
                        topic = null;
                        if (model == null) {
                            model = (Model)scope.getContainerOrSame(Model.class);
                        }
                        graphicName = (String)nams.get(nams.size() - 1);
                    }
                }
                graph = null;
                if (topic != null) {
                    graph = (Graphic)topic.getRealElement(Graphic.class, graphicName);
                }
                if (graph == null && topic == null) {
                    graph = (Graphic)model.getRealElement(Graphic.class, graphicName);
                }
                if (graph == null && nams.size() == 1) {
                    graph = (Graphic)model.getImportedElement(Graphic.class, graphicName);
                }
                if (graph != null) break block17;
                if (topic == null) {
                    this.reportError(this.formatMessage("err_graphicRef_notInModel", graphicName, model.toString()), lin);
                } else {
                    this.reportError(this.formatMessage("err_graphicRef_notInModelOrTopic", graphicName, topic.toString(), model.toString()), lin);
                }
                try {
                    graph = new Graphic();
                    graph.setName(graphicName);
                    if (topic == null) {
                        model.add(graph);
                        break block17;
                    }
                    topic.add(graph);
                }
                catch (Exception ex) {
                    Ili24Parser.panic();
                }
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_92);
                }
                throw ex;
            }
        }
        return graph;
    }

    protected final void drawingRule(Graphic graph) throws RecognitionException, TokenStreamException {
        Token n = null;
        int mods = 0;
        Table signTab = null;
        SignAttribute attr = null;
        SignAttribute overriding = null;
        boolean declaredExtended = false;
        SignInstruction instruct = null;
        LinkedList<SignInstruction> instructs = null;
        Viewable basedOn = graph.getBasedOn();
        try {
            n = this.LT(1);
            this.match(11);
            mods = this.properties(7);
            if (this.LA(1) == 20) {
                this.match(20);
                signTab = this.classRef(graph);
            } else if (this.LA(1) != 47) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(47);
            if (this.inputState.guessing == 0) {
                declaredExtended = (mods & 4) != 0;
                overriding = (SignAttribute)graph.getRealElement(SignAttribute.class, n.getText());
                if (overriding == null && declaredExtended) {
                    if (graph.getRealExtending() == null) {
                        this.reportError(this.formatMessage("err_signAttr_extendedInRootGraphic", n.getText(), graph.toString()), n.getLine());
                    } else {
                        this.reportError(this.formatMessage("err_signAttr_nothingToExtend", n.getText(), graph.getRealExtending().toString()), n.getLine());
                    }
                }
                if (overriding != null && overriding.getContainer(Graphic.class) == graph) {
                    this.reportError(this.formatMessage("err_signAttr_inSameGraphic", graph.toString(), n.getText()), n.getLine());
                } else if (overriding != null && !declaredExtended) {
                    this.reportError(this.formatMessage("err_signAttr_extendedWithoutDecl", n.getText(), graph.toString(), overriding.toString()), n.getLine());
                }
            }
            if (this.inputState.guessing == 0) {
                attr = new SignAttribute();
                try {
                    attr.setName(n.getText());
                    attr.setExtending(overriding);
                    attr.setAbstract((mods & 1) != 0);
                    graph.add(attr);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                    Ili24Parser.panic();
                }
                try {
                    if (signTab == null) {
                        if (overriding != null) {
                            signTab = overriding.getGenerating();
                        } else {
                            this.reportError(this.formatMessage("err_signAttr_ofOmitted", attr.toString()), n.getLine());
                        }
                    }
                    attr.setGenerating(signTab);
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
            instruct = this.condSigParamAssignment(graph, signTab);
            if (this.inputState.guessing == 0) {
                instructs = new LinkedList<SignInstruction>();
                if (instruct != null) {
                    instructs.add(instruct);
                }
            }
            while (this.LA(1) == 28) {
                this.match(28);
                instruct = this.condSigParamAssignment(graph, signTab);
                if (this.inputState.guessing != 0 || instruct == null) continue;
                instructs.add(instruct);
            }
            this.match(5);
            if (this.inputState.guessing == 0) {
                try {
                    attr.setInstructions(instructs.toArray(new SignInstruction[instructs.size()]));
                }
                catch (Exception ex) {
                    this.reportError(ex, n.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_28);
            }
            throw ex;
        }
    }

    protected final SignInstruction condSigParamAssignment(Graphic graph, Table signTab) throws RecognitionException, TokenStreamException {
        Evaluable restrictor = null;
        LinkedList<ParameterAssignment> paramAssignments = null;
        ParameterAssignment assign = null;
        Viewable basedOn = graph.getBasedOn();
        SignInstruction instruct = null;
        try {
            if (this.LA(1) == 143) {
                this.match(143);
                restrictor = this.expression(basedOn, this.predefinedBooleanType, graph);
            } else if (this.LA(1) != 12) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(12);
            assign = this.sigParamAssignment(graph, signTab);
            if (this.inputState.guessing == 0) {
                paramAssignments = new LinkedList<ParameterAssignment>();
                if (assign != null) {
                    paramAssignments.add(assign);
                }
            }
            while (this.LA(1) == 5) {
                this.match(5);
                assign = this.sigParamAssignment(graph, signTab);
                if (this.inputState.guessing != 0 || assign == null) continue;
                paramAssignments.add(assign);
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                instruct = new SignInstruction(restrictor, paramAssignments.toArray(new ParameterAssignment[paramAssignments.size()]));
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_93);
            }
            throw ex;
        }
        return instruct;
    }

    protected final ParameterAssignment sigParamAssignment(Graphic graph, Table signTab) throws RecognitionException, TokenStreamException {
        Token parm = null;
        Token doteq = null;
        Object assignments = null;
        Parameter assignedParam = null;
        Evaluable value = null;
        ParameterAssignment assign = null;
        Type expectedType = null;
        MetaObject metaObj = null;
        Viewable basedOn = graph.getBasedOn();
        try {
            parm = this.LT(1);
            this.match(11);
            doteq = this.LT(1);
            this.match(48);
            if (this.inputState.guessing == 0) {
                assignedParam = (Parameter)signTab.getRealElement(Parameter.class, parm.getText());
                if (assignedParam == null) {
                    this.reportError(this.formatMessage("err_parameter_unknownInSignTable", parm.getText(), signTab.toString()), parm.getLine());
                } else {
                    expectedType = Type.findReal(assignedParam.getType());
                }
            }
            switch (this.LA(1)) {
                case 175: {
                    value = this.conditionalExpression(graph, expectedType, expectedType instanceof MetaobjectType ? ((MetaobjectType)expectedType).getReferred() : null);
                    break;
                }
                case 66: {
                    this.match(66);
                    metaObj = this.metaObjectRef(graph, ((MetaobjectType)expectedType).getReferred());
                    this.match(69);
                    if (this.inputState.guessing != 0) break;
                    value = new Constant.ReferenceToMetaObject(metaObj);
                    break;
                }
                case 4: 
                case 7: 
                case 11: 
                case 16: 
                case 44: 
                case 72: 
                case 81: 
                case 90: 
                case 91: 
                case 92: 
                case 111: 
                case 117: 
                case 131: 
                case 134: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 182: 
                case 183: 
                case 184: {
                    value = this.factor(basedOn, graph);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (this.inputState.guessing == 0) {
                try {
                    assign = new ParameterAssignment(assignedParam, value);
                }
                catch (Exception ex) {
                    this.reportError(ex, doteq.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_78);
            }
            throw ex;
        }
        return assign;
    }

    protected final ConditionalExpression conditionalExpression(Graphic graph, Type expectedType, Table metaobjectclass) throws RecognitionException, TokenStreamException {
        ObjectPath attrPath = null;
        LinkedList<ConditionalExpression.Condition> items = null;
        ConditionalExpression.Condition cond = null;
        Viewable basedOn = graph.getBasedOn();
        ConditionalExpression condex = null;
        try {
            this.match(175);
            attrPath = this.attributePath(basedOn);
            this.match(12);
            cond = this.enumAssignment(graph, expectedType, metaobjectclass);
            if (this.inputState.guessing == 0) {
                items = new LinkedList<ConditionalExpression.Condition>();
                if (cond != null) {
                    items.add(cond);
                }
            }
            while (this.LA(1) == 28) {
                this.match(28);
                cond = this.enumAssignment(graph, expectedType, metaobjectclass);
                if (this.inputState.guessing != 0 || cond == null) continue;
                items.add(cond);
            }
            this.match(13);
            if (this.inputState.guessing == 0) {
                condex = new ConditionalExpression(null, items.toArray(new ConditionalExpression.Condition[items.size()]));
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_78);
            }
            throw ex;
        }
        return condex;
    }

    protected final ConditionalExpression.Condition enumAssignment(Graphic graph, Type expectedType, Table metaobjectclass) throws RecognitionException, TokenStreamException {
        Token wh = null;
        Constant cnst = null;
        Constant.EnumConstOrRange range = null;
        ConditionalExpression.Condition cond = null;
        MetaObject metaObj = null;
        try {
            if (_tokenSet_94.member(this.LA(1))) {
                cnst = this.constant(graph);
            } else if (this.LA(1) == 66) {
                this.match(66);
                metaObj = this.metaObjectRef(graph, metaobjectclass);
                this.match(69);
                if (this.inputState.guessing == 0) {
                    cnst = new Constant.ReferenceToMetaObject(metaObj);
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            wh = this.LT(1);
            this.match(176);
            this.match(141);
            range = this.enumRange();
            if (this.inputState.guessing == 0) {
                try {
                    cond = new ConditionalExpression.Condition(cnst, range);
                }
                catch (Exception ex) {
                    this.reportError(ex, wh.getLine());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_69);
            }
            throw ex;
        }
        return cond;
    }

    protected final Constant.EnumConstOrRange enumRange() throws RecognitionException, TokenStreamException {
        Constant.EnumConstOrRange rangeOrEnum;
        block10: {
            Token ddot = null;
            rangeOrEnum = null;
            Constant.Enumeration from = null;
            Constant.Enumeration to = null;
            String[] commonPrefix = null;
            try {
                from = this.enumerationConst();
                if (this.LA(1) == 68) {
                    ddot = this.LT(1);
                    this.match(68);
                    to = this.enumerationConst();
                    if (this.inputState.guessing == 0) {
                        if (from.getValue().length != to.getValue().length) {
                            rangeOrEnum = from;
                            this.reportError(this.formatMessage("err_enumRange_notSameLength", ((Object)rangeOrEnum).toString(), to.toString()), ddot.getLine());
                        } else {
                            commonPrefix = new String[from.getValue().length - 1];
                            for (int i = 0; i < commonPrefix.length; ++i) {
                                commonPrefix[i] = from.getValue()[i];
                                if (from.getValue()[i].equals(to.getValue()[i])) continue;
                                this.reportError(this.formatMessage("err_enumRange_notCommonPrefix", from.toString(), to.toString()), ddot.getLine());
                                break;
                            }
                            rangeOrEnum = new Constant.EnumerationRange(commonPrefix, from.getValue()[from.getValue().length - 1], to.getValue()[from.getValue().length - 1]);
                        }
                    }
                    break block10;
                }
                if (this.LA(1) == 13 || this.LA(1) == 28) {
                    if (this.inputState.guessing == 0) {
                        rangeOrEnum = from;
                    }
                    break block10;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            catch (RecognitionException ex) {
                if (this.inputState.guessing == 0) {
                    this.reportError(ex);
                    this.recover(ex, _tokenSet_69);
                }
                throw ex;
            }
        }
        return rangeOrEnum;
    }

    protected final int property(int acceptable, int encountered) throws RecognitionException, TokenStreamException {
        Token a = null;
        Token f = null;
        Token e = null;
        Token o = null;
        Token d = null;
        Token v = null;
        Token b = null;
        Token g = null;
        Token x = null;
        Token t = null;
        Token g2 = null;
        int mod = 0;
        try {
            switch (this.LA(1)) {
                case 129: {
                    a = this.LT(1);
                    this.match(129);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 1) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeAbstract"), a.getLine());
                        } else {
                            mod = 1;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleAbstract"), a.getLine());
                        }
                    }
                    break;
                }
                case 80: {
                    f = this.LT(1);
                    this.match(80);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 2) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeFinal"), f.getLine());
                        } else {
                            mod = 2;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleFinal"), f.getLine());
                        }
                    }
                    break;
                }
                case 172: {
                    e = this.LT(1);
                    this.match(172);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 4) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeExtended"), e.getLine());
                        } else {
                            mod = 4;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleExtended"), e.getLine());
                        }
                    }
                    break;
                }
                case 77: {
                    o = this.LT(1);
                    this.match(77);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 8) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeOrdered"), o.getLine());
                        } else {
                            mod = 8;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleOrdered"), o.getLine());
                        }
                    }
                    break;
                }
                case 177: {
                    d = this.LT(1);
                    this.match(177);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x10) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeData"), d.getLine());
                        } else {
                            mod = 16;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleData"), d.getLine());
                        }
                    }
                    break;
                }
                case 30: {
                    v = this.LT(1);
                    this.match(30);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x20) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeView"), v.getLine());
                        } else {
                            mod = 32;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleView"), v.getLine());
                        }
                    }
                    break;
                }
                case 171: {
                    b = this.LT(1);
                    this.match(171);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x40) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeBase"), b.getLine());
                        } else {
                            mod = 64;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleBase"), b.getLine());
                        }
                    }
                    break;
                }
                case 174: {
                    g = this.LT(1);
                    this.match(174);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x80) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeGraphic"), g.getLine());
                        } else {
                            mod = 128;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleGraphic"), g.getLine());
                        }
                    }
                    break;
                }
                case 178: {
                    x = this.LT(1);
                    this.match(178);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x100) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeExternal"), x.getLine());
                        } else {
                            mod = 256;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleExternal"), x.getLine());
                        }
                    }
                    break;
                }
                case 179: {
                    t = this.LT(1);
                    this.match(179);
                    if (this.inputState.guessing == 0) {
                        if ((acceptable & 0x200) == 0) {
                            this.reportError(this.rsrc.getString("err_cantBeTransient"), t.getLine());
                        } else {
                            mod = 512;
                        }
                        if ((encountered & mod) != 0) {
                            this.reportWarning(this.rsrc.getString("err_multipleTransient"), t.getLine());
                        }
                    }
                    break;
                }
                case 34: {
                    this.match(34);
                    if (this.inputState.guessing == 0) {
                        mod = 1024;
                    }
                    break;
                }
                case 180: {
                    this.match(180);
                    if (this.inputState.guessing == 0) {
                    }
                    break;
                }
                case 181: {
                    g2 = this.LT(1);
                    this.match(181);
                    if (this.inputState.guessing == 0) {
                        mod = 4096;
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_69);
            }
            throw ex;
        }
        return mod;
    }

    protected final void enumNameListHelper(List namList) throws RecognitionException, TokenStreamException {
        Token n = null;
        try {
            boolean synPredMatched459 = false;
            if (this.LA(1) == 29) {
                int _m459 = this.mark();
                synPredMatched459 = true;
                ++this.inputState.guessing;
                try {
                    this.match(29);
                    this.match(11);
                }
                catch (RecognitionException pe) {
                    synPredMatched459 = false;
                }
                this.rewind(_m459);
                --this.inputState.guessing;
            }
            if (synPredMatched459) {
                this.match(29);
                n = this.LT(1);
                this.match(11);
                if (this.inputState.guessing == 0) {
                    namList.add(n.getText());
                }
                this.enumNameListHelper(namList);
            } else if (!_tokenSet_62.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_62);
            }
            throw ex;
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{422212735873056L, 288230655450431582L, 281475006859008L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{2305863903256510592L, 288232575174967424L, 13L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{2305863903222956160L, 288232575174967424L, 13L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{1986L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{2449979091231703168L, 288232575174967488L, 0x40000000000DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{2305863903155847296L, 288232575174967424L, 13L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{2192L, 0L, 72L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{2306537900562450432L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{2306529104469428224L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{0x2000000000000L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{2449961857675427968L, 0x200000000C0L, 0x40000000000DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{2449961840495558784L, 0x200000000C0L, 0x40000000000DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{2449961496898175104L, 0x200000000C0L, 0x40000000000DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[]{0x20000020L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[]{-4250975831468275568L, 9007200328482817L, 12506978353240L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[]{276824096L, 0L, 32L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{281475255969824L, 360287970256748610L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{0x2000000000000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{288230380455071744L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[]{3459441812983252992L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[]{3459433016890230784L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_22() {
        long[] data = new long[]{0x2002000000000000L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_23() {
        long[] data = new long[]{297659788156024866L, 360289075170672746L, 294669146424112L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_24() {
        long[] data = new long[]{9429411728470050L, 64L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_25() {
        long[] data = new long[]{3459450609076275200L, 32768L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_26() {
        long[] data = new long[]{0x2002100000000000L, 0L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_27() {
        long[] data = new long[]{26470759618648208L, 35756384968023552L, 126100789566373960L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_28() {
        long[] data = new long[]{0x2000000000000800L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_29() {
        long[] data = new long[]{9288674231726114L, 64L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_30() {
        long[] data = new long[]{22530109944699024L, 35756384968023552L, 126100789566373960L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_31() {
        long[] data = new long[]{281474976981024L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_32() {
        long[] data = new long[]{140737756803104L, 0x6000002L, 30147328L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_33() {
        long[] data = new long[]{2048L, 0L, 0xFC000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_34() {
        long[] data = new long[]{72057594038978736L, 0L, 72L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_35() {
        long[] data = new long[]{12111807844352L, 9062925770240L, 0x1C0000000000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_36() {
        long[] data = new long[]{281474976981024L, 64L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_37() {
        long[] data = new long[]{281474976981024L, 2L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_38() {
        long[] data = new long[]{9288674231722016L, 2L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_39() {
        long[] data = new long[]{297659788149665824L, 1099612323842L, 294669146424064L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_40() {
        long[] data = new long[]{0x400000000800000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_41() {
        long[] data = new long[]{276828192L, 0x10000008000L, 0xC0000008000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_42() {
        long[] data = new long[]{72057594037930128L, 0L, 72L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_43() {
        long[] data = new long[]{281474981242912L, 1374389534832L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_44() {
        long[] data = new long[]{12111807844352L, 35756384968023552L, 0x1C0000000000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_45() {
        long[] data = new long[]{2449979091231705216L, 288232575174967488L, 0x40000000000DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_46() {
        long[] data = new long[]{140737756803104L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_47() {
        long[] data = new long[]{281474976981024L, 396316767208603712L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_48() {
        long[] data = new long[]{281474976981024L, 0x500000000000040L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_49() {
        long[] data = new long[]{281474976981024L, 0x400000000000040L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_50() {
        long[] data = new long[]{281475247513632L, 274936627268L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_51() {
        long[] data = new long[]{281475245416480L, 274936627268L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_52() {
        long[] data = new long[]{281475245416480L, 0x4000000040L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_53() {
        long[] data = new long[]{0L, 0x400000L, 0x1C0000000000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_54() {
        long[] data = new long[]{281474976981024L, 0x4000000040L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_55() {
        long[] data = new long[]{9288674231722016L, 0x400000000040L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_56() {
        long[] data = new long[]{9288674231722016L, 64L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_57() {
        long[] data = new long[]{140737756803104L, 0x6000002L, 281475006857984L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_58() {
        long[] data = new long[]{140737756803106L, 0x6000002L, 281475006857984L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_59() {
        long[] data = new long[]{140737756803104L, 100663314L, 281475006857984L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_60() {
        long[] data = new long[]{422212733771808L, 24640L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_61() {
        long[] data = new long[]{140737756798976L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_62() {
        long[] data = new long[]{140738293674016L, 100663314L, 281475006857984L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_63() {
        long[] data = new long[]{0xC02020L, 0x100000008L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_64() {
        long[] data = new long[]{0x200000L, 32L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_65() {
        long[] data = new long[]{140737758900256L, 4395630602L, 281475006857984L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_66() {
        long[] data = new long[]{75776L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_67() {
        long[] data = new long[]{2449979091231705232L, 288232575174967488L, 0x40000000004DL, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_68() {
        long[] data = new long[]{9288674231726112L, 0x400000000042L, 4096L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_69() {
        long[] data = new long[]{0x10002000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_70() {
        long[] data = new long[]{0x200000L, 0x18000000L, 126100789566373892L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_71() {
        long[] data = new long[]{32L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_72() {
        long[] data = new long[]{0L, 0L, 16L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_73() {
        long[] data = new long[]{17592186116240L, 9147937212989696L, 126100793830932552L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_74() {
        long[] data = new long[]{6144L, 0L, 4227891200L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_75() {
        long[] data = new long[]{6144L, 0L, 0xFC000000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_76() {
        long[] data = new long[]{17592186116240L, 9147937212989696L, 126100793830965320L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_77() {
        long[] data = new long[]{140737765183520L, 0x10000008000L, 0xC0000008000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_78() {
        long[] data = new long[]{8224L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_79() {
        long[] data = new long[]{9429411988516896L, 70368844841026L, 30151424L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_80() {
        long[] data = new long[]{140737756803104L, 0L, 262144L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_81() {
        long[] data = new long[]{140737756803104L, 2L, 262144L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_82() {
        long[] data = new long[]{0L, 0x6000000L, 29360896L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_83() {
        long[] data = new long[]{140737756803104L, 2L, 786432L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_84() {
        long[] data = new long[]{17592186116240L, 9147937213022464L, 126100793830932552L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_85() {
        long[] data = new long[]{140737757851680L, 0x6000002L, 30147328L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_86() {
        long[] data = new long[]{9429411988516896L, 71468356468802L, 30151424L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_87() {
        long[] data = new long[]{0x400000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_88() {
        long[] data = new long[]{270368L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_89() {
        long[] data = new long[]{0x800000L, 0L, 0x80000008000L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_90() {
        long[] data = new long[]{0x2000000000800800L, 0L, 32768L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_91() {
        long[] data = new long[]{2306511512283383808L, 32768L, 149632L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_92() {
        long[] data = new long[]{0x800000L, 0x40000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_93() {
        long[] data = new long[]{0x10000020L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_94() {
        long[] data = new long[]{65536L, 140737958248704L, 0x1C0000000000000L, 0L, 0L, 0L};
        return data;
    }
}

