/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.iox.ilisite.ILIREPOSITORY09;
import ch.ehi.iox.ilisite.IliRepository09.ModelName_;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata_SchemaLanguage;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;

public class MakeIliModelsXml {
    public static final String META_ORIGINAL = "Original";
    public static final String META_FURTHER_METADATA = "furtherMetadata";
    public static final String META_PRECURSOR_VERSION = "precursorVersion";
    public static final String META_TAGS = "tags";
    public static final String META_FURTHER_INFORMATION = "furtherInformation";
    public static final String META_ID_GEO_IV = "IDGeoIV";
    public static final String META_TECHNICAL_CONTACT = "technicalContact";
    public static final String DEFAULT_ILIDIRS = "http://models.interlis.ch/;%JAR_DIR";
    public static final String APP_NAME = "mkilimodelsxml";
    private String version = null;
    private String ilidirs = "http://models.interlis.ch/;%JAR_DIR";
    private long newtid = 0L;

    public static void main(String[] args) {
        new MakeIliModelsXml().mymain(args);
    }

    /*
     * WARNING - void declaration
     */
    public void mymain(String[] args) {
        block60: {
            String httpProxyHost = null;
            String httpProxyPort = null;
            try {
                String outFile = null;
                int argi = 0;
                while (argi < args.length) {
                    String arg = args[argi];
                    if (args[argi].equals("--proxy")) {
                        httpProxyHost = args[++argi];
                    } else if (args[argi].equals("--proxyPort")) {
                        httpProxyPort = args[++argi];
                    } else if (args[argi].equals("--ilidirs")) {
                        this.ilidirs = args[++argi];
                    } else if (arg.equals("--trace")) {
                        EhiLogger.getInstance().setTraceFilter(false);
                    } else if (arg.equals("--quiet")) {
                        StdListener.getInstance().skipInfo(true);
                    } else {
                        if (arg.equals("--version")) {
                            this.printVersion();
                            return;
                        }
                        if (arg.equals("--o")) {
                            outFile = args[++argi];
                        } else {
                            if (arg.equals("--help")) {
                                this.printHelp();
                                return;
                            }
                            if (!arg.startsWith("-")) break;
                            EhiLogger.logAdaption(String.valueOf(arg) + ": unknown option; ignored");
                        }
                    }
                    ++argi;
                }
                if (argi == args.length) {
                    this.printHelp();
                    return;
                }
                if (argi + 1 != args.length) {
                    this.printHelp();
                    return;
                }
                String repositoryRoot = args[argi];
                if (outFile == null) {
                    outFile = String.valueOf(repositoryRoot) + File.separator + "ilimodels.xml";
                }
                HashMap<String, ArrayList<ModelMetadata>> oldfiles = null;
                File out = new File(outFile);
                if (out.exists()) {
                    oldfiles = this.readIliModelsXml(out);
                }
                if (oldfiles == null) {
                    oldfiles = new HashMap();
                }
                ArrayList<ModelMetadata> models = new ArrayList<ModelMetadata>(MakeIliModelsXml.scanIliFileDir(new File(repositoryRoot)));
                HashMap<String, ArrayList<ModelMetadata>> newfiles = this.createFilelist(models);
                HashSet<ModelMetadata> newModels = new HashSet<ModelMetadata>();
                ArrayList<void> updatedModels = new ArrayList<void>();
                for (ModelMetadata modelMetadata : models) {
                    void var14_15;
                    ModelMetadata theOldModel = null;
                    if (oldfiles.containsKey(modelMetadata.getFile())) {
                        ArrayList<ModelMetadata> oldmodels = oldfiles.get(modelMetadata.getFile());
                        for (ModelMetadata oldmodel : oldmodels) {
                            if (!oldmodel.getName().equals(modelMetadata.getName())) continue;
                            theOldModel = oldmodel;
                            break;
                        }
                        if (theOldModel != null) {
                            ModelName_[] deps;
                            theOldModel.setmd5(modelMetadata.getmd5());
                            theOldModel.setattrundefined("dependsOnModel");
                            ModelName_[] modelName_Array = deps = modelMetadata.getdependsOnModel();
                            int n = deps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ModelName_ dep = modelName_Array[n2];
                                theOldModel.adddependsOnModel(dep);
                                ++n2;
                            }
                            ModelMetadata modelMetadata2 = theOldModel;
                        } else {
                            newModels.add(modelMetadata);
                            modelMetadata.setobjectoid(Long.toString(this.newtid));
                            ++this.newtid;
                        }
                    } else {
                        newModels.add(modelMetadata);
                        modelMetadata.setobjectoid(Long.toString(this.newtid));
                        ++this.newtid;
                    }
                    updatedModels.add(var14_15);
                }
                models = updatedModels;
                HashMap<String, ArrayList<ModelMetadata>> files = this.createFilelist(newModels);
                for (String theNewFile : files.keySet()) {
                    IliFiles tempIliFiles = RepositoryAccess.createIliFiles(repositoryRoot, newModels);
                    UserSettings settings = new UserSettings();
                    settings.setHttpProxyHost(httpProxyHost);
                    settings.setHttpProxyPort(httpProxyPort);
                    settings.setIlidirs(String.valueOf(repositoryRoot) + ";" + this.ilidirs);
                    settings.setTransientObject("ch.interlis.ili2c.tempReposIliFiles", tempIliFiles);
                    settings.setTransientObject("ch.interlis.ili2c.tempReposUri", repositoryRoot);
                    Configuration config = new Configuration();
                    FileEntry file = new FileEntry(new File(repositoryRoot, theNewFile).getAbsolutePath(), 1);
                    config.addFileEntry(file);
                    config.setAutoCompleteModelList(true);
                    config.setGenerateWarnings(false);
                    config.setOutputKind(1);
                    TransferDescription td = Main.runCompiler(config, settings);
                    if (td == null) continue;
                    ArrayList<ModelMetadata> modelv = files.get(theNewFile);
                    for (ModelMetadata model : modelv) {
                        String original;
                        String furtherMetadata;
                        String furtherInfo;
                        String precursorVersion;
                        String technicalContact;
                        Model modelDef = (Model)td.getElement(Model.class, model.getName());
                        if (modelDef == null) continue;
                        String title = modelDef.getDocumentation();
                        if (title != null) {
                            int titleEnd = title.indexOf(46);
                            if (titleEnd > 0) {
                                String doc = StringUtility.purge(title.substring(titleEnd + 1));
                                title = StringUtility.purge(title.substring(0, titleEnd + 1));
                                if (doc != null) {
                                    model.setshortDescription(doc);
                                }
                                if (title != null) {
                                    model.setTitle(title);
                                }
                            } else {
                                model.setTitle(title);
                            }
                        }
                        if ((technicalContact = modelDef.getMetaValue(META_TECHNICAL_CONTACT)) != null) {
                            model.settechnicalContact(technicalContact);
                        }
                        if ((precursorVersion = modelDef.getMetaValue(META_PRECURSOR_VERSION)) != null) {
                            model.setprecursorVersion(precursorVersion);
                        }
                        if ((furtherInfo = modelDef.getMetaValue(META_FURTHER_INFORMATION)) != null) {
                            model.setfurtherInformation(furtherInfo);
                        }
                        if ((furtherMetadata = modelDef.getMetaValue(META_FURTHER_METADATA)) != null) {
                            model.setfurtherMetadata(furtherMetadata);
                        }
                        String idGeoIV = modelDef.getMetaValue(META_ID_GEO_IV);
                        String tags = modelDef.getMetaValue(META_TAGS);
                        if (tags == null) {
                            tags = idGeoIV;
                        } else if (idGeoIV != null) {
                            tags = String.valueOf(tags) + "," + idGeoIV;
                        }
                        if (tags != null) {
                            model.setTags(tags);
                        }
                        if ((original = modelDef.getMetaValue(META_ORIGINAL)) != null) {
                            model.setOriginal(original);
                        }
                        if (!model.getSchemaLanguage().equals(ModelMetadata_SchemaLanguage.ili2_3)) continue;
                        String issuer = modelDef.getIssuer();
                        model.setIssuer(issuer);
                        String version = modelDef.getModelVersion();
                        model.setVersion(version);
                        String versionExpl = modelDef.getModelVersionExpl();
                        if (versionExpl == null) continue;
                        model.setVersionComment(versionExpl);
                    }
                }
                FileOutputStream outStream = null;
                XtfWriterBase ioxWriter = null;
                try {
                    try {
                        outStream = new FileOutputStream(outFile);
                        ioxWriter = new XtfWriterBase(outStream, ILIREPOSITORY09.getIoxMapping(), "2.3");
                        ioxWriter.setModels(new XtfModel[]{ILIREPOSITORY09.getXtfModel()});
                        StartTransferEvent startTransferEvent = new StartTransferEvent();
                        startTransferEvent.setSender("mkilimodelsxml-" + this.getVersion());
                        ioxWriter.write(startTransferEvent);
                        StartBasketEvent startBasketEvent = new StartBasketEvent("IliRepository09.RepositoryIndex", "b1");
                        ioxWriter.write(startBasketEvent);
                        for (ModelMetadata model : models) {
                            ioxWriter.write(new ch.interlis.iox_j.ObjectEvent(model));
                        }
                        ioxWriter.write(new EndBasketEvent());
                        ioxWriter.write(new ch.interlis.iox_j.EndTransferEvent());
                        ioxWriter.flush();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        EhiLogger.logError(fileNotFoundException);
                        System.exit(1);
                        if (ioxWriter != null) {
                            ioxWriter.close();
                            ioxWriter = null;
                        }
                        if (outStream == null) break block60;
                        try {
                            ((OutputStream)outStream).close();
                        }
                        catch (IOException ex2) {
                            EhiLogger.logError(ex2);
                        }
                        outStream = null;
                    }
                }
                finally {
                    if (ioxWriter != null) {
                        ioxWriter.close();
                        ioxWriter = null;
                    }
                    if (outStream != null) {
                        try {
                            ((OutputStream)outStream).close();
                        }
                        catch (IOException ex) {
                            EhiLogger.logError(ex);
                        }
                        outStream = null;
                    }
                }
            }
            catch (Exception ex) {
                EhiLogger.logError("mkilimodelsxml: failed", ex);
                System.exit(1);
            }
        }
    }

    public static HashSet<ModelMetadata> scanIliFileDir(File startdir) throws IOException {
        int oid = 1;
        if (!startdir.isDirectory()) {
            throw new IllegalArgumentException(startdir + " is not a folder/directory");
        }
        URI starturi = startdir.toURI();
        HashSet<ModelMetadata> ret = new HashSet<ModelMetadata>();
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(startdir);
        GenericFileFilter filter = new GenericFileFilter("INTERLIS models (*.ili)", "ili");
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.remove(0);
            File[] filev = dir.listFiles();
            int i = 0;
            while (i < filev.length) {
                IliFile iliFile;
                if (filev[i].isDirectory()) {
                    dirs.add(filev[i]);
                } else if (filter.accept(filev[i]) && (iliFile = ModelScan.scanIliFile(filev[i])) != null) {
                    URI relPath = starturi.relativize(filev[i].toURI());
                    String md5 = RepositoryAccess.calcMD5(filev[i]);
                    String fileVersion = MakeIliModelsXml.getFileVersion(filev[i]);
                    Iterator modeli = iliFile.iteratorModel();
                    while (modeli.hasNext()) {
                        IliModel iliModel = (IliModel)modeli.next();
                        ModelMetadata model = new ModelMetadata(Integer.toString(oid++));
                        model.setFile(relPath.toString());
                        model.setName(iliModel.getName());
                        double cslVersion = iliModel.getIliVersion();
                        if (cslVersion == 1.0) {
                            model.setSchemaLanguage(ModelMetadata_SchemaLanguage.ili1);
                        } else if (cslVersion == 2.2) {
                            model.setSchemaLanguage(ModelMetadata_SchemaLanguage.ili2_2);
                        } else if (cslVersion == 2.3) {
                            model.setSchemaLanguage(ModelMetadata_SchemaLanguage.ili2_3);
                        } else {
                            throw new IllegalStateException("unexpected ili version");
                        }
                        model.setpublishingDate(fileVersion);
                        model.setVersion(fileVersion);
                        model.setmd5(md5);
                        for (String depModelName : iliModel.getDependencies()) {
                            ModelName_ depModel = new ModelName_();
                            depModel.setvalue(depModelName);
                            model.adddependsOnModel(depModel);
                        }
                        ret.add(model);
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private static String getFileVersion(File file) {
        String fileVersion = new SimpleDateFormat("yyyy-MM-dd").format(new Date(file.lastModified()));
        String fileName = GenericFileFilter.stripFileExtension(file.getName());
        if (fileName.length() >= 10) {
            String dateString = fileName.substring(fileName.length() - 10);
            Date date = null;
            date = new SimpleDateFormat("yyyy-MM-dd").parse(dateString, new ParsePosition(0));
            if (date == null) {
                date = new SimpleDateFormat("yyyyMMdd").parse(dateString, new ParsePosition(2));
            }
            if (date != null) {
                fileVersion = new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
        }
        return fileVersion;
    }

    private void printHelp() {
        this.printVersion();
        System.err.println();
        this.printDescription();
        System.err.println();
        this.printUsage();
        System.err.println();
        System.err.println("OPTIONS");
        System.err.println();
        System.err.println("--o filename           name of outputfile.");
        System.err.println("--trace                enable trace messages.");
        System.err.println("--quiet               Suppress info messages.");
        System.err.println("--ilidirs " + this.ilidirs + " list of directories with ili-files.");
        System.err.println("--proxy host          proxy server to access model repositories.");
        System.err.println("--proxyPort port      proxy port to access model repositories.");
        System.err.println("--help                 Display this help text.");
        System.err.println("--version              Display the version of mkilimodelsxml");
        System.err.println();
    }

    protected void printVersion() {
        System.err.println("mkilimodelsxml, Version " + this.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3401 Burgdorf");
    }

    protected void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Reads INTERLIS models and generates a suitable ilimodels.xml file (according to IliRepository09.");
    }

    protected void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -cp ili2c.jar " + MakeIliModelsXml.class.getName() + " [Options] folder-with-ili-files");
    }

    public String getVersion() {
        if (this.version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch.interlis.iox_j.Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("versionMajor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMinor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMicro"));
            ret.append('-');
            ret.append(resVersion.getString("versionDate"));
            this.version = ret.toString();
        }
        return this.version;
    }

    private HashMap<String, ArrayList<ModelMetadata>> readIliModelsXml(File file) {
        if (file == null) {
            return null;
        }
        ArrayList<ModelMetadata> models = new ArrayList<ModelMetadata>();
        XtfReader reader = null;
        try {
            try {
                reader = new XtfReader(file);
                reader.getFactory().registerFactory(ILIREPOSITORY09.getIoxFactory());
                IoxEvent event = null;
                do {
                    IomObject iomObj;
                    if (!((event = reader.read()) instanceof ObjectEvent) || !((iomObj = ((ObjectEvent)event).getIomObject()) instanceof ModelMetadata)) continue;
                    ModelMetadata model = (ModelMetadata)iomObj;
                    models.add(model);
                    try {
                        long tidInt = Long.parseLong(model.getobjectoid());
                        if (tidInt <= this.newtid) continue;
                        this.newtid = tidInt;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                } while (!(event instanceof EndTransferEvent));
            }
            catch (IoxException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            this.newtid = (this.newtid / 10L + 1L) * 10L;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new IllegalStateException(e);
                }
                reader = null;
            }
        }
        HashMap<String, ArrayList<ModelMetadata>> files = this.createFilelist(models);
        return files;
    }

    private HashMap<String, ArrayList<ModelMetadata>> createFilelist(Collection<ModelMetadata> models) {
        HashMap<String, ArrayList<ModelMetadata>> files = new HashMap<String, ArrayList<ModelMetadata>>();
        for (ModelMetadata model : models) {
            String filename = model.getFile();
            ArrayList<Object> modelv = null;
            if (!files.containsKey(filename)) {
                modelv = new ArrayList();
                files.put(filename, modelv);
            } else {
                modelv = files.get(filename);
            }
            modelv.add(model);
        }
        return files;
    }
}

