/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    private Connector fOriginalTarget;
    private Figure myTarget;
    private ConnectionFigure myConnection;
    private Point fStart;

    protected ChangeConnectionHandle(Figure owner) {
        super(owner);
        this.setConnection((ConnectionFigure)this.owner());
        this.setTargetFigure(null);
    }

    protected abstract Connector target();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setPoint(int var1, int var2);

    protected Connector source() {
        if (this.target() == this.getConnection().getStartConnector()) {
            return this.getConnection().getEndConnector();
        }
        return this.getConnection().getStartConnector();
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.fOriginalTarget = this.target();
        this.fStart = new Point(x, y);
        this.setUndoActivity(this.createUndoActivity(view));
        ((UndoActivity)this.getUndoActivity()).setOldConnector(this.target());
        this.disconnect();
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false);
            }
            this.setTargetFigure(f);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.setPoint(p.x, p.y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target == null) {
            target = this.fOriginalTarget;
        }
        this.setPoint(x, y);
        this.connect(target);
        this.getConnection().updateConnection();
        Connector oldConnector = ((UndoActivity)this.getUndoActivity()).getOldConnector();
        if (oldConnector == null || this.target() == null || oldConnector.owner() == this.target().owner()) {
            this.setUndoActivity(null);
        } else {
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getConnection()));
        }
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false);
            this.setTargetFigure(null);
        }
    }

    private Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && target != this.fOriginalTarget && !target.includes(this.owner()) && this.getConnection().canConnect(this.source().owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.green);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.myConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected void setTargetFigure(Figure newTarget) {
        this.myTarget = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.myTarget;
    }

    protected abstract Undoable createUndoActivity(DrawingView var1);

    public static abstract class UndoActivity
    extends UndoableAdapter {
        private Connector myOldConnector;

        public UndoActivity(DrawingView newView) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.swapConnectors();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.swapConnectors();
            return true;
        }

        private void swapConnectors() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (fe.hasMoreElements()) {
                ConnectionFigure connection = (ConnectionFigure)fe.nextFigure();
                this.setOldConnector(this.replaceConnector(connection));
                connection.updateConnection();
            }
        }

        protected abstract Connector replaceConnector(ConnectionFigure var1);

        public void setOldConnector(Connector newOldConnector) {
            this.myOldConnector = newOldConnector;
        }

        public Connector getOldConnector() {
            return this.myOldConnector;
        }
    }
}

