/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.plugin.loader;

import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.plugin.AbstractPlugin;
import ch.ehi.umleditor.plugin.loader.JARClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class PluginLoader {
    private ArrayList jars = new ArrayList();

    public void loadPlugins(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] plugins = dir.listFiles();
        if (plugins == null) {
            return;
        }
        for (int i = 0; i < plugins.length; ++i) {
            File plugin = plugins[i];
            if (!plugin.getName().toLowerCase().endsWith(".jar")) continue;
            String path = plugin.getAbsolutePath();
            try {
                new JARClassLoader(path, this);
                continue;
            }
            catch (IOException io) {
                LauncherView.getInstance().log("plugin", "Cannot load plugin " + path);
            }
        }
    }

    public void startAllPlugins() {
        for (int i = 0; i < this.jars.size(); ++i) {
            ((JARClassLoader.JAR)this.jars.get(i)).getClassLoader().startAllPlugins();
        }
    }

    public ArrayList getAllPlugins() {
        ArrayList<AbstractPlugin> ret = new ArrayList<AbstractPlugin>();
        for (int i = 0; i < this.jars.size(); ++i) {
            ret.addAll(Arrays.asList(((JARClassLoader.JAR)this.jars.get(i)).getPlugins()));
        }
        return ret;
    }

    public void addPluginJAR(JARClassLoader.JAR jar) {
        this.jars.add(jar);
    }
}

