/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BaseFrame;
import ch.softenvironment.view.swingext.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class WaitDialog
extends BaseDialog {
    public static final int UNKNOWN_PROGRESS = -1;
    private static volatile WaitDialog waitDialog = null;
    private static volatile int waitCounter = 0;
    private static volatile WaitDialog waitDialogThread = null;
    private static volatile int waitCounterThread = 0;
    private JPanel ivjBaseDialogContentPane = null;
    private JLabel ivjLblText = null;
    private JLabel ivjLblImage = null;
    private JProgressBar ivjPrgBar = null;

    private WaitDialog(Frame owner, String title) {
        super(owner, false);
        this.setTitle(title);
        this.initialize();
    }

    private WaitDialog(Dialog owner, String title) {
        super(owner, false);
        this.setTitle(title);
        this.initialize();
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(null);
                this.getBaseDialogContentPane().add((Component)this.getLblImage(), this.getLblImage().getName());
                this.getBaseDialogContentPane().add((Component)this.getLblText(), this.getLblText().getName());
                this.getBaseDialogContentPane().add((Component)this.getPrgBar(), this.getPrgBar().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JLabel getLblImage() {
        if (this.ivjLblImage == null) {
            try {
                this.ivjLblImage = new JLabel();
                this.ivjLblImage.setName("LblImage");
                this.ivjLblImage.setText("JLabel1");
                this.ivjLblImage.setBounds(16, 14, 120, 232);
                this.ivjLblImage.setText("");
                this.ivjLblImage.setIcon(ResourceBundle.getImageIcon(WaitDialog.class, "traffic_redlight.png"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblImage;
    }

    protected JLabel getLblText() {
        if (this.ivjLblText == null) {
            try {
                this.ivjLblText = new JLabel();
                this.ivjLblText.setName("LblText");
                this.ivjLblText.setText("Bitte gedulden Sie sich einen Moment...");
                this.ivjLblText.setBounds(162, 176, 254, 14);
                this.ivjLblText.setText(ResourceManager.getResource(WaitDialog.class, "LblText_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblText;
    }

    protected JProgressBar getPrgBar() {
        if (this.ivjPrgBar == null) {
            try {
                this.ivjPrgBar = new JProgressBar();
                this.ivjPrgBar.setName("PrgBar");
                this.ivjPrgBar.setBounds(162, 93, 167, 14);
                this.ivjPrgBar.setValue(0);
                this.getPrgBar().setStringPainted(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPrgBar;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initialize() {
        try {
            this.setResizable(false);
            this.setName("WaitDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 289);
            this.setContentPane(this.getBaseDialogContentPane());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getPrgBar().setVisible(false);
    }

    public static void showBusy(Frame owner, Runnable block) {
        if (owner == null) {
            Tracer.getInstance().developerWarning("WaitDialog suppressed because owner unknown!");
        }
        if (++waitCounter == 1) {
            try {
                owner.setCursor(Cursor.getPredefinedCursor(3));
                waitDialog = new WaitDialog(owner, ResourceManager.getResource(WaitDialog.class, "DlgTitle"));
                waitDialog.setVisible(true);
                waitDialog.paint(waitDialog.getGraphics());
            }
            catch (Throwable e) {
                Tracer.getInstance().runtimeWarning("fork WaitDialog failed: " + e.toString());
                waitDialog = null;
                owner.setCursor(Cursor.getPredefinedCursor(0));
                waitCounter = 0;
            }
        }
        try {
            block.run();
        }
        catch (Throwable e) {
            Tracer.getInstance().runtimeError("Block failed", e);
            BaseFrame.showException(owner, e);
        }
        if (--waitCounter == 0) {
            try {
                waitDialog.dispose();
            }
            catch (Throwable e) {
                Tracer.getInstance().runtimeWarning("#finished() could not dispose() WaitDialog correctly!");
            }
            waitDialog = null;
            owner.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static void showBusyThread(final Frame owner, final Runnable block) {
        if (++waitCounterThread == 1) {
            try {
                waitDialogThread = new WaitDialog(owner, ResourceManager.getResource(WaitDialog.class, "DlgTitleThread"));
                waitDialogThread.setVisible(true);
                WaitDialog.updateProgressThread(-1, ResourceManager.getResource(WaitDialog.class, "LblText_text"));
            }
            catch (Throwable e) {
                Tracer.getInstance().runtimeWarning("show WaitDialog failed: " + e.getLocalizedMessage());
                waitDialogThread = null;
                waitCounterThread = 0;
            }
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    block.run();
                }
                catch (Throwable e) {
                    Tracer.getInstance().runtimeError("showBusyThread(Runnable)->Block failed", e);
                    BaseFrame.showException(owner, e);
                }
                return null;
            }

            @Override
            public void finished() {
                if (--waitCounterThread == 0) {
                    try {
                        waitDialogThread.dispose();
                    }
                    catch (Throwable e) {
                        Tracer.getInstance().runtimeWarning("showBusyThread()#finished() could not dispose() WaitDialog correctly!");
                    }
                    waitDialogThread = null;
                }
            }
        };
        worker.start();
    }

    public static void updateProgress(int percentage, String currentActivity) {
        try {
            waitDialog.getPrgBar().setVisible(true);
            if (percentage > 0) {
                waitDialog.getPrgBar().setValue(percentage);
            } else {
                waitDialog.getPrgBar().setIndeterminate(false);
            }
            if (currentActivity != null) {
                waitDialog.getLblText().setText(currentActivity);
            }
            waitDialog.paint(waitDialog.getGraphics());
        }
        catch (NullPointerException ex) {
            Tracer.getInstance().developerWarning("IGNORE: use #showBusy() first: %=" + percentage + " activity: " + currentActivity);
        }
        catch (Throwable e) {
            Tracer.getInstance().developerWarning("IGNORE: " + e.getLocalizedMessage());
        }
    }

    public static void updateProgressThread(final int percentage, final String currentActivity) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    waitDialogThread.getPrgBar().setVisible(true);
                    if (percentage > 0) {
                        waitDialogThread.getPrgBar().setValue(percentage);
                    } else {
                        waitDialogThread.getPrgBar().setIndeterminate(false);
                    }
                    if (currentActivity != null) {
                        waitDialogThread.getLblText().setText(currentActivity);
                    }
                }
                catch (Throwable e) {
                    Tracer.getInstance().developerWarning("updateProgressThread(..)->Ignoring: " + e.getLocalizedMessage());
                }
            }
        });
    }
}

