/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.MIME2Java;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.SchemaWriter;
import com.ibm.xmi.framework.WriterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class XMISchema {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String encoding = "UTF-8";
    protected int indent = 2;
    private Vector decls;
    private File file;
    private String version = "2.0";
    private Namespace namespace;

    public XMISchema(String string) {
        this.file = new File(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Collection getDeclarations() {
        if (this.decls == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.decls);
    }

    public Namespace getTargetNamespace() {
        return this.namespace;
    }

    public String getVersion() {
        return this.version;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setTargetNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void write(Iterator iterator) throws Exception {
        Object object;
        if (iterator == null) {
            this.decls = new Vector(1);
        } else {
            this.decls = new Vector(10);
            while (iterator.hasNext()) {
                this.decls.addElement(iterator.next());
            }
        }
        String string = this.file.getParent();
        if (string != null) {
            object = new File(string);
            ((File)object).mkdirs();
        }
        object = null;
        if (!this.file.getPath().equals("")) {
            object = new FileOutputStream(this.file);
        }
        String string2 = MIME2Java.convert(this.encoding);
        PrintWriter printWriter = null;
        if (object != null) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)object, string2));
        } else {
            System.out.println("Sf equals null....failure imminent!!!");
        }
        PrintXML.setPrintWriter(printWriter);
        SchemaWriter schemaWriter = WriterFactory.makeSchemaWriter(this, this.version);
        schemaWriter.write(0, this.indent);
        ((OutputStream)object).close();
    }
}

