/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.io.IOException;
import org.freehep.graphicsio.AbstractPathConstructor;

public abstract class QuadToCubicPathConstructor
extends AbstractPathConstructor {
    protected QuadToCubicPathConstructor() {
    }

    public void move(double x, double y) throws IOException {
        this.currentX = x;
        this.currentY = y;
    }

    public void line(double x, double y) throws IOException {
        this.currentX = x;
        this.currentY = y;
    }

    public void quad(double x1, double y1, double x2, double y2) throws IOException {
        double xctrl1 = x1 + (this.currentX - x1) / 3.0;
        double yctrl1 = y1 + (this.currentY - y1) / 3.0;
        double xctrl2 = x1 + (x2 - x1) / 3.0;
        double yctrl2 = y1 + (y2 - y1) / 3.0;
        this.cubic(xctrl1, yctrl1, xctrl2, yctrl2, x2, y2);
        this.currentX = x2;
        this.currentY = y2;
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.currentX = x3;
        this.currentY = y3;
    }

    public void closePath() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }
}

