/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XMLNodeTraverser {
    private NamedNodeMap attrs;

    public void traverse(Node node) throws BadXMLException {
        if (node instanceof Element) {
            this.attrs = ((Element)node).getAttributes();
            this.handleElementAttributes(this.attrs);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.handleSubNode(n, n.getNodeName());
        }
        this.attrs = null;
    }

    protected void handleSubNode(Node node, String name) throws BadXMLException {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                this.handleElement((Element)node, name);
                break;
            }
            case 3: {
                this.handleTextNode((Text)node, name);
                break;
            }
            default: {
                this.handleOtherNode(node, name);
            }
        }
    }

    protected void handleElementAttributes(NamedNodeMap nnm) throws BadXMLException {
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            this.handleAttributeNode(attr, attr.getName(), attr.getValue());
        }
    }

    protected void handleElement(Element node, String name) throws BadXMLException {
        throw new BadXMLException("Unhandled Element node " + node);
    }

    protected void handleTextNode(Text node, String name) throws BadXMLException {
    }

    protected void handleAttributeNode(Attr node, String name, String value) throws BadXMLException {
        throw new BadXMLException("Unhandled Attribute node " + node);
    }

    protected void handleOtherNode(Node node, String name) throws BadXMLException {
        throw new BadXMLException("Unhandled Other node " + node + " type=" + node.getNodeType());
    }

    public int toInt(String value) throws BadXMLException {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad integer value " + value);
        }
    }

    public String getAttributeValue(String name) {
        if (this.attrs == null) {
            return null;
        }
        Node attr = this.attrs.getNamedItem(name);
        if (attr == null) {
            return null;
        }
        return attr.getNodeValue();
    }

    public boolean toBoolean(String value) throws BadXMLException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BadXMLException("Bad boolean value " + value);
    }

    public double toDouble(String value) throws BadXMLException {
        try {
            return new Double(value);
        }
        catch (Throwable x) {
            throw new BadXMLException("Bad double value " + value);
        }
    }

    public static class BadXMLException
    extends Exception {
        public BadXMLException() {
        }

        public BadXMLException(String s) {
            super(s);
        }
    }
}

