/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.helper;

import com.baselet.diagram.draw.helper.StyleException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ColorOwn {
    public static final String EXAMPLE_TEXT = "color string (green,...) or code (#3c7a00,...)";
    public static final ColorOwn RED = new ColorOwn(255, 0, 0, Transparency.FOREGROUND);
    public static final ColorOwn GREEN = new ColorOwn(0, 255, 0, Transparency.FOREGROUND);
    public static final ColorOwn BLUE = new ColorOwn(0, 0, 255, Transparency.FOREGROUND);
    public static final ColorOwn YELLOW = new ColorOwn(255, 255, 0, Transparency.FOREGROUND);
    public static final ColorOwn MAGENTA = new ColorOwn(255, 0, 255, Transparency.FOREGROUND);
    public static final ColorOwn WHITE = new ColorOwn(255, 255, 255, Transparency.FOREGROUND);
    public static final ColorOwn BLACK = new ColorOwn(0, 0, 0, Transparency.FOREGROUND);
    public static final ColorOwn ORANGE = new ColorOwn(255, 165, 0, Transparency.FOREGROUND);
    public static final ColorOwn CYAN = new ColorOwn(0, 255, 255, Transparency.FOREGROUND);
    public static final ColorOwn DARK_GRAY = new ColorOwn(70, 70, 70, Transparency.FOREGROUND);
    public static final ColorOwn GRAY = new ColorOwn(120, 120, 120, Transparency.FOREGROUND);
    public static final ColorOwn LIGHT_GRAY = new ColorOwn(200, 200, 200, Transparency.FOREGROUND);
    public static final ColorOwn PINK = new ColorOwn(255, 175, 175, Transparency.FOREGROUND);
    public static final ColorOwn TRANSPARENT = WHITE.transparency(Transparency.FULL_TRANSPARENT);
    public static final ColorOwn SELECTION_FG = BLUE;
    public static final ColorOwn SELECTION_BG = new ColorOwn(0, 0, 255, Transparency.SELECTION_BACKGROUND);
    public static final ColorOwn STICKING_POLYGON = new ColorOwn(100, 180, 255, Transparency.FOREGROUND);
    public static final ColorOwn SYNTAX_HIGHLIGHTING = new ColorOwn(0, 100, 255, Transparency.FOREGROUND);
    public static final ColorOwn DEFAULT_FOREGROUND = BLACK;
    public static final ColorOwn DEFAULT_BACKGROUND = TRANSPARENT;
    public static final Map<String, ColorOwn> COLOR_MAP;
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    static {
        HashMap<String, ColorOwn> colorMap = new HashMap<String, ColorOwn>();
        colorMap.put("black", BLACK);
        colorMap.put("blue", BLUE);
        colorMap.put("cyan", CYAN);
        colorMap.put("dark_gray", DARK_GRAY);
        colorMap.put("gray", GRAY);
        colorMap.put("green", GREEN);
        colorMap.put("light_gray", LIGHT_GRAY);
        colorMap.put("magenta", MAGENTA);
        colorMap.put("orange", ORANGE);
        colorMap.put("pink", PINK);
        colorMap.put("red", RED);
        colorMap.put("white", WHITE);
        colorMap.put("yellow", YELLOW);
        colorMap.put("none", TRANSPARENT);
        COLOR_MAP = Collections.unmodifiableMap(colorMap);
    }

    public ColorOwn(int red, int green, int blue, Transparency transparency) {
        this(red, green, blue, transparency.getAlpha());
    }

    public ColorOwn(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ColorOwn(String hex) {
        int i = Integer.decode(hex);
        this.red = i >> 16 & 0xFF;
        this.green = i >> 8 & 0xFF;
        this.blue = i & 0xFF;
        this.alpha = Transparency.FOREGROUND.getAlpha();
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public ColorOwn transparency(Transparency transparency) {
        return this.transparency(transparency.getAlpha());
    }

    public ColorOwn transparency(int alpha) {
        return new ColorOwn(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public ColorOwn darken(int factor) {
        return new ColorOwn(Math.max(0, this.getRed() - factor), Math.max(0, this.getGreen() - factor), Math.max(0, this.getBlue() - factor), this.getAlpha());
    }

    public static ColorOwn forStringOrNull(String colorString, Transparency transparency) {
        try {
            return ColorOwn.forString(colorString, transparency);
        }
        catch (StyleException e) {
            return null;
        }
    }

    public static ColorOwn forString(String colorString, Transparency transparency) {
        return ColorOwn.forString(colorString, transparency.alpha);
    }

    public static ColorOwn forString(String colorString, int transparency) {
        boolean error = false;
        ColorOwn returnColor = null;
        if (colorString == null) {
            error = true;
        } else {
            for (Map.Entry<String, ColorOwn> c : COLOR_MAP.entrySet()) {
                if (!colorString.equalsIgnoreCase(c.getKey())) continue;
                returnColor = c.getValue();
                break;
            }
            if (returnColor == null) {
                try {
                    returnColor = new ColorOwn(colorString);
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (returnColor != null) {
                returnColor = returnColor.transparency(transparency);
            }
        }
        if (error) {
            throw new StyleException("value must be a color string (green,...) or code (#3c7a00,...)");
        }
        return returnColor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorOwn other = (ColorOwn)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }

    public String toString() {
        return "ColorOwn [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    public static enum Transparency {
        FOREGROUND(255),
        FULL_TRANSPARENT(0),
        DEPRECATED_WARNING(175),
        BACKGROUND(125),
        SELECTION_BACKGROUND(20);

        private int alpha;

        private Transparency(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }
}

