/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;

public class SyntaxMenu
extends ExtensionPopupMenu {
    private static final long serialVersionUID = 8472491919281117716L;
    private static final String MENU_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.popup.syntax.label");
    private static final String AUTO_DETECT_SYNTAX_OPTION = Constant.messages.getString("http.panel.view.syntaxtext.popup.syntax.autoDetect");
    private JCheckBoxMenuItem autoDetectSyntax;
    private JPopupMenu.Separator autoDetectSyntaxSeparator;
    private ButtonGroup syntaxStylesButtonGroup = new ButtonGroup();
    private Map<String, JRadioButtonMenuItem> syntaxOptions = new HashMap<String, JRadioButtonMenuItem>();
    private JPopupMenu.Separator plainSyntaxSeparator;

    public SyntaxMenu() {
        super(MENU_LABEL);
        this.autoDetectSyntax = new JCheckBoxMenuItem(new ChangeAutoDetectSyntaxAction(AUTO_DETECT_SYNTAX_OPTION));
        this.add(this.autoDetectSyntax);
        this.autoDetectSyntaxSeparator = new JPopupMenu.Separator();
        this.add(this.autoDetectSyntaxSeparator);
        this.addSyntaxOption(HttpPanelSyntaxHighlightTextArea.PLAIN_SYNTAX_LABEL, "text/plain");
        this.syntaxOptions.get("text/plain").setSelected(true);
        this.plainSyntaxSeparator = new JPopupMenu.Separator();
        this.add(this.plainSyntaxSeparator);
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if (component instanceof HttpPanelSyntaxHighlightTextArea) {
            HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)component);
            this.updateState(httpPanelSyntaxHighlightTextArea);
            return true;
        }
        return false;
    }

    @Override
    public boolean precedeWithSeparator() {
        return true;
    }

    public void updateState(HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea) {
        JRadioButtonMenuItem jRadioButtonMenuItem;
        String string;
        Object object;
        if (httpPanelSyntaxHighlightTextArea instanceof AutoDetectSyntaxHttpPanelTextArea) {
            object = (AutoDetectSyntaxHttpPanelTextArea)httpPanelSyntaxHighlightTextArea;
            this.autoDetectSyntax.setSelected(((AutoDetectSyntaxHttpPanelTextArea)object).isAutoDetectSyntax());
            this.autoDetectSyntax.setVisible(true);
            this.autoDetectSyntaxSeparator.setVisible(true);
        } else {
            this.autoDetectSyntax.setVisible(false);
            this.autoDetectSyntaxSeparator.setVisible(false);
        }
        object = httpPanelSyntaxHighlightTextArea.getSyntaxStyles();
        boolean bl = true;
        if (bl && ((Vector)object).size() == 1) {
            bl = false;
        }
        this.plainSyntaxSeparator.setVisible(bl);
        Iterator<JRadioButtonMenuItem> iterator = this.syntaxOptions.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setVisible(false);
        }
        this.syntaxOptions.get("text/plain").setVisible(true);
        if (bl) {
            Iterator iterator2 = ((Vector)object).iterator();
            while (iterator2.hasNext()) {
                HttpPanelSyntaxHighlightTextArea.SyntaxStyle syntaxStyle = (HttpPanelSyntaxHighlightTextArea.SyntaxStyle)iterator2.next();
                string = syntaxStyle.getStyleKey();
                jRadioButtonMenuItem = this.syntaxOptions.get(string);
                if (jRadioButtonMenuItem != null) {
                    jRadioButtonMenuItem.setVisible(true);
                    continue;
                }
                this.addSyntaxOption(syntaxStyle.getLabel(), string);
                this.syntaxOptions.get(string).setVisible(true);
            }
        }
        if ((jRadioButtonMenuItem = this.syntaxOptions.get(string = httpPanelSyntaxHighlightTextArea.getSyntaxEditingStyle())) != null) {
            jRadioButtonMenuItem.setSelected(true);
        } else if ("text/plain".equals(string)) {
            this.syntaxOptions.get("text/plain").setSelected(true);
        }
    }

    private void addSyntaxOption(String string, String string2) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new ChangeSyntaxAction(string, string2));
        this.syntaxStylesButtonGroup.add(jRadioButtonMenuItem);
        this.add(jRadioButtonMenuItem);
        this.syntaxOptions.put(string2, jRadioButtonMenuItem);
    }

    private static class ChangeAutoDetectSyntaxAction
    extends TextAction {
        private static final long serialVersionUID = -6045054098695629693L;

        public ChangeAutoDetectSyntaxAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof AutoDetectSyntaxHttpPanelTextArea) {
                AutoDetectSyntaxHttpPanelTextArea autoDetectSyntaxHttpPanelTextArea;
                autoDetectSyntaxHttpPanelTextArea.setAutoDetectSyntax(!(autoDetectSyntaxHttpPanelTextArea = (AutoDetectSyntaxHttpPanelTextArea)((Object)jTextComponent)).isAutoDetectSyntax());
            }
        }
    }

    private static class ChangeSyntaxAction
    extends TextAction {
        private static final long serialVersionUID = 5136037355346821365L;
        private final String styleKey;

        public ChangeSyntaxAction(String string, String string2) {
            super(string);
            this.styleKey = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)jTextComponent);
                httpPanelSyntaxHighlightTextArea.setSyntaxEditingStyle(this.styleKey);
            }
        }
    }
}

