/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptParam
extends AbstractParam {
    private static final String SCRIPTS_BASE_KEY = "script";
    private static final String PARAM_DEFAULT_SCRIPT = "script.defaultScript";
    private static final String PARAM_DEFAULT_DIR = "script.defaultDir";
    private static final String ALL_SCRIPTS_KEY = "script.scripts";
    private static final String SCRIPT_NAME_KEY = "name";
    private static final String SCRIPT_DESC_KEY = "description";
    private static final String SCRIPT_ENGINE_KEY = "engine";
    private static final String SCRIPT_TYPE_KEY = "type";
    private static final String SCRIPT_FILE_KEY = "file";
    private static final String SCRIPT_ENABLED_KEY = "enabled";
    private static final String SCRIPT_DIRS = "dirs";
    private static final String SCRIPT_CONFIRM_REMOVE_DIR = "confRemdir";
    private static final Logger logger = Logger.getLogger(ScriptParam.class);
    private String defaultScript = null;
    private String defaultDir = null;
    private Set<ScriptWrapper> scripts;
    private List<File> scriptDirs;
    private boolean confirmRemoveDir = true;

    @Override
    protected void parse() {
        Object object;
        this.defaultScript = this.getConfig().getString(PARAM_DEFAULT_SCRIPT, "");
        this.defaultDir = this.getConfig().getString(PARAM_DEFAULT_DIR, "");
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_SCRIPTS_KEY);
            this.scripts = new HashSet<ScriptWrapper>(list.size());
            ArrayList arrayList = new ArrayList(list.size());
            object = list.iterator();
            while (object.hasNext()) {
                HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)object.next();
                String string = hierarchicalConfiguration.getString(SCRIPT_NAME_KEY, "");
                try {
                    if ("".equals(string) || arrayList.contains(string)) continue;
                    arrayList.add(string);
                    File file = new File(hierarchicalConfiguration.getString(SCRIPT_FILE_KEY));
                    if (!file.exists()) {
                        logger.error((Object)("Script '" + file.getAbsolutePath() + "' does not exist"));
                        continue;
                    }
                    ScriptWrapper scriptWrapper = new ScriptWrapper(hierarchicalConfiguration.getString(SCRIPT_NAME_KEY), hierarchicalConfiguration.getString(SCRIPT_DESC_KEY), hierarchicalConfiguration.getString(SCRIPT_ENGINE_KEY), hierarchicalConfiguration.getString(SCRIPT_TYPE_KEY), hierarchicalConfiguration.getBoolean(SCRIPT_ENABLED_KEY), file);
                    scriptWrapper.setLoadOnStart(true);
                    this.scripts.add(scriptWrapper);
                }
                catch (Exception exception) {
                    logger.error((Object)("Error while loading the script: " + string), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error while loading the scripts: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            this.scriptDirs = new ArrayList<File>();
            for (ArrayList arrayList : this.getConfig().getList(SCRIPT_DIRS)) {
                object = new File((String)((Object)arrayList));
                if (!((File)object).exists() || !((File)object).isDirectory()) {
                    logger.error((Object)("Not a valid script directory: " + arrayList));
                    continue;
                }
                this.scriptDirs.add((File)object);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error while loading the script dirs: " + exception.getMessage()), (Throwable)exception);
        }
        this.confirmRemoveDir = this.getConfig().getBoolean(SCRIPT_CONFIRM_REMOVE_DIR, true);
    }

    public void addScript(ScriptWrapper scriptWrapper) {
        this.scripts.add(scriptWrapper);
    }

    public void removeScript(ScriptWrapper scriptWrapper) {
        this.scripts.remove(scriptWrapper);
    }

    public void saveScripts() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SCRIPTS_KEY);
        int n = 0;
        for (ScriptWrapper scriptWrapper : this.scripts) {
            if (!scriptWrapper.isLoadOnStart()) continue;
            String string = "script.scripts(" + n + ").";
            this.getConfig().setProperty(string + SCRIPT_NAME_KEY, (Object)scriptWrapper.getName());
            this.getConfig().setProperty(string + SCRIPT_DESC_KEY, (Object)scriptWrapper.getDescription());
            this.getConfig().setProperty(string + SCRIPT_ENGINE_KEY, (Object)scriptWrapper.getEngineName());
            this.getConfig().setProperty(string + SCRIPT_TYPE_KEY, (Object)scriptWrapper.getTypeName());
            this.getConfig().setProperty(string + SCRIPT_ENABLED_KEY, (Object)scriptWrapper.isEnabled());
            this.getConfig().setProperty(string + SCRIPT_FILE_KEY, (Object)scriptWrapper.getFile().getAbsolutePath());
            ++n;
        }
    }

    public Set<ScriptWrapper> getScripts() {
        return this.scripts;
    }

    public void addScriptDir(File file) {
        this.scriptDirs.add(file);
        this.saveScriptDirs();
    }

    public void removeScriptDir(File file) {
        this.scriptDirs.remove(file);
        this.saveScriptDirs();
    }

    private void saveScriptDirs() {
        this.getConfig().setProperty(SCRIPT_DIRS, this.scriptDirs);
    }

    public List<File> getScriptDirs() {
        return this.scriptDirs;
    }

    public void setScriptDirs(List<File> list) {
        this.scriptDirs = list;
        this.saveScriptDirs();
    }

    public String getDefaultScript() {
        return this.defaultScript;
    }

    public void setDefaultScript(String string) {
        this.defaultScript = string;
        this.getConfig().setProperty(PARAM_DEFAULT_SCRIPT, (Object)this.defaultScript);
    }

    public String getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(String string) {
        this.defaultDir = string;
        this.getConfig().setProperty(PARAM_DEFAULT_DIR, (Object)this.defaultDir);
    }

    public void setConfirmRemoveDir(boolean bl) {
        this.confirmRemoveDir = bl;
        this.getConfig().setProperty(SCRIPT_CONFIRM_REMOVE_DIR, (Object)this.confirmRemoveDir);
    }

    public boolean isConfirmRemoveDir() {
        return this.confirmRemoveDir;
    }
}

