/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class StatsdClient
extends TimerTask {
    private ByteBuffer sendBuffer;
    private Timer flushTimer;
    private boolean multi_metrics = false;
    private static final Random RNG = new Random();
    private static final Logger log = Logger.getLogger((String)StatsdClient.class.getName());
    private final InetSocketAddress _address;
    private final DatagramChannel _channel;

    public StatsdClient(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n);
    }

    public StatsdClient(InetAddress inetAddress, int n) throws IOException {
        this._address = new InetSocketAddress(inetAddress, n);
        this._channel = DatagramChannel.open();
        this._channel.configureBlocking(false);
        this._channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)4096);
        this.setBufferSize((short)1500);
    }

    protected void finalize() {
        this.flush();
    }

    public synchronized void setBufferSize(short s) {
        if (this.sendBuffer != null) {
            this.flush();
        }
        this.sendBuffer = ByteBuffer.allocate(s);
    }

    public synchronized void enableMultiMetrics(boolean bl) {
        this.multi_metrics = bl;
    }

    public synchronized boolean startFlushTimer(long l) {
        if (this.flushTimer == null) {
            if (l <= 0L) {
                l = 2000L;
            }
            this.flushTimer = new Timer();
            this.flushTimer.schedule((TimerTask)this, l, l);
            return true;
        }
        return false;
    }

    public synchronized void stopFlushTimer() {
        if (this.flushTimer != null) {
            this.flushTimer.cancel();
            this.flushTimer = null;
        }
    }

    @Override
    public void run() {
        this.flush();
    }

    public boolean timing(String string, int n) {
        return this.timing(string, n, 1.0);
    }

    public boolean timing(String string, int n, double d) {
        return this.send(d, String.format(Locale.ENGLISH, "%s:%d|ms", string, n));
    }

    public boolean decrement(String string) {
        return this.increment(string, -1, 1.0);
    }

    public boolean decrement(String string, int n) {
        return this.decrement(string, n, 1.0);
    }

    public boolean decrement(String string, int n, double d) {
        n = n < 0 ? n : -n;
        return this.increment(string, n, d);
    }

    public boolean decrement(String ... stringArray) {
        return this.increment(-1, 1.0, stringArray);
    }

    public boolean decrement(int n, String ... stringArray) {
        n = n < 0 ? n : -n;
        return this.increment(n, 1.0, stringArray);
    }

    public boolean decrement(int n, double d, String ... stringArray) {
        n = n < 0 ? n : -n;
        return this.increment(n, d, stringArray);
    }

    public boolean increment(String string) {
        return this.increment(string, 1, 1.0);
    }

    public boolean increment(String string, int n) {
        return this.increment(string, n, 1.0);
    }

    public boolean increment(String string, int n, double d) {
        String string2 = String.format(Locale.ENGLISH, "%s:%s|c", string, n);
        return this.send(d, string2);
    }

    public boolean increment(int n, double d, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = String.format(Locale.ENGLISH, "%s:%s|c", stringArray[i], n);
        }
        return this.send(d, stringArray2);
    }

    public boolean gauge(String string, double d) {
        return this.gauge(string, d, 1.0);
    }

    public boolean gauge(String string, double d, double d2) {
        String string2 = String.format(Locale.ENGLISH, "%s:%s|g", string, d);
        return this.send(d2, string2);
    }

    private boolean send(double d, String ... stringArray) {
        boolean bl = false;
        if (d < 1.0) {
            for (String string : stringArray) {
                if (!(RNG.nextDouble() <= d) || !this.doSend(string = String.format(Locale.ENGLISH, "%s|@%f", string, d))) continue;
                bl = true;
            }
        } else {
            for (String string : stringArray) {
                if (!this.doSend(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private synchronized boolean doSend(String string) {
        try {
            byte[] byArray = string.getBytes("utf-8");
            if (this.sendBuffer.remaining() < byArray.length + 1) {
                this.flush();
            }
            if (this.sendBuffer.position() > 0) {
                this.sendBuffer.put((byte)10);
            }
            this.sendBuffer.put(byArray);
            if (!this.multi_metrics) {
                this.flush();
            }
            return true;
        }
        catch (IOException iOException) {
            log.error((Object)String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort()), (Throwable)iOException);
            return false;
        }
    }

    public synchronized boolean flush() {
        try {
            int n = this.sendBuffer.position();
            if (n <= 0) {
                return false;
            }
            this.sendBuffer.flip();
            int n2 = this._channel.send(this.sendBuffer, this._address);
            this.sendBuffer.limit(this.sendBuffer.capacity());
            this.sendBuffer.rewind();
            if (n == n2) {
                return true;
            }
            log.error((Object)String.format("Could not send entirely stat %s to host %s:%d. Only sent %d bytes out of %d bytes", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort(), n2, n));
            return false;
        }
        catch (IOException iOException) {
            log.error((Object)String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort()), (Throwable)iOException);
            return false;
        }
    }
}

