/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollScanAsyncAction;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/scroll", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchScrollRequest.class);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void doExecute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            AbstractAsyncAction action;
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            switch (scrollId.getType()) {
                case "queryThenFetch": {
                    action = new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchService, this.searchPhaseController, request, scrollId, listener);
                    break;
                }
                case "queryAndFetch": {
                    action = new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchService, this.searchPhaseController, request, scrollId, listener);
                    break;
                }
                case "scan": {
                    action = new SearchScrollScanAsyncAction(this.logger, this.clusterService, this.searchService, this.searchPhaseController, request, scrollId, listener);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
                }
            }
            action.start();
        }
        catch (Throwable e) {
            listener.onFailure(e);
        }
    }
}

