/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.base;

import java.util.Collection;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, objectArray));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(Preconditions.format(string, objectArray));
        }
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static <T> T checkNotNull(T t, String string, Object ... objectArray) {
        if (t == null) {
            throw new NullPointerException(Preconditions.format(string, objectArray));
        }
        return t;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T t) {
        if (Preconditions.containsOrIsNull(t)) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T t, Object object) {
        if (Preconditions.containsOrIsNull(t)) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T t, String string, Object ... objectArray) {
        if (Preconditions.containsOrIsNull(t)) {
            throw new NullPointerException(Preconditions.format(string, objectArray));
        }
        return t;
    }

    private static boolean containsOrIsNull(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            try {
                return collection.contains(null);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        for (Object obj : iterable) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public static void checkElementIndex(int n, int n2) {
        Preconditions.checkElementIndex(n, n2, "index");
    }

    public static void checkElementIndex(int n, int n2, String string) {
        Preconditions.checkArgument(n2 >= 0, "negative size: %s", n2);
        if (n < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", string, n));
        }
        if (n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must be less than size (%s)", string, n, n2));
        }
    }

    public static void checkPositionIndex(int n, int n2) {
        Preconditions.checkPositionIndex(n, n2, "index");
    }

    public static void checkPositionIndex(int n, int n2, String string) {
        Preconditions.checkArgument(n2 >= 0, "negative size: %s", n2);
        if (n < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", string, n));
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be greater than size (%s)", string, n, n2));
        }
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        Preconditions.checkPositionIndex(n, n3, "start index");
        Preconditions.checkPositionIndex(n2, n3, "end index");
        if (n2 < n) {
            throw new IndexOutOfBoundsException(Preconditions.format("end index (%s) must not be less than start index (%s)", n2, n));
        }
    }

    static String format(String string, Object ... objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(objectArray[n3++]);
            n2 = n + 2;
        }
        stringBuilder.append(string.substring(n2));
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n3++]);
            while (n3 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n3++]);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

