/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.debug;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.DebugShapeVisitor;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.Transition;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GraphvizShapeVisitor
extends DebugShapeVisitor<GraphvizShapeVisitor> {
    private final Set<Shape> drawn;
    private final StringBuilder sb = new StringBuilder();

    public GraphvizShapeVisitor() {
        this.drawn = new HashSet<Shape>();
    }

    @Override
    public GraphvizShapeVisitor visitShape(Shape shape, Map<? extends Transition, ? extends Shape> transitions) {
        if (!this.drawn.add(shape)) {
            return this;
        }
        String prefix = "s";
        this.sb.append(prefix).append(GraphvizShapeVisitor.getId(shape));
        this.sb.append(" [label=\"");
        if (shape.getLastProperty() != null) {
            this.sb.append(GraphvizShapeVisitor.escapeString(shape.getLastProperty().toString()));
        } else {
            this.sb.append("ROOT");
        }
        this.sb.append("\"");
        this.sb.append(", shape=\"rectangle\"");
        if (!shape.isValid()) {
            this.sb.append(", color=\"red\", style=dotted");
        }
        this.sb.append("];");
        for (Map.Entry<? extends Transition, ? extends Shape> entry : transitions.entrySet()) {
            Shape dst = entry.getValue();
            ((ShapeImpl)dst).accept(this);
            assert (this.drawn.contains(dst));
            this.sb.append(prefix).append(GraphvizShapeVisitor.getId(shape)).append("->").append(prefix).append(GraphvizShapeVisitor.getId(dst));
            this.sb.append(" [label=\"").append(GraphvizShapeVisitor.escapeString(entry.getKey().toString())).append("\"]");
            this.sb.append(";");
        }
        return this;
    }

    private static String escapeString(String str) {
        return str.replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\\\"");
    }

    public String toString() {
        return "digraph{" + this.sb + "}";
    }
}

