/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public class CheckMatchVariableTypeNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    private final BranchProfile unsuitableTypeProfile = BranchProfile.create();

    public CheckMatchVariableTypeNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object childValue = this.child.execute(frame);
        if (!RubyGuards.isRubyMatchData(childValue) && !this.isNil(childValue)) {
            this.unsuitableTypeProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorWrongArgumentType(childValue, "MatchData", this));
        }
        return childValue;
    }
}

