/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.lang.reflect.Modifier;
import javax.swing.Icon;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.selector.api.nodes.Bundle;
import org.netbeans.modules.profiler.selector.api.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.util.lookup.Lookups;

public class ConstructorNode
extends SelectorNode {
    private SourceMethodInfo method;
    private ClientUtils.SourceCodeSelection signature;
    private static MethodNameFormatterFactory formatterFactory = MethodNameFormatterFactory.getDefault((MethodNameFormatter)new DefaultMethodNameFormatter(2));

    public ConstructorNode(SourceMethodInfo sourceMethodInfo, ConstructorsNode constructorsNode) {
        super(sourceMethodInfo != null ? sourceMethodInfo.getName() : Bundle.LBL_Unknown(), sourceMethodInfo != null ? sourceMethodInfo.getName() : Bundle.LBL_Unknown(), null, SelectorChildren.LEAF, constructorsNode, Lookups.singleton((Object)sourceMethodInfo));
        this.method = sourceMethodInfo;
        if (this.method != null) {
            this.signature = new ClientUtils.SourceCodeSelection(this.method.getClassName(), this.method.getName(), this.method.getSignature());
            this.updateDisplayName(formatterFactory.getFormatter().formatMethodName(this.signature).toFormatted());
        }
    }

    public final boolean getAllowsChildren() {
        return false;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    public final Icon getIcon() {
        if (this.method == null) {
            return Icons.getIcon((String)"LanguageIcons.ConstructorPublic");
        }
        Icon icon = Modifier.isPublic(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.ConstructorPublic") : (Modifier.isProtected(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.ConstructorProtected") : (Modifier.isPrivate(this.method.getModifiers()) ? Icons.getIcon((String)"LanguageIcons.ConstructorPrivate") : Icons.getIcon((String)"LanguageIcons.ConstructorPackage")));
        return icon;
    }

    public final ClassNode getParentClass() {
        return ((ConstructorsNode)this.getParent()).getParentClass();
    }

    @Override
    public final ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    public final SourceMethodInfo getMethodInfo() {
        return this.method;
    }
}

