/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

class IconWithArrow
implements Icon {
    private static final String ARROW_IMAGE_NAME = "org/openide/awt/resources/arrow.png";
    private Icon orig;
    private Icon arrow = ImageUtilities.loadImageIcon((String)"org/openide/awt/resources/arrow.png", (boolean)false);
    private boolean paintRollOver;
    private static final int GAP = 6;

    public IconWithArrow(Icon icon, boolean bl) {
        Parameters.notNull((CharSequence)"original icon", (Object)icon);
        this.orig = icon;
        this.paintRollOver = bl;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconHeight();
        this.orig.paintIcon(component, graphics, n, n2 + (n3 - this.orig.getIconHeight()) / 2);
        this.arrow.paintIcon(component, graphics, n + 6 + this.orig.getIconWidth(), n2 + (n3 - this.arrow.getIconHeight()) / 2);
        if (this.paintRollOver) {
            Color color = UIManager.getColor("controlHighlight");
            Color color2 = UIManager.getColor("controlShadow");
            if (null == color || null == color2) {
                color = component.getBackground().brighter();
                color2 = component.getBackground().darker();
            }
            if (null != color && null != color2) {
                graphics.setColor(color);
                graphics.drawLine(n + this.orig.getIconWidth() + 1, n2, n + this.orig.getIconWidth() + 1, n2 + this.getIconHeight());
                graphics.setColor(color2);
                graphics.drawLine(n + this.orig.getIconWidth() + 2, n2, n + this.orig.getIconWidth() + 2, n2 + this.getIconHeight());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth() + 6 + this.arrow.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.orig.getIconHeight(), this.arrow.getIconHeight());
    }

    public static int getArrowAreaWidth() {
        return 8;
    }
}

