/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;

class FileHashSnapshot
implements IncrementalFileSnapshot {
    private final HashCode hash;
    private final transient long lastModified;

    public FileHashSnapshot(HashCode hash) {
        this(hash, 0L);
    }

    public FileHashSnapshot(HashCode hash, long lastModified) {
        this.hash = hash;
        this.lastModified = lastModified;
    }

    public boolean isContentUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return Objects.equal((Object)this.hash, (Object)other.hash);
    }

    public boolean isContentAndMetadataUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.lastModified == other.lastModified && Objects.equal((Object)this.hash, (Object)other.hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHashSnapshot that = (FileHashSnapshot)o;
        return Objects.equal((Object)this.hash, (Object)that.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public String toString() {
        return this.hash.toString();
    }

    public HashCode getHash() {
        return this.hash;
    }
}

