/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gradle.internal.resource.local.LocalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ResourceConnector
implements ExternalResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ResourceConnector.class);
    private final S3Client s3Client;

    public S3ResourceConnector(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public List<String> list(URI parent) {
        LOGGER.debug("Listing parent resources: {}", (Object)parent);
        return this.s3Client.listDirectChildren(parent);
    }

    public ExternalResourceReadResponse openResource(URI location) {
        LOGGER.debug("Attempting to get resource: {}", (Object)location);
        S3Object s3Object = this.s3Client.getResource(location);
        if (s3Object == null) {
            return null;
        }
        return new S3Resource(s3Object, location);
    }

    public ExternalResourceMetaData getMetaData(URI location) {
        LOGGER.debug("Attempting to get resource metadata: {}", (Object)location);
        S3Object s3Object = this.s3Client.getMetaData(location);
        if (s3Object == null) {
            return null;
        }
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        return new DefaultExternalResourceMetaData(location, objectMetadata.getLastModified().getTime(), objectMetadata.getContentLength(), objectMetadata.getContentType(), objectMetadata.getETag(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(LocalResource resource, URI destination) throws IOException {
        LOGGER.debug("Attempting to upload stream to : {}", (Object)destination);
        try (InputStream inputStream = resource.open();){
            this.s3Client.put(inputStream, resource.getContentLength(), destination);
        }
    }
}

