/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.LatestConflictResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ModuleForcingResolveRule;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.StrictConflictResolution;
import org.gradle.internal.Actions;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NormalizedTimeUnit;
import org.gradle.internal.typeconversion.TimeUnitsParser;
import org.gradle.util.GUtil;

public class DefaultResolutionStrategy
implements ResolutionStrategyInternal {
    private final Set<ModuleVersionSelector> forcedModules = new LinkedHashSet<ModuleVersionSelector>();
    private ConflictResolution conflictResolution = new LatestConflictResolution();
    private final DefaultComponentSelectionRules componentSelectionRules = new DefaultComponentSelectionRules();
    private final DefaultCachePolicy cachePolicy;
    private final DependencySubstitutionsInternal dependencySubstitutions;
    private final DependencySubstitutionRules globalDependencySubstitutionRules;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private boolean assumeFluidDependencies;
    private static final String ASSUME_FLUID_DEPENDENCIES = "org.gradle.resolution.assumeFluidDependencies";

    public DefaultResolutionStrategy(DependencySubstitutionRules globalDependencySubstitutionRules, ComponentIdentifierFactory componentIdentifierFactory) {
        this(new DefaultCachePolicy(), DefaultDependencySubstitutions.forResolutionStrategy(componentIdentifierFactory), globalDependencySubstitutionRules);
    }

    DefaultResolutionStrategy(DefaultCachePolicy cachePolicy, DependencySubstitutionsInternal dependencySubstitutions, DependencySubstitutionRules globalDependencySubstitutionRules) {
        this.cachePolicy = cachePolicy;
        this.dependencySubstitutions = dependencySubstitutions;
        this.globalDependencySubstitutionRules = globalDependencySubstitutionRules;
        this.assumeFluidDependencies = Boolean.getBoolean(ASSUME_FLUID_DEPENDENCIES);
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
        this.cachePolicy.setMutationValidator(validator);
        this.componentSelectionRules.setMutationValidator(validator);
        this.dependencySubstitutions.setMutationValidator(validator);
    }

    public Set<ModuleVersionSelector> getForcedModules() {
        return Collections.unmodifiableSet(this.forcedModules);
    }

    public ResolutionStrategy failOnVersionConflict() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.conflictResolution = new StrictConflictResolution();
        return this;
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public ResolutionRules getResolutionRules() {
        return this.cachePolicy;
    }

    public DefaultResolutionStrategy force(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        Set modules = (Set)ModuleVersionSelectorParsers.multiParser().parseNotation((Object)moduleVersionSelectorNotations);
        this.forcedModules.addAll(modules);
        return this;
    }

    public ResolutionStrategy eachDependency(Action<? super DependencyResolveDetails> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencySubstitutions.allWithDependencyResolveDetails(rule);
        return this;
    }

    @Override
    public Action<DependencySubstitution> getDependencySubstitutionRule() {
        Collection allRules = GUtil.flattenElements((Object[])new Object[]{new ModuleForcingResolveRule(this.forcedModules), this.dependencySubstitutions.getRuleAction(), this.globalDependencySubstitutionRules.getRuleAction()});
        return Actions.composite((Iterable)allRules);
    }

    @Override
    public void assumeFluidDependencies() {
        this.assumeFluidDependencies = true;
    }

    @Override
    public boolean resolveGraphToDetermineTaskDependencies() {
        return this.assumeFluidDependencies || this.dependencySubstitutions.hasRules() || this.globalDependencySubstitutionRules.hasRules();
    }

    public DefaultResolutionStrategy setForcedModules(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        Set modules = (Set)ModuleVersionSelectorParsers.multiParser().parseNotation((Object)moduleVersionSelectorNotations);
        this.forcedModules.clear();
        this.forcedModules.addAll(modules);
        return this;
    }

    @Override
    public DefaultCachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void cacheDynamicVersionsFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheDynamicVersionsFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit units) {
        this.cachePolicy.cacheDynamicVersionsFor(value, units);
    }

    public void cacheChangingModulesFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheChangingModulesFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.cachePolicy.cacheChangingModulesFor(value, units);
    }

    @Override
    public ComponentSelectionRulesInternal getComponentSelection() {
        return this.componentSelectionRules;
    }

    public ResolutionStrategy componentSelection(Action<? super ComponentSelectionRules> action) {
        action.execute((Object)this.componentSelectionRules);
        return this;
    }

    @Override
    public DependencySubstitutionsInternal getDependencySubstitution() {
        return this.dependencySubstitutions;
    }

    public ResolutionStrategy dependencySubstitution(Action<? super DependencySubstitutions> action) {
        action.execute((Object)this.dependencySubstitutions);
        return this;
    }

    @Override
    public DefaultResolutionStrategy copy() {
        DefaultResolutionStrategy out = new DefaultResolutionStrategy(this.cachePolicy.copy(), this.dependencySubstitutions.copy(), this.globalDependencySubstitutionRules);
        if (this.conflictResolution instanceof StrictConflictResolution) {
            out.failOnVersionConflict();
        }
        out.setForcedModules(this.getForcedModules());
        for (SpecRuleAction<? super ComponentSelection> ruleAction : this.componentSelectionRules.getRules()) {
            out.getComponentSelection().addRule(ruleAction);
        }
        return out;
    }
}

