/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;

public final class CompanionObjectMapping {
    private final LinkedHashSet<FqName> classesFqNames = SetsKt.linkedSetOf(new FqName[0]);

    @NotNull
    public final Set<FqName> allClassesWithIntrinsicCompanions() {
        Set<FqName> set = Collections.unmodifiableSet((Set)this.classesFqNames);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiableSet(classesFqNames)");
        return set;
    }

    public final boolean hasMappingToObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            return false;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(classDescriptor.getContainingDeclaration());
        if (!fqName2.isSafe()) {
            return false;
        }
        return this.classesFqNames.contains(fqName2.toSafe());
    }

    public CompanionObjectMapping() {
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            this.classesFqNames.add(KotlinBuiltIns.getPrimitiveFqName(type2));
        }
        this.classesFqNames.add(KotlinBuiltIns.FQ_NAMES.string.toSafe());
        this.classesFqNames.add(KotlinBuiltIns.FQ_NAMES._enum.toSafe());
    }
}

