/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020\u000bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0006\u0010*\u001a\u00020\u000bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130 0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "isThereAnyTryCatch", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "", "getSaveStackMarkerForRestoreMarker", "()Ljava/util/Map;", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "insnNode", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "kotlin-compiler"})
public final class FixStackContext {
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    private final boolean isThereAnyTryCatch;
    @NotNull
    private final Map<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    public final boolean isThereAnyTryCatch() {
        return this.isThereAnyTryCatch;
    }

    @NotNull
    public final Map<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        AbstractInsnNode next = insnNode.getNext();
        boolean bl = next.getOpcode() == 167;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by GOTO";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AbstractInsnNode abstractInsnNode = next;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)abstractInsnNode);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        boolean bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        boolean bl = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasAnyMarkers() {
        Object object = this.breakContinueGotoNodes;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        object = this.fakeAlwaysTrueIfeqMarkers;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        object = this.fakeAlwaysFalseIfeqMarkers;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (this.isThereAnyTryCatch) return true;
        object = this.openingInlineMethodMarker;
        if (object.isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAnalysisRequired() {
        Object object = this.breakContinueGotoNodes;
        if (!object.isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (this.isThereAnyTryCatch) return true;
        object = this.openingInlineMethodMarker;
        if (object.isEmpty()) return false;
        return true;
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    /*
     * WARNING - void declaration
     */
    public FixStackContext(@NotNull MethodNode methodNode) {
        void $receiver$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = SetsKt.linkedSetOf(new JumpInsnNode[0]);
        this.fakeAlwaysTrueIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.fakeAlwaysFalseIfeqMarkers = CollectionsKt.arrayListOf(new AbstractInsnNode[0]);
        this.restoreStackMarkersForSaveMarker = MapsKt.hashMapOf(new Pair[0]);
        this.openingInlineMethodMarker = MapsKt.hashMapOf(new Pair[0]);
        this.consistentInlineMarkers = true;
        this.saveStackMarkerForRestoreMarker = AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        Object object = this.saveStackMarkerForRestoreMarker;
        FixStackContext fixStackContext = this;
        fixStackContext.isThereAnyTryCatch = bl = !object.isEmpty();
        Map<AbstractInsnNode, AbstractInsnNode> map2 = this.saveStackMarkerForRestoreMarker;
        Object object2 = map2.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3;
            void $receiver$iv2;
            Object object4 = object = object2.next();
            AbstractInsnNode restore = (AbstractInsnNode)object4.getKey();
            Object object5 = object;
            AbstractInsnNode save = (AbstractInsnNode)object5.getValue();
            object5 = this.restoreStackMarkersForSaveMarker;
            Object value$iv = $receiver$iv2.get(save);
            if (value$iv == null) {
                SmartList answer$iv = new SmartList();
                $receiver$iv2.put(save, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            ((List)object3).add(restore);
        }
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "methodNode.instructions");
        object2 = new InsnSequence(insnList);
        for (Object element$iv : $receiver$iv) {
            Object t;
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FIX_STACK_BEFORE_JUMP)) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ)) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (Intrinsics.areEqual((Object)pseudoInsn, (Object)PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ)) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (InlineCodegenUtil.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtil.isAfterInlineMarker(insnNode)) continue;
            Object object6 = inlineMarkersStack;
            boolean bl2 = !object6.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            object6 = this.openingInlineMethodMarker;
            Intrinsics.checkExpressionValueIsNotNull(inlineMarkersStack.pop(), "inlineMarkersStack.pop()");
            object6.put(insnNode, t);
        }
        object2 = inlineMarkersStack;
        if (!object2.isEmpty()) {
            this.consistentInlineMarkers = false;
        }
    }
}

