/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.util.C;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class _IdtfExporter
extends __CartesianExporter {
    private boolean haveSphere;
    private boolean haveCylinder;
    private boolean haveCylinderIn;
    private boolean haveCone;
    private boolean haveCircle;
    private P3 ptMin = P3.new3(1.0E10f, 1.0E10f, 1.0E10f);
    private P3 ptMax = P3.new3(-1.0E10f, -1.0E10f, -1.0E10f);
    private int iObj;
    private Map<String, Boolean> htDefs = new Hashtable<String, Boolean>();
    private final M4 m = new M4();
    private final SB models = new SB();
    private final SB resources = new SB();
    private final SB modifiers = new SB();
    private Map<String, Lst<String>> htNodes = new Hashtable<String, Lst<String>>();
    private M4 cylinderMatrix = new M4();
    private SB sbTemp;
    private int[][] triangleFace = AU.newInt2(1);

    public _IdtfExporter() {
        this.triangleFace[0] = new int[]{0, 1, 2};
        this.commentChar = "% ";
    }

    @Override
    protected void output(T3 pt) {
        this.output(pt, this.sbTemp, true);
    }

    private void output(T3 pt, SB sb, boolean checkpt) {
        if (checkpt) {
            this.checkPoint(pt);
        }
        sb.append(_IdtfExporter.round(pt.x)).append(" ").append(_IdtfExporter.round(pt.y)).append(" ").append(_IdtfExporter.round(pt.z)).append(" ");
    }

    private void checkPoint(T3 pt) {
        if (pt.x < this.ptMin.x) {
            this.ptMin.x = pt.x;
        }
        if (pt.y < this.ptMin.y) {
            this.ptMin.y = pt.y;
        }
        if (pt.z < this.ptMin.z) {
            this.ptMin.z = pt.z;
        }
        if (pt.x > this.ptMax.x) {
            this.ptMax.x = pt.x;
        }
        if (pt.y > this.ptMax.y) {
            this.ptMax.y = pt.y;
        }
        if (pt.z > this.ptMax.z) {
            this.ptMax.z = pt.z;
        }
    }

    @Override
    protected void outputHeader() {
        this.output("FILE_FORMAT \"IDTF\"\nFORMAT_VERSION 100\n");
        this.m.setIdentity();
        this.m.setToM3(this.tm.matrixRotate);
        this.m.rotate2(this.referenceCenter, this.tempP1);
        this.m.m03 = -this.tempP1.x;
        this.m.m13 = -this.tempP1.y;
        this.m.m23 = -this.tempP1.z;
        this.m.m33 = 1.0f;
        this.output("NODE \"GROUP\" {\n");
        this.output("NODE_NAME \"Jmol\"\n");
        this.output("PARENT_LIST {\nPARENT_COUNT 1\n");
        this.output("PARENT 0 {\n");
        this.output(this.getParentItem("", this.m));
        this.output("}}}\n");
    }

    @Override
    protected String finalizeOutput() {
        this.finalizeOutput2();
        return this.getAuxiliaryFileData();
    }

    private String getAuxiliaryFileData() {
        String fName = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
        fName = fName.substring(fName.lastIndexOf("\\") + 1);
        String name = fName + ".";
        name = name.substring(0, name.indexOf("."));
        return "% Created by: Jmol " + Viewer.getJmolVersion() + "\n% Creation date: " + this.getExportDate() + "\n% File created: " + this.fileName + " (" + this.getByteCount() + " bytes)\n\n" + "\n\\documentclass[12pt,letter]{article}" + "\n\\usepackage{hyperref}" + "\n\\usepackage{media9}" + "\n\\usepackage{verbatim}" + "\n\\pagestyle{empty}" + "\n\\begin{document}" + "\n    \\begin{center}" + "\n        \\addmediapath{./} % here you can set the path where is been saved the u3d file" + "\n        \\includemedia[" + "\n            label=" + name + "," + "\n            width=0.9\\textwidth," + "\n            height=0.9\\textheight," + "\n            activate=pageopen," + "\n            deactivate=pageclose," + "\n            3Dtoolbar=false," + "\n            3Dnavpane=false," + "\n            3Dmenu," + "\n            3Droo=" + this.cameraDistance + "," + "\n            3Dcoo= 0.0 0.0 0.0," + "\n            3Dc2c=0.0 0.0 1.0," + "\n            3Daac=" + this.aperatureAngle + "," + "\n            3Droll=0.0," + "\n            3Dbg=" + this.rgbFractionalFromColix(this.backgroundColix) + ", % to set the background color for 3D vwr; white = 1 1 1; so, you need to do the proportion: '255:1=[RGB]:x'" + "\n            transparent=false," + "\n            3Dlights=Headlamp," + "\n            3Drender=Solid," + "\n            3Dpartsattrs=restore," + "\n        ]{}{" + name + ".u3d}" + "\n%  \\\\" + "\n%\\movieref[3Dcalculate]{" + name + "}{Click here!}" + "\n\\end{center}" + "\n\\end{document}" + "\n\\begin{comment}" + this.vwr.getWrappedStateScript() + "\n\\end{comment}";
    }

    private String getParentItem(String name, M4 m) {
        SB sb = new SB();
        sb.append("PARENT_NAME \"" + name + "\"\n");
        sb.append("PARENT_TM {\n");
        sb.append(m.m00 + " " + m.m10 + " " + m.m20 + " 0.0\n");
        sb.append(m.m01 + " " + m.m11 + " " + m.m21 + " 0.0\n");
        sb.append(m.m02 + " " + m.m12 + " " + m.m22 + " 0.0\n");
        sb.append(m.m03 + " " + m.m13 + " " + m.m23 + " " + m.m33 + "\n");
        sb.append("}\n");
        return sb.toString();
    }

    private void addColix(short colix, boolean haveColors) {
        String key = "_" + colix;
        if (this.htDefs.containsKey(key)) {
            return;
        }
        String color = haveColors ? "1.0 1.0 1.0" : this.rgbFractionalFromColix(colix);
        this.htDefs.put(key, Boolean.TRUE);
        this.resources.append("RESOURCE_LIST \"SHADER\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Shader" + key + "\"\n");
        this.resources.append("ATTRIBUTE_USE_VERTEX_COLOR \"FALSE\"\n");
        this.resources.append("SHADER_MATERIAL_NAME \"Mat" + key + "\"\n");
        this.resources.append("SHADER_ACTIVE_TEXTURE_COUNT 0\n");
        this.resources.append("}}\n");
        this.resources.append("RESOURCE_LIST \"MATERIAL\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Mat" + key + "\"\n");
        this.resources.append("MATERIAL_AMBIENT " + color + "\n");
        this.resources.append("MATERIAL_DIFFUSE " + color + "\n");
        this.resources.append("MATERIAL_SPECULAR 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_EMISSIVE 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_REFLECTIVITY 0.00000\n");
        this.resources.append("MATERIAL_OPACITY " + _IdtfExporter.opacityFractionalFromColix(colix) + "\n");
        this.resources.append("}}\n");
    }

    private void addShader(String key, short colix) {
        this.modifiers.append("MODIFIER \"SHADING\" {\n");
        this.modifiers.append("MODIFIER_NAME \"" + key + "\"\n");
        this.modifiers.append("PARAMETERS {\n");
        this.modifiers.append("SHADER_LIST_COUNT 1\n");
        this.modifiers.append("SHADING_GROUP {\n");
        this.modifiers.append("SHADER_LIST 0 {\n");
        this.modifiers.append("SHADER_COUNT 1\n");
        this.modifiers.append("SHADER_NAME_LIST {\n");
        this.modifiers.append("SHADER 0 NAME: \"Shader_" + colix + "\"\n");
        this.modifiers.append("}}}}}\n");
    }

    @Override
    protected void outputFooter() {
        this.htDefs = null;
        this.outputNodes();
        this.output(this.models.toString());
        this.output(this.resources.toString());
        this.output("RESOURCE_LIST \"VIEW\" {\n");
        this.output("\tRESOURCE_COUNT 1\n");
        this.output("\tRESOURCE 0 {\n");
        this.output("\t\tRESOURCE_NAME \"View0\"\n");
        this.output("\t\tVIEW_PASS_COUNT 1\n");
        this.output("\t\tVIEW_ROOT_NODE_LIST {\n");
        this.output("\t\t\tROOT_NODE 0 {\n");
        this.output("\t\t\t\tROOT_NODE_NAME \"\"\n");
        this.output("\t\t\t}\n");
        this.output("\t\t}\n");
        this.output("\t}\n");
        this.output("}\n\n");
        this.output(this.modifiers.toString());
    }

    private void outputNodes() {
        for (Map.Entry<String, Lst<String>> entry : this.htNodes.entrySet()) {
            int i;
            String key = entry.getKey();
            Lst<String> v = entry.getValue();
            this.output("NODE \"MODEL\" {\n");
            this.output("NODE_NAME \"" + key + "\"\n");
            System.out.println("output idtf " + key);
            int n = v.size();
            this.output("PARENT_LIST {\nPARENT_COUNT " + n + "\n");
            for (i = 0; i < n; ++i) {
                this.output("PARENT " + i + " {\n");
                this.output((String)v.get(i));
                this.output("}\n");
            }
            this.output("}\n");
            i = key.indexOf("_");
            if (i > 0) {
                key = key.substring(0, i);
            }
            if (key.equals("Ellipse")) {
                key = "Circle";
            }
            this.output("RESOURCE_NAME \"" + key + "_Mesh\"\n}\n");
        }
    }

    @Override
    protected void outputEllipsoid(P3 center, P3[] points, short colix) {
        A4 a = Quat.getQuaternionFrame(center, points[1], points[3]).toAxisAngle4f();
        float sx = points[1].distance(center);
        float sy = points[3].distance(center);
        float sz = points[5].distance(center);
        this.setSphereMatrix(center, sx, sy, sz, a, this.sphereMatrix);
        this.outputEllipsoid((T3)center, this.sphereMatrix, colix);
    }

    private void outputEllipsoid(T3 center, M4 sphereMatrix, short colix) {
        if (!this.haveSphere) {
            this.models.append(this.getSphereResource());
            this.haveSphere = true;
        }
        this.checkPoint(center);
        this.addColix(colix, false);
        String key = "Sphere_" + colix;
        Lst<String> v = this.htNodes.get(key);
        if (v == null) {
            v = new Lst();
            this.htNodes.put(key, v);
            this.addShader(key, colix);
        }
        v.addLast(this.getParentItem("Jmol", sphereMatrix));
    }

    private String getSphereResource() {
        SB sb = new SB();
        sb.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"Sphere_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n");
        int vertexCount = Geodesic.getVertexCount(2);
        short[] f = Geodesic.getFaceVertexes(2);
        int nFaces = f.length / 3;
        int[][] faces = new int[nFaces][3];
        int p = 0;
        for (int i = 0; i < nFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                faces[i][j] = f[++p];
            }
        }
        T3[] vertexes = new V3[vertexCount];
        for (int i = 0; i < vertexCount; ++i) {
            vertexes[i] = Geodesic.getVertexVector(i);
        }
        return this.getMeshData("Sphere", faces, vertexes, vertexes);
    }

    private String getMeshData(String type, int[][] indices, T3[] vertexes, T3[] normals) {
        int i;
        int nFaces = indices.length;
        int vertexCount = vertexes.length;
        int normalCount = normals.length;
        SB sb = new SB();
        this.getMeshHeader(type, nFaces, vertexCount, normalCount, 0, sb);
        SB sb1 = new SB();
        for (i = 0; i < indices.length; ++i) {
            sb1.appendI(indices[i][0]).append(" ");
            sb1.appendI(indices[i][1]).append(" ");
            sb1.appendI(indices[i][2]).append(" ");
        }
        sb.append("MESH_FACE_POSITION_LIST { ");
        sb.appendSB(sb1);
        sb.append("}\n");
        sb.append("MESH_FACE_NORMAL_LIST { ");
        sb.appendSB(sb1);
        sb.append("}\n");
        sb.append("MESH_FACE_SHADING_LIST { ");
        for (i = 0; i < nFaces; ++i) {
            sb.append("0 ");
        }
        sb.append("}\n");
        sb.append("MODEL_POSITION_LIST { ");
        for (i = 0; i < vertexCount; ++i) {
            this.output(vertexes[i], sb, false);
        }
        sb.append("}\n");
        sb.append("MODEL_NORMAL_LIST { ");
        for (i = 0; i < normalCount; ++i) {
            this.output(normals[i], sb, false);
        }
        sb.append("}\n}}}\n");
        return sb.toString();
    }

    private void getMeshHeader(String type, int nFaces, int vertexCount, int normalCount, int colorCount, SB sb) {
        sb.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"").append(type).append("_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n").append("FACE_COUNT ").appendI(nFaces).append("\n").append("MODEL_POSITION_COUNT ").appendI(vertexCount).append("\n").append("MODEL_NORMAL_COUNT ").appendI(normalCount).append("\n").append("MODEL_DIFFUSE_COLOR_COUNT ").appendI(colorCount).append("\n").append("MODEL_SPECULAR_COLOR_COUNT 0\n").append("MODEL_TEXTURE_COORD_COUNT 0\n").append("MODEL_BONE_COUNT 0\n").append("MODEL_SHADING_COUNT 1\n").append("MODEL_SHADING_DESCRIPTION_LIST {\n").append("SHADING_DESCRIPTION 0 {\n").append("TEXTURE_LAYER_COUNT 0\n").append("SHADER_ID 0\n}}\n");
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        if (ptX != null) {
            if (endcaps == 2) {
                this.outputEllipse(ptCenter, pt1, ptX, ptY, colix);
                this.tempP3.add2(ptCenter, ptCenter);
                this.tempP3.sub(ptX);
                this.outputEllipse(ptCenter, pt2, this.tempP3, ptY, colix);
            }
        } else if (endcaps == 3) {
            this.outputSphere(pt1, radius * 1.01f, colix, true);
            this.outputSphere(pt2, radius * 1.01f, colix, true);
        } else if (endcaps == 2) {
            this.outputCircle(pt1, pt2, colix, radius);
            this.outputCircle(pt2, pt1, colix, radius);
        }
        if (!this.haveCylinder) {
            this.models.append(this.getCylinderResource(false));
            this.haveCylinder = true;
        }
        if (ptX != null && endcaps == 0 && !this.haveCylinderIn) {
            this.models.append(this.getCylinderResource(true));
            this.haveCylinderIn = true;
        }
        this.checkPoint(pt1);
        this.checkPoint(pt2);
        this.addColix(colix, false);
        int n = ptX != null && endcaps == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            String key = "Cylinder" + (i == 0 ? "_" : "In_") + colix;
            Lst<String> v = this.htNodes.get(key);
            if (v == null) {
                v = new Lst();
                this.htNodes.put(key, v);
                this.addShader(key, colix);
            }
            if (ptX == null) {
                this.cylinderMatrix.setToM3(this.getRotationMatrix(pt1, pt2, radius));
            } else {
                this.cylinderMatrix.setToM3(this.getRotationMatrix(ptCenter, pt2, radius, ptX, ptY));
            }
            this.cylinderMatrix.m03 = pt1.x;
            this.cylinderMatrix.m13 = pt1.y;
            this.cylinderMatrix.m23 = pt1.z;
            this.cylinderMatrix.m33 = 1.0f;
            v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
            radius *= 0.95f;
        }
        return true;
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        if (doFill) {
            this.outputCircle(pt1, pt2, colix, radius);
            return;
        }
    }

    private boolean outputEllipse(P3 ptCenter, P3 ptZ, P3 ptX, P3 ptY, short colix) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new M4();
        }
        this.addColix(colix, false);
        String key = "Ellipse_" + colix;
        Lst<String> v = this.htNodes.get(key);
        if (v == null) {
            v = new Lst();
            this.htNodes.put(key, v);
            this.addShader(key, colix);
        }
        this.checkPoint(ptCenter);
        this.cylinderMatrix.setToM3(this.getRotationMatrix(ptCenter, ptZ, 1.0f, ptX, ptY));
        this.cylinderMatrix.m03 = ptZ.x;
        this.cylinderMatrix.m13 = ptZ.y;
        this.cylinderMatrix.m23 = ptZ.z;
        this.cylinderMatrix.m33 = 1.0f;
        v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
        return true;
    }

    private void outputCircle(P3 ptCenter, P3 ptPerp, short colix, float radius) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new M4();
        }
        this.addColix(colix, false);
        String key = "Circle_" + colix;
        Lst<String> v = this.htNodes.get(key);
        if (v == null) {
            v = new Lst();
            this.htNodes.put(key, v);
            this.addShader(key, colix);
        }
        this.checkPoint(ptCenter);
        this.cylinderMatrix.setToM3(this.getRotationMatrix(ptCenter, ptPerp, radius));
        this.cylinderMatrix.m03 = ptCenter.x;
        this.cylinderMatrix.m13 = ptCenter.y;
        this.cylinderMatrix.m23 = ptCenter.z;
        this.cylinderMatrix.m33 = 1.0f;
        v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getCylinderResource(boolean inSide) {
        float y;
        float x;
        int i;
        int ndeg = 10;
        int vertexCount = 360 / ndeg * 2;
        int n = vertexCount / 2;
        int[][] faces = AU.newInt2(vertexCount);
        int fpt = -1;
        for (int i2 = 0; i2 < n; ++i2) {
            if (inSide) {
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n, i2};
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n + n, (i2 + 1) % n};
                continue;
            }
            faces[++fpt] = new int[]{i2, (i2 + 1) % n, i2 + n};
            faces[++fpt] = new int[]{(i2 + 1) % n, (i2 + 1) % n + n, i2 + n};
        }
        T3[] vertexes = new P3[vertexCount];
        T3[] normals = new P3[vertexCount];
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, y, 0.0f);
            normals[i] = P3.new3(x, y, 0.0f);
        }
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            y = (float)Math.sin(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            vertexes[i + n] = P3.new3(x, y, 1.0f);
            normals[i + n] = normals[i];
        }
        if (inSide) {
            for (i = 0; i < n; ++i) {
                normals[i].scale(-1.0f);
            }
        }
        return this.getMeshData(inSide ? "CylinderIn" : "Cylinder", faces, vertexes, normals);
    }

    @Override
    protected void outputFace(int[] face, int[] map, int faceVertexMax) {
        this.sbTemp.append(" " + map[face[0]] + " " + map[face[1]] + " " + map[face[2]]);
        if (faceVertexMax == 4 && face.length == 4) {
            this.sbTemp.append(" " + map[face[0]] + " " + map[face[2]] + " " + map[face[3]]);
        }
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.addColix(colix, polygonColixes != null || colixes != null);
        if (polygonColixes != null) {
            return;
        }
        SB sbFaceCoordIndices = this.sbTemp = new SB();
        int[] map = new int[nVertices];
        int nCoord = this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        SB sbFaceNormalIndices = this.sbTemp = new SB();
        Lst<String> vNormals = null;
        if (normals != null) {
            vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        }
        map = null;
        SB sbColorIndexes = new SB();
        if (colorList != null) {
            int i0;
            boolean isAll = bsPolygons == null;
            int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
            while (i >= 0) {
                sbColorIndexes.append(" " + htColixes.get("" + colixes[indices[i][0]]) + " " + htColixes.get("" + colixes[indices[i][1]]) + " " + htColixes.get("" + colixes[indices[i][2]]));
                if (faceVertexMax == 4 && indices[i].length == 4) {
                    sbColorIndexes.append(" " + htColixes.get("" + colixes[indices[i][0]]) + " " + htColixes.get("" + colixes[indices[i][2]]) + " " + htColixes.get("" + colixes[indices[i][3]]));
                }
                i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
            }
        }
        SB sbCoords = this.sbTemp = new SB();
        this.outputVertices(vertices, nVertices, offset);
        SB sbNormals = new SB();
        int nNormals = 0;
        if (normals != null) {
            nNormals = vNormals.size();
            for (int i = 0; i < nNormals; ++i) {
                sbNormals.append((String)vNormals.get(i));
            }
            vNormals = null;
        }
        SB sbColors = new SB();
        int nColors = 0;
        if (colorList != null) {
            nColors = colorList.size();
            for (int i = 0; i < nColors; ++i) {
                short c = (Short)colorList.get(i);
                sbColors.append(this.rgbFractionalFromColix(c)).append(" ").append(_IdtfExporter.translucencyFractionalFromColix(c)).append(" ");
            }
        }
        String key = "mesh" + ++this.iObj;
        this.addMeshData(key, nTriangles, nCoord, nNormals, nColors, sbFaceCoordIndices, sbFaceNormalIndices, sbColorIndexes, sbCoords, sbNormals, sbColors);
        Lst<String> v = new Lst<String>();
        this.htNodes.put(key, v);
        this.addShader(key, colix);
        this.cylinderMatrix.setIdentity();
        v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private void addMeshData(String key, int nFaces, int nCoord, int nNormals, int nColors, SB sbFaceCoordIndices, SB sbFaceNormalIndices, SB sbColorIndices, SB sbCoords, SB sbNormals, SB sbColors) {
        this.getMeshHeader(key, nFaces, nCoord, nNormals, nColors, this.models);
        this.models.append("MESH_FACE_POSITION_LIST { ").appendSB(sbFaceCoordIndices).append(" }\n").append("MESH_FACE_NORMAL_LIST { ").appendSB(sbFaceNormalIndices).append(" }\n");
        this.models.append("MESH_FACE_SHADING_LIST { ");
        for (int i = 0; i < nFaces; ++i) {
            this.models.append("0 ");
        }
        this.models.append("}\n");
        if (nColors > 0) {
            this.models.append("MESH_FACE_DIFFUSE_COLOR_LIST { ").appendSB(sbColorIndices).append(" }\n");
        }
        this.models.append("MODEL_POSITION_LIST { ").appendSB(sbCoords).append(" }\n").append("MODEL_NORMAL_LIST { ").appendSB(sbNormals).append(" }\n");
        if (nColors > 0) {
            this.models.append("MODEL_DIFFUSE_COLOR_LIST { ").appendSB(sbColors).append(" }\n");
        }
        this.models.append("}}}\n");
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        if (!this.haveCone) {
            this.models.append(this.getConeResource());
            this.haveCone = true;
        }
        this.checkPoint(ptBase);
        this.checkPoint(ptTip);
        this.addColix(colix, false);
        String key = "Cone_" + colix;
        Lst<String> v = this.htNodes.get(key);
        if (v == null) {
            v = new Lst();
            this.htNodes.put(key, v);
            this.addShader(key, colix);
        }
        this.cylinderMatrix.setToM3(this.getRotationMatrix(ptBase, ptTip, radius));
        this.cylinderMatrix.m03 = ptBase.x;
        this.cylinderMatrix.m13 = ptBase.y;
        this.cylinderMatrix.m23 = ptBase.z;
        this.cylinderMatrix.m33 = 1.0f;
        v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getConeResource() {
        MeshSurface m = _IdtfExporter.getConeMesh(null, null, (short)0);
        return this.getMeshData("Cone", m.pis, m.vs, m.vs);
    }

    private String getCircleResource() {
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n + 1;
        int[][] faces = AU.newInt2(n);
        for (int i = 0; i < n; ++i) {
            faces[i] = new int[]{i, (i + 1) % n, n};
        }
        T3[] vertexes = new P3[vertexCount];
        T3[] normals = new P3[vertexCount];
        for (int i = 0; i < n; ++i) {
            float x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            float y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, y, 0.0f);
            normals[i] = P3.new3(0.0f, 0.0f, 1.0f);
        }
        vertexes[n] = P3.new3(0.0f, 0.0f, 0.0f);
        normals[n] = P3.new3(0.0f, 0.0f, 1.0f);
        return this.getMeshData("Circle", faces, vertexes, normals);
    }

    @Override
    protected void outputSphere(P3 center, float radius, short colix, boolean checkRadius) {
        this.setSphereMatrix(center, radius, radius, radius, null, this.sphereMatrix);
        this.outputEllipsoid((T3)center, this.sphereMatrix, colix);
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
        short colix = C.getColix(argb);
        this.outputSphere(pt, 0.02f, colix, true);
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.addColix(colix, false);
        String key = "T" + ++this.iObj;
        this.models.append(this.getTriangleResource(key, pt1, pt2, pt3));
        Lst<String> v = new Lst<String>();
        this.htNodes.put(key, v);
        this.addShader(key, colix);
        if (this.cylinderMatrix == null) {
            this.cylinderMatrix = new M4();
        }
        this.cylinderMatrix.setIdentity();
        v.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getTriangleResource(String key, T3 pt1, T3 pt2, T3 pt3) {
        T3[] vertexes = new T3[]{pt1, pt2, pt3};
        this.tempV1.sub2(pt3, pt1);
        this.tempV2.sub2(pt2, pt1);
        this.tempV2.cross(this.tempV2, this.tempV1);
        this.tempV2.normalize();
        T3[] normals = new V3[]{this.tempV2, this.tempV2, this.tempV2};
        return this.getMeshData(key, this.triangleFace, vertexes, normals);
    }
}

