/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import java.util.ArrayList;
import java.util.List;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.V3;
import javax.swing.JOptionPane;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.script.T;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.surfacetool.Slice;
import org.openscience.jmol.app.surfacetool.SurfaceStatus;
import org.openscience.jmol.app.surfacetool.SurfaceToolGUI;

public class SurfaceTool {
    private SurfaceToolGUI gui;
    boolean useGUI;
    protected JmolViewer vwr;
    private final P3 negCorner = new P3();
    private final P3 posCorner = new P3();
    private final P3 center = new P3();
    private final V3 boxVec = new V3();
    private final List<SurfaceStatus> surfaces = new ArrayList<SurfaceStatus>();
    static final int DEGREES = 0;
    static final int RADIANS = 1;
    static final int GRADIANS = 2;
    static final int CIRCLE_FRACTION = 3;
    static final int UNITS_PI = 4;
    private int angleUnits = 0;
    private String[] angleUnitsList = new String[]{GT._("Degrees"), GT._("Radians"), GT._("Gradians"), GT._("Circle Fraction"), GT._("Units of Pi")};
    private float angleXY;
    private float anglefromZ;
    private float positionMin;
    private float position;
    private float thickness;
    private float thicknessMax;
    private Slice slice = new Slice();
    private boolean leftOn = false;
    private boolean rightOn = false;
    private boolean ghostOn = false;
    private boolean capOn = false;
    private boolean useMolecular = false;
    private boolean usePercent = false;

    public SurfaceTool(JmolViewer vwr, HistoryFile hfile, String winName, boolean useGUI) {
        this.vwr = vwr;
        this.useGUI = useGUI;
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
        this.initSlice();
        this.gui = useGUI ? new SurfaceToolGUI(vwr, hfile, winName, this) : null;
    }

    public void toFront() {
        this.gui.toFront();
    }

    void toFrontOrGotFocus() {
        this.updateSurfaceInfo();
        this.chooseBestBoundBox();
        this.setSurfaceToolParam();
    }

    private void chooseBestBoundBox() {
        BoxInfo box = new BoxInfo();
        this.vwr.calcAtomsMinMax(null, box);
        this.center.setT(box.getBoundBoxCenter());
        this.boxVec.setT(box.getBoundBoxCornerVector());
        this.posCorner.add2(this.center, this.boxVec);
        this.negCorner.sub2(this.center, this.boxVec);
        Shape[] shapes = (Shape[])this.vwr.getProperty("DATA_API", "shapeManager", "getShapes");
        box = this.checkMeshBB(shapes, 24, box);
        box = this.checkMeshBB(shapes, 29, box);
        box = this.checkMeshBB(shapes, 27, box);
        if (box != null) {
            this.center.setT(box.getBoundBoxCenter());
            this.negCorner.sub2(this.center, box.getBoundBoxCornerVector());
            this.posCorner.add2(this.center, box.getBoundBoxCornerVector());
            this.boxVec.setT(box.getBoundBoxCornerVector());
        }
    }

    BoxInfo checkMeshBB(Shape[] shapes, int kind, BoxInfo box) {
        MeshCollection mc = (MeshCollection)shapes[kind];
        if (mc == null) {
            return box;
        }
        for (int i = 0; i < mc.meshCount; ++i) {
            P3[] bb;
            Mesh m = mc.meshes[i];
            if (!m.isValid || m.vc == 0 && m.pc == 0 || m.thisID.equalsIgnoreCase("_slicerleft") || m.thisID.equalsIgnoreCase("_slicerright") || (bb = m.getBoundingBox()) == null) continue;
            box.addBoundBoxPoint(bb[0]);
            box.addBoundBoxPoint(bb[1]);
        }
        return box;
    }

    void setSurfaceToolParam() {
        this.thicknessMax = 2.0f * this.boxVec.length();
        float delta = this.position - this.positionMin;
        if (this.useMolecular) {
            if (this.negCorner.x < 0.0f && this.negCorner.y < 0.0f && this.negCorner.z < 0.0f) {
                this.positionMin = -1.0f * this.negCorner.length();
            } else {
                this.positionMin = Math.min(this.negCorner.x, this.negCorner.y);
                this.positionMin = Math.min(this.negCorner.z, this.positionMin);
            }
        } else {
            this.positionMin = -1.0f * this.boxVec.length();
        }
        this.position = this.positionMin + delta;
    }

    private void updateSurfaceInfo() {
        Shape[] shapes = (Shape[])this.vwr.getProperty("DATA_API", "shapeManager", "getShapes");
        this.setSyncStarting();
        this.updateMeshInfo(shapes, 24);
        this.updateMeshInfo(shapes, 29);
        this.updateMeshInfo(shapes, 27);
        this.syncDone();
    }

    private void setSyncStarting() {
        for (int i = 0; i < this.surfaces.size(); ++i) {
            this.surfaces.get((int)i).foundDuringLastSync = false;
        }
    }

    private void syncDone() {
        for (int i = this.surfaces.size() - 1; i >= 0; --i) {
            if (this.surfaces.get((int)i).foundDuringLastSync) continue;
            this.surfaces.remove(i);
        }
    }

    private void updateMeshInfo(Shape[] shapes, int kind) {
        block10: {
            int i;
            MeshCollection mc;
            if (shapes == null || (mc = (MeshCollection)shapes[kind]) == null) break block10;
            int[] meshIndexList = new int[mc.meshCount];
            for (i = 0; i < mc.meshCount; ++i) {
                meshIndexList[i] = -1;
            }
            if (!this.surfaces.isEmpty()) {
                int i2;
                int[] surfaceIndexList = new int[this.surfaces.size()];
                for (i2 = 0; i2 < this.surfaces.size(); ++i2) {
                    surfaceIndexList[i2] = -1;
                }
                for (i2 = 0; i2 < mc.meshCount; ++i2) {
                    Mesh m = mc.meshes[i2];
                    if (!this.checkMesh(m)) {
                        meshIndexList[i2] = -2;
                        continue;
                    }
                    for (int j = 0; j < this.surfaces.size(); ++j) {
                        if (this.surfaces.get((int)j).id != m.thisID) continue;
                        surfaceIndexList[j] = i2;
                        meshIndexList[i2] = j;
                    }
                }
                for (i2 = 0; i2 < surfaceIndexList.length; ++i2) {
                    if (surfaceIndexList[i2] < 0) continue;
                    this.surfaces.get(i2).updateExisting(mc.meshes[surfaceIndexList[i2]]);
                }
            } else {
                for (i = 0; i < mc.meshCount; ++i) {
                    Mesh m = mc.meshes[i];
                    meshIndexList[i] = !this.checkMesh(m) ? -2 : -1;
                }
            }
            for (int i3 = 0; i3 < meshIndexList.length; ++i3) {
                if (meshIndexList[i3] != -1) continue;
                this.surfaces.add(new SurfaceStatus(mc.meshes[i3], kind));
            }
        }
    }

    private boolean checkMesh(Mesh m) {
        if (!m.isValid || m.vc == 0 && m.pc == 0) {
            return false;
        }
        return !m.thisID.equalsIgnoreCase("_slicerleft") && !m.thisID.equalsIgnoreCase("_slicerright");
    }

    void setAngleUnits(int units) {
        this.angleUnits = units;
    }

    P3 getNegCorner() {
        return this.negCorner;
    }

    P3 getPosCorner() {
        return this.posCorner;
    }

    private void initSlice() {
        this.angleXY = 0.0f;
        this.anglefromZ = 1.5707964f;
        this.position = 0.0f;
        this.thickness = this.negCorner.distance(this.posCorner) / 5.0f;
        this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
    }

    void showSliceBoundaryPlanes(boolean onOrOff) {
        this.leftOn = this.rightOn = onOrOff;
        SB cmd = new SB();
        this.drawSlicePlane(cmd, 1073741996, onOrOff);
        this.drawSlicePlane(cmd, 1073742126, onOrOff);
        this.vwr.evalStringQuiet(cmd.toString());
    }

    void setSlice(float angleXY, float anglefromZ, float position, float thickness) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        this.angleXY = angleXY;
        this.anglefromZ = anglefromZ;
        this.position = position;
        this.thickness = thickness;
        this.slice.setSlice(angleXY, anglefromZ, position, thickness, this.center, this.boxVec, this.useMolecular);
    }

    void setSliceAngleXY(float angle) {
        if (this.angleXY != angle) {
            this.angleXY = angle;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceAngleXY() {
        return this.angleXY;
    }

    void setSliceAnglefromZ(float angle) {
        if (this.anglefromZ != angle) {
            this.anglefromZ = angle;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getAnglefromZ() {
        return this.anglefromZ;
    }

    void setSlicePosition(float where) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.position != where) {
            this.position = where;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSlicePosition() {
        return this.position;
    }

    void setSliceThickness(float width) {
        if (this.usePercent) {
            JOptionPane.showMessageDialog(null, GT._("Percentage scaling not implemented yet!"), "Warning", 2);
        }
        if (this.thickness != width) {
            this.thickness = width;
            this.slice.setSlice(this.angleXY, this.anglefromZ, this.position, this.thickness, this.center, this.boxVec, this.useMolecular);
        }
    }

    float getSliceThickness() {
        return this.thickness;
    }

    void updateSlices() {
        for (int i = 0; i < this.surfaces.size(); ++i) {
            this.sliceObject(this.surfaces.get((int)i).id, this.surfaces.get((int)i).kind);
        }
    }

    void sliceObject(String objectName, int kind) {
        String cmdStart = "";
        String idStr = " ID \"" + objectName + "\"";
        String slabCapStr = this.capOn ? " cap " : " slab ";
        String ghostStr = this.ghostOn ? "translucent 0.8 mesh " : "";
        switch (kind) {
            case 24: {
                cmdStart = "isosurface";
                break;
            }
            case 29: {
                cmdStart = "pmesh";
                break;
            }
            case 27: {
                cmdStart = "mo";
                idStr = "";
                slabCapStr = " slab ";
            }
        }
        SB cmd = new SB();
        this.drawSlicePlane(cmd, 1073741996, this.leftOn);
        this.drawSlicePlane(cmd, 1073742126, this.rightOn);
        cmd.append(cmdStart).append(idStr).append(" slab none;");
        cmd.append(cmdStart).append(idStr);
        cmd.append(slabCapStr).append(ghostStr).append("-").append(Escape.eP4(this.slice.leftPlane));
        cmd.append(";").append(cmdStart).append(idStr);
        cmd.append(slabCapStr).append(ghostStr).append(Escape.eP4(this.slice.rightPlane));
        cmd.append(";");
        this.vwr.evalStringQuiet(cmd.toString());
    }

    private void drawSlicePlane(SB cmd, int side, boolean on) {
        String color;
        P4 plane;
        String name = T.nameOf(side);
        switch (side) {
            default: {
                plane = this.slice.leftPlane;
                color = "magenta";
                break;
            }
            case 1073742126: {
                plane = this.slice.rightPlane;
                color = "cyan";
            }
        }
        cmd.append("isosurface _slicer").append(name);
        if (on) {
            cmd.append(" plane ").append(Escape.eP4(plane)).append(" translucent 0.7 ").append(color).append(";");
        } else {
            cmd.append(" off;");
        }
    }

    int getAngleUnits() {
        return this.angleUnits;
    }

    boolean getGhostOn() {
        return this.ghostOn;
    }

    void setGhostOn(boolean b) {
        this.ghostOn = b;
    }

    boolean getUseMolecular() {
        return this.useMolecular;
    }

    void setUseMolecular(boolean on) {
        this.useMolecular = on;
    }

    float getPositionMin() {
        return this.positionMin;
    }

    float getThicknessMax() {
        return this.thicknessMax;
    }

    P3 getCenter() {
        return this.center;
    }

    V3 getBoxVec() {
        return this.boxVec;
    }

    P4 getSliceMiddle() {
        return this.slice.getMiddle();
    }

    String[] getAngleUnitsList() {
        return this.angleUnitsList;
    }

    boolean getCapOn() {
        return this.capOn;
    }

    void setCapOn(boolean b) {
        this.capOn = b;
    }

    public List<SurfaceStatus> getSurfaces() {
        return this.surfaces;
    }
}

