/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.supercall.LookupSuperMethodNode;
import org.jruby.truffle.language.supercall.LookupSuperMethodNodeGen;

public class ZSuperOutsideMethodNode
extends RubyNode {
    final boolean insideDefineMethod;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;

    public ZSuperOutsideMethodNode(RubyContext context, SourceSection sourceSection, boolean insideDefineMethod) {
        super(context, sourceSection);
        this.insideDefineMethod = insideDefineMethod;
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        if (this.insideDefineMethod) {
            throw new RaiseException(this.coreExceptions().runtimeError("implicit argument passing of super from method defined by define_method() is not supported. Specify all arguments explicitly.", this));
        }
        throw new RaiseException(this.coreExceptions().noSuperMethodOutsideMethodError(this));
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame);
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.create7BitString("super", (Encoding)UTF8Encoding.INSTANCE);
    }
}

