/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayToObjectArrayNode;
import org.jruby.truffle.core.array.ArrayToObjectArrayNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.yield.YieldNode;

public class YieldExpressionNode
extends RubyNode {
    private final boolean unsplat;
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    private YieldNode yieldNode;
    @Node.Child
    private ArrayToObjectArrayNode unsplatNode;
    private final BranchProfile useCapturedBlock = BranchProfile.create();
    private final BranchProfile noCapturedBlock = BranchProfile.create();

    public YieldExpressionNode(RubyContext context, SourceSection sourceSection, boolean unsplat, RubyNode[] arguments) {
        super(context, sourceSection);
        this.unsplat = unsplat;
        this.arguments = arguments;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        DynamicObject block = RubyArguments.getBlock(frame);
        if (block == null) {
            this.useCapturedBlock.enter();
            block = RubyArguments.getMethod(frame).getCapturedBlock();
            if (block == null) {
                this.noCapturedBlock.enter();
                throw new RaiseException(this.coreExceptions().noBlockToYieldTo(this));
            }
        }
        if (this.unsplat) {
            argumentsObjects = this.unsplat(argumentsObjects);
        }
        return this.getYieldNode().dispatch(frame, block, argumentsObjects);
    }

    private Object[] unsplat(Object[] argumentsObjects) {
        if (this.unsplatNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unsplatNode = this.insert(ArrayToObjectArrayNodeGen.create(null));
        }
        return this.unsplatNode.unsplat(argumentsObjects);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (RubyArguments.getBlock(frame) == null) {
            return this.nil();
        }
        return this.coreStrings().YIELD.createInstance();
    }

    private YieldNode getYieldNode() {
        if (this.yieldNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.yieldNode = this.insert(new YieldNode(this.getContext()));
        }
        return this.yieldNode;
    }
}

