#ifndef _flextgl_h_
#define _flextgl_h_

#include <Corrade/Utility/VisibilityMacros.h>

#include "Magnum/configure.h"

/* Defensive include guards */

#if defined(__glew_h__) || defined(__GLEW_H__)
#error Attempt to include auto-generated header after including glew.h
#endif
#if defined(__gl_h_) || defined(__GL_H__)
#error Attempt to include auto-generated header after including gl.h
#endif
#if defined(__glext_h_) || defined(__GLEXT_H_)
#error Attempt to include auto-generated header after including glext.h
#endif
#if defined(__gltypes_h_)
#error Attempt to include auto-generated header after including gltypes.h
#endif
#if defined(__gl_ATI_h_)
#error Attempt to include auto-generated header after including glATI.h
#endif

#define __glew_h__
#define __GLEW_H__
#define __gl_h_
#define __GL_H__
#define __glext_h_
#define __GLEXT_H_
#define __gltypes_h_
#define __gl_ATI_h_

#ifdef __cplusplus
extern "C" {
#endif

void flextGLInit();

/* Function declaration macros */

#ifndef MAGNUM_BUILD_STATIC
    #ifdef FlextGL_EXPORTS
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_EXPORT
    #else
        #define FLEXTGL_EXPORT CORRADE_VISIBILITY_IMPORT
    #endif
#else
    #define FLEXTGL_EXPORT CORRADE_VISIBILITY_STATIC
#endif

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__) && !defined(__SCITECH_SNAP__)
#define WIN32_LEAN_AND_MEAN 1
#ifndef WINAPI
#define WINAPI __stdcall
#endif
#define APIENTRY WINAPI
#endif

#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef GLAPI
#define GLAPI extern
#endif

/* Data types */

#include <stddef.h>
#ifndef GLEXT_64_TYPES_DEFINED
/* This code block is duplicated in glxext.h, so must be protected */
#define GLEXT_64_TYPES_DEFINED
/* Define int32_t, int64_t, and uint64_t types for UST/MSC */
/* (as used in the GL_EXT_timer_query extension). */
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
#elif defined(__sun__) || defined(__digital__)
#include <inttypes.h>
#if defined(__STDC__)
#if defined(__arch64__) || defined(_LP64)
typedef long int int64_t;
typedef unsigned long int uint64_t;
#else
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#endif /* __arch64__ */
#endif /* __STDC__ */
#elif defined( __VMS ) || defined(__sgi)
#include <inttypes.h>
#elif defined(__SCO__) || defined(__USLC__)
#include <stdint.h>
#elif defined(__UNIXOS2__) || defined(__SOL64__)
typedef long int int32_t;
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#elif defined(_WIN32) && defined(__GNUC__)
#include <stdint.h>
#elif defined(_WIN32)
typedef __int32 int32_t;
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#else
/* Fallback if nothing above works */
#include <inttypes.h>
#endif
#endif
typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef void GLvoid;
typedef signed char GLbyte;
typedef short GLshort;
typedef int GLint;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned int GLuint;
typedef int GLsizei;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef char GLchar;
typedef unsigned short GLhalf;
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
typedef int64_t GLint64;
typedef uint64_t GLuint64;
typedef uint64_t GLuint64EXT;
typedef struct __GLsync *GLsync;
typedef void (APIENTRY *GLDEBUGPROC)(GLenum source,GLenum type,GLuint id,GLenum severity,GLsizei length,const GLchar *message,const void *userParam);

/* Enums */

/* GL_VERSION_1_1 */

#define GL_DEPTH_BUFFER_BIT 0x00000100
#define GL_STENCIL_BUFFER_BIT 0x00000400
#define GL_COLOR_BUFFER_BIT 0x00004000
#define GL_FALSE 0
#define GL_TRUE 1
#define GL_POINTS 0x0000
#define GL_LINES 0x0001
#define GL_LINE_LOOP 0x0002
#define GL_LINE_STRIP 0x0003
#define GL_TRIANGLES 0x0004
#define GL_TRIANGLE_STRIP 0x0005
#define GL_TRIANGLE_FAN 0x0006
#define GL_NEVER 0x0200
#define GL_LESS 0x0201
#define GL_EQUAL 0x0202
#define GL_LEQUAL 0x0203
#define GL_GREATER 0x0204
#define GL_NOTEQUAL 0x0205
#define GL_GEQUAL 0x0206
#define GL_ALWAYS 0x0207
#define GL_ZERO 0
#define GL_ONE 1
#define GL_SRC_COLOR 0x0300
#define GL_ONE_MINUS_SRC_COLOR 0x0301
#define GL_SRC_ALPHA 0x0302
#define GL_ONE_MINUS_SRC_ALPHA 0x0303
#define GL_DST_ALPHA 0x0304
#define GL_ONE_MINUS_DST_ALPHA 0x0305
#define GL_DST_COLOR 0x0306
#define GL_ONE_MINUS_DST_COLOR 0x0307
#define GL_SRC_ALPHA_SATURATE 0x0308
#define GL_NONE 0
#define GL_FRONT_LEFT 0x0400
#define GL_FRONT_RIGHT 0x0401
#define GL_BACK_LEFT 0x0402
#define GL_BACK_RIGHT 0x0403
#define GL_FRONT 0x0404
#define GL_BACK 0x0405
#define GL_LEFT 0x0406
#define GL_RIGHT 0x0407
#define GL_FRONT_AND_BACK 0x0408
#define GL_NO_ERROR 0
#define GL_INVALID_ENUM 0x0500
#define GL_INVALID_VALUE 0x0501
#define GL_INVALID_OPERATION 0x0502
#define GL_OUT_OF_MEMORY 0x0505
#define GL_CW 0x0900
#define GL_CCW 0x0901
#define GL_POINT_SIZE 0x0B11
#define GL_POINT_SIZE_RANGE 0x0B12
#define GL_POINT_SIZE_GRANULARITY 0x0B13
#define GL_LINE_SMOOTH 0x0B20
#define GL_LINE_WIDTH 0x0B21
#define GL_LINE_WIDTH_RANGE 0x0B22
#define GL_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_POLYGON_MODE 0x0B40
#define GL_POLYGON_SMOOTH 0x0B41
#define GL_CULL_FACE 0x0B44
#define GL_CULL_FACE_MODE 0x0B45
#define GL_FRONT_FACE 0x0B46
#define GL_DEPTH_RANGE 0x0B70
#define GL_DEPTH_TEST 0x0B71
#define GL_DEPTH_WRITEMASK 0x0B72
#define GL_DEPTH_CLEAR_VALUE 0x0B73
#define GL_DEPTH_FUNC 0x0B74
#define GL_STENCIL_TEST 0x0B90
#define GL_STENCIL_CLEAR_VALUE 0x0B91
#define GL_STENCIL_FUNC 0x0B92
#define GL_STENCIL_VALUE_MASK 0x0B93
#define GL_STENCIL_FAIL 0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define GL_STENCIL_REF 0x0B97
#define GL_STENCIL_WRITEMASK 0x0B98
#define GL_VIEWPORT 0x0BA2
#define GL_DITHER 0x0BD0
#define GL_BLEND_DST 0x0BE0
#define GL_BLEND_SRC 0x0BE1
#define GL_BLEND 0x0BE2
#define GL_LOGIC_OP_MODE 0x0BF0
#define GL_COLOR_LOGIC_OP 0x0BF2
#define GL_DRAW_BUFFER 0x0C01
#define GL_READ_BUFFER 0x0C02
#define GL_SCISSOR_BOX 0x0C10
#define GL_SCISSOR_TEST 0x0C11
#define GL_COLOR_CLEAR_VALUE 0x0C22
#define GL_COLOR_WRITEMASK 0x0C23
#define GL_DOUBLEBUFFER 0x0C32
#define GL_STEREO 0x0C33
#define GL_LINE_SMOOTH_HINT 0x0C52
#define GL_POLYGON_SMOOTH_HINT 0x0C53
#define GL_UNPACK_SWAP_BYTES 0x0CF0
#define GL_UNPACK_LSB_FIRST 0x0CF1
#define GL_UNPACK_ROW_LENGTH 0x0CF2
#define GL_UNPACK_SKIP_ROWS 0x0CF3
#define GL_UNPACK_SKIP_PIXELS 0x0CF4
#define GL_UNPACK_ALIGNMENT 0x0CF5
#define GL_PACK_SWAP_BYTES 0x0D00
#define GL_PACK_LSB_FIRST 0x0D01
#define GL_PACK_ROW_LENGTH 0x0D02
#define GL_PACK_SKIP_ROWS 0x0D03
#define GL_PACK_SKIP_PIXELS 0x0D04
#define GL_PACK_ALIGNMENT 0x0D05
#define GL_MAX_TEXTURE_SIZE 0x0D33
#define GL_MAX_VIEWPORT_DIMS 0x0D3A
#define GL_SUBPIXEL_BITS 0x0D50
#define GL_TEXTURE_1D 0x0DE0
#define GL_TEXTURE_2D 0x0DE1
#define GL_POLYGON_OFFSET_UNITS 0x2A00
#define GL_POLYGON_OFFSET_POINT 0x2A01
#define GL_POLYGON_OFFSET_LINE 0x2A02
#define GL_POLYGON_OFFSET_FILL 0x8037
#define GL_POLYGON_OFFSET_FACTOR 0x8038
#define GL_TEXTURE_BINDING_1D 0x8068
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_TEXTURE_WIDTH 0x1000
#define GL_TEXTURE_HEIGHT 0x1001
#define GL_TEXTURE_INTERNAL_FORMAT 0x1003
#define GL_TEXTURE_BORDER_COLOR 0x1004
#define GL_TEXTURE_RED_SIZE 0x805C
#define GL_TEXTURE_GREEN_SIZE 0x805D
#define GL_TEXTURE_BLUE_SIZE 0x805E
#define GL_TEXTURE_ALPHA_SIZE 0x805F
#define GL_DONT_CARE 0x1100
#define GL_FASTEST 0x1101
#define GL_NICEST 0x1102
#define GL_BYTE 0x1400
#define GL_UNSIGNED_BYTE 0x1401
#define GL_SHORT 0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT 0x1404
#define GL_UNSIGNED_INT 0x1405
#define GL_FLOAT 0x1406
#define GL_DOUBLE 0x140A
#define GL_CLEAR 0x1500
#define GL_AND 0x1501
#define GL_AND_REVERSE 0x1502
#define GL_COPY 0x1503
#define GL_AND_INVERTED 0x1504
#define GL_NOOP 0x1505
#define GL_XOR 0x1506
#define GL_OR 0x1507
#define GL_NOR 0x1508
#define GL_EQUIV 0x1509
#define GL_INVERT 0x150A
#define GL_OR_REVERSE 0x150B
#define GL_COPY_INVERTED 0x150C
#define GL_OR_INVERTED 0x150D
#define GL_NAND 0x150E
#define GL_SET 0x150F
#define GL_TEXTURE 0x1702
#define GL_COLOR 0x1800
#define GL_DEPTH 0x1801
#define GL_STENCIL 0x1802
#define GL_STENCIL_INDEX 0x1901
#define GL_DEPTH_COMPONENT 0x1902
#define GL_RED 0x1903
#define GL_GREEN 0x1904
#define GL_BLUE 0x1905
#define GL_ALPHA 0x1906
#define GL_RGB 0x1907
#define GL_RGBA 0x1908
#define GL_POINT 0x1B00
#define GL_LINE 0x1B01
#define GL_FILL 0x1B02
#define GL_KEEP 0x1E00
#define GL_REPLACE 0x1E01
#define GL_INCR 0x1E02
#define GL_DECR 0x1E03
#define GL_VENDOR 0x1F00
#define GL_RENDERER 0x1F01
#define GL_VERSION 0x1F02
#define GL_EXTENSIONS 0x1F03
#define GL_NEAREST 0x2600
#define GL_LINEAR 0x2601
#define GL_NEAREST_MIPMAP_NEAREST 0x2700
#define GL_LINEAR_MIPMAP_NEAREST 0x2701
#define GL_NEAREST_MIPMAP_LINEAR 0x2702
#define GL_LINEAR_MIPMAP_LINEAR 0x2703
#define GL_TEXTURE_MAG_FILTER 0x2800
#define GL_TEXTURE_MIN_FILTER 0x2801
#define GL_TEXTURE_WRAP_S 0x2802
#define GL_TEXTURE_WRAP_T 0x2803
#define GL_PROXY_TEXTURE_1D 0x8063
#define GL_PROXY_TEXTURE_2D 0x8064
#define GL_REPEAT 0x2901
#define GL_R3_G3_B2 0x2A10
#define GL_RGB4 0x804F
#define GL_RGB5 0x8050
#define GL_RGB8 0x8051
#define GL_RGB10 0x8052
#define GL_RGB12 0x8053
#define GL_RGB16 0x8054
#define GL_RGBA2 0x8055
#define GL_RGBA4 0x8056
#define GL_RGB5_A1 0x8057
#define GL_RGBA8 0x8058
#define GL_RGB10_A2 0x8059
#define GL_RGBA12 0x805A
#define GL_RGBA16 0x805B

/* GL_VERSION_1_2 */

#define GL_UNSIGNED_BYTE_3_3_2 0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4 0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1 0x8034
#define GL_UNSIGNED_INT_8_8_8_8 0x8035
#define GL_UNSIGNED_INT_10_10_10_2 0x8036
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_PACK_SKIP_IMAGES 0x806B
#define GL_PACK_IMAGE_HEIGHT 0x806C
#define GL_UNPACK_SKIP_IMAGES 0x806D
#define GL_UNPACK_IMAGE_HEIGHT 0x806E
#define GL_TEXTURE_3D 0x806F
#define GL_PROXY_TEXTURE_3D 0x8070
#define GL_TEXTURE_DEPTH 0x8071
#define GL_TEXTURE_WRAP_R 0x8072
#define GL_MAX_3D_TEXTURE_SIZE 0x8073
#define GL_UNSIGNED_BYTE_2_3_3_REV 0x8362
#define GL_UNSIGNED_SHORT_5_6_5 0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV 0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV 0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV 0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV 0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV 0x8368
#define GL_BGR 0x80E0
#define GL_BGRA 0x80E1
#define GL_MAX_ELEMENTS_VERTICES 0x80E8
#define GL_MAX_ELEMENTS_INDICES 0x80E9
#define GL_CLAMP_TO_EDGE 0x812F
#define GL_TEXTURE_MIN_LOD 0x813A
#define GL_TEXTURE_MAX_LOD 0x813B
#define GL_TEXTURE_BASE_LEVEL 0x813C
#define GL_TEXTURE_MAX_LEVEL 0x813D
#define GL_SMOOTH_POINT_SIZE_RANGE 0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY 0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE 0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY 0x0B23
#define GL_ALIASED_LINE_WIDTH_RANGE 0x846E

/* GL_VERSION_1_3 */

#define GL_TEXTURE0 0x84C0
#define GL_TEXTURE1 0x84C1
#define GL_TEXTURE2 0x84C2
#define GL_TEXTURE3 0x84C3
#define GL_TEXTURE4 0x84C4
#define GL_TEXTURE5 0x84C5
#define GL_TEXTURE6 0x84C6
#define GL_TEXTURE7 0x84C7
#define GL_TEXTURE8 0x84C8
#define GL_TEXTURE9 0x84C9
#define GL_TEXTURE10 0x84CA
#define GL_TEXTURE11 0x84CB
#define GL_TEXTURE12 0x84CC
#define GL_TEXTURE13 0x84CD
#define GL_TEXTURE14 0x84CE
#define GL_TEXTURE15 0x84CF
#define GL_TEXTURE16 0x84D0
#define GL_TEXTURE17 0x84D1
#define GL_TEXTURE18 0x84D2
#define GL_TEXTURE19 0x84D3
#define GL_TEXTURE20 0x84D4
#define GL_TEXTURE21 0x84D5
#define GL_TEXTURE22 0x84D6
#define GL_TEXTURE23 0x84D7
#define GL_TEXTURE24 0x84D8
#define GL_TEXTURE25 0x84D9
#define GL_TEXTURE26 0x84DA
#define GL_TEXTURE27 0x84DB
#define GL_TEXTURE28 0x84DC
#define GL_TEXTURE29 0x84DD
#define GL_TEXTURE30 0x84DE
#define GL_TEXTURE31 0x84DF
#define GL_ACTIVE_TEXTURE 0x84E0
#define GL_MULTISAMPLE 0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define GL_SAMPLE_ALPHA_TO_ONE 0x809F
#define GL_SAMPLE_COVERAGE 0x80A0
#define GL_SAMPLE_BUFFERS 0x80A8
#define GL_SAMPLES 0x80A9
#define GL_SAMPLE_COVERAGE_VALUE 0x80AA
#define GL_SAMPLE_COVERAGE_INVERT 0x80AB
#define GL_TEXTURE_CUBE_MAP 0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z 0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP 0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE 0x851C
#define GL_COMPRESSED_RGB 0x84ED
#define GL_COMPRESSED_RGBA 0x84EE
#define GL_TEXTURE_COMPRESSION_HINT 0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE 0x86A0
#define GL_TEXTURE_COMPRESSED 0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS 0x86A3
#define GL_CLAMP_TO_BORDER 0x812D

/* GL_VERSION_1_4 */

#define GL_BLEND_DST_RGB 0x80C8
#define GL_BLEND_SRC_RGB 0x80C9
#define GL_BLEND_DST_ALPHA 0x80CA
#define GL_BLEND_SRC_ALPHA 0x80CB
#define GL_POINT_FADE_THRESHOLD_SIZE 0x8128
#define GL_DEPTH_COMPONENT16 0x81A5
#define GL_DEPTH_COMPONENT24 0x81A6
#define GL_DEPTH_COMPONENT32 0x81A7
#define GL_MIRRORED_REPEAT 0x8370
#define GL_MAX_TEXTURE_LOD_BIAS 0x84FD
#define GL_TEXTURE_LOD_BIAS 0x8501
#define GL_INCR_WRAP 0x8507
#define GL_DECR_WRAP 0x8508
#define GL_TEXTURE_DEPTH_SIZE 0x884A
#define GL_TEXTURE_COMPARE_MODE 0x884C
#define GL_TEXTURE_COMPARE_FUNC 0x884D
#define GL_FUNC_ADD 0x8006
#define GL_FUNC_SUBTRACT 0x800A
#define GL_FUNC_REVERSE_SUBTRACT 0x800B
#define GL_MIN 0x8007
#define GL_MAX 0x8008
#define GL_CONSTANT_COLOR 0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR 0x8002
#define GL_CONSTANT_ALPHA 0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA 0x8004

/* GL_VERSION_1_5 */

#define GL_BUFFER_SIZE 0x8764
#define GL_BUFFER_USAGE 0x8765
#define GL_QUERY_COUNTER_BITS 0x8864
#define GL_CURRENT_QUERY 0x8865
#define GL_QUERY_RESULT 0x8866
#define GL_QUERY_RESULT_AVAILABLE 0x8867
#define GL_ARRAY_BUFFER 0x8892
#define GL_ELEMENT_ARRAY_BUFFER 0x8893
#define GL_ARRAY_BUFFER_BINDING 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING 0x8895
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_READ_ONLY 0x88B8
#define GL_WRITE_ONLY 0x88B9
#define GL_READ_WRITE 0x88BA
#define GL_BUFFER_ACCESS 0x88BB
#define GL_BUFFER_MAPPED 0x88BC
#define GL_BUFFER_MAP_POINTER 0x88BD
#define GL_STREAM_DRAW 0x88E0
#define GL_STREAM_READ 0x88E1
#define GL_STREAM_COPY 0x88E2
#define GL_STATIC_DRAW 0x88E4
#define GL_STATIC_READ 0x88E5
#define GL_STATIC_COPY 0x88E6
#define GL_DYNAMIC_DRAW 0x88E8
#define GL_DYNAMIC_READ 0x88E9
#define GL_DYNAMIC_COPY 0x88EA
#define GL_SAMPLES_PASSED 0x8914
#define GL_SRC1_ALPHA 0x8589

/* GL_VERSION_2_0 */

#define GL_BLEND_EQUATION_RGB 0x8009
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE 0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE 0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE 0x8625
#define GL_CURRENT_VERTEX_ATTRIB 0x8626
#define GL_VERTEX_PROGRAM_POINT_SIZE 0x8642
#define GL_VERTEX_ATTRIB_ARRAY_POINTER 0x8645
#define GL_STENCIL_BACK_FUNC 0x8800
#define GL_STENCIL_BACK_FAIL 0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 0x8803
#define GL_MAX_DRAW_BUFFERS 0x8824
#define GL_DRAW_BUFFER0 0x8825
#define GL_DRAW_BUFFER1 0x8826
#define GL_DRAW_BUFFER2 0x8827
#define GL_DRAW_BUFFER3 0x8828
#define GL_DRAW_BUFFER4 0x8829
#define GL_DRAW_BUFFER5 0x882A
#define GL_DRAW_BUFFER6 0x882B
#define GL_DRAW_BUFFER7 0x882C
#define GL_DRAW_BUFFER8 0x882D
#define GL_DRAW_BUFFER9 0x882E
#define GL_DRAW_BUFFER10 0x882F
#define GL_DRAW_BUFFER11 0x8830
#define GL_DRAW_BUFFER12 0x8831
#define GL_DRAW_BUFFER13 0x8832
#define GL_DRAW_BUFFER14 0x8833
#define GL_DRAW_BUFFER15 0x8834
#define GL_BLEND_EQUATION_ALPHA 0x883D
#define GL_MAX_VERTEX_ATTRIBS 0x8869
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED 0x886A
#define GL_MAX_TEXTURE_IMAGE_UNITS 0x8872
#define GL_FRAGMENT_SHADER 0x8B30
#define GL_VERTEX_SHADER 0x8B31
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS 0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS 0x8B4A
#define GL_MAX_VARYING_FLOATS 0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS 0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS 0x8B4D
#define GL_SHADER_TYPE 0x8B4F
#define GL_FLOAT_VEC2 0x8B50
#define GL_FLOAT_VEC3 0x8B51
#define GL_FLOAT_VEC4 0x8B52
#define GL_INT_VEC2 0x8B53
#define GL_INT_VEC3 0x8B54
#define GL_INT_VEC4 0x8B55
#define GL_BOOL 0x8B56
#define GL_BOOL_VEC2 0x8B57
#define GL_BOOL_VEC3 0x8B58
#define GL_BOOL_VEC4 0x8B59
#define GL_FLOAT_MAT2 0x8B5A
#define GL_FLOAT_MAT3 0x8B5B
#define GL_FLOAT_MAT4 0x8B5C
#define GL_SAMPLER_1D 0x8B5D
#define GL_SAMPLER_2D 0x8B5E
#define GL_SAMPLER_3D 0x8B5F
#define GL_SAMPLER_CUBE 0x8B60
#define GL_SAMPLER_1D_SHADOW 0x8B61
#define GL_SAMPLER_2D_SHADOW 0x8B62
#define GL_DELETE_STATUS 0x8B80
#define GL_COMPILE_STATUS 0x8B81
#define GL_LINK_STATUS 0x8B82
#define GL_VALIDATE_STATUS 0x8B83
#define GL_INFO_LOG_LENGTH 0x8B84
#define GL_ATTACHED_SHADERS 0x8B85
#define GL_ACTIVE_UNIFORMS 0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH 0x8B87
#define GL_SHADER_SOURCE_LENGTH 0x8B88
#define GL_ACTIVE_ATTRIBUTES 0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH 0x8B8A
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT 0x8B8B
#define GL_SHADING_LANGUAGE_VERSION 0x8B8C
#define GL_CURRENT_PROGRAM 0x8B8D
#define GL_POINT_SPRITE_COORD_ORIGIN 0x8CA0
#define GL_LOWER_LEFT 0x8CA1
#define GL_UPPER_LEFT 0x8CA2
#define GL_STENCIL_BACK_REF 0x8CA3
#define GL_STENCIL_BACK_VALUE_MASK 0x8CA4
#define GL_STENCIL_BACK_WRITEMASK 0x8CA5

/* GL_VERSION_2_1 */

#define GL_PIXEL_PACK_BUFFER 0x88EB
#define GL_PIXEL_UNPACK_BUFFER 0x88EC
#define GL_PIXEL_PACK_BUFFER_BINDING 0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING 0x88EF
#define GL_FLOAT_MAT2x3 0x8B65
#define GL_FLOAT_MAT2x4 0x8B66
#define GL_FLOAT_MAT3x2 0x8B67
#define GL_FLOAT_MAT3x4 0x8B68
#define GL_FLOAT_MAT4x2 0x8B69
#define GL_FLOAT_MAT4x3 0x8B6A
#define GL_SRGB 0x8C40
#define GL_SRGB8 0x8C41
#define GL_SRGB_ALPHA 0x8C42
#define GL_SRGB8_ALPHA8 0x8C43
#define GL_COMPRESSED_SRGB 0x8C48
#define GL_COMPRESSED_SRGB_ALPHA 0x8C49

/* GL_VERSION_3_0 */

#define GL_COMPARE_REF_TO_TEXTURE 0x884E
#define GL_CLIP_DISTANCE0 0x3000
#define GL_CLIP_DISTANCE1 0x3001
#define GL_CLIP_DISTANCE2 0x3002
#define GL_CLIP_DISTANCE3 0x3003
#define GL_CLIP_DISTANCE4 0x3004
#define GL_CLIP_DISTANCE5 0x3005
#define GL_CLIP_DISTANCE6 0x3006
#define GL_CLIP_DISTANCE7 0x3007
#define GL_MAX_CLIP_DISTANCES 0x0D32
#define GL_MAJOR_VERSION 0x821B
#define GL_MINOR_VERSION 0x821C
#define GL_NUM_EXTENSIONS 0x821D
#define GL_CONTEXT_FLAGS 0x821E
#define GL_COMPRESSED_RED 0x8225
#define GL_COMPRESSED_RG 0x8226
#define GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT 0x00000001
#define GL_RGBA32F 0x8814
#define GL_RGB32F 0x8815
#define GL_RGBA16F 0x881A
#define GL_RGB16F 0x881B
#define GL_VERTEX_ATTRIB_ARRAY_INTEGER 0x88FD
#define GL_MAX_ARRAY_TEXTURE_LAYERS 0x88FF
#define GL_MIN_PROGRAM_TEXEL_OFFSET 0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET 0x8905
#define GL_CLAMP_READ_COLOR 0x891C
#define GL_FIXED_ONLY 0x891D
#define GL_MAX_VARYING_COMPONENTS 0x8B4B
#define GL_TEXTURE_1D_ARRAY 0x8C18
#define GL_PROXY_TEXTURE_1D_ARRAY 0x8C19
#define GL_TEXTURE_2D_ARRAY 0x8C1A
#define GL_PROXY_TEXTURE_2D_ARRAY 0x8C1B
#define GL_TEXTURE_BINDING_1D_ARRAY 0x8C1C
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_R11F_G11F_B10F 0x8C3A
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B
#define GL_RGB9_E5 0x8C3D
#define GL_UNSIGNED_INT_5_9_9_9_REV 0x8C3E
#define GL_TEXTURE_SHARED_SIZE 0x8C3F
#define GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH 0x8C76
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE 0x8C7F
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS 0x8C80
#define GL_TRANSFORM_FEEDBACK_VARYINGS 0x8C83
#define GL_TRANSFORM_FEEDBACK_BUFFER_START 0x8C84
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE 0x8C85
#define GL_PRIMITIVES_GENERATED 0x8C87
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN 0x8C88
#define GL_RASTERIZER_DISCARD 0x8C89
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS 0x8C8A
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS 0x8C8B
#define GL_INTERLEAVED_ATTRIBS 0x8C8C
#define GL_SEPARATE_ATTRIBS 0x8C8D
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING 0x8C8F
#define GL_RGBA32UI 0x8D70
#define GL_RGB32UI 0x8D71
#define GL_RGBA16UI 0x8D76
#define GL_RGB16UI 0x8D77
#define GL_RGBA8UI 0x8D7C
#define GL_RGB8UI 0x8D7D
#define GL_RGBA32I 0x8D82
#define GL_RGB32I 0x8D83
#define GL_RGBA16I 0x8D88
#define GL_RGB16I 0x8D89
#define GL_RGBA8I 0x8D8E
#define GL_RGB8I 0x8D8F
#define GL_RED_INTEGER 0x8D94
#define GL_GREEN_INTEGER 0x8D95
#define GL_BLUE_INTEGER 0x8D96
#define GL_RGB_INTEGER 0x8D98
#define GL_RGBA_INTEGER 0x8D99
#define GL_BGR_INTEGER 0x8D9A
#define GL_BGRA_INTEGER 0x8D9B
#define GL_SAMPLER_1D_ARRAY 0x8DC0
#define GL_SAMPLER_2D_ARRAY 0x8DC1
#define GL_SAMPLER_1D_ARRAY_SHADOW 0x8DC3
#define GL_SAMPLER_2D_ARRAY_SHADOW 0x8DC4
#define GL_SAMPLER_CUBE_SHADOW 0x8DC5
#define GL_UNSIGNED_INT_VEC2 0x8DC6
#define GL_UNSIGNED_INT_VEC3 0x8DC7
#define GL_UNSIGNED_INT_VEC4 0x8DC8
#define GL_INT_SAMPLER_1D 0x8DC9
#define GL_INT_SAMPLER_2D 0x8DCA
#define GL_INT_SAMPLER_3D 0x8DCB
#define GL_INT_SAMPLER_CUBE 0x8DCC
#define GL_INT_SAMPLER_1D_ARRAY 0x8DCE
#define GL_INT_SAMPLER_2D_ARRAY 0x8DCF
#define GL_UNSIGNED_INT_SAMPLER_1D 0x8DD1
#define GL_UNSIGNED_INT_SAMPLER_2D 0x8DD2
#define GL_UNSIGNED_INT_SAMPLER_3D 0x8DD3
#define GL_UNSIGNED_INT_SAMPLER_CUBE 0x8DD4
#define GL_UNSIGNED_INT_SAMPLER_1D_ARRAY 0x8DD6
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY 0x8DD7
#define GL_QUERY_WAIT 0x8E13
#define GL_QUERY_NO_WAIT 0x8E14
#define GL_QUERY_BY_REGION_WAIT 0x8E15
#define GL_QUERY_BY_REGION_NO_WAIT 0x8E16
#define GL_BUFFER_ACCESS_FLAGS 0x911F
#define GL_BUFFER_MAP_LENGTH 0x9120
#define GL_BUFFER_MAP_OFFSET 0x9121
#define GL_DEPTH_COMPONENT32F 0x8CAC
#define GL_DEPTH32F_STENCIL8 0x8CAD
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV 0x8DAD
#define GL_INVALID_FRAMEBUFFER_OPERATION 0x0506
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING 0x8210
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE 0x8211
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE 0x8212
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE 0x8213
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE 0x8214
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE 0x8215
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE 0x8216
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE 0x8217
#define GL_FRAMEBUFFER_DEFAULT 0x8218
#define GL_FRAMEBUFFER_UNDEFINED 0x8219
#define GL_DEPTH_STENCIL_ATTACHMENT 0x821A
#define GL_MAX_RENDERBUFFER_SIZE 0x84E8
#define GL_DEPTH_STENCIL 0x84F9
#define GL_UNSIGNED_INT_24_8 0x84FA
#define GL_DEPTH24_STENCIL8 0x88F0
#define GL_TEXTURE_STENCIL_SIZE 0x88F1
#define GL_TEXTURE_RED_TYPE 0x8C10
#define GL_TEXTURE_GREEN_TYPE 0x8C11
#define GL_TEXTURE_BLUE_TYPE 0x8C12
#define GL_TEXTURE_ALPHA_TYPE 0x8C13
#define GL_TEXTURE_DEPTH_TYPE 0x8C16
#define GL_UNSIGNED_NORMALIZED 0x8C17
#define GL_FRAMEBUFFER_BINDING 0x8CA6
#define GL_DRAW_FRAMEBUFFER_BINDING 0x8CA6
#define GL_RENDERBUFFER_BINDING 0x8CA7
#define GL_READ_FRAMEBUFFER 0x8CA8
#define GL_DRAW_FRAMEBUFFER 0x8CA9
#define GL_READ_FRAMEBUFFER_BINDING 0x8CAA
#define GL_RENDERBUFFER_SAMPLES 0x8CAB
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE 0x8CD0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME 0x8CD1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL 0x8CD2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE 0x8CD3
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER 0x8CD4
#define GL_FRAMEBUFFER_COMPLETE 0x8CD5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT 0x8CD6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT 0x8CD7
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER 0x8CDB
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER 0x8CDC
#define GL_FRAMEBUFFER_UNSUPPORTED 0x8CDD
#define GL_MAX_COLOR_ATTACHMENTS 0x8CDF
#define GL_COLOR_ATTACHMENT0 0x8CE0
#define GL_COLOR_ATTACHMENT1 0x8CE1
#define GL_COLOR_ATTACHMENT2 0x8CE2
#define GL_COLOR_ATTACHMENT3 0x8CE3
#define GL_COLOR_ATTACHMENT4 0x8CE4
#define GL_COLOR_ATTACHMENT5 0x8CE5
#define GL_COLOR_ATTACHMENT6 0x8CE6
#define GL_COLOR_ATTACHMENT7 0x8CE7
#define GL_COLOR_ATTACHMENT8 0x8CE8
#define GL_COLOR_ATTACHMENT9 0x8CE9
#define GL_COLOR_ATTACHMENT10 0x8CEA
#define GL_COLOR_ATTACHMENT11 0x8CEB
#define GL_COLOR_ATTACHMENT12 0x8CEC
#define GL_COLOR_ATTACHMENT13 0x8CED
#define GL_COLOR_ATTACHMENT14 0x8CEE
#define GL_COLOR_ATTACHMENT15 0x8CEF
#define GL_COLOR_ATTACHMENT16 0x8CF0
#define GL_COLOR_ATTACHMENT17 0x8CF1
#define GL_COLOR_ATTACHMENT18 0x8CF2
#define GL_COLOR_ATTACHMENT19 0x8CF3
#define GL_COLOR_ATTACHMENT20 0x8CF4
#define GL_COLOR_ATTACHMENT21 0x8CF5
#define GL_COLOR_ATTACHMENT22 0x8CF6
#define GL_COLOR_ATTACHMENT23 0x8CF7
#define GL_COLOR_ATTACHMENT24 0x8CF8
#define GL_COLOR_ATTACHMENT25 0x8CF9
#define GL_COLOR_ATTACHMENT26 0x8CFA
#define GL_COLOR_ATTACHMENT27 0x8CFB
#define GL_COLOR_ATTACHMENT28 0x8CFC
#define GL_COLOR_ATTACHMENT29 0x8CFD
#define GL_COLOR_ATTACHMENT30 0x8CFE
#define GL_COLOR_ATTACHMENT31 0x8CFF
#define GL_DEPTH_ATTACHMENT 0x8D00
#define GL_STENCIL_ATTACHMENT 0x8D20
#define GL_FRAMEBUFFER 0x8D40
#define GL_RENDERBUFFER 0x8D41
#define GL_RENDERBUFFER_WIDTH 0x8D42
#define GL_RENDERBUFFER_HEIGHT 0x8D43
#define GL_RENDERBUFFER_INTERNAL_FORMAT 0x8D44
#define GL_STENCIL_INDEX1 0x8D46
#define GL_STENCIL_INDEX4 0x8D47
#define GL_STENCIL_INDEX8 0x8D48
#define GL_STENCIL_INDEX16 0x8D49
#define GL_RENDERBUFFER_RED_SIZE 0x8D50
#define GL_RENDERBUFFER_GREEN_SIZE 0x8D51
#define GL_RENDERBUFFER_BLUE_SIZE 0x8D52
#define GL_RENDERBUFFER_ALPHA_SIZE 0x8D53
#define GL_RENDERBUFFER_DEPTH_SIZE 0x8D54
#define GL_RENDERBUFFER_STENCIL_SIZE 0x8D55
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE 0x8D56
#define GL_MAX_SAMPLES 0x8D57
#define GL_FRAMEBUFFER_SRGB 0x8DB9
#define GL_HALF_FLOAT 0x140B
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT 0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT 0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT 0x0020
#define GL_COMPRESSED_RED_RGTC1 0x8DBB
#define GL_COMPRESSED_SIGNED_RED_RGTC1 0x8DBC
#define GL_COMPRESSED_RG_RGTC2 0x8DBD
#define GL_COMPRESSED_SIGNED_RG_RGTC2 0x8DBE
#define GL_RG 0x8227
#define GL_RG_INTEGER 0x8228
#define GL_R8 0x8229
#define GL_R16 0x822A
#define GL_RG8 0x822B
#define GL_RG16 0x822C
#define GL_R16F 0x822D
#define GL_R32F 0x822E
#define GL_RG16F 0x822F
#define GL_RG32F 0x8230
#define GL_R8I 0x8231
#define GL_R8UI 0x8232
#define GL_R16I 0x8233
#define GL_R16UI 0x8234
#define GL_R32I 0x8235
#define GL_R32UI 0x8236
#define GL_RG8I 0x8237
#define GL_RG8UI 0x8238
#define GL_RG16I 0x8239
#define GL_RG16UI 0x823A
#define GL_RG32I 0x823B
#define GL_RG32UI 0x823C
#define GL_VERTEX_ARRAY_BINDING 0x85B5

/* GL_VERSION_3_1 */

#define GL_SAMPLER_2D_RECT 0x8B63
#define GL_SAMPLER_2D_RECT_SHADOW 0x8B64
#define GL_SAMPLER_BUFFER 0x8DC2
#define GL_INT_SAMPLER_2D_RECT 0x8DCD
#define GL_INT_SAMPLER_BUFFER 0x8DD0
#define GL_UNSIGNED_INT_SAMPLER_2D_RECT 0x8DD5
#define GL_UNSIGNED_INT_SAMPLER_BUFFER 0x8DD8
#define GL_TEXTURE_BUFFER 0x8C2A
#define GL_MAX_TEXTURE_BUFFER_SIZE 0x8C2B
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING 0x8C2D
#define GL_TEXTURE_RECTANGLE 0x84F5
#define GL_TEXTURE_BINDING_RECTANGLE 0x84F6
#define GL_PROXY_TEXTURE_RECTANGLE 0x84F7
#define GL_MAX_RECTANGLE_TEXTURE_SIZE 0x84F8
#define GL_R8_SNORM 0x8F94
#define GL_RG8_SNORM 0x8F95
#define GL_RGB8_SNORM 0x8F96
#define GL_RGBA8_SNORM 0x8F97
#define GL_R16_SNORM 0x8F98
#define GL_RG16_SNORM 0x8F99
#define GL_RGB16_SNORM 0x8F9A
#define GL_RGBA16_SNORM 0x8F9B
#define GL_SIGNED_NORMALIZED 0x8F9C
#define GL_PRIMITIVE_RESTART 0x8F9D
#define GL_PRIMITIVE_RESTART_INDEX 0x8F9E
#define GL_COPY_READ_BUFFER 0x8F36
#define GL_COPY_WRITE_BUFFER 0x8F37
#define GL_UNIFORM_BUFFER 0x8A11
#define GL_UNIFORM_BUFFER_BINDING 0x8A28
#define GL_UNIFORM_BUFFER_START 0x8A29
#define GL_UNIFORM_BUFFER_SIZE 0x8A2A
#define GL_MAX_VERTEX_UNIFORM_BLOCKS 0x8A2B
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS 0x8A2C
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS 0x8A2D
#define GL_MAX_COMBINED_UNIFORM_BLOCKS 0x8A2E
#define GL_MAX_UNIFORM_BUFFER_BINDINGS 0x8A2F
#define GL_MAX_UNIFORM_BLOCK_SIZE 0x8A30
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS 0x8A31
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS 0x8A32
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS 0x8A33
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT 0x8A34
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH 0x8A35
#define GL_ACTIVE_UNIFORM_BLOCKS 0x8A36
#define GL_UNIFORM_TYPE 0x8A37
#define GL_UNIFORM_SIZE 0x8A38
#define GL_UNIFORM_NAME_LENGTH 0x8A39
#define GL_UNIFORM_BLOCK_INDEX 0x8A3A
#define GL_UNIFORM_OFFSET 0x8A3B
#define GL_UNIFORM_ARRAY_STRIDE 0x8A3C
#define GL_UNIFORM_MATRIX_STRIDE 0x8A3D
#define GL_UNIFORM_IS_ROW_MAJOR 0x8A3E
#define GL_UNIFORM_BLOCK_BINDING 0x8A3F
#define GL_UNIFORM_BLOCK_DATA_SIZE 0x8A40
#define GL_UNIFORM_BLOCK_NAME_LENGTH 0x8A41
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS 0x8A42
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES 0x8A43
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER 0x8A44
#define GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER 0x8A45
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER 0x8A46
#define GL_INVALID_INDEX 0xFFFFFFFFu

/* GL_VERSION_3_2 */

#define GL_CONTEXT_CORE_PROFILE_BIT 0x00000001
#define GL_CONTEXT_COMPATIBILITY_PROFILE_BIT 0x00000002
#define GL_LINES_ADJACENCY 0x000A
#define GL_LINE_STRIP_ADJACENCY 0x000B
#define GL_TRIANGLES_ADJACENCY 0x000C
#define GL_TRIANGLE_STRIP_ADJACENCY 0x000D
#define GL_PROGRAM_POINT_SIZE 0x8642
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS 0x8C29
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED 0x8DA7
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS 0x8DA8
#define GL_GEOMETRY_SHADER 0x8DD9
#define GL_GEOMETRY_VERTICES_OUT 0x8916
#define GL_GEOMETRY_INPUT_TYPE 0x8917
#define GL_GEOMETRY_OUTPUT_TYPE 0x8918
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS 0x8DDF
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES 0x8DE0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS 0x8DE1
#define GL_MAX_VERTEX_OUTPUT_COMPONENTS 0x9122
#define GL_MAX_GEOMETRY_INPUT_COMPONENTS 0x9123
#define GL_MAX_GEOMETRY_OUTPUT_COMPONENTS 0x9124
#define GL_MAX_FRAGMENT_INPUT_COMPONENTS 0x9125
#define GL_CONTEXT_PROFILE_MASK 0x9126
#define GL_DEPTH_CLAMP 0x864F
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION 0x8E4C
#define GL_FIRST_VERTEX_CONVENTION 0x8E4D
#define GL_LAST_VERTEX_CONVENTION 0x8E4E
#define GL_PROVOKING_VERTEX 0x8E4F
#define GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F
#define GL_MAX_SERVER_WAIT_TIMEOUT 0x9111
#define GL_OBJECT_TYPE 0x9112
#define GL_SYNC_CONDITION 0x9113
#define GL_SYNC_STATUS 0x9114
#define GL_SYNC_FLAGS 0x9115
#define GL_SYNC_FENCE 0x9116
#define GL_SYNC_GPU_COMMANDS_COMPLETE 0x9117
#define GL_UNSIGNALED 0x9118
#define GL_SIGNALED 0x9119
#define GL_ALREADY_SIGNALED 0x911A
#define GL_TIMEOUT_EXPIRED 0x911B
#define GL_CONDITION_SATISFIED 0x911C
#define GL_WAIT_FAILED 0x911D
#define GL_TIMEOUT_IGNORED 0xFFFFFFFFFFFFFFFFull
#define GL_SYNC_FLUSH_COMMANDS_BIT 0x00000001
#define GL_SAMPLE_POSITION 0x8E50
#define GL_SAMPLE_MASK 0x8E51
#define GL_SAMPLE_MASK_VALUE 0x8E52
#define GL_MAX_SAMPLE_MASK_WORDS 0x8E59
#define GL_TEXTURE_2D_MULTISAMPLE 0x9100
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE 0x9101
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9102
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY 0x9103
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_TEXTURE_SAMPLES 0x9106
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS 0x9107
#define GL_SAMPLER_2D_MULTISAMPLE 0x9108
#define GL_INT_SAMPLER_2D_MULTISAMPLE 0x9109
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE 0x910A
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910B
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910C
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY 0x910D
#define GL_MAX_COLOR_TEXTURE_SAMPLES 0x910E
#define GL_MAX_DEPTH_TEXTURE_SAMPLES 0x910F
#define GL_MAX_INTEGER_SAMPLES 0x9110

/* GL_VERSION_3_3 */

#define GL_VERTEX_ATTRIB_ARRAY_DIVISOR 0x88FE
#define GL_SRC1_COLOR 0x88F9
#define GL_ONE_MINUS_SRC1_COLOR 0x88FA
#define GL_ONE_MINUS_SRC1_ALPHA 0x88FB
#define GL_MAX_DUAL_SOURCE_DRAW_BUFFERS 0x88FC
#define GL_ANY_SAMPLES_PASSED 0x8C2F
#define GL_SAMPLER_BINDING 0x8919
#define GL_RGB10_A2UI 0x906F
#define GL_TEXTURE_SWIZZLE_R 0x8E42
#define GL_TEXTURE_SWIZZLE_G 0x8E43
#define GL_TEXTURE_SWIZZLE_B 0x8E44
#define GL_TEXTURE_SWIZZLE_A 0x8E45
#define GL_TEXTURE_SWIZZLE_RGBA 0x8E46
#define GL_TIME_ELAPSED 0x88BF
#define GL_TIMESTAMP 0x8E28
#define GL_INT_2_10_10_10_REV 0x8D9F

/* GL_VERSION_4_0 */

#define GL_SAMPLE_SHADING 0x8C36
#define GL_MIN_SAMPLE_SHADING_VALUE 0x8C37
#define GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5E
#define GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET 0x8E5F
#define GL_TEXTURE_CUBE_MAP_ARRAY 0x9009
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY 0x900A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARRAY 0x900B
#define GL_SAMPLER_CUBE_MAP_ARRAY 0x900C
#define GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW 0x900D
#define GL_INT_SAMPLER_CUBE_MAP_ARRAY 0x900E
#define GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY 0x900F
#define GL_DRAW_INDIRECT_BUFFER 0x8F3F
#define GL_DRAW_INDIRECT_BUFFER_BINDING 0x8F43
#define GL_GEOMETRY_SHADER_INVOCATIONS 0x887F
#define GL_MAX_GEOMETRY_SHADER_INVOCATIONS 0x8E5A
#define GL_MIN_FRAGMENT_INTERPOLATION_OFFSET 0x8E5B
#define GL_MAX_FRAGMENT_INTERPOLATION_OFFSET 0x8E5C
#define GL_FRAGMENT_INTERPOLATION_OFFSET_BITS 0x8E5D
#define GL_MAX_VERTEX_STREAMS 0x8E71
#define GL_DOUBLE_VEC2 0x8FFC
#define GL_DOUBLE_VEC3 0x8FFD
#define GL_DOUBLE_VEC4 0x8FFE
#define GL_DOUBLE_MAT2 0x8F46
#define GL_DOUBLE_MAT3 0x8F47
#define GL_DOUBLE_MAT4 0x8F48
#define GL_DOUBLE_MAT2x3 0x8F49
#define GL_DOUBLE_MAT2x4 0x8F4A
#define GL_DOUBLE_MAT3x2 0x8F4B
#define GL_DOUBLE_MAT3x4 0x8F4C
#define GL_DOUBLE_MAT4x2 0x8F4D
#define GL_DOUBLE_MAT4x3 0x8F4E
#define GL_ACTIVE_SUBROUTINES 0x8DE5
#define GL_ACTIVE_SUBROUTINE_UNIFORMS 0x8DE6
#define GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS 0x8E47
#define GL_ACTIVE_SUBROUTINE_MAX_LENGTH 0x8E48
#define GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH 0x8E49
#define GL_MAX_SUBROUTINES 0x8DE7
#define GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS 0x8DE8
#define GL_NUM_COMPATIBLE_SUBROUTINES 0x8E4A
#define GL_COMPATIBLE_SUBROUTINES 0x8E4B
#define GL_PATCHES 0x000E
#define GL_PATCH_VERTICES 0x8E72
#define GL_PATCH_DEFAULT_INNER_LEVEL 0x8E73
#define GL_PATCH_DEFAULT_OUTER_LEVEL 0x8E74
#define GL_TESS_CONTROL_OUTPUT_VERTICES 0x8E75
#define GL_TESS_GEN_MODE 0x8E76
#define GL_TESS_GEN_SPACING 0x8E77
#define GL_TESS_GEN_VERTEX_ORDER 0x8E78
#define GL_TESS_GEN_POINT_MODE 0x8E79
#define GL_ISOLINES 0x8E7A
#define GL_QUADS 0x0007
#define GL_FRACTIONAL_ODD 0x8E7B
#define GL_FRACTIONAL_EVEN 0x8E7C
#define GL_MAX_PATCH_VERTICES 0x8E7D
#define GL_MAX_TESS_GEN_LEVEL 0x8E7E
#define GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E7F
#define GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E80
#define GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS 0x8E81
#define GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS 0x8E82
#define GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS 0x8E83
#define GL_MAX_TESS_PATCH_COMPONENTS 0x8E84
#define GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS 0x8E85
#define GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS 0x8E86
#define GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS 0x8E89
#define GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS 0x8E8A
#define GL_MAX_TESS_CONTROL_INPUT_COMPONENTS 0x886C
#define GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS 0x886D
#define GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS 0x8E1E
#define GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS 0x8E1F
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER 0x84F0
#define GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER 0x84F1
#define GL_TESS_EVALUATION_SHADER 0x8E87
#define GL_TESS_CONTROL_SHADER 0x8E88
#define GL_TRANSFORM_FEEDBACK 0x8E22
#define GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED 0x8E23
#define GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE 0x8E24
#define GL_TRANSFORM_FEEDBACK_BINDING 0x8E25
#define GL_MAX_TRANSFORM_FEEDBACK_BUFFERS 0x8E70
#define GL_MAX_VERTEX_STREAMS 0x8E71

/* GL_VERSION_4_1 */

#define GL_FIXED 0x140C
#define GL_IMPLEMENTATION_COLOR_READ_TYPE 0x8B9A
#define GL_IMPLEMENTATION_COLOR_READ_FORMAT 0x8B9B
#define GL_LOW_FLOAT 0x8DF0
#define GL_MEDIUM_FLOAT 0x8DF1
#define GL_HIGH_FLOAT 0x8DF2
#define GL_LOW_INT 0x8DF3
#define GL_MEDIUM_INT 0x8DF4
#define GL_HIGH_INT 0x8DF5
#define GL_SHADER_COMPILER 0x8DFA
#define GL_SHADER_BINARY_FORMATS 0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS 0x8DF9
#define GL_MAX_VERTEX_UNIFORM_VECTORS 0x8DFB
#define GL_MAX_VARYING_VECTORS 0x8DFC
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS 0x8DFD
#define GL_RGB565 0x8D62
#define GL_PROGRAM_BINARY_RETRIEVABLE_HINT 0x8257
#define GL_PROGRAM_BINARY_LENGTH 0x8741
#define GL_NUM_PROGRAM_BINARY_FORMATS 0x87FE
#define GL_PROGRAM_BINARY_FORMATS 0x87FF
#define GL_VERTEX_SHADER_BIT 0x00000001
#define GL_FRAGMENT_SHADER_BIT 0x00000002
#define GL_GEOMETRY_SHADER_BIT 0x00000004
#define GL_TESS_CONTROL_SHADER_BIT 0x00000008
#define GL_TESS_EVALUATION_SHADER_BIT 0x00000010
#define GL_ALL_SHADER_BITS 0xFFFFFFFF
#define GL_PROGRAM_SEPARABLE 0x8258
#define GL_ACTIVE_PROGRAM 0x8259
#define GL_PROGRAM_PIPELINE_BINDING 0x825A
#define GL_MAX_VIEWPORTS 0x825B
#define GL_VIEWPORT_SUBPIXEL_BITS 0x825C
#define GL_VIEWPORT_BOUNDS_RANGE 0x825D
#define GL_LAYER_PROVOKING_VERTEX 0x825E
#define GL_VIEWPORT_INDEX_PROVOKING_VERTEX 0x825F
#define GL_UNDEFINED_VERTEX 0x8260

/* GL_VERSION_4_2 */

#define GL_COPY_READ_BUFFER_BINDING 0x8F36
#define GL_COPY_WRITE_BUFFER_BINDING 0x8F37
#define GL_TRANSFORM_FEEDBACK_ACTIVE 0x8E24
#define GL_TRANSFORM_FEEDBACK_PAUSED 0x8E23
#define GL_UNPACK_COMPRESSED_BLOCK_WIDTH 0x9127
#define GL_UNPACK_COMPRESSED_BLOCK_HEIGHT 0x9128
#define GL_UNPACK_COMPRESSED_BLOCK_DEPTH 0x9129
#define GL_UNPACK_COMPRESSED_BLOCK_SIZE 0x912A
#define GL_PACK_COMPRESSED_BLOCK_WIDTH 0x912B
#define GL_PACK_COMPRESSED_BLOCK_HEIGHT 0x912C
#define GL_PACK_COMPRESSED_BLOCK_DEPTH 0x912D
#define GL_PACK_COMPRESSED_BLOCK_SIZE 0x912E
#define GL_NUM_SAMPLE_COUNTS 0x9380
#define GL_MIN_MAP_BUFFER_ALIGNMENT 0x90BC
#define GL_ATOMIC_COUNTER_BUFFER 0x92C0
#define GL_ATOMIC_COUNTER_BUFFER_BINDING 0x92C1
#define GL_ATOMIC_COUNTER_BUFFER_START 0x92C2
#define GL_ATOMIC_COUNTER_BUFFER_SIZE 0x92C3
#define GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE 0x92C4
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS 0x92C5
#define GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES 0x92C6
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER 0x92C7
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER 0x92C8
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER 0x92C9
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER 0x92CA
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER 0x92CB
#define GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS 0x92CC
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS 0x92CD
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS 0x92CE
#define GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS 0x92CF
#define GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS 0x92D0
#define GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS 0x92D1
#define GL_MAX_VERTEX_ATOMIC_COUNTERS 0x92D2
#define GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS 0x92D3
#define GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS 0x92D4
#define GL_MAX_GEOMETRY_ATOMIC_COUNTERS 0x92D5
#define GL_MAX_FRAGMENT_ATOMIC_COUNTERS 0x92D6
#define GL_MAX_COMBINED_ATOMIC_COUNTERS 0x92D7
#define GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE 0x92D8
#define GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS 0x92DC
#define GL_ACTIVE_ATOMIC_COUNTER_BUFFERS 0x92D9
#define GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX 0x92DA
#define GL_UNSIGNED_INT_ATOMIC_COUNTER 0x92DB
#define GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT 0x00000001
#define GL_ELEMENT_ARRAY_BARRIER_BIT 0x00000002
#define GL_UNIFORM_BARRIER_BIT 0x00000004
#define GL_TEXTURE_FETCH_BARRIER_BIT 0x00000008
#define GL_SHADER_IMAGE_ACCESS_BARRIER_BIT 0x00000020
#define GL_COMMAND_BARRIER_BIT 0x00000040
#define GL_PIXEL_BUFFER_BARRIER_BIT 0x00000080
#define GL_TEXTURE_UPDATE_BARRIER_BIT 0x00000100
#define GL_BUFFER_UPDATE_BARRIER_BIT 0x00000200
#define GL_FRAMEBUFFER_BARRIER_BIT 0x00000400
#define GL_TRANSFORM_FEEDBACK_BARRIER_BIT 0x00000800
#define GL_ATOMIC_COUNTER_BARRIER_BIT 0x00001000
#define GL_ALL_BARRIER_BITS 0xFFFFFFFF
#define GL_MAX_IMAGE_UNITS 0x8F38
#define GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS 0x8F39
#define GL_IMAGE_BINDING_NAME 0x8F3A
#define GL_IMAGE_BINDING_LEVEL 0x8F3B
#define GL_IMAGE_BINDING_LAYERED 0x8F3C
#define GL_IMAGE_BINDING_LAYER 0x8F3D
#define GL_IMAGE_BINDING_ACCESS 0x8F3E
#define GL_IMAGE_1D 0x904C
#define GL_IMAGE_2D 0x904D
#define GL_IMAGE_3D 0x904E
#define GL_IMAGE_2D_RECT 0x904F
#define GL_IMAGE_CUBE 0x9050
#define GL_IMAGE_BUFFER 0x9051
#define GL_IMAGE_1D_ARRAY 0x9052
#define GL_IMAGE_2D_ARRAY 0x9053
#define GL_IMAGE_CUBE_MAP_ARRAY 0x9054
#define GL_IMAGE_2D_MULTISAMPLE 0x9055
#define GL_IMAGE_2D_MULTISAMPLE_ARRAY 0x9056
#define GL_INT_IMAGE_1D 0x9057
#define GL_INT_IMAGE_2D 0x9058
#define GL_INT_IMAGE_3D 0x9059
#define GL_INT_IMAGE_2D_RECT 0x905A
#define GL_INT_IMAGE_CUBE 0x905B
#define GL_INT_IMAGE_BUFFER 0x905C
#define GL_INT_IMAGE_1D_ARRAY 0x905D
#define GL_INT_IMAGE_2D_ARRAY 0x905E
#define GL_INT_IMAGE_CUBE_MAP_ARRAY 0x905F
#define GL_INT_IMAGE_2D_MULTISAMPLE 0x9060
#define GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY 0x9061
#define GL_UNSIGNED_INT_IMAGE_1D 0x9062
#define GL_UNSIGNED_INT_IMAGE_2D 0x9063
#define GL_UNSIGNED_INT_IMAGE_3D 0x9064
#define GL_UNSIGNED_INT_IMAGE_2D_RECT 0x9065
#define GL_UNSIGNED_INT_IMAGE_CUBE 0x9066
#define GL_UNSIGNED_INT_IMAGE_BUFFER 0x9067
#define GL_UNSIGNED_INT_IMAGE_1D_ARRAY 0x9068
#define GL_UNSIGNED_INT_IMAGE_2D_ARRAY 0x9069
#define GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY 0x906A
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE 0x906B
#define GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY 0x906C
#define GL_MAX_IMAGE_SAMPLES 0x906D
#define GL_IMAGE_BINDING_FORMAT 0x906E
#define GL_IMAGE_FORMAT_COMPATIBILITY_TYPE 0x90C7
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE 0x90C8
#define GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS 0x90C9
#define GL_MAX_VERTEX_IMAGE_UNIFORMS 0x90CA
#define GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS 0x90CB
#define GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS 0x90CC
#define GL_MAX_GEOMETRY_IMAGE_UNIFORMS 0x90CD
#define GL_MAX_FRAGMENT_IMAGE_UNIFORMS 0x90CE
#define GL_MAX_COMBINED_IMAGE_UNIFORMS 0x90CF
#define GL_COMPRESSED_RGBA_BPTC_UNORM 0x8E8C
#define GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM 0x8E8D
#define GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT 0x8E8E
#define GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT 0x8E8F
#define GL_TEXTURE_IMMUTABLE_FORMAT 0x912F

/* GL_VERSION_4_3 */

#define GL_NUM_SHADING_LANGUAGE_VERSIONS 0x82E9
#define GL_VERTEX_ATTRIB_ARRAY_LONG 0x874E
#define GL_COMPRESSED_RGB8_ETC2 0x9274
#define GL_COMPRESSED_SRGB8_ETC2 0x9275
#define GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9276
#define GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 0x9277
#define GL_COMPRESSED_RGBA8_ETC2_EAC 0x9278
#define GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC 0x9279
#define GL_COMPRESSED_R11_EAC 0x9270
#define GL_COMPRESSED_SIGNED_R11_EAC 0x9271
#define GL_COMPRESSED_RG11_EAC 0x9272
#define GL_COMPRESSED_SIGNED_RG11_EAC 0x9273
#define GL_PRIMITIVE_RESTART_FIXED_INDEX 0x8D69
#define GL_ANY_SAMPLES_PASSED_CONSERVATIVE 0x8D6A
#define GL_MAX_ELEMENT_INDEX 0x8D6B
#define GL_COMPUTE_SHADER 0x91B9
#define GL_MAX_COMPUTE_UNIFORM_BLOCKS 0x91BB
#define GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS 0x91BC
#define GL_MAX_COMPUTE_IMAGE_UNIFORMS 0x91BD
#define GL_MAX_COMPUTE_SHARED_MEMORY_SIZE 0x8262
#define GL_MAX_COMPUTE_UNIFORM_COMPONENTS 0x8263
#define GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS 0x8264
#define GL_MAX_COMPUTE_ATOMIC_COUNTERS 0x8265
#define GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS 0x8266
#define GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS 0x90EB
#define GL_MAX_COMPUTE_WORK_GROUP_COUNT 0x91BE
#define GL_MAX_COMPUTE_WORK_GROUP_SIZE 0x91BF
#define GL_COMPUTE_WORK_GROUP_SIZE 0x8267
#define GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER 0x90EC
#define GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER 0x90ED
#define GL_DISPATCH_INDIRECT_BUFFER 0x90EE
#define GL_DISPATCH_INDIRECT_BUFFER_BINDING 0x90EF
#define GL_COMPUTE_SHADER_BIT 0x00000020
#define GL_DEBUG_OUTPUT_SYNCHRONOUS 0x8242
#define GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH 0x8243
#define GL_DEBUG_CALLBACK_FUNCTION 0x8244
#define GL_DEBUG_CALLBACK_USER_PARAM 0x8245
#define GL_DEBUG_SOURCE_API 0x8246
#define GL_DEBUG_SOURCE_WINDOW_SYSTEM 0x8247
#define GL_DEBUG_SOURCE_SHADER_COMPILER 0x8248
#define GL_DEBUG_SOURCE_THIRD_PARTY 0x8249
#define GL_DEBUG_SOURCE_APPLICATION 0x824A
#define GL_DEBUG_SOURCE_OTHER 0x824B
#define GL_DEBUG_TYPE_ERROR 0x824C
#define GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR 0x824D
#define GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR 0x824E
#define GL_DEBUG_TYPE_PORTABILITY 0x824F
#define GL_DEBUG_TYPE_PERFORMANCE 0x8250
#define GL_DEBUG_TYPE_OTHER 0x8251
#define GL_MAX_DEBUG_MESSAGE_LENGTH 0x9143
#define GL_MAX_DEBUG_LOGGED_MESSAGES 0x9144
#define GL_DEBUG_LOGGED_MESSAGES 0x9145
#define GL_DEBUG_SEVERITY_HIGH 0x9146
#define GL_DEBUG_SEVERITY_MEDIUM 0x9147
#define GL_DEBUG_SEVERITY_LOW 0x9148
#define GL_DEBUG_TYPE_MARKER 0x8268
#define GL_DEBUG_TYPE_PUSH_GROUP 0x8269
#define GL_DEBUG_TYPE_POP_GROUP 0x826A
#define GL_DEBUG_SEVERITY_NOTIFICATION 0x826B
#define GL_MAX_DEBUG_GROUP_STACK_DEPTH 0x826C
#define GL_DEBUG_GROUP_STACK_DEPTH 0x826D
#define GL_BUFFER 0x82E0
#define GL_SHADER 0x82E1
#define GL_PROGRAM 0x82E2
#define GL_VERTEX_ARRAY 0x8074
#define GL_QUERY 0x82E3
#define GL_PROGRAM_PIPELINE 0x82E4
#define GL_SAMPLER 0x82E6
#define GL_MAX_LABEL_LENGTH 0x82E8
#define GL_DEBUG_OUTPUT 0x92E0
#define GL_CONTEXT_FLAG_DEBUG_BIT 0x00000002
#define GL_MAX_UNIFORM_LOCATIONS 0x826E
#define GL_FRAMEBUFFER_DEFAULT_WIDTH 0x9310
#define GL_FRAMEBUFFER_DEFAULT_HEIGHT 0x9311
#define GL_FRAMEBUFFER_DEFAULT_LAYERS 0x9312
#define GL_FRAMEBUFFER_DEFAULT_SAMPLES 0x9313
#define GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS 0x9314
#define GL_MAX_FRAMEBUFFER_WIDTH 0x9315
#define GL_MAX_FRAMEBUFFER_HEIGHT 0x9316
#define GL_MAX_FRAMEBUFFER_LAYERS 0x9317
#define GL_MAX_FRAMEBUFFER_SAMPLES 0x9318
#define GL_INTERNALFORMAT_SUPPORTED 0x826F
#define GL_INTERNALFORMAT_PREFERRED 0x8270
#define GL_INTERNALFORMAT_RED_SIZE 0x8271
#define GL_INTERNALFORMAT_GREEN_SIZE 0x8272
#define GL_INTERNALFORMAT_BLUE_SIZE 0x8273
#define GL_INTERNALFORMAT_ALPHA_SIZE 0x8274
#define GL_INTERNALFORMAT_DEPTH_SIZE 0x8275
#define GL_INTERNALFORMAT_STENCIL_SIZE 0x8276
#define GL_INTERNALFORMAT_SHARED_SIZE 0x8277
#define GL_INTERNALFORMAT_RED_TYPE 0x8278
#define GL_INTERNALFORMAT_GREEN_TYPE 0x8279
#define GL_INTERNALFORMAT_BLUE_TYPE 0x827A
#define GL_INTERNALFORMAT_ALPHA_TYPE 0x827B
#define GL_INTERNALFORMAT_DEPTH_TYPE 0x827C
#define GL_INTERNALFORMAT_STENCIL_TYPE 0x827D
#define GL_MAX_WIDTH 0x827E
#define GL_MAX_HEIGHT 0x827F
#define GL_MAX_DEPTH 0x8280
#define GL_MAX_LAYERS 0x8281
#define GL_MAX_COMBINED_DIMENSIONS 0x8282
#define GL_COLOR_COMPONENTS 0x8283
#define GL_DEPTH_COMPONENTS 0x8284
#define GL_STENCIL_COMPONENTS 0x8285
#define GL_COLOR_RENDERABLE 0x8286
#define GL_DEPTH_RENDERABLE 0x8287
#define GL_STENCIL_RENDERABLE 0x8288
#define GL_FRAMEBUFFER_RENDERABLE 0x8289
#define GL_FRAMEBUFFER_RENDERABLE_LAYERED 0x828A
#define GL_FRAMEBUFFER_BLEND 0x828B
#define GL_READ_PIXELS 0x828C
#define GL_READ_PIXELS_FORMAT 0x828D
#define GL_READ_PIXELS_TYPE 0x828E
#define GL_TEXTURE_IMAGE_FORMAT 0x828F
#define GL_TEXTURE_IMAGE_TYPE 0x8290
#define GL_GET_TEXTURE_IMAGE_FORMAT 0x8291
#define GL_GET_TEXTURE_IMAGE_TYPE 0x8292
#define GL_MIPMAP 0x8293
#define GL_MANUAL_GENERATE_MIPMAP 0x8294
#define GL_AUTO_GENERATE_MIPMAP 0x8295
#define GL_COLOR_ENCODING 0x8296
#define GL_SRGB_READ 0x8297
#define GL_SRGB_WRITE 0x8298
#define GL_FILTER 0x829A
#define GL_VERTEX_TEXTURE 0x829B
#define GL_TESS_CONTROL_TEXTURE 0x829C
#define GL_TESS_EVALUATION_TEXTURE 0x829D
#define GL_GEOMETRY_TEXTURE 0x829E
#define GL_FRAGMENT_TEXTURE 0x829F
#define GL_COMPUTE_TEXTURE 0x82A0
#define GL_TEXTURE_SHADOW 0x82A1
#define GL_TEXTURE_GATHER 0x82A2
#define GL_TEXTURE_GATHER_SHADOW 0x82A3
#define GL_SHADER_IMAGE_LOAD 0x82A4
#define GL_SHADER_IMAGE_STORE 0x82A5
#define GL_SHADER_IMAGE_ATOMIC 0x82A6
#define GL_IMAGE_TEXEL_SIZE 0x82A7
#define GL_IMAGE_COMPATIBILITY_CLASS 0x82A8
#define GL_IMAGE_PIXEL_FORMAT 0x82A9
#define GL_IMAGE_PIXEL_TYPE 0x82AA
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST 0x82AC
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST 0x82AD
#define GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE 0x82AE
#define GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE 0x82AF
#define GL_TEXTURE_COMPRESSED_BLOCK_WIDTH 0x82B1
#define GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT 0x82B2
#define GL_TEXTURE_COMPRESSED_BLOCK_SIZE 0x82B3
#define GL_CLEAR_BUFFER 0x82B4
#define GL_TEXTURE_VIEW 0x82B5
#define GL_VIEW_COMPATIBILITY_CLASS 0x82B6
#define GL_FULL_SUPPORT 0x82B7
#define GL_CAVEAT_SUPPORT 0x82B8
#define GL_IMAGE_CLASS_4_X_32 0x82B9
#define GL_IMAGE_CLASS_2_X_32 0x82BA
#define GL_IMAGE_CLASS_1_X_32 0x82BB
#define GL_IMAGE_CLASS_4_X_16 0x82BC
#define GL_IMAGE_CLASS_2_X_16 0x82BD
#define GL_IMAGE_CLASS_1_X_16 0x82BE
#define GL_IMAGE_CLASS_4_X_8 0x82BF
#define GL_IMAGE_CLASS_2_X_8 0x82C0
#define GL_IMAGE_CLASS_1_X_8 0x82C1
#define GL_IMAGE_CLASS_11_11_10 0x82C2
#define GL_IMAGE_CLASS_10_10_10_2 0x82C3
#define GL_VIEW_CLASS_128_BITS 0x82C4
#define GL_VIEW_CLASS_96_BITS 0x82C5
#define GL_VIEW_CLASS_64_BITS 0x82C6
#define GL_VIEW_CLASS_48_BITS 0x82C7
#define GL_VIEW_CLASS_32_BITS 0x82C8
#define GL_VIEW_CLASS_24_BITS 0x82C9
#define GL_VIEW_CLASS_16_BITS 0x82CA
#define GL_VIEW_CLASS_8_BITS 0x82CB
#define GL_VIEW_CLASS_S3TC_DXT1_RGB 0x82CC
#define GL_VIEW_CLASS_S3TC_DXT1_RGBA 0x82CD
#define GL_VIEW_CLASS_S3TC_DXT3_RGBA 0x82CE
#define GL_VIEW_CLASS_S3TC_DXT5_RGBA 0x82CF
#define GL_VIEW_CLASS_RGTC1_RED 0x82D0
#define GL_VIEW_CLASS_RGTC2_RG 0x82D1
#define GL_VIEW_CLASS_BPTC_UNORM 0x82D2
#define GL_VIEW_CLASS_BPTC_FLOAT 0x82D3
#define GL_UNIFORM 0x92E1
#define GL_UNIFORM_BLOCK 0x92E2
#define GL_PROGRAM_INPUT 0x92E3
#define GL_PROGRAM_OUTPUT 0x92E4
#define GL_BUFFER_VARIABLE 0x92E5
#define GL_SHADER_STORAGE_BLOCK 0x92E6
#define GL_VERTEX_SUBROUTINE 0x92E8
#define GL_TESS_CONTROL_SUBROUTINE 0x92E9
#define GL_TESS_EVALUATION_SUBROUTINE 0x92EA
#define GL_GEOMETRY_SUBROUTINE 0x92EB
#define GL_FRAGMENT_SUBROUTINE 0x92EC
#define GL_COMPUTE_SUBROUTINE 0x92ED
#define GL_VERTEX_SUBROUTINE_UNIFORM 0x92EE
#define GL_TESS_CONTROL_SUBROUTINE_UNIFORM 0x92EF
#define GL_TESS_EVALUATION_SUBROUTINE_UNIFORM 0x92F0
#define GL_GEOMETRY_SUBROUTINE_UNIFORM 0x92F1
#define GL_FRAGMENT_SUBROUTINE_UNIFORM 0x92F2
#define GL_COMPUTE_SUBROUTINE_UNIFORM 0x92F3
#define GL_TRANSFORM_FEEDBACK_VARYING 0x92F4
#define GL_ACTIVE_RESOURCES 0x92F5
#define GL_MAX_NAME_LENGTH 0x92F6
#define GL_MAX_NUM_ACTIVE_VARIABLES 0x92F7
#define GL_MAX_NUM_COMPATIBLE_SUBROUTINES 0x92F8
#define GL_NAME_LENGTH 0x92F9
#define GL_TYPE 0x92FA
#define GL_ARRAY_SIZE 0x92FB
#define GL_OFFSET 0x92FC
#define GL_BLOCK_INDEX 0x92FD
#define GL_ARRAY_STRIDE 0x92FE
#define GL_MATRIX_STRIDE 0x92FF
#define GL_IS_ROW_MAJOR 0x9300
#define GL_ATOMIC_COUNTER_BUFFER_INDEX 0x9301
#define GL_BUFFER_BINDING 0x9302
#define GL_BUFFER_DATA_SIZE 0x9303
#define GL_NUM_ACTIVE_VARIABLES 0x9304
#define GL_ACTIVE_VARIABLES 0x9305
#define GL_REFERENCED_BY_VERTEX_SHADER 0x9306
#define GL_REFERENCED_BY_TESS_CONTROL_SHADER 0x9307
#define GL_REFERENCED_BY_TESS_EVALUATION_SHADER 0x9308
#define GL_REFERENCED_BY_GEOMETRY_SHADER 0x9309
#define GL_REFERENCED_BY_FRAGMENT_SHADER 0x930A
#define GL_REFERENCED_BY_COMPUTE_SHADER 0x930B
#define GL_TOP_LEVEL_ARRAY_SIZE 0x930C
#define GL_TOP_LEVEL_ARRAY_STRIDE 0x930D
#define GL_LOCATION 0x930E
#define GL_LOCATION_INDEX 0x930F
#define GL_IS_PER_PATCH 0x92E7
#define GL_SHADER_STORAGE_BUFFER 0x90D2
#define GL_SHADER_STORAGE_BUFFER_BINDING 0x90D3
#define GL_SHADER_STORAGE_BUFFER_START 0x90D4
#define GL_SHADER_STORAGE_BUFFER_SIZE 0x90D5
#define GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS 0x90D6
#define GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS 0x90D7
#define GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS 0x90D8
#define GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS 0x90D9
#define GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS 0x90DA
#define GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS 0x90DB
#define GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS 0x90DC
#define GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS 0x90DD
#define GL_MAX_SHADER_STORAGE_BLOCK_SIZE 0x90DE
#define GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT 0x90DF
#define GL_SHADER_STORAGE_BARRIER_BIT 0x00002000
#define GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES 0x8F39
#define GL_DEPTH_STENCIL_TEXTURE_MODE 0x90EA
#define GL_TEXTURE_BUFFER_OFFSET 0x919D
#define GL_TEXTURE_BUFFER_SIZE 0x919E
#define GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT 0x919F
#define GL_TEXTURE_VIEW_MIN_LEVEL 0x82DB
#define GL_TEXTURE_VIEW_NUM_LEVELS 0x82DC
#define GL_TEXTURE_VIEW_MIN_LAYER 0x82DD
#define GL_TEXTURE_VIEW_NUM_LAYERS 0x82DE
#define GL_TEXTURE_IMMUTABLE_LEVELS 0x82DF
#define GL_VERTEX_ATTRIB_BINDING 0x82D4
#define GL_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D5
#define GL_VERTEX_BINDING_DIVISOR 0x82D6
#define GL_VERTEX_BINDING_OFFSET 0x82D7
#define GL_VERTEX_BINDING_STRIDE 0x82D8
#define GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET 0x82D9
#define GL_MAX_VERTEX_ATTRIB_BINDINGS 0x82DA
#define GL_VERTEX_BINDING_BUFFER 0x8F4F
#define GL_STACK_UNDERFLOW 0x0504
#define GL_STACK_OVERFLOW 0x0503

/* GL_VERSION_4_4 */

#define GL_MAX_VERTEX_ATTRIB_STRIDE 0x82E5
#define GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED 0x8221
#define GL_TEXTURE_BUFFER_BINDING 0x8C2A
#define GL_MAP_READ_BIT 0x0001
#define GL_MAP_WRITE_BIT 0x0002
#define GL_MAP_PERSISTENT_BIT 0x0040
#define GL_MAP_COHERENT_BIT 0x0080
#define GL_DYNAMIC_STORAGE_BIT 0x0100
#define GL_CLIENT_STORAGE_BIT 0x0200
#define GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT 0x00004000
#define GL_BUFFER_IMMUTABLE_STORAGE 0x821F
#define GL_BUFFER_STORAGE_FLAGS 0x8220
#define GL_CLEAR_TEXTURE 0x9365
#define GL_LOCATION_COMPONENT 0x934A
#define GL_TRANSFORM_FEEDBACK_BUFFER 0x8C8E
#define GL_TRANSFORM_FEEDBACK_BUFFER_INDEX 0x934B
#define GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE 0x934C
#define GL_QUERY_BUFFER 0x9192
#define GL_QUERY_BUFFER_BARRIER_BIT 0x00008000
#define GL_QUERY_BUFFER_BINDING 0x9193
#define GL_QUERY_RESULT_NO_WAIT 0x9194
#define GL_MIRROR_CLAMP_TO_EDGE 0x8743
#define GL_STENCIL_INDEX 0x1901
#define GL_STENCIL_INDEX8 0x8D48
#define GL_UNSIGNED_INT_10F_11F_11F_REV 0x8C3B

/* GL_VERSION_4_5 */

#define GL_CONTEXT_LOST 0x0507
#define GL_LOWER_LEFT 0x8CA1
#define GL_UPPER_LEFT 0x8CA2
#define GL_NEGATIVE_ONE_TO_ONE 0x935E
#define GL_ZERO_TO_ONE 0x935F
#define GL_CLIP_ORIGIN 0x935C
#define GL_CLIP_DEPTH_MODE 0x935D
#define GL_QUERY_WAIT_INVERTED 0x8E17
#define GL_QUERY_NO_WAIT_INVERTED 0x8E18
#define GL_QUERY_BY_REGION_WAIT_INVERTED 0x8E19
#define GL_QUERY_BY_REGION_NO_WAIT_INVERTED 0x8E1A
#define GL_MAX_CULL_DISTANCES 0x82F9
#define GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES 0x82FA
#define GL_TEXTURE_TARGET 0x1006
#define GL_QUERY_TARGET 0x82EA
#define GL_TEXTURE_BINDING_1D 0x8068
#define GL_TEXTURE_BINDING_1D_ARRAY 0x8C1C
#define GL_TEXTURE_BINDING_2D 0x8069
#define GL_TEXTURE_BINDING_2D_ARRAY 0x8C1D
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE 0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY 0x9105
#define GL_TEXTURE_BINDING_3D 0x806A
#define GL_TEXTURE_BINDING_BUFFER 0x8C2C
#define GL_TEXTURE_BINDING_CUBE_MAP 0x8514
#define GL_TEXTURE_BINDING_CUBE_MAP_ARRAY 0x900A
#define GL_TEXTURE_BINDING_RECTANGLE 0x84F6
#define GL_BACK 0x0405
#define GL_NO_ERROR 0
#define GL_GUILTY_CONTEXT_RESET 0x8253
#define GL_INNOCENT_CONTEXT_RESET 0x8254
#define GL_UNKNOWN_CONTEXT_RESET 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY 0x8256
#define GL_LOSE_CONTEXT_ON_RESET 0x8252
#define GL_NO_RESET_NOTIFICATION 0x8261
#define GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT 0x00000004
#define GL_CONTEXT_LOST 0x0507
#define GL_CONTEXT_RELEASE_BEHAVIOR 0x82FB
#define GL_NONE 0
#define GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH 0x82FC

/* GL_ARB_robustness */

#define GL_NO_ERROR 0
#define GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB 0x00000004
#define GL_LOSE_CONTEXT_ON_RESET_ARB 0x8252
#define GL_GUILTY_CONTEXT_RESET_ARB 0x8253
#define GL_INNOCENT_CONTEXT_RESET_ARB 0x8254
#define GL_UNKNOWN_CONTEXT_RESET_ARB 0x8255
#define GL_RESET_NOTIFICATION_STRATEGY_ARB 0x8256
#define GL_NO_RESET_NOTIFICATION_ARB 0x8261

/* GL_ARB_bindless_texture */

#define GL_UNSIGNED_INT64_ARB 0x140F

/* GL_ARB_compute_variable_group_size */

#define GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB 0x9344
#define GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB 0x90EB
#define GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB 0x9345
#define GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB 0x91BF

/* GL_ARB_indirect_parameters */

#define GL_PARAMETER_BUFFER_ARB 0x80EE
#define GL_PARAMETER_BUFFER_BINDING_ARB 0x80EF

/* GL_ARB_seamless_cubemap_per_texture */

#define GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F

/* GL_ARB_sparse_texture */

#define GL_TEXTURE_SPARSE_ARB 0x91A6
#define GL_VIRTUAL_PAGE_SIZE_INDEX_ARB 0x91A7
#define GL_NUM_SPARSE_LEVELS_ARB 0x91AA
#define GL_NUM_VIRTUAL_PAGE_SIZES_ARB 0x91A8
#define GL_VIRTUAL_PAGE_SIZE_X_ARB 0x9195
#define GL_VIRTUAL_PAGE_SIZE_Y_ARB 0x9196
#define GL_VIRTUAL_PAGE_SIZE_Z_ARB 0x9197
#define GL_MAX_SPARSE_TEXTURE_SIZE_ARB 0x9198
#define GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB 0x9199
#define GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB 0x919A
#define GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB 0x91A9

/* GL_ARB_pipeline_statistics_query */

#define GL_VERTICES_SUBMITTED_ARB 0x82EE
#define GL_PRIMITIVES_SUBMITTED_ARB 0x82EF
#define GL_VERTEX_SHADER_INVOCATIONS_ARB 0x82F0
#define GL_TESS_CONTROL_SHADER_PATCHES_ARB 0x82F1
#define GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB 0x82F2
#define GL_GEOMETRY_SHADER_INVOCATIONS 0x887F
#define GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB 0x82F3
#define GL_FRAGMENT_SHADER_INVOCATIONS_ARB 0x82F4
#define GL_COMPUTE_SHADER_INVOCATIONS_ARB 0x82F5
#define GL_CLIPPING_INPUT_PRIMITIVES_ARB 0x82F6
#define GL_CLIPPING_OUTPUT_PRIMITIVES_ARB 0x82F7

/* GL_ARB_sparse_buffer */

#define GL_SPARSE_STORAGE_BIT_ARB 0x0400
#define GL_SPARSE_BUFFER_PAGE_SIZE_ARB 0x82F8

/* GL_ARB_transform_feedback_overflow_query */

#define GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB 0x82EC
#define GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB 0x82ED

/* GL_ATI_texture_mirror_once */

#define GL_MIRROR_CLAMP_ATI 0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_ATI 0x8743

/* GL_EXT_texture_filter_anisotropic */

#define GL_TEXTURE_MAX_ANISOTROPY_EXT 0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF

/* GL_EXT_texture_compression_s3tc */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

/* GL_EXT_texture_mirror_clamp */

#define GL_MIRROR_CLAMP_EXT 0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_EXT 0x8743
#define GL_MIRROR_CLAMP_TO_BORDER_EXT 0x8912

/* GL_EXT_direct_state_access */

#define GL_PROGRAM_MATRIX_EXT 0x8E2D
#define GL_TRANSPOSE_PROGRAM_MATRIX_EXT 0x8E2E
#define GL_PROGRAM_MATRIX_STACK_DEPTH_EXT 0x8E2F

/* GL_EXT_texture_sRGB_decode */

#define GL_TEXTURE_SRGB_DECODE_EXT 0x8A48
#define GL_DECODE_EXT 0x8A49
#define GL_SKIP_DECODE_EXT 0x8A4A

/* GL_EXT_debug_label */

#define GL_PROGRAM_PIPELINE_OBJECT_EXT 0x8A4F
#define GL_PROGRAM_OBJECT_EXT 0x8B40
#define GL_SHADER_OBJECT_EXT 0x8B48
#define GL_BUFFER_OBJECT_EXT 0x9151
#define GL_QUERY_OBJECT_EXT 0x9153
#define GL_VERTEX_ARRAY_OBJECT_EXT 0x9154
#define GL_SAMPLER 0x82E6
#define GL_TRANSFORM_FEEDBACK 0x8E22

/* GL_KHR_texture_compression_astc_ldr */

#define GL_COMPRESSED_RGBA_ASTC_4x4_KHR 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4_KHR 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5_KHR 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5_KHR 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6_KHR 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5_KHR 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6_KHR 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8_KHR 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5_KHR 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6_KHR 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8_KHR 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10_KHR 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10_KHR 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12_KHR 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR 0x93DD

/* GL_KHR_texture_compression_astc_hdr */

#define GL_COMPRESSED_RGBA_ASTC_4x4_KHR 0x93B0
#define GL_COMPRESSED_RGBA_ASTC_5x4_KHR 0x93B1
#define GL_COMPRESSED_RGBA_ASTC_5x5_KHR 0x93B2
#define GL_COMPRESSED_RGBA_ASTC_6x5_KHR 0x93B3
#define GL_COMPRESSED_RGBA_ASTC_6x6_KHR 0x93B4
#define GL_COMPRESSED_RGBA_ASTC_8x5_KHR 0x93B5
#define GL_COMPRESSED_RGBA_ASTC_8x6_KHR 0x93B6
#define GL_COMPRESSED_RGBA_ASTC_8x8_KHR 0x93B7
#define GL_COMPRESSED_RGBA_ASTC_10x5_KHR 0x93B8
#define GL_COMPRESSED_RGBA_ASTC_10x6_KHR 0x93B9
#define GL_COMPRESSED_RGBA_ASTC_10x8_KHR 0x93BA
#define GL_COMPRESSED_RGBA_ASTC_10x10_KHR 0x93BB
#define GL_COMPRESSED_RGBA_ASTC_12x10_KHR 0x93BC
#define GL_COMPRESSED_RGBA_ASTC_12x12_KHR 0x93BD
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR 0x93D0
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR 0x93D1
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR 0x93D2
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR 0x93D3
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR 0x93D4
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR 0x93D5
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR 0x93D6
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR 0x93D7
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR 0x93D8
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR 0x93D9
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR 0x93DA
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR 0x93DB
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR 0x93DC
#define GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR 0x93DD

/* GL_KHR_blend_equation_advanced */

#define GL_MULTIPLY_KHR 0x9294
#define GL_SCREEN_KHR 0x9295
#define GL_OVERLAY_KHR 0x9296
#define GL_DARKEN_KHR 0x9297
#define GL_LIGHTEN_KHR 0x9298
#define GL_COLORDODGE_KHR 0x9299
#define GL_COLORBURN_KHR 0x929A
#define GL_HARDLIGHT_KHR 0x929B
#define GL_SOFTLIGHT_KHR 0x929C
#define GL_DIFFERENCE_KHR 0x929E
#define GL_EXCLUSION_KHR 0x92A0
#define GL_HSL_HUE_KHR 0x92AD
#define GL_HSL_SATURATION_KHR 0x92AE
#define GL_HSL_COLOR_KHR 0x92AF
#define GL_HSL_LUMINOSITY_KHR 0x92B0

/* GL_KHR_blend_equation_advanced_coherent */

#define GL_BLEND_ADVANCED_COHERENT_KHR 0x9285

/* GL_KHR_no_error */

#define GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR 0x00000008

/* Function prototypes */

/* GL_ARB_bindless_texture */

GLAPI FLEXTGL_EXPORT GLuint64(APIENTRY *flextglGetImageHandleARB)(GLuint, GLint, GLboolean, GLint, GLenum);
#define glGetImageHandleARB flextglGetImageHandleARB
GLAPI FLEXTGL_EXPORT GLuint64(APIENTRY *flextglGetTextureHandleARB)(GLuint);
#define glGetTextureHandleARB flextglGetTextureHandleARB
GLAPI FLEXTGL_EXPORT GLuint64(APIENTRY *flextglGetTextureSamplerHandleARB)(GLuint, GLuint);
#define glGetTextureSamplerHandleARB flextglGetTextureSamplerHandleARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribLui64vARB)(GLuint, GLenum, GLuint64EXT *);
#define glGetVertexAttribLui64vARB flextglGetVertexAttribLui64vARB
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsImageHandleResidentARB)(GLuint64);
#define glIsImageHandleResidentARB flextglIsImageHandleResidentARB
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsTextureHandleResidentARB)(GLuint64);
#define glIsTextureHandleResidentARB flextglIsTextureHandleResidentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMakeImageHandleNonResidentARB)(GLuint64);
#define glMakeImageHandleNonResidentARB flextglMakeImageHandleNonResidentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMakeImageHandleResidentARB)(GLuint64, GLenum);
#define glMakeImageHandleResidentARB flextglMakeImageHandleResidentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMakeTextureHandleNonResidentARB)(GLuint64);
#define glMakeTextureHandleNonResidentARB flextglMakeTextureHandleNonResidentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMakeTextureHandleResidentARB)(GLuint64);
#define glMakeTextureHandleResidentARB flextglMakeTextureHandleResidentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformHandleui64ARB)(GLuint, GLint, GLuint64);
#define glProgramUniformHandleui64ARB flextglProgramUniformHandleui64ARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformHandleui64vARB)(GLuint, GLint, GLsizei, const GLuint64 *);
#define glProgramUniformHandleui64vARB flextglProgramUniformHandleui64vARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformHandleui64ARB)(GLint, GLuint64);
#define glUniformHandleui64ARB flextglUniformHandleui64ARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformHandleui64vARB)(GLint, GLsizei, const GLuint64 *);
#define glUniformHandleui64vARB flextglUniformHandleui64vARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL1ui64ARB)(GLuint, GLuint64EXT);
#define glVertexAttribL1ui64ARB flextglVertexAttribL1ui64ARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL1ui64vARB)(GLuint, const GLuint64EXT *);
#define glVertexAttribL1ui64vARB flextglVertexAttribL1ui64vARB

/* GL_ARB_compute_variable_group_size */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDispatchComputeGroupSizeARB)(GLuint, GLuint, GLuint, GLuint, GLuint, GLuint);
#define glDispatchComputeGroupSizeARB flextglDispatchComputeGroupSizeARB

/* GL_ARB_indirect_parameters */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawArraysIndirectCountARB)(GLenum, GLintptr, GLintptr, GLsizei, GLsizei);
#define glMultiDrawArraysIndirectCountARB flextglMultiDrawArraysIndirectCountARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawElementsIndirectCountARB)(GLenum, GLenum, GLintptr, GLintptr, GLsizei, GLsizei);
#define glMultiDrawElementsIndirectCountARB flextglMultiDrawElementsIndirectCountARB

/* GL_ARB_robustness */

GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglGetGraphicsResetStatusARB)(void);
#define glGetGraphicsResetStatusARB flextglGetGraphicsResetStatusARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnCompressedTexImageARB)(GLenum, GLint, GLsizei, void *);
#define glGetnCompressedTexImageARB flextglGetnCompressedTexImageARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnTexImageARB)(GLenum, GLint, GLenum, GLenum, GLsizei, void *);
#define glGetnTexImageARB flextglGetnTexImageARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformdvARB)(GLuint, GLint, GLsizei, GLdouble *);
#define glGetnUniformdvARB flextglGetnUniformdvARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformfvARB)(GLuint, GLint, GLsizei, GLfloat *);
#define glGetnUniformfvARB flextglGetnUniformfvARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformivARB)(GLuint, GLint, GLsizei, GLint *);
#define glGetnUniformivARB flextglGetnUniformivARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformuivARB)(GLuint, GLint, GLsizei, GLuint *);
#define glGetnUniformuivARB flextglGetnUniformuivARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglReadnPixelsARB)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
#define glReadnPixelsARB flextglReadnPixelsARB

/* GL_ARB_sparse_buffer */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBufferPageCommitmentARB)(GLenum, GLintptr, GLsizeiptr, GLboolean);
#define glBufferPageCommitmentARB flextglBufferPageCommitmentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferPageCommitmentARB)(GLuint, GLintptr, GLsizeiptr, GLboolean);
#define glNamedBufferPageCommitmentARB flextglNamedBufferPageCommitmentARB
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferPageCommitmentEXT)(GLuint, GLintptr, GLsizeiptr, GLboolean);
#define glNamedBufferPageCommitmentEXT flextglNamedBufferPageCommitmentEXT

/* GL_ARB_sparse_texture */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexPageCommitmentARB)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTexPageCommitmentARB flextglTexPageCommitmentARB

/* GL_EXT_debug_label */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetObjectLabelEXT)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetObjectLabelEXT flextglGetObjectLabelEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglLabelObjectEXT)(GLenum, GLuint, GLsizei, const GLchar *);
#define glLabelObjectEXT flextglLabelObjectEXT

/* GL_EXT_debug_marker */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInsertEventMarkerEXT)(GLsizei, const GLchar *);
#define glInsertEventMarkerEXT flextglInsertEventMarkerEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPopGroupMarkerEXT)(void);
#define glPopGroupMarkerEXT flextglPopGroupMarkerEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPushGroupMarkerEXT)(GLsizei, const GLchar *);
#define glPushGroupMarkerEXT flextglPushGroupMarkerEXT

/* GL_EXT_direct_state_access */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindMultiTextureEXT)(GLenum, GLenum, GLuint);
#define glBindMultiTextureEXT flextglBindMultiTextureEXT
GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglCheckNamedFramebufferStatusEXT)(GLuint, GLenum);
#define glCheckNamedFramebufferStatusEXT flextglCheckNamedFramebufferStatusEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedBufferDataEXT)(GLuint, GLenum, GLenum, GLenum, const void *);
#define glClearNamedBufferDataEXT flextglClearNamedBufferDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedBufferSubDataEXT)(GLuint, GLenum, GLsizeiptr, GLsizeiptr, GLenum, GLenum, const void *);
#define glClearNamedBufferSubDataEXT flextglClearNamedBufferSubDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClientAttribDefaultEXT)(GLbitfield);
#define glClientAttribDefaultEXT flextglClientAttribDefaultEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexImage1DEXT)(GLenum, GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const void *);
#define glCompressedMultiTexImage1DEXT flextglCompressedMultiTexImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexImage2DEXT)(GLenum, GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedMultiTexImage2DEXT flextglCompressedMultiTexImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexImage3DEXT)(GLenum, GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedMultiTexImage3DEXT flextglCompressedMultiTexImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexSubImage1DEXT)(GLenum, GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedMultiTexSubImage1DEXT flextglCompressedMultiTexSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexSubImage2DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedMultiTexSubImage2DEXT flextglCompressedMultiTexSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedMultiTexSubImage3DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedMultiTexSubImage3DEXT flextglCompressedMultiTexSubImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureImage1DEXT)(GLuint, GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTextureImage1DEXT flextglCompressedTextureImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureImage2DEXT)(GLuint, GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTextureImage2DEXT flextglCompressedTextureImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureImage3DEXT)(GLuint, GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTextureImage3DEXT flextglCompressedTextureImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage1DEXT)(GLuint, GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage1DEXT flextglCompressedTextureSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage2DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage2DEXT flextglCompressedTextureSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage3DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage3DEXT flextglCompressedTextureSubImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyMultiTexImage1DEXT)(GLenum, GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLint);
#define glCopyMultiTexImage1DEXT flextglCopyMultiTexImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyMultiTexImage2DEXT)(GLenum, GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
#define glCopyMultiTexImage2DEXT flextglCopyMultiTexImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyMultiTexSubImage1DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLint, GLsizei);
#define glCopyMultiTexSubImage1DEXT flextglCopyMultiTexSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyMultiTexSubImage2DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyMultiTexSubImage2DEXT flextglCopyMultiTexSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyMultiTexSubImage3DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyMultiTexSubImage3DEXT flextglCopyMultiTexSubImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureImage1DEXT)(GLuint, GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLint);
#define glCopyTextureImage1DEXT flextglCopyTextureImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureImage2DEXT)(GLuint, GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
#define glCopyTextureImage2DEXT flextglCopyTextureImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage1DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei);
#define glCopyTextureSubImage1DEXT flextglCopyTextureSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage2DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyTextureSubImage2DEXT flextglCopyTextureSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage3DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyTextureSubImage3DEXT flextglCopyTextureSubImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableClientStateIndexedEXT)(GLenum, GLuint);
#define glDisableClientStateIndexedEXT flextglDisableClientStateIndexedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableClientStateiEXT)(GLenum, GLuint);
#define glDisableClientStateiEXT flextglDisableClientStateiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableIndexedEXT)(GLenum, GLuint);
#define glDisableIndexedEXT flextglDisableIndexedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableVertexArrayAttribEXT)(GLuint, GLuint);
#define glDisableVertexArrayAttribEXT flextglDisableVertexArrayAttribEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableVertexArrayEXT)(GLuint, GLenum);
#define glDisableVertexArrayEXT flextglDisableVertexArrayEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableClientStateIndexedEXT)(GLenum, GLuint);
#define glEnableClientStateIndexedEXT flextglEnableClientStateIndexedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableClientStateiEXT)(GLenum, GLuint);
#define glEnableClientStateiEXT flextglEnableClientStateiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableIndexedEXT)(GLenum, GLuint);
#define glEnableIndexedEXT flextglEnableIndexedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableVertexArrayAttribEXT)(GLuint, GLuint);
#define glEnableVertexArrayAttribEXT flextglEnableVertexArrayAttribEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableVertexArrayEXT)(GLuint, GLenum);
#define glEnableVertexArrayEXT flextglEnableVertexArrayEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFlushMappedNamedBufferRangeEXT)(GLuint, GLintptr, GLsizeiptr);
#define glFlushMappedNamedBufferRangeEXT flextglFlushMappedNamedBufferRangeEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferDrawBufferEXT)(GLuint, GLenum);
#define glFramebufferDrawBufferEXT flextglFramebufferDrawBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferDrawBuffersEXT)(GLuint, GLsizei, const GLenum *);
#define glFramebufferDrawBuffersEXT flextglFramebufferDrawBuffersEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferReadBufferEXT)(GLuint, GLenum);
#define glFramebufferReadBufferEXT flextglFramebufferReadBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenerateMultiTexMipmapEXT)(GLenum, GLenum);
#define glGenerateMultiTexMipmapEXT flextglGenerateMultiTexMipmapEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenerateTextureMipmapEXT)(GLuint, GLenum);
#define glGenerateTextureMipmapEXT flextglGenerateTextureMipmapEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBooleanIndexedvEXT)(GLenum, GLuint, GLboolean *);
#define glGetBooleanIndexedvEXT flextglGetBooleanIndexedvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetCompressedMultiTexImageEXT)(GLenum, GLenum, GLint, void *);
#define glGetCompressedMultiTexImageEXT flextglGetCompressedMultiTexImageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetCompressedTextureImageEXT)(GLuint, GLenum, GLint, void *);
#define glGetCompressedTextureImageEXT flextglGetCompressedTextureImageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetDoubleIndexedvEXT)(GLenum, GLuint, GLdouble *);
#define glGetDoubleIndexedvEXT flextglGetDoubleIndexedvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetDoublei_vEXT)(GLenum, GLuint, GLdouble *);
#define glGetDoublei_vEXT flextglGetDoublei_vEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFloatIndexedvEXT)(GLenum, GLuint, GLfloat *);
#define glGetFloatIndexedvEXT flextglGetFloatIndexedvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFloati_vEXT)(GLenum, GLuint, GLfloat *);
#define glGetFloati_vEXT flextglGetFloati_vEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFramebufferParameterivEXT)(GLuint, GLenum, GLint *);
#define glGetFramebufferParameterivEXT flextglGetFramebufferParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetIntegerIndexedvEXT)(GLenum, GLuint, GLint *);
#define glGetIntegerIndexedvEXT flextglGetIntegerIndexedvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexEnvfvEXT)(GLenum, GLenum, GLenum, GLfloat *);
#define glGetMultiTexEnvfvEXT flextglGetMultiTexEnvfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexEnvivEXT)(GLenum, GLenum, GLenum, GLint *);
#define glGetMultiTexEnvivEXT flextglGetMultiTexEnvivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexGendvEXT)(GLenum, GLenum, GLenum, GLdouble *);
#define glGetMultiTexGendvEXT flextglGetMultiTexGendvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexGenfvEXT)(GLenum, GLenum, GLenum, GLfloat *);
#define glGetMultiTexGenfvEXT flextglGetMultiTexGenfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexGenivEXT)(GLenum, GLenum, GLenum, GLint *);
#define glGetMultiTexGenivEXT flextglGetMultiTexGenivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexImageEXT)(GLenum, GLenum, GLint, GLenum, GLenum, void *);
#define glGetMultiTexImageEXT flextglGetMultiTexImageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexLevelParameterfvEXT)(GLenum, GLenum, GLint, GLenum, GLfloat *);
#define glGetMultiTexLevelParameterfvEXT flextglGetMultiTexLevelParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexLevelParameterivEXT)(GLenum, GLenum, GLint, GLenum, GLint *);
#define glGetMultiTexLevelParameterivEXT flextglGetMultiTexLevelParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexParameterIivEXT)(GLenum, GLenum, GLenum, GLint *);
#define glGetMultiTexParameterIivEXT flextglGetMultiTexParameterIivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexParameterIuivEXT)(GLenum, GLenum, GLenum, GLuint *);
#define glGetMultiTexParameterIuivEXT flextglGetMultiTexParameterIuivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexParameterfvEXT)(GLenum, GLenum, GLenum, GLfloat *);
#define glGetMultiTexParameterfvEXT flextglGetMultiTexParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultiTexParameterivEXT)(GLenum, GLenum, GLenum, GLint *);
#define glGetMultiTexParameterivEXT flextglGetMultiTexParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferParameterivEXT)(GLuint, GLenum, GLint *);
#define glGetNamedBufferParameterivEXT flextglGetNamedBufferParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferPointervEXT)(GLuint, GLenum, void **);
#define glGetNamedBufferPointervEXT flextglGetNamedBufferPointervEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferSubDataEXT)(GLuint, GLintptr, GLsizeiptr, void *);
#define glGetNamedBufferSubDataEXT flextglGetNamedBufferSubDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedFramebufferAttachmentParameterivEXT)(GLuint, GLenum, GLenum, GLint *);
#define glGetNamedFramebufferAttachmentParameterivEXT flextglGetNamedFramebufferAttachmentParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedFramebufferParameterivEXT)(GLuint, GLenum, GLint *);
#define glGetNamedFramebufferParameterivEXT flextglGetNamedFramebufferParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramLocalParameterIivEXT)(GLuint, GLenum, GLuint, GLint *);
#define glGetNamedProgramLocalParameterIivEXT flextglGetNamedProgramLocalParameterIivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramLocalParameterIuivEXT)(GLuint, GLenum, GLuint, GLuint *);
#define glGetNamedProgramLocalParameterIuivEXT flextglGetNamedProgramLocalParameterIuivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramLocalParameterdvEXT)(GLuint, GLenum, GLuint, GLdouble *);
#define glGetNamedProgramLocalParameterdvEXT flextglGetNamedProgramLocalParameterdvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramLocalParameterfvEXT)(GLuint, GLenum, GLuint, GLfloat *);
#define glGetNamedProgramLocalParameterfvEXT flextglGetNamedProgramLocalParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramStringEXT)(GLuint, GLenum, GLenum, void *);
#define glGetNamedProgramStringEXT flextglGetNamedProgramStringEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedProgramivEXT)(GLuint, GLenum, GLenum, GLint *);
#define glGetNamedProgramivEXT flextglGetNamedProgramivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedRenderbufferParameterivEXT)(GLuint, GLenum, GLint *);
#define glGetNamedRenderbufferParameterivEXT flextglGetNamedRenderbufferParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetPointerIndexedvEXT)(GLenum, GLuint, void **);
#define glGetPointerIndexedvEXT flextglGetPointerIndexedvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetPointeri_vEXT)(GLenum, GLuint, void **);
#define glGetPointeri_vEXT flextglGetPointeri_vEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureImageEXT)(GLuint, GLenum, GLint, GLenum, GLenum, void *);
#define glGetTextureImageEXT flextglGetTextureImageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureLevelParameterfvEXT)(GLuint, GLenum, GLint, GLenum, GLfloat *);
#define glGetTextureLevelParameterfvEXT flextglGetTextureLevelParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureLevelParameterivEXT)(GLuint, GLenum, GLint, GLenum, GLint *);
#define glGetTextureLevelParameterivEXT flextglGetTextureLevelParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterIivEXT)(GLuint, GLenum, GLenum, GLint *);
#define glGetTextureParameterIivEXT flextglGetTextureParameterIivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterIuivEXT)(GLuint, GLenum, GLenum, GLuint *);
#define glGetTextureParameterIuivEXT flextglGetTextureParameterIuivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterfvEXT)(GLuint, GLenum, GLenum, GLfloat *);
#define glGetTextureParameterfvEXT flextglGetTextureParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterivEXT)(GLuint, GLenum, GLenum, GLint *);
#define glGetTextureParameterivEXT flextglGetTextureParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayIntegeri_vEXT)(GLuint, GLuint, GLenum, GLint *);
#define glGetVertexArrayIntegeri_vEXT flextglGetVertexArrayIntegeri_vEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayIntegervEXT)(GLuint, GLenum, GLint *);
#define glGetVertexArrayIntegervEXT flextglGetVertexArrayIntegervEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayPointeri_vEXT)(GLuint, GLuint, GLenum, void **);
#define glGetVertexArrayPointeri_vEXT flextglGetVertexArrayPointeri_vEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayPointervEXT)(GLuint, GLenum, void **);
#define glGetVertexArrayPointervEXT flextglGetVertexArrayPointervEXT
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsEnabledIndexedEXT)(GLenum, GLuint);
#define glIsEnabledIndexedEXT flextglIsEnabledIndexedEXT
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapNamedBufferEXT)(GLuint, GLenum);
#define glMapNamedBufferEXT flextglMapNamedBufferEXT
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapNamedBufferRangeEXT)(GLuint, GLintptr, GLsizeiptr, GLbitfield);
#define glMapNamedBufferRangeEXT flextglMapNamedBufferRangeEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixFrustumEXT)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
#define glMatrixFrustumEXT flextglMatrixFrustumEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixLoadIdentityEXT)(GLenum);
#define glMatrixLoadIdentityEXT flextglMatrixLoadIdentityEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixLoadTransposedEXT)(GLenum, const GLdouble *);
#define glMatrixLoadTransposedEXT flextglMatrixLoadTransposedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixLoadTransposefEXT)(GLenum, const GLfloat *);
#define glMatrixLoadTransposefEXT flextglMatrixLoadTransposefEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixLoaddEXT)(GLenum, const GLdouble *);
#define glMatrixLoaddEXT flextglMatrixLoaddEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixLoadfEXT)(GLenum, const GLfloat *);
#define glMatrixLoadfEXT flextglMatrixLoadfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixMultTransposedEXT)(GLenum, const GLdouble *);
#define glMatrixMultTransposedEXT flextglMatrixMultTransposedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixMultTransposefEXT)(GLenum, const GLfloat *);
#define glMatrixMultTransposefEXT flextglMatrixMultTransposefEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixMultdEXT)(GLenum, const GLdouble *);
#define glMatrixMultdEXT flextglMatrixMultdEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixMultfEXT)(GLenum, const GLfloat *);
#define glMatrixMultfEXT flextglMatrixMultfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixOrthoEXT)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
#define glMatrixOrthoEXT flextglMatrixOrthoEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixPopEXT)(GLenum);
#define glMatrixPopEXT flextglMatrixPopEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixPushEXT)(GLenum);
#define glMatrixPushEXT flextglMatrixPushEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixRotatedEXT)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble);
#define glMatrixRotatedEXT flextglMatrixRotatedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixRotatefEXT)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat);
#define glMatrixRotatefEXT flextglMatrixRotatefEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixScaledEXT)(GLenum, GLdouble, GLdouble, GLdouble);
#define glMatrixScaledEXT flextglMatrixScaledEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixScalefEXT)(GLenum, GLfloat, GLfloat, GLfloat);
#define glMatrixScalefEXT flextglMatrixScalefEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixTranslatedEXT)(GLenum, GLdouble, GLdouble, GLdouble);
#define glMatrixTranslatedEXT flextglMatrixTranslatedEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMatrixTranslatefEXT)(GLenum, GLfloat, GLfloat, GLfloat);
#define glMatrixTranslatefEXT flextglMatrixTranslatefEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexBufferEXT)(GLenum, GLenum, GLenum, GLuint);
#define glMultiTexBufferEXT flextglMultiTexBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexCoordPointerEXT)(GLenum, GLint, GLenum, GLsizei, const void *);
#define glMultiTexCoordPointerEXT flextglMultiTexCoordPointerEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexEnvfEXT)(GLenum, GLenum, GLenum, GLfloat);
#define glMultiTexEnvfEXT flextglMultiTexEnvfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexEnvfvEXT)(GLenum, GLenum, GLenum, const GLfloat *);
#define glMultiTexEnvfvEXT flextglMultiTexEnvfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexEnviEXT)(GLenum, GLenum, GLenum, GLint);
#define glMultiTexEnviEXT flextglMultiTexEnviEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexEnvivEXT)(GLenum, GLenum, GLenum, const GLint *);
#define glMultiTexEnvivEXT flextglMultiTexEnvivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGendEXT)(GLenum, GLenum, GLenum, GLdouble);
#define glMultiTexGendEXT flextglMultiTexGendEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGendvEXT)(GLenum, GLenum, GLenum, const GLdouble *);
#define glMultiTexGendvEXT flextglMultiTexGendvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGenfEXT)(GLenum, GLenum, GLenum, GLfloat);
#define glMultiTexGenfEXT flextglMultiTexGenfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGenfvEXT)(GLenum, GLenum, GLenum, const GLfloat *);
#define glMultiTexGenfvEXT flextglMultiTexGenfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGeniEXT)(GLenum, GLenum, GLenum, GLint);
#define glMultiTexGeniEXT flextglMultiTexGeniEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexGenivEXT)(GLenum, GLenum, GLenum, const GLint *);
#define glMultiTexGenivEXT flextglMultiTexGenivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexImage1DEXT)(GLenum, GLenum, GLint, GLint, GLsizei, GLint, GLenum, GLenum, const void *);
#define glMultiTexImage1DEXT flextglMultiTexImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexImage2DEXT)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
#define glMultiTexImage2DEXT flextglMultiTexImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexImage3DEXT)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
#define glMultiTexImage3DEXT flextglMultiTexImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameterIivEXT)(GLenum, GLenum, GLenum, const GLint *);
#define glMultiTexParameterIivEXT flextglMultiTexParameterIivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameterIuivEXT)(GLenum, GLenum, GLenum, const GLuint *);
#define glMultiTexParameterIuivEXT flextglMultiTexParameterIuivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameterfEXT)(GLenum, GLenum, GLenum, GLfloat);
#define glMultiTexParameterfEXT flextglMultiTexParameterfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameterfvEXT)(GLenum, GLenum, GLenum, const GLfloat *);
#define glMultiTexParameterfvEXT flextglMultiTexParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameteriEXT)(GLenum, GLenum, GLenum, GLint);
#define glMultiTexParameteriEXT flextglMultiTexParameteriEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexParameterivEXT)(GLenum, GLenum, GLenum, const GLint *);
#define glMultiTexParameterivEXT flextglMultiTexParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexRenderbufferEXT)(GLenum, GLenum, GLuint);
#define glMultiTexRenderbufferEXT flextglMultiTexRenderbufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexSubImage1DEXT)(GLenum, GLenum, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
#define glMultiTexSubImage1DEXT flextglMultiTexSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexSubImage2DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glMultiTexSubImage2DEXT flextglMultiTexSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiTexSubImage3DEXT)(GLenum, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glMultiTexSubImage3DEXT flextglMultiTexSubImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferDataEXT)(GLuint, GLsizeiptr, const void *, GLenum);
#define glNamedBufferDataEXT flextglNamedBufferDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferStorageEXT)(GLuint, GLsizeiptr, const void *, GLbitfield);
#define glNamedBufferStorageEXT flextglNamedBufferStorageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferSubDataEXT)(GLuint, GLintptr, GLsizeiptr, const void *);
#define glNamedBufferSubDataEXT flextglNamedBufferSubDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedCopyBufferSubDataEXT)(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr);
#define glNamedCopyBufferSubDataEXT flextglNamedCopyBufferSubDataEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferParameteriEXT)(GLuint, GLenum, GLint);
#define glNamedFramebufferParameteriEXT flextglNamedFramebufferParameteriEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferRenderbufferEXT)(GLuint, GLenum, GLenum, GLuint);
#define glNamedFramebufferRenderbufferEXT flextglNamedFramebufferRenderbufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTexture1DEXT)(GLuint, GLenum, GLenum, GLuint, GLint);
#define glNamedFramebufferTexture1DEXT flextglNamedFramebufferTexture1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTexture2DEXT)(GLuint, GLenum, GLenum, GLuint, GLint);
#define glNamedFramebufferTexture2DEXT flextglNamedFramebufferTexture2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTexture3DEXT)(GLuint, GLenum, GLenum, GLuint, GLint, GLint);
#define glNamedFramebufferTexture3DEXT flextglNamedFramebufferTexture3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTextureEXT)(GLuint, GLenum, GLuint, GLint);
#define glNamedFramebufferTextureEXT flextglNamedFramebufferTextureEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTextureFaceEXT)(GLuint, GLenum, GLuint, GLint, GLenum);
#define glNamedFramebufferTextureFaceEXT flextglNamedFramebufferTextureFaceEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTextureLayerEXT)(GLuint, GLenum, GLuint, GLint, GLint);
#define glNamedFramebufferTextureLayerEXT flextglNamedFramebufferTextureLayerEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameter4dEXT)(GLuint, GLenum, GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glNamedProgramLocalParameter4dEXT flextglNamedProgramLocalParameter4dEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameter4dvEXT)(GLuint, GLenum, GLuint, const GLdouble *);
#define glNamedProgramLocalParameter4dvEXT flextglNamedProgramLocalParameter4dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameter4fEXT)(GLuint, GLenum, GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glNamedProgramLocalParameter4fEXT flextglNamedProgramLocalParameter4fEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameter4fvEXT)(GLuint, GLenum, GLuint, const GLfloat *);
#define glNamedProgramLocalParameter4fvEXT flextglNamedProgramLocalParameter4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameterI4iEXT)(GLuint, GLenum, GLuint, GLint, GLint, GLint, GLint);
#define glNamedProgramLocalParameterI4iEXT flextglNamedProgramLocalParameterI4iEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameterI4ivEXT)(GLuint, GLenum, GLuint, const GLint *);
#define glNamedProgramLocalParameterI4ivEXT flextglNamedProgramLocalParameterI4ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameterI4uiEXT)(GLuint, GLenum, GLuint, GLuint, GLuint, GLuint, GLuint);
#define glNamedProgramLocalParameterI4uiEXT flextglNamedProgramLocalParameterI4uiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameterI4uivEXT)(GLuint, GLenum, GLuint, const GLuint *);
#define glNamedProgramLocalParameterI4uivEXT flextglNamedProgramLocalParameterI4uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParameters4fvEXT)(GLuint, GLenum, GLuint, GLsizei, const GLfloat *);
#define glNamedProgramLocalParameters4fvEXT flextglNamedProgramLocalParameters4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParametersI4ivEXT)(GLuint, GLenum, GLuint, GLsizei, const GLint *);
#define glNamedProgramLocalParametersI4ivEXT flextglNamedProgramLocalParametersI4ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramLocalParametersI4uivEXT)(GLuint, GLenum, GLuint, GLsizei, const GLuint *);
#define glNamedProgramLocalParametersI4uivEXT flextglNamedProgramLocalParametersI4uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedProgramStringEXT)(GLuint, GLenum, GLenum, GLsizei, const void *);
#define glNamedProgramStringEXT flextglNamedProgramStringEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedRenderbufferStorageEXT)(GLuint, GLenum, GLsizei, GLsizei);
#define glNamedRenderbufferStorageEXT flextglNamedRenderbufferStorageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedRenderbufferStorageMultisampleCoverageEXT)(GLuint, GLsizei, GLsizei, GLenum, GLsizei, GLsizei);
#define glNamedRenderbufferStorageMultisampleCoverageEXT flextglNamedRenderbufferStorageMultisampleCoverageEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedRenderbufferStorageMultisampleEXT)(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
#define glNamedRenderbufferStorageMultisampleEXT flextglNamedRenderbufferStorageMultisampleEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1dEXT)(GLuint, GLint, GLdouble);
#define glProgramUniform1dEXT flextglProgramUniform1dEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1dvEXT)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform1dvEXT flextglProgramUniform1dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1fEXT)(GLuint, GLint, GLfloat);
#define glProgramUniform1fEXT flextglProgramUniform1fEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform1fvEXT flextglProgramUniform1fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1iEXT)(GLuint, GLint, GLint);
#define glProgramUniform1iEXT flextglProgramUniform1iEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1ivEXT)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform1ivEXT flextglProgramUniform1ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1uiEXT)(GLuint, GLint, GLuint);
#define glProgramUniform1uiEXT flextglProgramUniform1uiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform1uivEXT flextglProgramUniform1uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2dEXT)(GLuint, GLint, GLdouble, GLdouble);
#define glProgramUniform2dEXT flextglProgramUniform2dEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2dvEXT)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform2dvEXT flextglProgramUniform2dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2fEXT)(GLuint, GLint, GLfloat, GLfloat);
#define glProgramUniform2fEXT flextglProgramUniform2fEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform2fvEXT flextglProgramUniform2fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2iEXT)(GLuint, GLint, GLint, GLint);
#define glProgramUniform2iEXT flextglProgramUniform2iEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2ivEXT)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform2ivEXT flextglProgramUniform2ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2uiEXT)(GLuint, GLint, GLuint, GLuint);
#define glProgramUniform2uiEXT flextglProgramUniform2uiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform2uivEXT flextglProgramUniform2uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3dEXT)(GLuint, GLint, GLdouble, GLdouble, GLdouble);
#define glProgramUniform3dEXT flextglProgramUniform3dEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3dvEXT)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform3dvEXT flextglProgramUniform3dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
#define glProgramUniform3fEXT flextglProgramUniform3fEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform3fvEXT flextglProgramUniform3fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3iEXT)(GLuint, GLint, GLint, GLint, GLint);
#define glProgramUniform3iEXT flextglProgramUniform3iEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3ivEXT)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform3ivEXT flextglProgramUniform3ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3uiEXT)(GLuint, GLint, GLuint, GLuint, GLuint);
#define glProgramUniform3uiEXT flextglProgramUniform3uiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform3uivEXT flextglProgramUniform3uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4dEXT)(GLuint, GLint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glProgramUniform4dEXT flextglProgramUniform4dEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4dvEXT)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform4dvEXT flextglProgramUniform4dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4fEXT)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glProgramUniform4fEXT flextglProgramUniform4fEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4fvEXT)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform4fvEXT flextglProgramUniform4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4iEXT)(GLuint, GLint, GLint, GLint, GLint, GLint);
#define glProgramUniform4iEXT flextglProgramUniform4iEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4ivEXT)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform4ivEXT flextglProgramUniform4ivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4uiEXT)(GLuint, GLint, GLuint, GLuint, GLuint, GLuint);
#define glProgramUniform4uiEXT flextglProgramUniform4uiEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4uivEXT)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform4uivEXT flextglProgramUniform4uivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2dvEXT flextglProgramUniformMatrix2dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2fvEXT flextglProgramUniformMatrix2fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x3dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2x3dvEXT flextglProgramUniformMatrix2x3dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2x3fvEXT flextglProgramUniformMatrix2x3fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x4dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2x4dvEXT flextglProgramUniformMatrix2x4dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2x4fvEXT flextglProgramUniformMatrix2x4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3dvEXT flextglProgramUniformMatrix3dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3fvEXT flextglProgramUniformMatrix3fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x2dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3x2dvEXT flextglProgramUniformMatrix3x2dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3x2fvEXT flextglProgramUniformMatrix3x2fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x4dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3x4dvEXT flextglProgramUniformMatrix3x4dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3x4fvEXT flextglProgramUniformMatrix3x4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4dvEXT flextglProgramUniformMatrix4dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4fvEXT flextglProgramUniformMatrix4fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x2dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4x2dvEXT flextglProgramUniformMatrix4x2dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x2fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4x2fvEXT flextglProgramUniformMatrix4x2fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x3dvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4x3dvEXT flextglProgramUniformMatrix4x3dvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x3fvEXT)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4x3fvEXT flextglProgramUniformMatrix4x3fvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPushClientAttribDefaultEXT)(GLbitfield);
#define glPushClientAttribDefaultEXT flextglPushClientAttribDefaultEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureBufferEXT)(GLuint, GLenum, GLenum, GLuint);
#define glTextureBufferEXT flextglTextureBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureBufferRangeEXT)(GLuint, GLenum, GLenum, GLuint, GLintptr, GLsizeiptr);
#define glTextureBufferRangeEXT flextglTextureBufferRangeEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureImage1DEXT)(GLuint, GLenum, GLint, GLint, GLsizei, GLint, GLenum, GLenum, const void *);
#define glTextureImage1DEXT flextglTextureImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureImage2DEXT)(GLuint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
#define glTextureImage2DEXT flextglTextureImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureImage3DEXT)(GLuint, GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
#define glTextureImage3DEXT flextglTextureImage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexturePageCommitmentEXT)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTexturePageCommitmentEXT flextglTexturePageCommitmentEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterIivEXT)(GLuint, GLenum, GLenum, const GLint *);
#define glTextureParameterIivEXT flextglTextureParameterIivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterIuivEXT)(GLuint, GLenum, GLenum, const GLuint *);
#define glTextureParameterIuivEXT flextglTextureParameterIuivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterfEXT)(GLuint, GLenum, GLenum, GLfloat);
#define glTextureParameterfEXT flextglTextureParameterfEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterfvEXT)(GLuint, GLenum, GLenum, const GLfloat *);
#define glTextureParameterfvEXT flextglTextureParameterfvEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameteriEXT)(GLuint, GLenum, GLenum, GLint);
#define glTextureParameteriEXT flextglTextureParameteriEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterivEXT)(GLuint, GLenum, GLenum, const GLint *);
#define glTextureParameterivEXT flextglTextureParameterivEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureRenderbufferEXT)(GLuint, GLenum, GLuint);
#define glTextureRenderbufferEXT flextglTextureRenderbufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage1DEXT)(GLuint, GLenum, GLsizei, GLenum, GLsizei);
#define glTextureStorage1DEXT flextglTextureStorage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage2DEXT)(GLuint, GLenum, GLsizei, GLenum, GLsizei, GLsizei);
#define glTextureStorage2DEXT flextglTextureStorage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage2DMultisampleEXT)(GLuint, GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
#define glTextureStorage2DMultisampleEXT flextglTextureStorage2DMultisampleEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage3DEXT)(GLuint, GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);
#define glTextureStorage3DEXT flextglTextureStorage3DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage3DMultisampleEXT)(GLuint, GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTextureStorage3DMultisampleEXT flextglTextureStorage3DMultisampleEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage1DEXT)(GLuint, GLenum, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage1DEXT flextglTextureSubImage1DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage2DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage2DEXT flextglTextureSubImage2DEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage3DEXT)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage3DEXT flextglTextureSubImage3DEXT
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglUnmapNamedBufferEXT)(GLuint);
#define glUnmapNamedBufferEXT flextglUnmapNamedBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayBindVertexBufferEXT)(GLuint, GLuint, GLuint, GLintptr, GLsizei);
#define glVertexArrayBindVertexBufferEXT flextglVertexArrayBindVertexBufferEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayColorOffsetEXT)(GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayColorOffsetEXT flextglVertexArrayColorOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayEdgeFlagOffsetEXT)(GLuint, GLuint, GLsizei, GLintptr);
#define glVertexArrayEdgeFlagOffsetEXT flextglVertexArrayEdgeFlagOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayFogCoordOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr);
#define glVertexArrayFogCoordOffsetEXT flextglVertexArrayFogCoordOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayIndexOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr);
#define glVertexArrayIndexOffsetEXT flextglVertexArrayIndexOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayMultiTexCoordOffsetEXT)(GLuint, GLuint, GLenum, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayMultiTexCoordOffsetEXT flextglVertexArrayMultiTexCoordOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayNormalOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr);
#define glVertexArrayNormalOffsetEXT flextglVertexArrayNormalOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArraySecondaryColorOffsetEXT)(GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArraySecondaryColorOffsetEXT flextglVertexArraySecondaryColorOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayTexCoordOffsetEXT)(GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayTexCoordOffsetEXT flextglVertexArrayTexCoordOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribBindingEXT)(GLuint, GLuint, GLuint);
#define glVertexArrayVertexAttribBindingEXT flextglVertexArrayVertexAttribBindingEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribDivisorEXT)(GLuint, GLuint, GLuint);
#define glVertexArrayVertexAttribDivisorEXT flextglVertexArrayVertexAttribDivisorEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribFormatEXT)(GLuint, GLuint, GLint, GLenum, GLboolean, GLuint);
#define glVertexArrayVertexAttribFormatEXT flextglVertexArrayVertexAttribFormatEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribIFormatEXT)(GLuint, GLuint, GLint, GLenum, GLuint);
#define glVertexArrayVertexAttribIFormatEXT flextglVertexArrayVertexAttribIFormatEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribIOffsetEXT)(GLuint, GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayVertexAttribIOffsetEXT flextglVertexArrayVertexAttribIOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribLFormatEXT)(GLuint, GLuint, GLint, GLenum, GLuint);
#define glVertexArrayVertexAttribLFormatEXT flextglVertexArrayVertexAttribLFormatEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribLOffsetEXT)(GLuint, GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayVertexAttribLOffsetEXT flextglVertexArrayVertexAttribLOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexAttribOffsetEXT)(GLuint, GLuint, GLuint, GLint, GLenum, GLboolean, GLsizei, GLintptr);
#define glVertexArrayVertexAttribOffsetEXT flextglVertexArrayVertexAttribOffsetEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexBindingDivisorEXT)(GLuint, GLuint, GLuint);
#define glVertexArrayVertexBindingDivisorEXT flextglVertexArrayVertexBindingDivisorEXT
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexOffsetEXT)(GLuint, GLuint, GLint, GLenum, GLsizei, GLintptr);
#define glVertexArrayVertexOffsetEXT flextglVertexArrayVertexOffsetEXT

/* GL_GREMEDY_string_marker */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglStringMarkerGREMEDY)(GLsizei, const void *);
#define glStringMarkerGREMEDY flextglStringMarkerGREMEDY

/* GL_KHR_blend_equation_advanced */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendBarrierKHR)(void);
#define glBlendBarrierKHR flextglBlendBarrierKHR

/* GL_VERSION_1_0 */

GLAPI FLEXTGL_EXPORT void APIENTRY glBlendFunc(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glClear(GLbitfield);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearColor(GLfloat, GLfloat, GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearDepth(GLdouble);
GLAPI FLEXTGL_EXPORT void APIENTRY glClearStencil(GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glColorMask(GLboolean, GLboolean, GLboolean, GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glCullFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthFunc(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthMask(GLboolean);
GLAPI FLEXTGL_EXPORT void APIENTRY glDepthRange(GLdouble, GLdouble);
GLAPI FLEXTGL_EXPORT void APIENTRY glDisable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawBuffer(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glEnable(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glFinish(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFlush(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glFrontFace(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetBooleanv(GLenum, GLboolean *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetDoublev(GLenum, GLdouble *);
GLAPI FLEXTGL_EXPORT GLenum APIENTRY glGetError(void);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetFloatv(GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetIntegerv(GLenum, GLint *);
GLAPI FLEXTGL_EXPORT const GLubyte * APIENTRY glGetString(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexImage(GLenum, GLint, GLenum, GLenum, void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexLevelParameterfv(GLenum, GLint, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexLevelParameteriv(GLenum, GLint, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameterfv(GLenum, GLenum, GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGetTexParameteriv(GLenum, GLenum, GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glHint(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsEnabled(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glLineWidth(GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glLogicOp(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glPixelStoref(GLenum, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glPixelStorei(GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glPointSize(GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glPolygonMode(GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glReadBuffer(GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glReadPixels(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glScissor(GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilFunc(GLenum, GLint, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilMask(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glStencilOp(GLenum, GLenum, GLenum);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexImage1D(GLenum, GLint, GLint, GLsizei, GLint, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexImage2D(GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterf(GLenum, GLenum, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameterfv(GLenum, GLenum, const GLfloat *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteri(GLenum, GLenum, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexParameteriv(GLenum, GLenum, const GLint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glViewport(GLint, GLint, GLsizei, GLsizei);

/* GL_VERSION_1_1 */

GLAPI FLEXTGL_EXPORT void APIENTRY glBindTexture(GLenum, GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexImage1D(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexImage2D(GLenum, GLint, GLenum, GLint, GLint, GLsizei, GLsizei, GLint);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexSubImage1D(GLenum, GLint, GLint, GLint, GLint, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glCopyTexSubImage2D(GLenum, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDeleteTextures(GLsizei, const GLuint *);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawArrays(GLenum, GLint, GLsizei);
GLAPI FLEXTGL_EXPORT void APIENTRY glDrawElements(GLenum, GLsizei, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glGenTextures(GLsizei, GLuint *);
GLAPI FLEXTGL_EXPORT GLboolean APIENTRY glIsTexture(GLuint);
GLAPI FLEXTGL_EXPORT void APIENTRY glPolygonOffset(GLfloat, GLfloat);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexSubImage1D(GLenum, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
GLAPI FLEXTGL_EXPORT void APIENTRY glTexSubImage2D(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);

/* GL_VERSION_1_2 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyTexSubImage3D flextglCopyTexSubImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawRangeElements)(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *);
#define glDrawRangeElements flextglDrawRangeElements
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexImage3D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const void *);
#define glTexImage3D flextglTexImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glTexSubImage3D flextglTexSubImage3D

/* GL_VERSION_1_3 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglActiveTexture)(GLenum);
#define glActiveTexture flextglActiveTexture
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexImage1D)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTexImage1D flextglCompressedTexImage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTexImage2D flextglCompressedTexImage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexImage3D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const void *);
#define glCompressedTexImage3D flextglCompressedTexImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTexSubImage1D flextglCompressedTexSubImage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTexSubImage2D flextglCompressedTexSubImage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTexSubImage3D flextglCompressedTexSubImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetCompressedTexImage)(GLenum, GLint, void *);
#define glGetCompressedTexImage flextglGetCompressedTexImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSampleCoverage)(GLfloat, GLboolean);
#define glSampleCoverage flextglSampleCoverage

/* GL_VERSION_1_4 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendColor)(GLfloat, GLfloat, GLfloat, GLfloat);
#define glBlendColor flextglBlendColor
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendEquation)(GLenum);
#define glBlendEquation flextglBlendEquation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum);
#define glBlendFuncSeparate flextglBlendFuncSeparate
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawArrays)(GLenum, const GLint *, const GLsizei *, GLsizei);
#define glMultiDrawArrays flextglMultiDrawArrays
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawElements)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei);
#define glMultiDrawElements flextglMultiDrawElements
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPointParameterf)(GLenum, GLfloat);
#define glPointParameterf flextglPointParameterf
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPointParameterfv)(GLenum, const GLfloat *);
#define glPointParameterfv flextglPointParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPointParameteri)(GLenum, GLint);
#define glPointParameteri flextglPointParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPointParameteriv)(GLenum, const GLint *);
#define glPointParameteriv flextglPointParameteriv

/* GL_VERSION_1_5 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBeginQuery)(GLenum, GLuint);
#define glBeginQuery flextglBeginQuery
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindBuffer)(GLenum, GLuint);
#define glBindBuffer flextglBindBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBufferData)(GLenum, GLsizeiptr, const void *, GLenum);
#define glBufferData flextglBufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBufferSubData)(GLenum, GLintptr, GLsizeiptr, const void *);
#define glBufferSubData flextglBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteBuffers)(GLsizei, const GLuint *);
#define glDeleteBuffers flextglDeleteBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteQueries)(GLsizei, const GLuint *);
#define glDeleteQueries flextglDeleteQueries
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEndQuery)(GLenum);
#define glEndQuery flextglEndQuery
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenBuffers)(GLsizei, GLuint *);
#define glGenBuffers flextglGenBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenQueries)(GLsizei, GLuint *);
#define glGenQueries flextglGenQueries
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBufferParameteriv)(GLenum, GLenum, GLint *);
#define glGetBufferParameteriv flextglGetBufferParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBufferPointerv)(GLenum, GLenum, void **);
#define glGetBufferPointerv flextglGetBufferPointerv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBufferSubData)(GLenum, GLintptr, GLsizeiptr, void *);
#define glGetBufferSubData flextglGetBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryObjectiv)(GLuint, GLenum, GLint *);
#define glGetQueryObjectiv flextglGetQueryObjectiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryObjectuiv)(GLuint, GLenum, GLuint *);
#define glGetQueryObjectuiv flextglGetQueryObjectuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryiv)(GLenum, GLenum, GLint *);
#define glGetQueryiv flextglGetQueryiv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsBuffer)(GLuint);
#define glIsBuffer flextglIsBuffer
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsQuery)(GLuint);
#define glIsQuery flextglIsQuery
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapBuffer)(GLenum, GLenum);
#define glMapBuffer flextglMapBuffer
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglUnmapBuffer)(GLenum);
#define glUnmapBuffer flextglUnmapBuffer

/* GL_VERSION_2_0 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglAttachShader)(GLuint, GLuint);
#define glAttachShader flextglAttachShader
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindAttribLocation)(GLuint, GLuint, const GLchar *);
#define glBindAttribLocation flextglBindAttribLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendEquationSeparate)(GLenum, GLenum);
#define glBlendEquationSeparate flextglBlendEquationSeparate
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompileShader)(GLuint);
#define glCompileShader flextglCompileShader
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglCreateProgram)(void);
#define glCreateProgram flextglCreateProgram
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglCreateShader)(GLenum);
#define glCreateShader flextglCreateShader
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteProgram)(GLuint);
#define glDeleteProgram flextglDeleteProgram
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteShader)(GLuint);
#define glDeleteShader flextglDeleteShader
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDetachShader)(GLuint, GLuint);
#define glDetachShader flextglDetachShader
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableVertexAttribArray)(GLuint);
#define glDisableVertexAttribArray flextglDisableVertexAttribArray
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawBuffers)(GLsizei, const GLenum *);
#define glDrawBuffers flextglDrawBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableVertexAttribArray)(GLuint);
#define glEnableVertexAttribArray flextglEnableVertexAttribArray
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveAttrib)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
#define glGetActiveAttrib flextglGetActiveAttrib
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveUniform)(GLuint, GLuint, GLsizei, GLsizei *, GLint *, GLenum *, GLchar *);
#define glGetActiveUniform flextglGetActiveUniform
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetAttachedShaders)(GLuint, GLsizei, GLsizei *, GLuint *);
#define glGetAttachedShaders flextglGetAttachedShaders
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetAttribLocation)(GLuint, const GLchar *);
#define glGetAttribLocation flextglGetAttribLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetProgramInfoLog flextglGetProgramInfoLog
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramiv)(GLuint, GLenum, GLint *);
#define glGetProgramiv flextglGetProgramiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetShaderInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetShaderInfoLog flextglGetShaderInfoLog
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetShaderSource)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetShaderSource flextglGetShaderSource
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetShaderiv)(GLuint, GLenum, GLint *);
#define glGetShaderiv flextglGetShaderiv
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetUniformLocation)(GLuint, const GLchar *);
#define glGetUniformLocation flextglGetUniformLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformfv)(GLuint, GLint, GLfloat *);
#define glGetUniformfv flextglGetUniformfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformiv)(GLuint, GLint, GLint *);
#define glGetUniformiv flextglGetUniformiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribPointerv)(GLuint, GLenum, void **);
#define glGetVertexAttribPointerv flextglGetVertexAttribPointerv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribdv)(GLuint, GLenum, GLdouble *);
#define glGetVertexAttribdv flextglGetVertexAttribdv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribfv)(GLuint, GLenum, GLfloat *);
#define glGetVertexAttribfv flextglGetVertexAttribfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribiv)(GLuint, GLenum, GLint *);
#define glGetVertexAttribiv flextglGetVertexAttribiv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsProgram)(GLuint);
#define glIsProgram flextglIsProgram
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsShader)(GLuint);
#define glIsShader flextglIsShader
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglLinkProgram)(GLuint);
#define glLinkProgram flextglLinkProgram
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglShaderSource)(GLuint, GLsizei, const GLchar *const*, const GLint *);
#define glShaderSource flextglShaderSource
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglStencilFuncSeparate)(GLenum, GLenum, GLint, GLuint);
#define glStencilFuncSeparate flextglStencilFuncSeparate
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglStencilMaskSeparate)(GLenum, GLuint);
#define glStencilMaskSeparate flextglStencilMaskSeparate
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglStencilOpSeparate)(GLenum, GLenum, GLenum, GLenum);
#define glStencilOpSeparate flextglStencilOpSeparate
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1f)(GLint, GLfloat);
#define glUniform1f flextglUniform1f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1fv)(GLint, GLsizei, const GLfloat *);
#define glUniform1fv flextglUniform1fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1i)(GLint, GLint);
#define glUniform1i flextglUniform1i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1iv)(GLint, GLsizei, const GLint *);
#define glUniform1iv flextglUniform1iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2f)(GLint, GLfloat, GLfloat);
#define glUniform2f flextglUniform2f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2fv)(GLint, GLsizei, const GLfloat *);
#define glUniform2fv flextglUniform2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2i)(GLint, GLint, GLint);
#define glUniform2i flextglUniform2i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2iv)(GLint, GLsizei, const GLint *);
#define glUniform2iv flextglUniform2iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3f)(GLint, GLfloat, GLfloat, GLfloat);
#define glUniform3f flextglUniform3f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3fv)(GLint, GLsizei, const GLfloat *);
#define glUniform3fv flextglUniform3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3i)(GLint, GLint, GLint, GLint);
#define glUniform3i flextglUniform3i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3iv)(GLint, GLsizei, const GLint *);
#define glUniform3iv flextglUniform3iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4f)(GLint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glUniform4f flextglUniform4f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4fv)(GLint, GLsizei, const GLfloat *);
#define glUniform4fv flextglUniform4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4i)(GLint, GLint, GLint, GLint, GLint);
#define glUniform4i flextglUniform4i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4iv)(GLint, GLsizei, const GLint *);
#define glUniform4iv flextglUniform4iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix2fv flextglUniformMatrix2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix3fv flextglUniformMatrix3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix4fv flextglUniformMatrix4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUseProgram)(GLuint);
#define glUseProgram flextglUseProgram
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglValidateProgram)(GLuint);
#define glValidateProgram flextglValidateProgram
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1d)(GLuint, GLdouble);
#define glVertexAttrib1d flextglVertexAttrib1d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1dv)(GLuint, const GLdouble *);
#define glVertexAttrib1dv flextglVertexAttrib1dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1f)(GLuint, GLfloat);
#define glVertexAttrib1f flextglVertexAttrib1f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1fv)(GLuint, const GLfloat *);
#define glVertexAttrib1fv flextglVertexAttrib1fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1s)(GLuint, GLshort);
#define glVertexAttrib1s flextglVertexAttrib1s
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib1sv)(GLuint, const GLshort *);
#define glVertexAttrib1sv flextglVertexAttrib1sv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2d)(GLuint, GLdouble, GLdouble);
#define glVertexAttrib2d flextglVertexAttrib2d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2dv)(GLuint, const GLdouble *);
#define glVertexAttrib2dv flextglVertexAttrib2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2f)(GLuint, GLfloat, GLfloat);
#define glVertexAttrib2f flextglVertexAttrib2f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2fv)(GLuint, const GLfloat *);
#define glVertexAttrib2fv flextglVertexAttrib2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2s)(GLuint, GLshort, GLshort);
#define glVertexAttrib2s flextglVertexAttrib2s
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib2sv)(GLuint, const GLshort *);
#define glVertexAttrib2sv flextglVertexAttrib2sv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3d)(GLuint, GLdouble, GLdouble, GLdouble);
#define glVertexAttrib3d flextglVertexAttrib3d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3dv)(GLuint, const GLdouble *);
#define glVertexAttrib3dv flextglVertexAttrib3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3f)(GLuint, GLfloat, GLfloat, GLfloat);
#define glVertexAttrib3f flextglVertexAttrib3f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3fv)(GLuint, const GLfloat *);
#define glVertexAttrib3fv flextglVertexAttrib3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3s)(GLuint, GLshort, GLshort, GLshort);
#define glVertexAttrib3s flextglVertexAttrib3s
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib3sv)(GLuint, const GLshort *);
#define glVertexAttrib3sv flextglVertexAttrib3sv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nbv)(GLuint, const GLbyte *);
#define glVertexAttrib4Nbv flextglVertexAttrib4Nbv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Niv)(GLuint, const GLint *);
#define glVertexAttrib4Niv flextglVertexAttrib4Niv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nsv)(GLuint, const GLshort *);
#define glVertexAttrib4Nsv flextglVertexAttrib4Nsv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nub)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte);
#define glVertexAttrib4Nub flextglVertexAttrib4Nub
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nubv)(GLuint, const GLubyte *);
#define glVertexAttrib4Nubv flextglVertexAttrib4Nubv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nuiv)(GLuint, const GLuint *);
#define glVertexAttrib4Nuiv flextglVertexAttrib4Nuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4Nusv)(GLuint, const GLushort *);
#define glVertexAttrib4Nusv flextglVertexAttrib4Nusv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4bv)(GLuint, const GLbyte *);
#define glVertexAttrib4bv flextglVertexAttrib4bv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4d)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glVertexAttrib4d flextglVertexAttrib4d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4dv)(GLuint, const GLdouble *);
#define glVertexAttrib4dv flextglVertexAttrib4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4f)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glVertexAttrib4f flextglVertexAttrib4f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4fv)(GLuint, const GLfloat *);
#define glVertexAttrib4fv flextglVertexAttrib4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4iv)(GLuint, const GLint *);
#define glVertexAttrib4iv flextglVertexAttrib4iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4s)(GLuint, GLshort, GLshort, GLshort, GLshort);
#define glVertexAttrib4s flextglVertexAttrib4s
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4sv)(GLuint, const GLshort *);
#define glVertexAttrib4sv flextglVertexAttrib4sv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4ubv)(GLuint, const GLubyte *);
#define glVertexAttrib4ubv flextglVertexAttrib4ubv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4uiv)(GLuint, const GLuint *);
#define glVertexAttrib4uiv flextglVertexAttrib4uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttrib4usv)(GLuint, const GLushort *);
#define glVertexAttrib4usv flextglVertexAttrib4usv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribPointer)(GLuint, GLint, GLenum, GLboolean, GLsizei, const void *);
#define glVertexAttribPointer flextglVertexAttribPointer

/* GL_VERSION_2_1 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2x3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix2x3fv flextglUniformMatrix2x3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2x4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix2x4fv flextglUniformMatrix2x4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3x2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix3x2fv flextglUniformMatrix3x2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3x4fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix3x4fv flextglUniformMatrix3x4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4x2fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix4x2fv flextglUniformMatrix4x2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4x3fv)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix4x3fv flextglUniformMatrix4x3fv

/* GL_VERSION_3_0 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBeginConditionalRender)(GLuint, GLenum);
#define glBeginConditionalRender flextglBeginConditionalRender
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBeginTransformFeedback)(GLenum);
#define glBeginTransformFeedback flextglBeginTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindBufferBase)(GLenum, GLuint, GLuint);
#define glBindBufferBase flextglBindBufferBase
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindBufferRange)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
#define glBindBufferRange flextglBindBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindFragDataLocation)(GLuint, GLuint, const GLchar *);
#define glBindFragDataLocation flextglBindFragDataLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindFramebuffer)(GLenum, GLuint);
#define glBindFramebuffer flextglBindFramebuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindRenderbuffer)(GLenum, GLuint);
#define glBindRenderbuffer flextglBindRenderbuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindVertexArray)(GLuint);
#define glBindVertexArray flextglBindVertexArray
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlitFramebuffer)(GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
#define glBlitFramebuffer flextglBlitFramebuffer
GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglCheckFramebufferStatus)(GLenum);
#define glCheckFramebufferStatus flextglCheckFramebufferStatus
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClampColor)(GLenum, GLenum);
#define glClampColor flextglClampColor
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferfi)(GLenum, GLint, GLfloat, GLint);
#define glClearBufferfi flextglClearBufferfi
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferfv)(GLenum, GLint, const GLfloat *);
#define glClearBufferfv flextglClearBufferfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferiv)(GLenum, GLint, const GLint *);
#define glClearBufferiv flextglClearBufferiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferuiv)(GLenum, GLint, const GLuint *);
#define glClearBufferuiv flextglClearBufferuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglColorMaski)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
#define glColorMaski flextglColorMaski
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteFramebuffers)(GLsizei, const GLuint *);
#define glDeleteFramebuffers flextglDeleteFramebuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteRenderbuffers)(GLsizei, const GLuint *);
#define glDeleteRenderbuffers flextglDeleteRenderbuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteVertexArrays)(GLsizei, const GLuint *);
#define glDeleteVertexArrays flextglDeleteVertexArrays
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisablei)(GLenum, GLuint);
#define glDisablei flextglDisablei
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnablei)(GLenum, GLuint);
#define glEnablei flextglEnablei
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEndConditionalRender)(void);
#define glEndConditionalRender flextglEndConditionalRender
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEndTransformFeedback)(void);
#define glEndTransformFeedback flextglEndTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFlushMappedBufferRange)(GLenum, GLintptr, GLsizeiptr);
#define glFlushMappedBufferRange flextglFlushMappedBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferRenderbuffer)(GLenum, GLenum, GLenum, GLuint);
#define glFramebufferRenderbuffer flextglFramebufferRenderbuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferTexture1D)(GLenum, GLenum, GLenum, GLuint, GLint);
#define glFramebufferTexture1D flextglFramebufferTexture1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferTexture2D)(GLenum, GLenum, GLenum, GLuint, GLint);
#define glFramebufferTexture2D flextglFramebufferTexture2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferTexture3D)(GLenum, GLenum, GLenum, GLuint, GLint, GLint);
#define glFramebufferTexture3D flextglFramebufferTexture3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferTextureLayer)(GLenum, GLenum, GLuint, GLint, GLint);
#define glFramebufferTextureLayer flextglFramebufferTextureLayer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenFramebuffers)(GLsizei, GLuint *);
#define glGenFramebuffers flextglGenFramebuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenRenderbuffers)(GLsizei, GLuint *);
#define glGenRenderbuffers flextglGenRenderbuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenVertexArrays)(GLsizei, GLuint *);
#define glGenVertexArrays flextglGenVertexArrays
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenerateMipmap)(GLenum);
#define glGenerateMipmap flextglGenerateMipmap
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBooleani_v)(GLenum, GLuint, GLboolean *);
#define glGetBooleani_v flextglGetBooleani_v
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetFragDataLocation)(GLuint, const GLchar *);
#define glGetFragDataLocation flextglGetFragDataLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFramebufferAttachmentParameteriv)(GLenum, GLenum, GLenum, GLint *);
#define glGetFramebufferAttachmentParameteriv flextglGetFramebufferAttachmentParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetIntegeri_v)(GLenum, GLuint, GLint *);
#define glGetIntegeri_v flextglGetIntegeri_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetRenderbufferParameteriv)(GLenum, GLenum, GLint *);
#define glGetRenderbufferParameteriv flextglGetRenderbufferParameteriv
GLAPI FLEXTGL_EXPORT const GLubyte *(APIENTRY *flextglGetStringi)(GLenum, GLuint);
#define glGetStringi flextglGetStringi
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTexParameterIiv)(GLenum, GLenum, GLint *);
#define glGetTexParameterIiv flextglGetTexParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTexParameterIuiv)(GLenum, GLenum, GLuint *);
#define glGetTexParameterIuiv flextglGetTexParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTransformFeedbackVarying)(GLuint, GLuint, GLsizei, GLsizei *, GLsizei *, GLenum *, GLchar *);
#define glGetTransformFeedbackVarying flextglGetTransformFeedbackVarying
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformuiv)(GLuint, GLint, GLuint *);
#define glGetUniformuiv flextglGetUniformuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribIiv)(GLuint, GLenum, GLint *);
#define glGetVertexAttribIiv flextglGetVertexAttribIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribIuiv)(GLuint, GLenum, GLuint *);
#define glGetVertexAttribIuiv flextglGetVertexAttribIuiv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsEnabledi)(GLenum, GLuint);
#define glIsEnabledi flextglIsEnabledi
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsFramebuffer)(GLuint);
#define glIsFramebuffer flextglIsFramebuffer
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsRenderbuffer)(GLuint);
#define glIsRenderbuffer flextglIsRenderbuffer
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsVertexArray)(GLuint);
#define glIsVertexArray flextglIsVertexArray
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapBufferRange)(GLenum, GLintptr, GLsizeiptr, GLbitfield);
#define glMapBufferRange flextglMapBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglRenderbufferStorage)(GLenum, GLenum, GLsizei, GLsizei);
#define glRenderbufferStorage flextglRenderbufferStorage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglRenderbufferStorageMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
#define glRenderbufferStorageMultisample flextglRenderbufferStorageMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexParameterIiv)(GLenum, GLenum, const GLint *);
#define glTexParameterIiv flextglTexParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexParameterIuiv)(GLenum, GLenum, const GLuint *);
#define glTexParameterIuiv flextglTexParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTransformFeedbackVaryings)(GLuint, GLsizei, const GLchar *const*, GLenum);
#define glTransformFeedbackVaryings flextglTransformFeedbackVaryings
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1ui)(GLint, GLuint);
#define glUniform1ui flextglUniform1ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1uiv)(GLint, GLsizei, const GLuint *);
#define glUniform1uiv flextglUniform1uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2ui)(GLint, GLuint, GLuint);
#define glUniform2ui flextglUniform2ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2uiv)(GLint, GLsizei, const GLuint *);
#define glUniform2uiv flextglUniform2uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3ui)(GLint, GLuint, GLuint, GLuint);
#define glUniform3ui flextglUniform3ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3uiv)(GLint, GLsizei, const GLuint *);
#define glUniform3uiv flextglUniform3uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4ui)(GLint, GLuint, GLuint, GLuint, GLuint);
#define glUniform4ui flextglUniform4ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4uiv)(GLint, GLsizei, const GLuint *);
#define glUniform4uiv flextglUniform4uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI1i)(GLuint, GLint);
#define glVertexAttribI1i flextglVertexAttribI1i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI1iv)(GLuint, const GLint *);
#define glVertexAttribI1iv flextglVertexAttribI1iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI1ui)(GLuint, GLuint);
#define glVertexAttribI1ui flextglVertexAttribI1ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI1uiv)(GLuint, const GLuint *);
#define glVertexAttribI1uiv flextglVertexAttribI1uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI2i)(GLuint, GLint, GLint);
#define glVertexAttribI2i flextglVertexAttribI2i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI2iv)(GLuint, const GLint *);
#define glVertexAttribI2iv flextglVertexAttribI2iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI2ui)(GLuint, GLuint, GLuint);
#define glVertexAttribI2ui flextglVertexAttribI2ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI2uiv)(GLuint, const GLuint *);
#define glVertexAttribI2uiv flextglVertexAttribI2uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI3i)(GLuint, GLint, GLint, GLint);
#define glVertexAttribI3i flextglVertexAttribI3i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI3iv)(GLuint, const GLint *);
#define glVertexAttribI3iv flextglVertexAttribI3iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI3ui)(GLuint, GLuint, GLuint, GLuint);
#define glVertexAttribI3ui flextglVertexAttribI3ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI3uiv)(GLuint, const GLuint *);
#define glVertexAttribI3uiv flextglVertexAttribI3uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4bv)(GLuint, const GLbyte *);
#define glVertexAttribI4bv flextglVertexAttribI4bv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4i)(GLuint, GLint, GLint, GLint, GLint);
#define glVertexAttribI4i flextglVertexAttribI4i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4iv)(GLuint, const GLint *);
#define glVertexAttribI4iv flextglVertexAttribI4iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4sv)(GLuint, const GLshort *);
#define glVertexAttribI4sv flextglVertexAttribI4sv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4ubv)(GLuint, const GLubyte *);
#define glVertexAttribI4ubv flextglVertexAttribI4ubv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4ui)(GLuint, GLuint, GLuint, GLuint, GLuint);
#define glVertexAttribI4ui flextglVertexAttribI4ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4uiv)(GLuint, const GLuint *);
#define glVertexAttribI4uiv flextglVertexAttribI4uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribI4usv)(GLuint, const GLushort *);
#define glVertexAttribI4usv flextglVertexAttribI4usv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribIPointer)(GLuint, GLint, GLenum, GLsizei, const void *);
#define glVertexAttribIPointer flextglVertexAttribIPointer

/* GL_VERSION_3_1 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyBufferSubData)(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr);
#define glCopyBufferSubData flextglCopyBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawArraysInstanced)(GLenum, GLint, GLsizei, GLsizei);
#define glDrawArraysInstanced flextglDrawArraysInstanced
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsInstanced)(GLenum, GLsizei, GLenum, const void *, GLsizei);
#define glDrawElementsInstanced flextglDrawElementsInstanced
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveUniformBlockName)(GLuint, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetActiveUniformBlockName flextglGetActiveUniformBlockName
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveUniformBlockiv)(GLuint, GLuint, GLenum, GLint *);
#define glGetActiveUniformBlockiv flextglGetActiveUniformBlockiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveUniformName)(GLuint, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetActiveUniformName flextglGetActiveUniformName
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveUniformsiv)(GLuint, GLsizei, const GLuint *, GLenum, GLint *);
#define glGetActiveUniformsiv flextglGetActiveUniformsiv
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglGetUniformBlockIndex)(GLuint, const GLchar *);
#define glGetUniformBlockIndex flextglGetUniformBlockIndex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformIndices)(GLuint, GLsizei, const GLchar *const*, GLuint *);
#define glGetUniformIndices flextglGetUniformIndices
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPrimitiveRestartIndex)(GLuint);
#define glPrimitiveRestartIndex flextglPrimitiveRestartIndex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexBuffer)(GLenum, GLenum, GLuint);
#define glTexBuffer flextglTexBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformBlockBinding)(GLuint, GLuint, GLuint);
#define glUniformBlockBinding flextglUniformBlockBinding

/* GL_VERSION_3_2 */

GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglClientWaitSync)(GLsync, GLbitfield, GLuint64);
#define glClientWaitSync flextglClientWaitSync
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteSync)(GLsync);
#define glDeleteSync flextglDeleteSync
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLint);
#define glDrawElementsBaseVertex flextglDrawElementsBaseVertex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsInstancedBaseVertex)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLint);
#define glDrawElementsInstancedBaseVertex flextglDrawElementsInstancedBaseVertex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawRangeElementsBaseVertex)(GLenum, GLuint, GLuint, GLsizei, GLenum, const void *, GLint);
#define glDrawRangeElementsBaseVertex flextglDrawRangeElementsBaseVertex
GLAPI FLEXTGL_EXPORT GLsync(APIENTRY *flextglFenceSync)(GLenum, GLbitfield);
#define glFenceSync flextglFenceSync
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferTexture)(GLenum, GLenum, GLuint, GLint);
#define glFramebufferTexture flextglFramebufferTexture
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetBufferParameteri64v)(GLenum, GLenum, GLint64 *);
#define glGetBufferParameteri64v flextglGetBufferParameteri64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetInteger64i_v)(GLenum, GLuint, GLint64 *);
#define glGetInteger64i_v flextglGetInteger64i_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetInteger64v)(GLenum, GLint64 *);
#define glGetInteger64v flextglGetInteger64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetMultisamplefv)(GLenum, GLuint, GLfloat *);
#define glGetMultisamplefv flextglGetMultisamplefv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetSynciv)(GLsync, GLenum, GLsizei, GLsizei *, GLint *);
#define glGetSynciv flextglGetSynciv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsSync)(GLsync);
#define glIsSync flextglIsSync
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawElementsBaseVertex)(GLenum, const GLsizei *, GLenum, const void *const*, GLsizei, const GLint *);
#define glMultiDrawElementsBaseVertex flextglMultiDrawElementsBaseVertex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProvokingVertex)(GLenum);
#define glProvokingVertex flextglProvokingVertex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSampleMaski)(GLuint, GLbitfield);
#define glSampleMaski flextglSampleMaski
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexImage2DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
#define glTexImage2DMultisample flextglTexImage2DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexImage3DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTexImage3DMultisample flextglTexImage3DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglWaitSync)(GLsync, GLbitfield, GLuint64);
#define glWaitSync flextglWaitSync

/* GL_VERSION_3_3 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindFragDataLocationIndexed)(GLuint, GLuint, GLuint, const GLchar *);
#define glBindFragDataLocationIndexed flextglBindFragDataLocationIndexed
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindSampler)(GLuint, GLuint);
#define glBindSampler flextglBindSampler
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteSamplers)(GLsizei, const GLuint *);
#define glDeleteSamplers flextglDeleteSamplers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenSamplers)(GLsizei, GLuint *);
#define glGenSamplers flextglGenSamplers
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetFragDataIndex)(GLuint, const GLchar *);
#define glGetFragDataIndex flextglGetFragDataIndex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryObjecti64v)(GLuint, GLenum, GLint64 *);
#define glGetQueryObjecti64v flextglGetQueryObjecti64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryObjectui64v)(GLuint, GLenum, GLuint64 *);
#define glGetQueryObjectui64v flextglGetQueryObjectui64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetSamplerParameterIiv)(GLuint, GLenum, GLint *);
#define glGetSamplerParameterIiv flextglGetSamplerParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetSamplerParameterIuiv)(GLuint, GLenum, GLuint *);
#define glGetSamplerParameterIuiv flextglGetSamplerParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetSamplerParameterfv)(GLuint, GLenum, GLfloat *);
#define glGetSamplerParameterfv flextglGetSamplerParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetSamplerParameteriv)(GLuint, GLenum, GLint *);
#define glGetSamplerParameteriv flextglGetSamplerParameteriv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsSampler)(GLuint);
#define glIsSampler flextglIsSampler
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglQueryCounter)(GLuint, GLenum);
#define glQueryCounter flextglQueryCounter
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameterIiv)(GLuint, GLenum, const GLint *);
#define glSamplerParameterIiv flextglSamplerParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameterIuiv)(GLuint, GLenum, const GLuint *);
#define glSamplerParameterIuiv flextglSamplerParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameterf)(GLuint, GLenum, GLfloat);
#define glSamplerParameterf flextglSamplerParameterf
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameterfv)(GLuint, GLenum, const GLfloat *);
#define glSamplerParameterfv flextglSamplerParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameteri)(GLuint, GLenum, GLint);
#define glSamplerParameteri flextglSamplerParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglSamplerParameteriv)(GLuint, GLenum, const GLint *);
#define glSamplerParameteriv flextglSamplerParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribDivisor)(GLuint, GLuint);
#define glVertexAttribDivisor flextglVertexAttribDivisor
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP1ui)(GLuint, GLenum, GLboolean, GLuint);
#define glVertexAttribP1ui flextglVertexAttribP1ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP1uiv)(GLuint, GLenum, GLboolean, const GLuint *);
#define glVertexAttribP1uiv flextglVertexAttribP1uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP2ui)(GLuint, GLenum, GLboolean, GLuint);
#define glVertexAttribP2ui flextglVertexAttribP2ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP2uiv)(GLuint, GLenum, GLboolean, const GLuint *);
#define glVertexAttribP2uiv flextglVertexAttribP2uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP3ui)(GLuint, GLenum, GLboolean, GLuint);
#define glVertexAttribP3ui flextglVertexAttribP3ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP3uiv)(GLuint, GLenum, GLboolean, const GLuint *);
#define glVertexAttribP3uiv flextglVertexAttribP3uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP4ui)(GLuint, GLenum, GLboolean, GLuint);
#define glVertexAttribP4ui flextglVertexAttribP4ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribP4uiv)(GLuint, GLenum, GLboolean, const GLuint *);
#define glVertexAttribP4uiv flextglVertexAttribP4uiv

/* GL_VERSION_4_0 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBeginQueryIndexed)(GLenum, GLuint, GLuint);
#define glBeginQueryIndexed flextglBeginQueryIndexed
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindTransformFeedback)(GLenum, GLuint);
#define glBindTransformFeedback flextglBindTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendEquationSeparatei)(GLuint, GLenum, GLenum);
#define glBlendEquationSeparatei flextglBlendEquationSeparatei
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendEquationi)(GLuint, GLenum);
#define glBlendEquationi flextglBlendEquationi
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendFuncSeparatei)(GLuint, GLenum, GLenum, GLenum, GLenum);
#define glBlendFuncSeparatei flextglBlendFuncSeparatei
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlendFunci)(GLuint, GLenum, GLenum);
#define glBlendFunci flextglBlendFunci
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteTransformFeedbacks)(GLsizei, const GLuint *);
#define glDeleteTransformFeedbacks flextglDeleteTransformFeedbacks
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawArraysIndirect)(GLenum, const void *);
#define glDrawArraysIndirect flextglDrawArraysIndirect
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsIndirect)(GLenum, GLenum, const void *);
#define glDrawElementsIndirect flextglDrawElementsIndirect
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawTransformFeedback)(GLenum, GLuint);
#define glDrawTransformFeedback flextglDrawTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawTransformFeedbackStream)(GLenum, GLuint, GLuint);
#define glDrawTransformFeedbackStream flextglDrawTransformFeedbackStream
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEndQueryIndexed)(GLenum, GLuint);
#define glEndQueryIndexed flextglEndQueryIndexed
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenTransformFeedbacks)(GLsizei, GLuint *);
#define glGenTransformFeedbacks flextglGenTransformFeedbacks
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveSubroutineName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetActiveSubroutineName flextglGetActiveSubroutineName
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveSubroutineUniformName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetActiveSubroutineUniformName flextglGetActiveSubroutineUniformName
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveSubroutineUniformiv)(GLuint, GLenum, GLuint, GLenum, GLint *);
#define glGetActiveSubroutineUniformiv flextglGetActiveSubroutineUniformiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramStageiv)(GLuint, GLenum, GLenum, GLint *);
#define glGetProgramStageiv flextglGetProgramStageiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryIndexediv)(GLenum, GLuint, GLenum, GLint *);
#define glGetQueryIndexediv flextglGetQueryIndexediv
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglGetSubroutineIndex)(GLuint, GLenum, const GLchar *);
#define glGetSubroutineIndex flextglGetSubroutineIndex
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetSubroutineUniformLocation)(GLuint, GLenum, const GLchar *);
#define glGetSubroutineUniformLocation flextglGetSubroutineUniformLocation
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformSubroutineuiv)(GLenum, GLint, GLuint *);
#define glGetUniformSubroutineuiv flextglGetUniformSubroutineuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetUniformdv)(GLuint, GLint, GLdouble *);
#define glGetUniformdv flextglGetUniformdv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsTransformFeedback)(GLuint);
#define glIsTransformFeedback flextglIsTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMinSampleShading)(GLfloat);
#define glMinSampleShading flextglMinSampleShading
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPatchParameterfv)(GLenum, const GLfloat *);
#define glPatchParameterfv flextglPatchParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPatchParameteri)(GLenum, GLint);
#define glPatchParameteri flextglPatchParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPauseTransformFeedback)(void);
#define glPauseTransformFeedback flextglPauseTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglResumeTransformFeedback)(void);
#define glResumeTransformFeedback flextglResumeTransformFeedback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1d)(GLint, GLdouble);
#define glUniform1d flextglUniform1d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform1dv)(GLint, GLsizei, const GLdouble *);
#define glUniform1dv flextglUniform1dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2d)(GLint, GLdouble, GLdouble);
#define glUniform2d flextglUniform2d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform2dv)(GLint, GLsizei, const GLdouble *);
#define glUniform2dv flextglUniform2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3d)(GLint, GLdouble, GLdouble, GLdouble);
#define glUniform3d flextglUniform3d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform3dv)(GLint, GLsizei, const GLdouble *);
#define glUniform3dv flextglUniform3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4d)(GLint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glUniform4d flextglUniform4d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniform4dv)(GLint, GLsizei, const GLdouble *);
#define glUniform4dv flextglUniform4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix2dv flextglUniformMatrix2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2x3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix2x3dv flextglUniformMatrix2x3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix2x4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix2x4dv flextglUniformMatrix2x4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix3dv flextglUniformMatrix3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3x2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix3x2dv flextglUniformMatrix3x2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix3x4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix3x4dv flextglUniformMatrix3x4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix4dv flextglUniformMatrix4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4x2dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix4x2dv flextglUniformMatrix4x2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformMatrix4x3dv)(GLint, GLsizei, GLboolean, const GLdouble *);
#define glUniformMatrix4x3dv flextglUniformMatrix4x3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUniformSubroutinesuiv)(GLenum, GLsizei, const GLuint *);
#define glUniformSubroutinesuiv flextglUniformSubroutinesuiv

/* GL_VERSION_4_1 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglActiveShaderProgram)(GLuint, GLuint);
#define glActiveShaderProgram flextglActiveShaderProgram
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindProgramPipeline)(GLuint);
#define glBindProgramPipeline flextglBindProgramPipeline
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearDepthf)(GLfloat);
#define glClearDepthf flextglClearDepthf
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglCreateShaderProgramv)(GLenum, GLsizei, const GLchar *const*);
#define glCreateShaderProgramv flextglCreateShaderProgramv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDeleteProgramPipelines)(GLsizei, const GLuint *);
#define glDeleteProgramPipelines flextglDeleteProgramPipelines
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDepthRangeArrayv)(GLuint, GLsizei, const GLdouble *);
#define glDepthRangeArrayv flextglDepthRangeArrayv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDepthRangeIndexed)(GLuint, GLdouble, GLdouble);
#define glDepthRangeIndexed flextglDepthRangeIndexed
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDepthRangef)(GLfloat, GLfloat);
#define glDepthRangef flextglDepthRangef
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenProgramPipelines)(GLsizei, GLuint *);
#define glGenProgramPipelines flextglGenProgramPipelines
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetDoublei_v)(GLenum, GLuint, GLdouble *);
#define glGetDoublei_v flextglGetDoublei_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFloati_v)(GLenum, GLuint, GLfloat *);
#define glGetFloati_v flextglGetFloati_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramBinary)(GLuint, GLsizei, GLsizei *, GLenum *, void *);
#define glGetProgramBinary flextglGetProgramBinary
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramPipelineInfoLog)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetProgramPipelineInfoLog flextglGetProgramPipelineInfoLog
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramPipelineiv)(GLuint, GLenum, GLint *);
#define glGetProgramPipelineiv flextglGetProgramPipelineiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetShaderPrecisionFormat)(GLenum, GLenum, GLint *, GLint *);
#define glGetShaderPrecisionFormat flextglGetShaderPrecisionFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexAttribLdv)(GLuint, GLenum, GLdouble *);
#define glGetVertexAttribLdv flextglGetVertexAttribLdv
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglIsProgramPipeline)(GLuint);
#define glIsProgramPipeline flextglIsProgramPipeline
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramBinary)(GLuint, GLenum, const void *, GLsizei);
#define glProgramBinary flextglProgramBinary
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramParameteri)(GLuint, GLenum, GLint);
#define glProgramParameteri flextglProgramParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1d)(GLuint, GLint, GLdouble);
#define glProgramUniform1d flextglProgramUniform1d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1dv)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform1dv flextglProgramUniform1dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1f)(GLuint, GLint, GLfloat);
#define glProgramUniform1f flextglProgramUniform1f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1fv)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform1fv flextglProgramUniform1fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1i)(GLuint, GLint, GLint);
#define glProgramUniform1i flextglProgramUniform1i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1iv)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform1iv flextglProgramUniform1iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1ui)(GLuint, GLint, GLuint);
#define glProgramUniform1ui flextglProgramUniform1ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform1uiv)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform1uiv flextglProgramUniform1uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2d)(GLuint, GLint, GLdouble, GLdouble);
#define glProgramUniform2d flextglProgramUniform2d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2dv)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform2dv flextglProgramUniform2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2f)(GLuint, GLint, GLfloat, GLfloat);
#define glProgramUniform2f flextglProgramUniform2f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2fv)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform2fv flextglProgramUniform2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2i)(GLuint, GLint, GLint, GLint);
#define glProgramUniform2i flextglProgramUniform2i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2iv)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform2iv flextglProgramUniform2iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2ui)(GLuint, GLint, GLuint, GLuint);
#define glProgramUniform2ui flextglProgramUniform2ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform2uiv)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform2uiv flextglProgramUniform2uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3d)(GLuint, GLint, GLdouble, GLdouble, GLdouble);
#define glProgramUniform3d flextglProgramUniform3d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3dv)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform3dv flextglProgramUniform3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3f)(GLuint, GLint, GLfloat, GLfloat, GLfloat);
#define glProgramUniform3f flextglProgramUniform3f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3fv)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform3fv flextglProgramUniform3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3i)(GLuint, GLint, GLint, GLint, GLint);
#define glProgramUniform3i flextglProgramUniform3i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3iv)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform3iv flextglProgramUniform3iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3ui)(GLuint, GLint, GLuint, GLuint, GLuint);
#define glProgramUniform3ui flextglProgramUniform3ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform3uiv)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform3uiv flextglProgramUniform3uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4d)(GLuint, GLint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glProgramUniform4d flextglProgramUniform4d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4dv)(GLuint, GLint, GLsizei, const GLdouble *);
#define glProgramUniform4dv flextglProgramUniform4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4f)(GLuint, GLint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glProgramUniform4f flextglProgramUniform4f
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4fv)(GLuint, GLint, GLsizei, const GLfloat *);
#define glProgramUniform4fv flextglProgramUniform4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4i)(GLuint, GLint, GLint, GLint, GLint, GLint);
#define glProgramUniform4i flextglProgramUniform4i
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4iv)(GLuint, GLint, GLsizei, const GLint *);
#define glProgramUniform4iv flextglProgramUniform4iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4ui)(GLuint, GLint, GLuint, GLuint, GLuint, GLuint);
#define glProgramUniform4ui flextglProgramUniform4ui
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniform4uiv)(GLuint, GLint, GLsizei, const GLuint *);
#define glProgramUniform4uiv flextglProgramUniform4uiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2dv flextglProgramUniformMatrix2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2fv flextglProgramUniformMatrix2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2x3dv flextglProgramUniformMatrix2x3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2x3fv flextglProgramUniformMatrix2x3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix2x4dv flextglProgramUniformMatrix2x4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix2x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix2x4fv flextglProgramUniformMatrix2x4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3dv flextglProgramUniformMatrix3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3fv flextglProgramUniformMatrix3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3x2dv flextglProgramUniformMatrix3x2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3x2fv flextglProgramUniformMatrix3x2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix3x4dv flextglProgramUniformMatrix3x4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix3x4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix3x4fv flextglProgramUniformMatrix3x4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4dv flextglProgramUniformMatrix4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4fv flextglProgramUniformMatrix4fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x2dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4x2dv flextglProgramUniformMatrix4x2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x2fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4x2fv flextglProgramUniformMatrix4x2fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x3dv)(GLuint, GLint, GLsizei, GLboolean, const GLdouble *);
#define glProgramUniformMatrix4x3dv flextglProgramUniformMatrix4x3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglProgramUniformMatrix4x3fv)(GLuint, GLint, GLsizei, GLboolean, const GLfloat *);
#define glProgramUniformMatrix4x3fv flextglProgramUniformMatrix4x3fv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglReleaseShaderCompiler)(void);
#define glReleaseShaderCompiler flextglReleaseShaderCompiler
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglScissorArrayv)(GLuint, GLsizei, const GLint *);
#define glScissorArrayv flextglScissorArrayv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglScissorIndexed)(GLuint, GLint, GLint, GLsizei, GLsizei);
#define glScissorIndexed flextglScissorIndexed
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglScissorIndexedv)(GLuint, const GLint *);
#define glScissorIndexedv flextglScissorIndexedv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglShaderBinary)(GLsizei, const GLuint *, GLenum, const void *, GLsizei);
#define glShaderBinary flextglShaderBinary
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglUseProgramStages)(GLuint, GLbitfield, GLuint);
#define glUseProgramStages flextglUseProgramStages
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglValidateProgramPipeline)(GLuint);
#define glValidateProgramPipeline flextglValidateProgramPipeline
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL1d)(GLuint, GLdouble);
#define glVertexAttribL1d flextglVertexAttribL1d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL1dv)(GLuint, const GLdouble *);
#define glVertexAttribL1dv flextglVertexAttribL1dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL2d)(GLuint, GLdouble, GLdouble);
#define glVertexAttribL2d flextglVertexAttribL2d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL2dv)(GLuint, const GLdouble *);
#define glVertexAttribL2dv flextglVertexAttribL2dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL3d)(GLuint, GLdouble, GLdouble, GLdouble);
#define glVertexAttribL3d flextglVertexAttribL3d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL3dv)(GLuint, const GLdouble *);
#define glVertexAttribL3dv flextglVertexAttribL3dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL4d)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
#define glVertexAttribL4d flextglVertexAttribL4d
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribL4dv)(GLuint, const GLdouble *);
#define glVertexAttribL4dv flextglVertexAttribL4dv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribLPointer)(GLuint, GLint, GLenum, GLsizei, const void *);
#define glVertexAttribLPointer flextglVertexAttribLPointer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglViewportArrayv)(GLuint, GLsizei, const GLfloat *);
#define glViewportArrayv flextglViewportArrayv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglViewportIndexedf)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
#define glViewportIndexedf flextglViewportIndexedf
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglViewportIndexedfv)(GLuint, const GLfloat *);
#define glViewportIndexedfv flextglViewportIndexedfv

/* GL_VERSION_4_2 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindImageTexture)(GLuint, GLuint, GLint, GLboolean, GLint, GLenum, GLenum);
#define glBindImageTexture flextglBindImageTexture
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawArraysInstancedBaseInstance)(GLenum, GLint, GLsizei, GLsizei, GLuint);
#define glDrawArraysInstancedBaseInstance flextglDrawArraysInstancedBaseInstance
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsInstancedBaseInstance)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLuint);
#define glDrawElementsInstancedBaseInstance flextglDrawElementsInstancedBaseInstance
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawElementsInstancedBaseVertexBaseInstance)(GLenum, GLsizei, GLenum, const void *, GLsizei, GLint, GLuint);
#define glDrawElementsInstancedBaseVertexBaseInstance flextglDrawElementsInstancedBaseVertexBaseInstance
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawTransformFeedbackInstanced)(GLenum, GLuint, GLsizei);
#define glDrawTransformFeedbackInstanced flextglDrawTransformFeedbackInstanced
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDrawTransformFeedbackStreamInstanced)(GLenum, GLuint, GLuint, GLsizei);
#define glDrawTransformFeedbackStreamInstanced flextglDrawTransformFeedbackStreamInstanced
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetActiveAtomicCounterBufferiv)(GLuint, GLuint, GLenum, GLint *);
#define glGetActiveAtomicCounterBufferiv flextglGetActiveAtomicCounterBufferiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetInternalformativ)(GLenum, GLenum, GLenum, GLsizei, GLint *);
#define glGetInternalformativ flextglGetInternalformativ
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMemoryBarrier)(GLbitfield);
#define glMemoryBarrier flextglMemoryBarrier
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexStorage1D)(GLenum, GLsizei, GLenum, GLsizei);
#define glTexStorage1D flextglTexStorage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexStorage2D)(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
#define glTexStorage2D flextglTexStorage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexStorage3D)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);
#define glTexStorage3D flextglTexStorage3D

/* GL_VERSION_4_3 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindVertexBuffer)(GLuint, GLuint, GLintptr, GLsizei);
#define glBindVertexBuffer flextglBindVertexBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferData)(GLenum, GLenum, GLenum, GLenum, const void *);
#define glClearBufferData flextglClearBufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearBufferSubData)(GLenum, GLenum, GLintptr, GLsizeiptr, GLenum, GLenum, const void *);
#define glClearBufferSubData flextglClearBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyImageSubData)(GLuint, GLenum, GLint, GLint, GLint, GLint, GLuint, GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
#define glCopyImageSubData flextglCopyImageSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDebugMessageCallback)(GLDEBUGPROC, const void *);
#define glDebugMessageCallback flextglDebugMessageCallback
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDebugMessageControl)(GLenum, GLenum, GLenum, GLsizei, const GLuint *, GLboolean);
#define glDebugMessageControl flextglDebugMessageControl
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDebugMessageInsert)(GLenum, GLenum, GLuint, GLenum, GLsizei, const GLchar *);
#define glDebugMessageInsert flextglDebugMessageInsert
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDispatchCompute)(GLuint, GLuint, GLuint);
#define glDispatchCompute flextglDispatchCompute
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDispatchComputeIndirect)(GLintptr);
#define glDispatchComputeIndirect flextglDispatchComputeIndirect
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFramebufferParameteri)(GLenum, GLenum, GLint);
#define glFramebufferParameteri flextglFramebufferParameteri
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglGetDebugMessageLog)(GLuint, GLsizei, GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *);
#define glGetDebugMessageLog flextglGetDebugMessageLog
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetFramebufferParameteriv)(GLenum, GLenum, GLint *);
#define glGetFramebufferParameteriv flextglGetFramebufferParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetInternalformati64v)(GLenum, GLenum, GLenum, GLsizei, GLint64 *);
#define glGetInternalformati64v flextglGetInternalformati64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetObjectLabel)(GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetObjectLabel flextglGetObjectLabel
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetObjectPtrLabel)(const void *, GLsizei, GLsizei *, GLchar *);
#define glGetObjectPtrLabel flextglGetObjectPtrLabel
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetPointerv)(GLenum, void **);
#define glGetPointerv flextglGetPointerv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramInterfaceiv)(GLuint, GLenum, GLenum, GLint *);
#define glGetProgramInterfaceiv flextglGetProgramInterfaceiv
GLAPI FLEXTGL_EXPORT GLuint(APIENTRY *flextglGetProgramResourceIndex)(GLuint, GLenum, const GLchar *);
#define glGetProgramResourceIndex flextglGetProgramResourceIndex
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetProgramResourceLocation)(GLuint, GLenum, const GLchar *);
#define glGetProgramResourceLocation flextglGetProgramResourceLocation
GLAPI FLEXTGL_EXPORT GLint(APIENTRY *flextglGetProgramResourceLocationIndex)(GLuint, GLenum, const GLchar *);
#define glGetProgramResourceLocationIndex flextglGetProgramResourceLocationIndex
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramResourceName)(GLuint, GLenum, GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetProgramResourceName flextglGetProgramResourceName
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetProgramResourceiv)(GLuint, GLenum, GLuint, GLsizei, const GLenum *, GLsizei, GLsizei *, GLint *);
#define glGetProgramResourceiv flextglGetProgramResourceiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateBufferData)(GLuint);
#define glInvalidateBufferData flextglInvalidateBufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateBufferSubData)(GLuint, GLintptr, GLsizeiptr);
#define glInvalidateBufferSubData flextglInvalidateBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateFramebuffer)(GLenum, GLsizei, const GLenum *);
#define glInvalidateFramebuffer flextglInvalidateFramebuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateSubFramebuffer)(GLenum, GLsizei, const GLenum *, GLint, GLint, GLsizei, GLsizei);
#define glInvalidateSubFramebuffer flextglInvalidateSubFramebuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateTexImage)(GLuint, GLint);
#define glInvalidateTexImage flextglInvalidateTexImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateTexSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei);
#define glInvalidateTexSubImage flextglInvalidateTexSubImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawArraysIndirect)(GLenum, const void *, GLsizei, GLsizei);
#define glMultiDrawArraysIndirect flextglMultiDrawArraysIndirect
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMultiDrawElementsIndirect)(GLenum, GLenum, const void *, GLsizei, GLsizei);
#define glMultiDrawElementsIndirect flextglMultiDrawElementsIndirect
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglObjectLabel)(GLenum, GLuint, GLsizei, const GLchar *);
#define glObjectLabel flextglObjectLabel
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglObjectPtrLabel)(const void *, GLsizei, const GLchar *);
#define glObjectPtrLabel flextglObjectPtrLabel
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPopDebugGroup)(void);
#define glPopDebugGroup flextglPopDebugGroup
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglPushDebugGroup)(GLenum, GLuint, GLsizei, const GLchar *);
#define glPushDebugGroup flextglPushDebugGroup
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglShaderStorageBlockBinding)(GLuint, GLuint, GLuint);
#define glShaderStorageBlockBinding flextglShaderStorageBlockBinding
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexBufferRange)(GLenum, GLenum, GLuint, GLintptr, GLsizeiptr);
#define glTexBufferRange flextglTexBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexStorage2DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
#define glTexStorage2DMultisample flextglTexStorage2DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTexStorage3DMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTexStorage3DMultisample flextglTexStorage3DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureView)(GLuint, GLenum, GLuint, GLenum, GLuint, GLuint, GLuint, GLuint);
#define glTextureView flextglTextureView
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribBinding)(GLuint, GLuint);
#define glVertexAttribBinding flextglVertexAttribBinding
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribFormat)(GLuint, GLint, GLenum, GLboolean, GLuint);
#define glVertexAttribFormat flextglVertexAttribFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribIFormat)(GLuint, GLint, GLenum, GLuint);
#define glVertexAttribIFormat flextglVertexAttribIFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexAttribLFormat)(GLuint, GLint, GLenum, GLuint);
#define glVertexAttribLFormat flextglVertexAttribLFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexBindingDivisor)(GLuint, GLuint);
#define glVertexBindingDivisor flextglVertexBindingDivisor

/* GL_VERSION_4_4 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindBuffersBase)(GLenum, GLuint, GLsizei, const GLuint *);
#define glBindBuffersBase flextglBindBuffersBase
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindBuffersRange)(GLenum, GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizeiptr *);
#define glBindBuffersRange flextglBindBuffersRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindImageTextures)(GLuint, GLsizei, const GLuint *);
#define glBindImageTextures flextglBindImageTextures
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindSamplers)(GLuint, GLsizei, const GLuint *);
#define glBindSamplers flextglBindSamplers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindTextures)(GLuint, GLsizei, const GLuint *);
#define glBindTextures flextglBindTextures
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindVertexBuffers)(GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizei *);
#define glBindVertexBuffers flextglBindVertexBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBufferStorage)(GLenum, GLsizeiptr, const void *, GLbitfield);
#define glBufferStorage flextglBufferStorage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearTexImage)(GLuint, GLint, GLenum, GLenum, const void *);
#define glClearTexImage flextglClearTexImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearTexSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glClearTexSubImage flextglClearTexSubImage

/* GL_VERSION_4_5 */

GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBindTextureUnit)(GLuint, GLuint);
#define glBindTextureUnit flextglBindTextureUnit
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglBlitNamedFramebuffer)(GLuint, GLuint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLint, GLbitfield, GLenum);
#define glBlitNamedFramebuffer flextglBlitNamedFramebuffer
GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglCheckNamedFramebufferStatus)(GLuint, GLenum);
#define glCheckNamedFramebufferStatus flextglCheckNamedFramebufferStatus
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedBufferData)(GLuint, GLenum, GLenum, GLenum, const void *);
#define glClearNamedBufferData flextglClearNamedBufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedBufferSubData)(GLuint, GLenum, GLintptr, GLsizeiptr, GLenum, GLenum, const void *);
#define glClearNamedBufferSubData flextglClearNamedBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedFramebufferfi)(GLuint, GLenum, GLint, GLfloat, GLint);
#define glClearNamedFramebufferfi flextglClearNamedFramebufferfi
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedFramebufferfv)(GLuint, GLenum, GLint, const GLfloat *);
#define glClearNamedFramebufferfv flextglClearNamedFramebufferfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedFramebufferiv)(GLuint, GLenum, GLint, const GLint *);
#define glClearNamedFramebufferiv flextglClearNamedFramebufferiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClearNamedFramebufferuiv)(GLuint, GLenum, GLint, const GLuint *);
#define glClearNamedFramebufferuiv flextglClearNamedFramebufferuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglClipControl)(GLenum, GLenum);
#define glClipControl flextglClipControl
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage1D)(GLuint, GLint, GLint, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage1D flextglCompressedTextureSubImage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage2D)(GLuint, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage2D flextglCompressedTextureSubImage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCompressedTextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void *);
#define glCompressedTextureSubImage3D flextglCompressedTextureSubImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyNamedBufferSubData)(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr);
#define glCopyNamedBufferSubData flextglCopyNamedBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage1D)(GLuint, GLint, GLint, GLint, GLint, GLsizei);
#define glCopyTextureSubImage1D flextglCopyTextureSubImage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage2D)(GLuint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyTextureSubImage2D flextglCopyTextureSubImage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCopyTextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);
#define glCopyTextureSubImage3D flextglCopyTextureSubImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateBuffers)(GLsizei, GLuint *);
#define glCreateBuffers flextglCreateBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateFramebuffers)(GLsizei, GLuint *);
#define glCreateFramebuffers flextglCreateFramebuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateProgramPipelines)(GLsizei, GLuint *);
#define glCreateProgramPipelines flextglCreateProgramPipelines
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateQueries)(GLenum, GLsizei, GLuint *);
#define glCreateQueries flextglCreateQueries
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateRenderbuffers)(GLsizei, GLuint *);
#define glCreateRenderbuffers flextglCreateRenderbuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateSamplers)(GLsizei, GLuint *);
#define glCreateSamplers flextglCreateSamplers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateTextures)(GLenum, GLsizei, GLuint *);
#define glCreateTextures flextglCreateTextures
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateTransformFeedbacks)(GLsizei, GLuint *);
#define glCreateTransformFeedbacks flextglCreateTransformFeedbacks
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglCreateVertexArrays)(GLsizei, GLuint *);
#define glCreateVertexArrays flextglCreateVertexArrays
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglDisableVertexArrayAttrib)(GLuint, GLuint);
#define glDisableVertexArrayAttrib flextglDisableVertexArrayAttrib
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglEnableVertexArrayAttrib)(GLuint, GLuint);
#define glEnableVertexArrayAttrib flextglEnableVertexArrayAttrib
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglFlushMappedNamedBufferRange)(GLuint, GLintptr, GLsizeiptr);
#define glFlushMappedNamedBufferRange flextglFlushMappedNamedBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGenerateTextureMipmap)(GLuint);
#define glGenerateTextureMipmap flextglGenerateTextureMipmap
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetCompressedTextureImage)(GLuint, GLint, GLsizei, void *);
#define glGetCompressedTextureImage flextglGetCompressedTextureImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetCompressedTextureSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLsizei, void *);
#define glGetCompressedTextureSubImage flextglGetCompressedTextureSubImage
GLAPI FLEXTGL_EXPORT GLenum(APIENTRY *flextglGetGraphicsResetStatus)(void);
#define glGetGraphicsResetStatus flextglGetGraphicsResetStatus
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferParameteri64v)(GLuint, GLenum, GLint64 *);
#define glGetNamedBufferParameteri64v flextglGetNamedBufferParameteri64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferParameteriv)(GLuint, GLenum, GLint *);
#define glGetNamedBufferParameteriv flextglGetNamedBufferParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferPointerv)(GLuint, GLenum, void **);
#define glGetNamedBufferPointerv flextglGetNamedBufferPointerv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedBufferSubData)(GLuint, GLintptr, GLsizeiptr, void *);
#define glGetNamedBufferSubData flextglGetNamedBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedFramebufferAttachmentParameteriv)(GLuint, GLenum, GLenum, GLint *);
#define glGetNamedFramebufferAttachmentParameteriv flextglGetNamedFramebufferAttachmentParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedFramebufferParameteriv)(GLuint, GLenum, GLint *);
#define glGetNamedFramebufferParameteriv flextglGetNamedFramebufferParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetNamedRenderbufferParameteriv)(GLuint, GLenum, GLint *);
#define glGetNamedRenderbufferParameteriv flextglGetNamedRenderbufferParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryBufferObjecti64v)(GLuint, GLuint, GLenum, GLintptr);
#define glGetQueryBufferObjecti64v flextglGetQueryBufferObjecti64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryBufferObjectiv)(GLuint, GLuint, GLenum, GLintptr);
#define glGetQueryBufferObjectiv flextglGetQueryBufferObjectiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryBufferObjectui64v)(GLuint, GLuint, GLenum, GLintptr);
#define glGetQueryBufferObjectui64v flextglGetQueryBufferObjectui64v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetQueryBufferObjectuiv)(GLuint, GLuint, GLenum, GLintptr);
#define glGetQueryBufferObjectuiv flextglGetQueryBufferObjectuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureImage)(GLuint, GLint, GLenum, GLenum, GLsizei, void *);
#define glGetTextureImage flextglGetTextureImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureLevelParameterfv)(GLuint, GLint, GLenum, GLfloat *);
#define glGetTextureLevelParameterfv flextglGetTextureLevelParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureLevelParameteriv)(GLuint, GLint, GLenum, GLint *);
#define glGetTextureLevelParameteriv flextglGetTextureLevelParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterIiv)(GLuint, GLenum, GLint *);
#define glGetTextureParameterIiv flextglGetTextureParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterIuiv)(GLuint, GLenum, GLuint *);
#define glGetTextureParameterIuiv flextglGetTextureParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameterfv)(GLuint, GLenum, GLfloat *);
#define glGetTextureParameterfv flextglGetTextureParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureParameteriv)(GLuint, GLenum, GLint *);
#define glGetTextureParameteriv flextglGetTextureParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTextureSubImage)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
#define glGetTextureSubImage flextglGetTextureSubImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTransformFeedbacki64_v)(GLuint, GLenum, GLuint, GLint64 *);
#define glGetTransformFeedbacki64_v flextglGetTransformFeedbacki64_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTransformFeedbacki_v)(GLuint, GLenum, GLuint, GLint *);
#define glGetTransformFeedbacki_v flextglGetTransformFeedbacki_v
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetTransformFeedbackiv)(GLuint, GLenum, GLint *);
#define glGetTransformFeedbackiv flextglGetTransformFeedbackiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayIndexed64iv)(GLuint, GLuint, GLenum, GLint64 *);
#define glGetVertexArrayIndexed64iv flextglGetVertexArrayIndexed64iv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayIndexediv)(GLuint, GLuint, GLenum, GLint *);
#define glGetVertexArrayIndexediv flextglGetVertexArrayIndexediv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetVertexArrayiv)(GLuint, GLenum, GLint *);
#define glGetVertexArrayiv flextglGetVertexArrayiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnCompressedTexImage)(GLenum, GLint, GLsizei, void *);
#define glGetnCompressedTexImage flextglGetnCompressedTexImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnTexImage)(GLenum, GLint, GLenum, GLenum, GLsizei, void *);
#define glGetnTexImage flextglGetnTexImage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformdv)(GLuint, GLint, GLsizei, GLdouble *);
#define glGetnUniformdv flextglGetnUniformdv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformfv)(GLuint, GLint, GLsizei, GLfloat *);
#define glGetnUniformfv flextglGetnUniformfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformiv)(GLuint, GLint, GLsizei, GLint *);
#define glGetnUniformiv flextglGetnUniformiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglGetnUniformuiv)(GLuint, GLint, GLsizei, GLuint *);
#define glGetnUniformuiv flextglGetnUniformuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateNamedFramebufferData)(GLuint, GLsizei, const GLenum *);
#define glInvalidateNamedFramebufferData flextglInvalidateNamedFramebufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglInvalidateNamedFramebufferSubData)(GLuint, GLsizei, const GLenum *, GLint, GLint, GLsizei, GLsizei);
#define glInvalidateNamedFramebufferSubData flextglInvalidateNamedFramebufferSubData
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapNamedBuffer)(GLuint, GLenum);
#define glMapNamedBuffer flextglMapNamedBuffer
GLAPI FLEXTGL_EXPORT void *(APIENTRY *flextglMapNamedBufferRange)(GLuint, GLintptr, GLsizeiptr, GLbitfield);
#define glMapNamedBufferRange flextglMapNamedBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglMemoryBarrierByRegion)(GLbitfield);
#define glMemoryBarrierByRegion flextglMemoryBarrierByRegion
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferData)(GLuint, GLsizeiptr, const void *, GLenum);
#define glNamedBufferData flextglNamedBufferData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferStorage)(GLuint, GLsizeiptr, const void *, GLbitfield);
#define glNamedBufferStorage flextglNamedBufferStorage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedBufferSubData)(GLuint, GLintptr, GLsizeiptr, const void *);
#define glNamedBufferSubData flextglNamedBufferSubData
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferDrawBuffer)(GLuint, GLenum);
#define glNamedFramebufferDrawBuffer flextglNamedFramebufferDrawBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferDrawBuffers)(GLuint, GLsizei, const GLenum *);
#define glNamedFramebufferDrawBuffers flextglNamedFramebufferDrawBuffers
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferParameteri)(GLuint, GLenum, GLint);
#define glNamedFramebufferParameteri flextglNamedFramebufferParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferReadBuffer)(GLuint, GLenum);
#define glNamedFramebufferReadBuffer flextglNamedFramebufferReadBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferRenderbuffer)(GLuint, GLenum, GLenum, GLuint);
#define glNamedFramebufferRenderbuffer flextglNamedFramebufferRenderbuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTexture)(GLuint, GLenum, GLuint, GLint);
#define glNamedFramebufferTexture flextglNamedFramebufferTexture
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedFramebufferTextureLayer)(GLuint, GLenum, GLuint, GLint, GLint);
#define glNamedFramebufferTextureLayer flextglNamedFramebufferTextureLayer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedRenderbufferStorage)(GLuint, GLenum, GLsizei, GLsizei);
#define glNamedRenderbufferStorage flextglNamedRenderbufferStorage
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglNamedRenderbufferStorageMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
#define glNamedRenderbufferStorageMultisample flextglNamedRenderbufferStorageMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglReadnPixels)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, GLsizei, void *);
#define glReadnPixels flextglReadnPixels
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureBarrier)(void);
#define glTextureBarrier flextglTextureBarrier
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureBuffer)(GLuint, GLenum, GLuint);
#define glTextureBuffer flextglTextureBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureBufferRange)(GLuint, GLenum, GLuint, GLintptr, GLsizeiptr);
#define glTextureBufferRange flextglTextureBufferRange
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterIiv)(GLuint, GLenum, const GLint *);
#define glTextureParameterIiv flextglTextureParameterIiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterIuiv)(GLuint, GLenum, const GLuint *);
#define glTextureParameterIuiv flextglTextureParameterIuiv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterf)(GLuint, GLenum, GLfloat);
#define glTextureParameterf flextglTextureParameterf
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameterfv)(GLuint, GLenum, const GLfloat *);
#define glTextureParameterfv flextglTextureParameterfv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameteri)(GLuint, GLenum, GLint);
#define glTextureParameteri flextglTextureParameteri
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureParameteriv)(GLuint, GLenum, const GLint *);
#define glTextureParameteriv flextglTextureParameteriv
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage1D)(GLuint, GLsizei, GLenum, GLsizei);
#define glTextureStorage1D flextglTextureStorage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage2D)(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
#define glTextureStorage2D flextglTextureStorage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage2DMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLboolean);
#define glTextureStorage2DMultisample flextglTextureStorage2DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage3D)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLsizei);
#define glTextureStorage3D flextglTextureStorage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureStorage3DMultisample)(GLuint, GLsizei, GLenum, GLsizei, GLsizei, GLsizei, GLboolean);
#define glTextureStorage3DMultisample flextglTextureStorage3DMultisample
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage1D)(GLuint, GLint, GLint, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage1D flextglTextureSubImage1D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage2D)(GLuint, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage2D flextglTextureSubImage2D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTextureSubImage3D)(GLuint, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void *);
#define glTextureSubImage3D flextglTextureSubImage3D
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTransformFeedbackBufferBase)(GLuint, GLuint, GLuint);
#define glTransformFeedbackBufferBase flextglTransformFeedbackBufferBase
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglTransformFeedbackBufferRange)(GLuint, GLuint, GLuint, GLintptr, GLsizeiptr);
#define glTransformFeedbackBufferRange flextglTransformFeedbackBufferRange
GLAPI FLEXTGL_EXPORT GLboolean(APIENTRY *flextglUnmapNamedBuffer)(GLuint);
#define glUnmapNamedBuffer flextglUnmapNamedBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayAttribBinding)(GLuint, GLuint, GLuint);
#define glVertexArrayAttribBinding flextglVertexArrayAttribBinding
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayAttribFormat)(GLuint, GLuint, GLint, GLenum, GLboolean, GLuint);
#define glVertexArrayAttribFormat flextglVertexArrayAttribFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayAttribIFormat)(GLuint, GLuint, GLint, GLenum, GLuint);
#define glVertexArrayAttribIFormat flextglVertexArrayAttribIFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayAttribLFormat)(GLuint, GLuint, GLint, GLenum, GLuint);
#define glVertexArrayAttribLFormat flextglVertexArrayAttribLFormat
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayBindingDivisor)(GLuint, GLuint, GLuint);
#define glVertexArrayBindingDivisor flextglVertexArrayBindingDivisor
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayElementBuffer)(GLuint, GLuint);
#define glVertexArrayElementBuffer flextglVertexArrayElementBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexBuffer)(GLuint, GLuint, GLuint, GLintptr, GLsizei);
#define glVertexArrayVertexBuffer flextglVertexArrayVertexBuffer
GLAPI FLEXTGL_EXPORT void(APIENTRY *flextglVertexArrayVertexBuffers)(GLuint, GLuint, GLsizei, const GLuint *, const GLintptr *, const GLsizei *);
#define glVertexArrayVertexBuffers flextglVertexArrayVertexBuffers

#ifdef __cplusplus
}
#endif

#endif
