/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class AddModeDialog
extends EnhancedDialog {
    private JTextField modeName;
    private JTextField modeFile;
    private JButton browse;
    private JTextField filenameGlob;
    private JTextField firstLineGlob;
    private final JButton ok;
    private final JButton cancel;
    private boolean canceled = false;

    public AddModeDialog(View view) {
        super(view, jEdit.getProperty("options.editing.addMode.dialog.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        AbstractOptionPane abstractOptionPane = new AbstractOptionPane("addmode");
        this.modeName = new JTextField();
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.modeName"), (Component)this.modeName);
        JLabel jLabel = new JLabel(jEdit.getProperty("options.editing.addMode.dialog.modeFile"));
        abstractOptionPane.addComponent(jLabel);
        this.modeFile = new JTextField();
        this.browse = new JButton(jEdit.getProperty("options.editing.addMode.dialog.browse"));
        this.browse.addActionListener(new ActionHandler());
        abstractOptionPane.addComponent((Component)this.modeFile, (Component)this.browse);
        this.filenameGlob = new JTextField();
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.filenameGlob"), (Component)this.filenameGlob);
        this.firstLineGlob = new JTextField();
        abstractOptionPane.addComponent(jEdit.getProperty("options.editing.addMode.dialog.firstLineGlob"), (Component)this.firstLineGlob);
        this.getContentPane().add(abstractOptionPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel2.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        jPanel2.add(this.ok);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        jPanel2.add(this.cancel);
        jPanel2.add(Box.createGlue());
        jPanel.add("South", jPanel2);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public String getModeName() {
        return this.modeName.getText();
    }

    public String getModeFile() {
        return this.modeFile.getText();
    }

    public String getFilenameGlob() {
        return this.filenameGlob.getText();
    }

    public String getFirstLineGlob() {
        return this.firstLineGlob.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void ok() {
        if (this.getModeName() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Mode name may not be empty.");
            return;
        }
        if (this.getModeFile() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Mode name may not be empty.");
            return;
        }
        if (this.getFilenameGlob() == null && this.getFirstLineGlob() == null) {
            JOptionPane.showMessageDialog(jEdit.getActiveView(), "Either file name glob or first line glob or both must be filled in.");
            return;
        }
        this.canceled = false;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.dispose();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == AddModeDialog.this.browse) {
                boolean bl;
                int n;
                String string;
                View view = (View)AddModeDialog.this.getParent();
                String[] stringArray = GUIUtilities.showVFSFileDialog(view, string = jEdit.getSettingsDirectory(), n = 0, bl = false);
                if (stringArray.length > 0) {
                    AddModeDialog.this.modeFile.setText(stringArray[0]);
                } else {
                    AddModeDialog.this.modeFile.setText("");
                }
            } else if (object == AddModeDialog.this.ok) {
                AddModeDialog.this.ok();
            } else if (object == AddModeDialog.this.cancel) {
                AddModeDialog.this.cancel();
            }
        }
    }
}

