/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerRowSorter
extends TableRowSorter {
    private SortOrder defaultSortOrder = SortOrder.ASCENDING;
    private Map<Integer, SortOrder> defaultSortOrders;
    private static final String SORT_COLUMN_KEY = "ProfilerRowSorter.SortColumn";
    private static final String SORT_ORDER_KEY = "ProfilerRowSorter.SortOrder";

    ProfilerRowSorter(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    public void setSortKeys(List list) {
        RowSorter.SortKey sortKey = this.getSortKey();
        RowSorter.SortKey sortKey2 = (RowSorter.SortKey)list.get(0);
        if (sortKey == null || sortKey.getColumn() != sortKey2.getColumn()) {
            this.setSortColumn(sortKey2.getColumn());
        } else {
            this.setSortKeysImpl(list);
        }
    }

    protected void setSortKeysImpl(List list) {
        super.setSortKeys(list);
    }

    void setSortColumn(int n) {
        this.setSortColumn(n, this.getDefaultSortOrder(n));
    }

    void setSortColumn(int n, SortOrder sortOrder) {
        this.setSortKey(new RowSorter.SortKey(n, sortOrder));
    }

    void setSortKey(RowSorter.SortKey sortKey) {
        this.setSortKeysImpl(Arrays.asList(sortKey));
    }

    int getSortColumn() {
        RowSorter.SortKey sortKey = this.getSortKey();
        return sortKey == null ? -1 : sortKey.getColumn();
    }

    SortOrder getSortOrder() {
        RowSorter.SortKey sortKey = this.getSortKey();
        return sortKey == null ? SortOrder.UNSORTED : sortKey.getSortOrder();
    }

    RowSorter.SortKey getSortKey() {
        List<RowSorter.SortKey> list = this.getSortKeys();
        return list.isEmpty() ? null : list.get(0);
    }

    void setDefaultSortOrder(SortOrder sortOrder) {
        this.defaultSortOrder = sortOrder;
    }

    void setDefaultSortOrder(int n, SortOrder sortOrder) {
        if (this.defaultSortOrders == null) {
            this.defaultSortOrders = new HashMap<Integer, SortOrder>();
        }
        this.defaultSortOrders.put(n, sortOrder);
    }

    SortOrder getDefaultSortOrder(int n) {
        SortOrder sortOrder = this.defaultSortOrders == null ? null : this.defaultSortOrders.get(n);
        return sortOrder == null ? this.defaultSortOrder : sortOrder;
    }

    void loadFromStorage(Properties properties, ProfilerTable profilerTable) {
        String string = properties.getProperty(SORT_COLUMN_KEY);
        String string2 = properties.getProperty(SORT_ORDER_KEY);
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                SortOrder sortOrder = this.getSortOrder(string2);
                if (SortOrder.UNSORTED.equals((Object)sortOrder)) {
                    sortOrder = this.getDefaultSortOrder(n);
                }
                this.setSortColumn(n, sortOrder);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void saveToStorage(Properties properties, ProfilerTable profilerTable) {
        RowSorter.SortKey sortKey = this.getSortKey();
        if (sortKey == null) {
            properties.remove(SORT_COLUMN_KEY);
            properties.remove(SORT_ORDER_KEY);
        } else {
            int n = sortKey.getColumn();
            SortOrder sortOrder = sortKey.getSortOrder();
            properties.setProperty(SORT_COLUMN_KEY, Integer.toString(n));
            properties.setProperty(SORT_ORDER_KEY, sortOrder.toString());
        }
    }

    private SortOrder getSortOrder(String string) {
        if (SortOrder.ASCENDING.toString().equals(string)) {
            return SortOrder.ASCENDING;
        }
        if (SortOrder.DESCENDING.toString().equals(string)) {
            return SortOrder.DESCENDING;
        }
        return SortOrder.UNSORTED;
    }
}

