/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.signature;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import oauth.signpost.OAuth;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;

public class SignatureBaseString {
    private HttpRequest request;
    private HttpParameters requestParameters;

    public SignatureBaseString(HttpRequest httpRequest, HttpParameters httpParameters) {
        this.request = httpRequest;
        this.requestParameters = httpParameters;
    }

    public String generate() throws OAuthMessageSignerException {
        try {
            String string = this.normalizeRequestUrl();
            String string2 = this.normalizeRequestParameters();
            return this.request.getMethod() + '&' + OAuth.percentEncode(string) + '&' + OAuth.percentEncode(string2);
        }
        catch (Exception exception) {
            throw new OAuthMessageSignerException(exception);
        }
    }

    public String normalizeRequestUrl() throws URISyntaxException {
        String string;
        int n;
        boolean bl;
        URI uRI = new URI(this.request.getRequestUrl());
        String string2 = uRI.getScheme().toLowerCase();
        String string3 = uRI.getAuthority().toLowerCase();
        boolean bl2 = bl = string2.equals("http") && uRI.getPort() == 80 || string2.equals("https") && uRI.getPort() == 443;
        if (bl && (n = string3.lastIndexOf(":")) >= 0) {
            string3 = string3.substring(0, n);
        }
        if ((string = uRI.getRawPath()) == null || string.length() <= 0) {
            string = "/";
        }
        return string2 + "://" + string3 + string;
    }

    public String normalizeRequestParameters() throws IOException {
        if (this.requestParameters == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.requestParameters.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!"oauth_signature".equals(string) && !"realm".equals(string)) {
                if (n > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(this.requestParameters.getAsQueryString(string, false));
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

